/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.publisher;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.LogUtil;
import org.xipki.util.SqlUtil;
import org.xipki.util.exception.ErrorCode;
import org.xipki.util.exception.OperationException;

class OcspStoreQueryExecutor {
    private static final String SQL_ADD_REVOKED_CERT = SqlUtil.buildInsertSql((String)"CERT", (String)"ID,LUPDATE,SN,NBEFORE,NAFTER,REV,IID,HASH,SUBJECT,RT,RIT,RR");
    private static final String SQL_ADD_CERT = SqlUtil.buildInsertSql((String)"CERT", (String)"ID,LUPDATE,SN,NBEFORE,NAFTER,REV,IID,HASH,SUBJECT");
    private static final Logger LOG = LoggerFactory.getLogger(OcspStoreQueryExecutor.class);
    private final DataSourceWrapper datasource;
    private final String sqlCertRegistered;
    private final IssuerStore issuerStore;
    private final boolean publishGoodCerts;
    private final int dbSchemaVersion;
    private final int maxX500nameLen;
    private final HashAlgo certhashAlgo;
    private final AtomicInteger cachedIssuerId = new AtomicInteger(0);

    OcspStoreQueryExecutor(DataSourceWrapper datasource, boolean publishGoodCerts) throws DataAccessException, NoSuchAlgorithmException {
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.issuerStore = this.initIssuerStore();
        this.publishGoodCerts = publishGoodCerts;
        this.sqlCertRegistered = datasource.buildSelectFirstSql(1, "ID FROM CERT WHERE SN=? AND IID=?");
        String sql = "SELECT NAME,VALUE2 FROM DBSCHEMA";
        HashMap<String, String> variables = new HashMap<String, String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = datasource.createStatement();
            if (stmt == null) {
                throw new DataAccessException("could not create statement");
            }
            rs = stmt.executeQuery("SELECT NAME,VALUE2 FROM DBSCHEMA");
            while (rs.next()) {
                String name = rs.getString("NAME");
                String value = rs.getString("VALUE2");
                variables.put(name, value);
            }
        }
        catch (SQLException ex) {
            try {
                throw datasource.translate("SELECT NAME,VALUE2 FROM DBSCHEMA", ex);
            }
            catch (Throwable throwable) {
                datasource.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        datasource.releaseResources(stmt, rs);
        String str = (String)variables.get("VERSION");
        this.dbSchemaVersion = Integer.parseInt(str);
        str = (String)variables.get("X500NAME_MAXLEN");
        this.maxX500nameLen = Integer.parseInt(str);
        str = (String)variables.get("CERTHASH_ALGO");
        this.certhashAlgo = HashAlgo.getInstance((String)str);
    }

    private IssuerStore initIssuerStore() throws DataAccessException {
        String sql = "SELECT ID,CERT FROM ISSUER";
        PreparedStatement ps = this.datasource.prepareStatement("SELECT ID,CERT FROM ISSUER");
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            LinkedList<IssuerEntry> caInfos = new LinkedList<IssuerEntry>();
            while (rs.next()) {
                caInfos.add(new IssuerEntry(rs.getInt("ID"), rs.getString("CERT")));
            }
            IssuerStore issuerStore = new IssuerStore(caInfos);
            return issuerStore;
        }
        catch (SQLException ex) {
            throw this.datasource.translate("SELECT ID,CERT FROM ISSUER", ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
    }

    void addCert(X509Cert issuer, CertWithDbId certificate, CertRevocationInfo revInfo) throws DataAccessException, OperationException {
        this.addOrUpdateCert(issuer, certificate, revInfo);
    }

    private void addOrUpdateCert(X509Cert issuer, CertWithDbId certificate, CertRevocationInfo revInfo) throws DataAccessException, OperationException {
        Args.notNull((Object)issuer, (String)"issuer");
        boolean revoked = revInfo != null;
        int issuerId = this.getIssuerId(issuer);
        BigInteger serialNumber = certificate.getCert().getSerialNumber();
        Long certRegisteredId = this.getCertId(issuerId, serialNumber);
        if (!this.publishGoodCerts && !revoked && certRegisteredId != null) {
            return;
        }
        if (certRegisteredId != null) {
            this.updateRegisteredCert(certRegisteredId, revInfo);
            return;
        }
        String sql = revoked ? SQL_ADD_REVOKED_CERT : SQL_ADD_CERT;
        long certId = certificate.getCertId();
        byte[] encodedCert = certificate.getCert().getEncoded();
        String certHash = this.certhashAlgo.base64Hash((byte[][])new byte[][]{encodedCert});
        X509Cert cert = certificate.getCert();
        String cuttedSubject = X509Util.cutText((String)certificate.getCert().getSubjectText(), (int)this.maxX500nameLen);
        PreparedStatement ps = this.datasource.prepareStatement(sql);
        try {
            int idx = 1;
            ps.setLong(idx++, certId);
            ps.setLong(idx++, Instant.now().getEpochSecond());
            ps.setString(idx++, serialNumber.toString(16));
            ps.setLong(idx++, cert.getNotBefore().getEpochSecond());
            ps.setLong(idx++, cert.getNotAfter().getEpochSecond());
            OcspStoreQueryExecutor.setBoolean(ps, idx++, revoked);
            ps.setInt(idx++, issuerId);
            ps.setString(idx++, certHash);
            ps.setString(idx++, cuttedSubject);
            if (revoked) {
                long revTime = revInfo.getRevocationTime().getEpochSecond();
                ps.setLong(idx++, revTime);
                if (revInfo.getInvalidityTime() != null) {
                    ps.setLong(idx++, revInfo.getInvalidityTime().getEpochSecond());
                } else {
                    ps.setNull(idx++, -5);
                }
                int reasonCode = revInfo.getReason() == null ? 0 : revInfo.getReason().getCode();
                ps.setInt(idx, reasonCode);
            }
            try {
                ps.executeUpdate();
            }
            catch (Throwable th) {
                this.datasource.deleteFromTable(null, "CERT", "ID", certId);
                if (th instanceof SQLException) {
                    SQLException ex = (SQLException)th;
                    LOG.error("datasource {} could not add certificate with id {}: {}", new Object[]{this.datasource.getName(), certId, th.getMessage()});
                    throw this.datasource.translate(sql, ex);
                }
                throw new OperationException(ErrorCode.SYSTEM_FAILURE, th);
            }
        }
        catch (SQLException ex) {
            throw this.datasource.translate(null, ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    private void updateRegisteredCert(long registeredCertId, CertRevocationInfo revInfo) throws DataAccessException {
        boolean revoked = revInfo != null;
        String sql = "UPDATE CERT SET LUPDATE=?,REV=?,RT=?,RIT=?,RR=? WHERE ID=?";
        PreparedStatement ps = this.datasource.prepareStatement("UPDATE CERT SET LUPDATE=?,REV=?,RT=?,RIT=?,RR=? WHERE ID=?");
        try {
            int idx = 1;
            ps.setLong(idx++, Instant.now().getEpochSecond());
            OcspStoreQueryExecutor.setBoolean(ps, idx++, revoked);
            if (revoked) {
                long revTime = revInfo.getRevocationTime().getEpochSecond();
                ps.setLong(idx++, revTime);
                if (revInfo.getInvalidityTime() != null) {
                    ps.setLong(idx++, revInfo.getInvalidityTime().getEpochSecond());
                } else {
                    ps.setNull(idx++, 4);
                }
                ps.setInt(idx++, revInfo.getReason().getCode());
            } else {
                ps.setNull(idx++, 4);
                ps.setNull(idx++, 4);
                ps.setNull(idx++, 4);
            }
            ps.setLong(idx, registeredCertId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw this.datasource.translate("UPDATE CERT SET LUPDATE=?,REV=?,RT=?,RIT=?,RR=? WHERE ID=?", ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void revokeCert(X509Cert caCert, CertWithDbId cert, CertRevocationInfo revInfo) throws DataAccessException, OperationException {
        this.addOrUpdateCert(caCert, cert, revInfo);
    }

    void unrevokeCert(X509Cert issuer, CertWithDbId cert) throws DataAccessException {
        Args.notNull((Object)issuer, (String)"issuer");
        Args.notNull((Object)cert, (String)"cert");
        Integer issuerId = this.issuerStore.getIdForCert(issuer.getEncoded());
        if (issuerId == null) {
            return;
        }
        BigInteger serialNumber = cert.getCert().getSerialNumber();
        Long certRegisteredId = this.getCertId(issuerId, serialNumber);
        if (certRegisteredId == null) {
            return;
        }
        if (this.publishGoodCerts) {
            String sql = "UPDATE CERT SET LUPDATE=?,REV=?,RT=?,RIT=?,RR=? WHERE ID=?";
            PreparedStatement ps = this.datasource.prepareStatement("UPDATE CERT SET LUPDATE=?,REV=?,RT=?,RIT=?,RR=? WHERE ID=?");
            try {
                int idx = 1;
                ps.setLong(idx++, Instant.now().getEpochSecond());
                OcspStoreQueryExecutor.setBoolean(ps, idx++, false);
                ps.setNull(idx++, 4);
                ps.setNull(idx++, 4);
                ps.setNull(idx++, 4);
                ps.setLong(idx, certRegisteredId);
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                throw this.datasource.translate("UPDATE CERT SET LUPDATE=?,REV=?,RT=?,RIT=?,RR=? WHERE ID=?", ex);
            }
            finally {
                this.datasource.releaseResources((Statement)ps, null);
            }
        }
        String sql = "DELETE FROM CERT WHERE IID=? AND SN=?";
        PreparedStatement ps = this.datasource.prepareStatement("DELETE FROM CERT WHERE IID=? AND SN=?");
        try {
            ps.setInt(1, issuerId);
            ps.setString(2, serialNumber.toString(16));
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw this.datasource.translate("DELETE FROM CERT WHERE IID=? AND SN=?", ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void removeCert(X509Cert issuer, CertWithDbId cert) throws DataAccessException {
        Args.notNull((Object)cert, (String)"cert");
        Integer issuerId = this.issuerStore.getIdForCert(((X509Cert)Args.notNull((Object)issuer, (String)"issuer")).getEncoded());
        if (issuerId == null) {
            return;
        }
        String sql = "DELETE FROM CERT WHERE IID=? AND SN=?";
        PreparedStatement ps = this.datasource.prepareStatement("DELETE FROM CERT WHERE IID=? AND SN=?");
        try {
            ps.setInt(1, issuerId);
            ps.setString(2, cert.getCert().getSerialNumber().toString(16));
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw this.datasource.translate("DELETE FROM CERT WHERE IID=? AND SN=?", ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void revokeCa(X509Cert caCert, CertRevocationInfo revInfo) throws DataAccessException {
        Args.notNull((Object)revInfo, (String)"revInfo");
        int issuerId = this.getIssuerId((X509Cert)Args.notNull((Object)caCert, (String)"caCert"));
        String sql = "UPDATE ISSUER SET REV_INFO=? WHERE ID=?";
        PreparedStatement ps = this.datasource.prepareStatement("UPDATE ISSUER SET REV_INFO=? WHERE ID=?");
        try {
            ps.setString(1, revInfo.getEncoded());
            ps.setInt(2, issuerId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw this.datasource.translate("UPDATE ISSUER SET REV_INFO=? WHERE ID=?", ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void unrevokeCa(X509Cert caCert) throws DataAccessException {
        int issuerId = this.getIssuerId(caCert);
        String sql = "UPDATE ISSUER SET REV_INFO=? WHERE ID=?";
        PreparedStatement ps = this.datasource.prepareStatement("UPDATE ISSUER SET REV_INFO=? WHERE ID=?");
        try {
            ps.setNull(1, 12);
            ps.setInt(2, issuerId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw this.datasource.translate("UPDATE ISSUER SET REV_INFO=? WHERE ID=?", ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    private int getIssuerId(X509Cert issuerCert) {
        Args.notNull((Object)issuerCert, (String)"issuerCert");
        Integer id = this.issuerStore.getIdForCert(issuerCert.getEncoded());
        if (id == null) {
            throw new IllegalStateException("could not find issuer, please start XiPKI in master mode first the restart this XiPKI system");
        }
        return id;
    }

    void addIssuer(X509Cert issuerCert) throws DataAccessException {
        if (this.issuerStore.getIdForCert(issuerCert.getEncoded()) != null) {
            return;
        }
        String sha1FpCert = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{issuerCert.getEncoded()});
        int maxIdInDb = (int)this.datasource.getMax(null, "ISSUER", "ID");
        int id = Math.max(maxIdInDb, this.cachedIssuerId.get()) + 1;
        this.cachedIssuerId.set(id);
        byte[] encodedCert = issuerCert.getEncoded();
        String sql = "INSERT INTO ISSUER (ID,SUBJECT,NBEFORE,NAFTER,S1C,CERT) VALUES (?,?,?,?,?,?)";
        PreparedStatement ps = this.datasource.prepareStatement("INSERT INTO ISSUER (ID,SUBJECT,NBEFORE,NAFTER,S1C,CERT) VALUES (?,?,?,?,?,?)");
        try {
            String b64Cert = Base64.encodeToString((byte[])encodedCert);
            String subject = issuerCert.getSubjectText();
            int idx = 1;
            ps.setInt(idx++, id);
            ps.setString(idx++, subject);
            ps.setLong(idx++, issuerCert.getNotBefore().getEpochSecond());
            ps.setLong(idx++, issuerCert.getNotAfter().getEpochSecond());
            ps.setString(idx++, sha1FpCert);
            ps.setString(idx, b64Cert);
            ps.execute();
            this.issuerStore.addIdentityEntry(new IssuerEntry(id, b64Cert));
        }
        catch (SQLException ex) {
            throw this.datasource.translate("INSERT INTO ISSUER (ID,SUBJECT,NBEFORE,NAFTER,S1C,CERT) VALUES (?,?,?,?,?,?)", ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    private Long getCertId(int issuerId, BigInteger serialNumber) throws DataAccessException {
        Long l;
        String sql = this.sqlCertRegistered;
        ResultSet rs = null;
        PreparedStatement ps = this.datasource.prepareStatement(sql);
        try {
            ps.setString(1, serialNumber.toString(16));
            ps.setInt(2, issuerId);
            rs = ps.executeQuery();
            l = rs.next() ? Long.valueOf(rs.getLong("ID")) : null;
        }
        catch (SQLException ex) {
            try {
                throw this.datasource.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHealthy() {
        String sql = "SELECT ID FROM ISSUER";
        try {
            ResultSet rs = null;
            PreparedStatement ps = this.datasource.prepareStatement("SELECT ID FROM ISSUER");
            try {
                rs = ps.executeQuery();
            }
            finally {
                this.datasource.releaseResources((Statement)ps, rs);
            }
            return true;
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            return false;
        }
    }

    private static void setBoolean(PreparedStatement ps, int index, boolean value) throws SQLException {
        ps.setInt(index, value ? 1 : 0);
    }

    private static class IssuerStore {
        private final List<IssuerEntry> entries;

        IssuerStore(List<IssuerEntry> entries) {
            Args.notNull(entries, (String)"entries");
            this.entries = new ArrayList<IssuerEntry>(entries.size());
            for (IssuerEntry entry : entries) {
                this.addIdentityEntry(entry);
            }
        }

        final void addIdentityEntry(IssuerEntry entry) {
            Args.notNull((Object)entry, (String)"entry");
            for (IssuerEntry existingEntry : this.entries) {
                if (existingEntry.getId() != entry.getId()) continue;
                throw new IllegalArgumentException("issuer with the same id " + entry.getId() + " already available");
            }
            this.entries.add(entry);
        }

        Integer getIdForCert(byte[] encodedCert) {
            Args.notNull((Object)encodedCert, (String)"encodedCert");
            for (IssuerEntry entry : this.entries) {
                if (!entry.matchCert(encodedCert)) continue;
                return entry.getId();
            }
            return null;
        }
    }

    private static class IssuerEntry {
        private final int id;
        private final byte[] cert;

        IssuerEntry(int id, String b64Cert) {
            this.id = id;
            this.cert = Base64.decode((String)b64Cert);
        }

        int getId() {
            return this.id;
        }

        boolean matchCert(byte[] encodedCert) {
            return Arrays.equals(this.cert, encodedCert);
        }
    }
}

