/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaConf;
import org.xipki.ca.api.mgmt.CaConfType;
import org.xipki.ca.api.mgmt.CaJson;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaProfileEntry;
import org.xipki.ca.api.mgmt.entry.BaseCaInfo;
import org.xipki.ca.api.mgmt.entry.CaConfColumn;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.server.CaConfStore;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CertprofileFactoryRegister;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.KeypairGenEntryWrapper;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.SystemEvent;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.ca.server.mgmt.CaProfileIdAliases;
import org.xipki.ca.server.mgmt.SelfSignedCertBuilder;
import org.xipki.pki.OperationException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;

public class FileCaConfStore
implements CaConfStore {
    private static final Logger LOG = LoggerFactory.getLogger(FileCaConfStore.class);
    private static final CaMgmtException readOnlyException = new CaMgmtException("File based CaConfStore is read-only");
    private static final int REQUESTOR_BY_CA_ID = 1;
    private final Map<String, String> dbSchemas;
    private final int dbSchemaversion = 9;
    private final List<String> caNames;
    private final List<String> keyPairGenNames;
    private final List<String> profileNames;
    private final List<String> publisherNames;
    private final List<String> requestorNames;
    private final List<String> signerNames;
    private final Map<String, CaEntry> caTable = new HashMap<String, CaEntry>();
    private final Map<String, CertprofileEntry> certprofileTable = new HashMap<String, CertprofileEntry>();
    private final Map<String, PublisherEntry> publisherTable = new HashMap<String, PublisherEntry>();
    private final Map<String, RequestorEntry> requestorTable = new HashMap<String, RequestorEntry>();
    private final Map<String, SignerEntry> signerTable = new HashMap<String, SignerEntry>();
    private final Map<String, KeypairGenEntry> keypairGenTable = new HashMap<String, KeypairGenEntry>();
    private final Map<String, Integer> requestorNameToIdMap;
    private final Map<String, Set<CaHasRequestorEntry>> caHasRequestors;
    private final Map<String, Set<CaProfileIdAliases>> caHasProfiles;
    private final Map<String, Set<Integer>> caHasPublisherIds;
    private final Map<String, String> aliasToCaNames;
    private final Map<String, Integer> aliasToCaIds;
    private final boolean needsCertStore;

    public FileCaConfStore(SecurityFactory securityFactory, CertprofileFactoryRegister certprofileFactoryRegister, List<String> confFiles) throws IOException, CaMgmtException, InvalidConfException {
        boolean bl;
        NameId ident;
        SignerEntry entry;
        String name;
        if (confFiles == null || confFiles.isEmpty()) {
            throw new IllegalArgumentException("confFile shall not be empty");
        }
        String baseDir = null;
        for (String confFile : confFiles) {
            File fileobj = new File(IoUtil.expandFilepath((String)confFile, (boolean)true));
            if (baseDir == null) {
                baseDir = fileobj.getParent();
                continue;
            }
            if (CompareUtil.equalsObject((Object)baseDir, (Object)fileobj.getParent())) continue;
            throw new IllegalArgumentException("Not all confFiles have the same parent dir");
        }
        if (baseDir == null) {
            baseDir = ".";
        }
        CaConfType.CaSystem root = FileCaConfStore.mergeConfs(confFiles);
        Map<String, Integer> profileNameIdMap = FileCaConfStore.assertNameIdUnique(root.getProfiles(), "profile");
        this.profileNames = List.copyOf(profileNameIdMap.keySet());
        Map<String, Integer> publisherNameIdMap = FileCaConfStore.assertNameIdUnique(root.getPublishers(), "publisher");
        this.publisherNames = List.copyOf(publisherNameIdMap.keySet());
        this.signerNames = Collections.unmodifiableList(FileCaConfStore.assertNameUnique(root.getSigners(), "signer"));
        Map<String, Integer> requestorNameIdMap = FileCaConfStore.assertNameIdUnique(root.getRequestors(), "requestor");
        if (requestorNameIdMap.containsKey("by-ca")) {
            throw new InvalidConfException("requestor name by-ca is reserved and shall no be used");
        }
        requestorNameIdMap.put("by-ca", 1);
        this.requestorNames = List.copyOf(requestorNameIdMap.keySet());
        this.requestorNameToIdMap = Collections.unmodifiableMap(requestorNameIdMap);
        this.keyPairGenNames = Collections.unmodifiableList(FileCaConfStore.assertNameUnique(root.getKeypairGens(), "keypairGen"));
        Map<String, Integer> caNameIdMap = FileCaConfStore.assertNameIdUnique(root.getCas(), "CA");
        this.caNames = List.copyOf(caNameIdMap.keySet());
        for (Object m : root.getRequestors()) {
            if (m.getId() != 1) continue;
            throw new InvalidConfException("requestor id " + m.getId() + " is reserved and shall not be used");
        }
        HashMap<String, Integer> caAliasNameIdMap = new HashMap<String, Integer>();
        for (CaConfType.Ca ca : root.getCas()) {
            Object m2;
            for (String alias : ca.getAliases()) {
                if (caAliasNameIdMap.containsKey(alias)) {
                    throw new InvalidConfException("duplicated CA alias " + alias);
                }
                caAliasNameIdMap.put(alias, ca.getId());
            }
            for (String m2 : ca.getPublishers()) {
                if (publisherNameIdMap.containsKey(m2)) continue;
                throw new InvalidConfException("unknown publisher " + m2);
            }
            for (Object m2 : ca.getRequestors()) {
                if (requestorNameIdMap.containsKey(m2.getRequestorName())) continue;
                throw new InvalidConfException("unknown requestor " + m2.getRequestorName());
            }
            HashSet<String> localProfileNames = new HashSet<String>();
            m2 = ca.getProfiles().iterator();
            while (m2.hasNext()) {
                String profile = (String)m2.next();
                CaProfileEntry entry2 = CaProfileEntry.decode((String)profile);
                if (!profileNameIdMap.containsKey(entry2.getProfileName())) {
                    throw new InvalidConfException("unknown certprofile " + entry2.getProfileName());
                }
                localProfileNames.add(entry2.getProfileName());
                for (String alias : entry2.getProfileAliases()) {
                    if (localProfileNames.contains(alias)) {
                        throw new InvalidConfException("duplicated cerprofile alias " + alias);
                    }
                    localProfileNames.add(alias);
                }
            }
            CaConfType.CaInfo caInfo = ca.getCaInfo();
            if (caInfo == null) continue;
            String tname = caInfo.getCrlSignerName();
            if (tname != null && !this.signerNames.contains(tname)) {
                throw new InvalidConfException("unknown signer " + tname);
            }
            if (caInfo.getKeypairGenNames() == null) continue;
            for (String string : caInfo.getKeypairGenNames()) {
                if (this.keyPairGenNames.contains(string)) continue;
                throw new InvalidConfException("unknown keypairGen " + string);
            }
        }
        if (!root.getDbSchemas().containsKey("VENDOR")) {
            root.getDbSchemas().put("VENDOR", "XIPKI");
        }
        if (!root.getDbSchemas().containsKey("X500NAME_MAXLEN")) {
            root.getDbSchemas().put("X500NAME_MAXLEN", "350");
        }
        if (!root.getDbSchemas().containsKey("VERSION")) {
            root.getDbSchemas().put("VERSION", "9");
        }
        this.dbSchemas = Collections.unmodifiableMap(root.getDbSchemas());
        for (CaConfType.Signer m : root.getSigners()) {
            name = m.getName();
            try {
                entry = new SignerEntry(name, m.getType(), FileCaConfStore.getValue(m.getConf(), baseDir), FileCaConfStore.getBase64Value(m.getCert(), baseDir));
                this.signerTable.put(name, entry);
                LOG.info("initialized signer {}", (Object)name);
            }
            catch (Exception ex) {
                throw new InvalidConfException("error initializing signer " + name, (Throwable)ex);
            }
        }
        for (CaConfType.Signer m : root.getRequestors()) {
            ident = new NameId(m.getId(), m.getName());
            try {
                String conf;
                if (m.getConf() != null) {
                    conf = FileCaConfStore.getValue(m.getConf(), baseDir);
                } else if ("cert".equalsIgnoreCase(m.getType())) {
                    byte[] binary = FileCaConfStore.getBinary(m.getBinaryConf(), baseDir);
                    if (binary == null) {
                        conf = null;
                    } else {
                        binary = X509Util.toDerEncoded((byte[])binary);
                        conf = Base64.encodeToString((byte[])binary);
                    }
                } else {
                    conf = FileCaConfStore.getBase64Value(m.getBinaryConf(), baseDir);
                }
                RequestorEntry entry3 = new RequestorEntry(ident, m.getType(), conf);
                this.requestorTable.put(ident.getName(), entry3);
                LOG.info("initialized requestor {}", (Object)ident);
            }
            catch (Exception ex) {
                throw new InvalidConfException("error initializing requestor " + ident, (Throwable)ex);
            }
        }
        for (CaConfType.Signer m : root.getPublishers()) {
            ident = new NameId(m.getId(), m.getName());
            try {
                entry = new PublisherEntry(ident, m.getType(), FileCaConfStore.getValue(m.getConf(), baseDir));
                this.publisherTable.put(ident.getName(), (PublisherEntry)entry);
                LOG.info("initialized publisher {}", (Object)ident);
            }
            catch (Exception ex) {
                throw new InvalidConfException("error initializing publisher " + ident, (Throwable)ex);
            }
        }
        for (CaConfType.Signer m : root.getKeypairGens()) {
            name = m.getName();
            try {
                entry = new KeypairGenEntry(name, m.getType(), FileCaConfStore.getValue(m.getConf(), baseDir));
                this.keypairGenTable.put(name, (KeypairGenEntry)entry);
                LOG.info("initialized KeyPairGen {}", (Object)name);
            }
            catch (RuntimeException ex) {
                throw new InvalidConfException("error initializing KeyPairGen " + name, (Throwable)ex);
            }
        }
        for (CaConfType.Signer m : root.getProfiles()) {
            ident = new NameId(m.getId(), m.getName());
            try {
                entry = new CertprofileEntry(ident, m.getType(), FileCaConfStore.getValue(m.getConf(), baseDir));
                this.certprofileTable.put(ident.getName(), (CertprofileEntry)entry);
                LOG.info("initialized certprofile {}", (Object)ident);
            }
            catch (RuntimeException ex) {
                throw new InvalidConfException("error initializing certprofile " + ident, (Throwable)ex);
            }
        }
        HashMap<String, String> caAliasToNameMap = new HashMap<String, String>();
        HashMap caHasPublisherMap = new HashMap();
        HashMap caHasProfileMap = new HashMap();
        HashMap caHasRequestorMap = new HashMap();
        if (root.getCas() != null) {
            for (Object m : root.getCas()) {
                CaConfType.CaInfo caInfo;
                CaProfileEntry entry0;
                HashSet<CaProfileIdAliases> set;
                Iterator alias22;
                String string = m.getName();
                NameId ident2 = new NameId(m.getId(), string);
                try {
                    CaEntry entry4 = this.buildCaEntry((CaConfType.Ca)m, baseDir, certprofileFactoryRegister, securityFactory);
                    this.caTable.put(string, entry4);
                    LOG.info("initialized CA {}", (Object)ident2);
                }
                catch (Exception ex) {
                    throw new InvalidConfException("error initializing CA " + ident2, (Throwable)ex);
                }
                if (m.getAliases() != null) {
                    for (Iterator alias22 : m.getAliases()) {
                        caAliasToNameMap.put((String)((Object)alias22), string);
                    }
                }
                if (m.getPublishers() != null) {
                    caHasPublisherMap.put(string, new HashSet(m.getPublishers()));
                }
                if (m.getProfiles() != null) {
                    set = new HashSet<CaProfileIdAliases>();
                    alias22 = m.getProfiles().iterator();
                    while (alias22.hasNext()) {
                        String combinedProfile = (String)alias22.next();
                        try {
                            entry0 = CaProfileEntry.decode((String)combinedProfile);
                            String profileName = entry0.getProfileName();
                            CertprofileEntry certprofileEntry = this.certprofileTable.get(profileName);
                            CaProfileIdAliases entry5 = new CaProfileIdAliases(certprofileEntry.getIdent().getId(), entry0.getEncodedAliases());
                            set.add(entry5);
                        }
                        catch (Exception ex) {
                            throw new CaMgmtException("invalid syntax of CaProfileEntry '" + combinedProfile + "'", (Throwable)ex);
                        }
                    }
                    caHasProfileMap.put(string, set);
                }
                if (m.getRequestors() != null) {
                    set = new HashSet();
                    alias22 = m.getRequestors().iterator();
                    while (alias22.hasNext()) {
                        CaConfType.CaHasRequestor c = (CaConfType.CaHasRequestor)alias22.next();
                        entry0 = this.requestorTable.get(c.getRequestorName());
                        CaHasRequestorEntry entry6 = new CaHasRequestorEntry(entry0.getIdent());
                        entry6.setPermissions(c.getPermissions());
                        entry6.setProfiles((Set)(c.getProfiles() == null ? Collections.emptySet() : new HashSet(c.getProfiles())));
                        set.add((CaProfileIdAliases)entry6);
                    }
                    caHasRequestorMap.put(string, set);
                }
                if ((caInfo = m.getCaInfo()) == null) continue;
            }
        }
        this.caHasProfiles = Collections.unmodifiableMap(caHasProfileMap);
        this.caHasRequestors = Collections.unmodifiableMap(caHasRequestorMap);
        this.aliasToCaNames = Collections.unmodifiableMap(caAliasToNameMap);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Map.Entry entry2 : this.aliasToCaNames.entrySet()) {
            int caId = caNameIdMap.get(entry2.getValue());
            map.put((String)entry2.getKey(), caId);
        }
        this.aliasToCaIds = Collections.unmodifiableMap(map);
        HashMap caHasPublisherIds = new HashMap();
        for (Map.Entry m : caHasPublisherMap.entrySet()) {
            String caName = (String)m.getKey();
            HashSet<Integer> ids = new HashSet<Integer>();
            for (String publisheName : (Set)m.getValue()) {
                ids.add(publisherNameIdMap.get(publisheName));
            }
            caHasPublisherIds.put(caName, ids);
        }
        this.caHasPublisherIds = Collections.unmodifiableMap(caHasPublisherIds);
        boolean bl2 = false;
        for (CaConfType.Ca ca : root.getCas()) {
            if (!ca.getCaInfo().isSaveCert() && !ca.getCaInfo().isSaveKeypair()) continue;
            bl = true;
            break;
        }
        this.needsCertStore = bl;
    }

    private CaEntry buildCaEntry(CaConfType.Ca ca, String baseDir, CertprofileFactoryRegister certprofileFactoryRegister, SecurityFactory securityFactory) throws InvalidConfException, IOException, CaMgmtException {
        X509Cert caCert;
        NameId ident = new NameId(ca.getId(), ca.getName());
        CaConfType.CaInfo ci = ca.getCaInfo();
        if (ci.getGenSelfIssued() != null) {
            IdentifiedCertprofile certprofile;
            X509Cert cert;
            if (ci.getCert() != null) {
                throw new InvalidConfException("cert.file of CA " + ident + " may not be set");
            }
            File certFile = new File(baseDir, "generated-rootcerts/" + ident.getName() + ".pem");
            if (certFile.exists()) {
                try {
                    cert = X509Util.parseCert((File)certFile);
                }
                catch (CertificateException e) {
                    throw new CaMgmtException("error parsing certificate " + certFile.getPath());
                }
            }
            CaConfType.GenSelfIssued gsi = ci.getGenSelfIssued();
            Instant notBefore = gsi.getNotBefore() == null ? null : DateUtil.parseUtcTimeyyyyMMddhhmmss((String)gsi.getNotBefore());
            Instant notAfter = gsi.getNotAfter() == null ? null : DateUtil.parseUtcTimeyyyyMMddhhmmss((String)gsi.getNotAfter());
            CaConf.GenSelfIssued genSelfIssued = new CaConf.GenSelfIssued(gsi.getProfile(), gsi.getSubject(), gsi.getSerialNumber(), notBefore, notAfter);
            try {
                CertprofileEntry certprofileConfEntry = this.certprofileTable.get(gsi.getProfile());
                Certprofile certprofile0 = certprofileFactoryRegister.newCertprofile(certprofileConfEntry.getType());
                certprofile0.initialize(certprofileConfEntry.getConf());
                certprofile = new IdentifiedCertprofile(certprofileConfEntry, certprofile0);
            }
            catch (RuntimeException | CertprofileException | ObjectCreationException ex) {
                throw new CaMgmtException("error initializing certprofile " + gsi.getProfile());
            }
            String signerConf = FileCaConfStore.getValue(ci.getSignerConf(), baseDir);
            try {
                cert = SelfSignedCertBuilder.generateSelfSigned(securityFactory, ci.getSignerType(), signerConf, certprofile, genSelfIssued.getSubject(), genSelfIssued.getSerialNumber(), genSelfIssued.getNotBefore(), genSelfIssued.getNotAfter());
            }
            catch (OperationException ex) {
                throw new CaMgmtException(((Object)((Object)ex)).getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
            }
            IoUtil.save((File)certFile, (byte[])X509Util.toPemCert((X509Cert)cert).getBytes(StandardCharsets.UTF_8));
            ci.setCert(FileOrBinary.ofBinary((byte[])cert.getEncoded()));
        }
        CaEntry caEntry = new CaEntry(ident);
        ci.copyBaseInfoTo((BaseCaInfo)caEntry);
        caEntry.setSignerConf(FileCaConfStore.getValue(ci.getSignerConf(), baseDir));
        if (caEntry.getCaUris() == null) {
            caEntry.setCaUris(CaUris.EMPTY_INSTANCE);
        }
        if (ci.getCert() != null) {
            byte[] bytes = FileCaConfStore.getBinary(ci.getCert(), baseDir);
            try {
                caCert = X509Util.parseCert((byte[])bytes);
            }
            catch (CertificateException ex) {
                throw new InvalidConfException("invalid certificate of CA " + ident, (Throwable)ex);
            }
        }
        try {
            List signerConfs = CaEntry.splitCaSignerConfs((String)FileCaConfStore.getValue(ci.getSignerConf(), baseDir));
            SignerConf signerConf = new SignerConf(((CaEntry.CaSignerConf)signerConfs.get(0)).getConf());
            try (ConcurrentContentSigner signer = securityFactory.createSigner(ci.getSignerType(), signerConf, (X509Cert)null);){
                caCert = signer.getCertificate();
            }
        }
        catch (IOException | XiSecurityException | ObjectCreationException ex) {
            throw new InvalidConfException("could not create CA signer for CA " + ident, ex);
        }
        caEntry.setCert(caCert);
        if (CollectionUtil.isNotEmpty((Collection)ci.getCertchain())) {
            LinkedList<X509Cert> certchain = new LinkedList<X509Cert>();
            for (FileOrBinary cc : ci.getCertchain()) {
                byte[] bytes = FileCaConfStore.getBinary(cc, baseDir);
                try {
                    certchain.add(X509Util.parseCert((byte[])bytes));
                }
                catch (CertificateException ex) {
                    throw new InvalidConfException("invalid certchain for CA " + ident, (Throwable)ex);
                }
            }
            caEntry.setCertchain(certchain);
        }
        if (caEntry.getCrlControl() != null && !caEntry.isSaveCert()) {
            throw new InvalidConfException("crlCControl shall be null, since saveCert=true");
        }
        return caEntry;
    }

    private static String getValue(FileOrValue fv, String baseDir) throws IOException {
        if (fv == null) {
            return null;
        }
        if (fv.getValue() != null) {
            String value = fv.getValue();
            if (value.contains("${basedir}")) {
                value = value.replace("${basedir}", baseDir);
            }
            return value;
        }
        String expandedPath = IoUtil.expandFilepath((String)fv.getFile());
        Path path = Paths.get(expandedPath, new String[0]);
        if (!path.isAbsolute()) {
            path = Paths.get(baseDir, expandedPath);
        }
        return StringUtil.toUtf8String((byte[])Files.readAllBytes(path));
    }

    private static CaConfType.CaSystem mergeConfs(List<String> confFiles) throws IOException, InvalidConfException {
        LinkedList cas;
        LinkedList<CaConfType.NameTypeConf> keypairGens;
        LinkedList signers;
        LinkedList publishers;
        LinkedList requestors;
        LinkedList profiles;
        CaConfType.CaSystem conf0 = (CaConfType.CaSystem)CaJson.parseObject((Path)Paths.get(IoUtil.expandFilepath((String)confFiles.get(0), (boolean)true), new String[0]), CaConfType.CaSystem.class);
        HashMap dbSchemas = conf0.getDbSchemas();
        if (dbSchemas == null) {
            dbSchemas = new HashMap();
            conf0.setDbSchemas(dbSchemas);
        }
        if ((profiles = conf0.getProfiles()) == null) {
            profiles = new LinkedList();
            conf0.setProfiles(profiles);
        }
        if ((requestors = conf0.getRequestors()) == null) {
            requestors = new LinkedList();
            conf0.setRequestors(requestors);
        }
        if ((publishers = conf0.getPublishers()) == null) {
            publishers = new LinkedList();
            conf0.setPublishers(publishers);
        }
        if ((signers = conf0.getSigners()) == null) {
            signers = new LinkedList();
            conf0.setSigners(signers);
        }
        if ((keypairGens = conf0.getKeypairGens()) == null) {
            keypairGens = new LinkedList<CaConfType.NameTypeConf>();
            conf0.setKeypairGens(keypairGens);
        }
        if ((cas = conf0.getCas()) == null) {
            cas = new LinkedList();
            conf0.setCas(cas);
        }
        for (int i = 1; i < confFiles.size(); ++i) {
            CaConfType.CaSystem root = (CaConfType.CaSystem)CaJson.parseObject((Path)Paths.get(IoUtil.expandFilepath((String)confFiles.get(i), (boolean)true), new String[0]), CaConfType.CaSystem.class);
            if (root.getDbSchemas() != null) {
                for (Map.Entry entry : root.getDbSchemas().entrySet()) {
                    String name = (String)entry.getKey();
                    if (!dbSchemas.containsKey(name) || CompareUtil.equalsObject(dbSchemas.get(name), entry.getValue())) continue;
                    throw new InvalidConfException("Duplicated DbSchema '" + name + "' but with differnt values");
                }
            }
            if (root.getRequestors() != null) {
                requestors.addAll(root.getRequestors());
            }
            if (root.getPublishers() != null) {
                publishers.addAll(root.getPublishers());
            }
            if (root.getProfiles() != null) {
                profiles.addAll(root.getProfiles());
            }
            if (root.getKeypairGens() != null) {
                keypairGens.addAll(root.getKeypairGens());
            }
            if (root.getSigners() != null) {
                signers.addAll(root.getSigners());
            }
            if (root.getCas() == null) continue;
            cas.addAll(root.getCas());
        }
        boolean withSoftwareKeyPairGen = false;
        String nameSoftware = "software";
        for (CaConfType.NameTypeConf nameTypeConf : keypairGens) {
            if (!nameSoftware.equalsIgnoreCase(nameTypeConf.getName())) continue;
            withSoftwareKeyPairGen = true;
            if ("software".equalsIgnoreCase(nameTypeConf.getType())) break;
            throw new InvalidConfException("KeyPairGen name 'software' is reserved");
        }
        if (!withSoftwareKeyPairGen) {
            CaConfType.NameTypeConf sw = new CaConfType.NameTypeConf();
            sw.setName(nameSoftware);
            sw.setType("software");
            keypairGens.add(sw);
        }
        return conf0;
    }

    private static Map<String, Integer> assertNameIdUnique(List<? extends CaConfType.IdNameConf> list, String type) throws InvalidConfException {
        HashMap<String, Integer> nameIdMap = new HashMap<String, Integer>();
        for (CaConfType.IdNameConf idNameConf : list) {
            String name = idNameConf.getName();
            if (nameIdMap.containsKey(name)) {
                throw new InvalidConfException("Duplicated name of " + type + " " + name);
            }
            Integer id = idNameConf.getId();
            if (id == null) {
                throw new InvalidConfException("id shall not be null");
            }
            if (id == 0) {
                throw new InvalidConfException("id value 0 is not allowed");
            }
            if (nameIdMap.containsValue(id)) {
                throw new InvalidConfException("Duplicated id of " + type + " " + name);
            }
            nameIdMap.put(name, id);
        }
        return nameIdMap;
    }

    private static List<String> assertNameUnique(List<? extends CaConfType.NameTypeConf> list, String type) throws InvalidConfException {
        ArrayList<String> names = new ArrayList<String>(list.size());
        for (CaConfType.NameTypeConf nameTypeConf : list) {
            String name = nameTypeConf.getName();
            if (names.contains(name)) {
                throw new InvalidConfException("Duplicated name of " + type + " " + name);
            }
            names.add(name);
        }
        return names;
    }

    private static String getBase64Value(FileOrBinary fb, String baseDir) throws IOException {
        byte[] binary = FileCaConfStore.getBinary(fb, baseDir);
        return binary == null ? null : Base64.encodeToString((byte[])binary);
    }

    private static byte[] getBinary(FileOrBinary fb, String baseDir) throws IOException {
        if (fb == null) {
            return null;
        }
        if (fb.getBinary() != null) {
            return fb.getBinary();
        }
        String expandedPath = IoUtil.expandFilepath((String)fb.getFile());
        Path path = Paths.get(expandedPath, new String[0]);
        if (!path.isAbsolute()) {
            path = Paths.get(baseDir, expandedPath);
        }
        return Files.readAllBytes(path);
    }

    @Override
    public boolean needsCertStore() {
        return this.needsCertStore;
    }

    @Override
    public SystemEvent getSystemEvent(String eventName) throws CaMgmtException {
        return null;
    }

    @Override
    public void changeSystemEvent(SystemEvent systemEvent) throws CaMgmtException {
    }

    @Override
    public Map<String, Integer> createCaAliases() throws CaMgmtException {
        return this.aliasToCaIds;
    }

    @Override
    public CertprofileEntry createCertprofile(String name) throws CaMgmtException {
        return Optional.ofNullable(this.certprofileTable.get(name)).orElseThrow(() -> new CaMgmtException("Unknown Certprofile " + name));
    }

    @Override
    public PublisherEntry createPublisher(String name) throws CaMgmtException {
        return Optional.ofNullable(this.publisherTable.get(name)).orElseThrow(() -> new CaMgmtException("Unknown Publisher " + name));
    }

    @Override
    public Integer getRequestorId(String requestorName) throws CaMgmtException {
        return this.requestorNameToIdMap.get(requestorName);
    }

    @Override
    public RequestorEntry createRequestor(String name) throws CaMgmtException {
        return Optional.ofNullable(this.requestorTable.get(name)).orElseThrow(() -> new CaMgmtException("Unknown Requestor " + name));
    }

    @Override
    public SignerEntry createSigner(String name) throws CaMgmtException {
        return Optional.ofNullable(this.signerTable.get(name)).orElseThrow(() -> new CaMgmtException("Unknown Signer " + name));
    }

    @Override
    public KeypairGenEntry createKeypairGen(String name) throws CaMgmtException {
        return Optional.ofNullable(this.keypairGenTable.get(name)).orElseThrow(() -> new CaMgmtException("Unknown KeypairGen " + name));
    }

    @Override
    public CaInfo createCaInfo(String name, CertStore certstore) throws CaMgmtException {
        CaEntry caEntry = this.caTable.get(name);
        if (caEntry == null) {
            throw new CaMgmtException("unknown CA " + name);
        }
        try {
            return new CaInfo(caEntry, CaConfColumn.fromBaseCaInfo((BaseCaInfo)caEntry), certstore);
        }
        catch (OperationException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    @Override
    public Set<CaHasRequestorEntry> createCaHasRequestors(NameId ca) throws CaMgmtException {
        return this.caHasRequestors.get(ca.getName());
    }

    @Override
    public Set<CaProfileIdAliases> createCaHasProfiles(NameId ca) throws CaMgmtException {
        return this.caHasProfiles.get(ca.getName());
    }

    @Override
    public Set<Integer> createCaHasPublishers(NameId ca) throws CaMgmtException {
        return this.caHasPublisherIds.get(ca.getName());
    }

    @Override
    public void addCa(CaEntry caEntry) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void addCaAlias(String aliasName, NameId ca) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void addCertprofile(CertprofileEntry dbEntry) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void addCertprofileToCa(NameId profile, NameId ca, List<String> aliases) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void addPublisherToCa(NameId publisher, NameId ca) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void addRequestor(RequestorEntry dbEntry) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public NameId addEmbeddedRequestor(String requestorName) throws CaMgmtException {
        if ("by-ca".equals(requestorName)) {
            return new NameId(Integer.valueOf(1), "by-ca");
        }
        throw readOnlyException;
    }

    @Override
    public void addRequestorToCa(CaHasRequestorEntry requestor, NameId ca) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void addPublisher(PublisherEntry dbEntry) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void changeCa(ChangeCaEntry changeCaEntry, CaConfColumn currentCaConfColumn, SecurityFactory securityFactory) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void commitNextCrlNoIfLess(NameId ca, long nextCrlNo) throws CaMgmtException {
    }

    @Override
    public IdentifiedCertprofile changeCertprofile(NameId nameId, String type, String conf, CaManagerImpl certprofileManager) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public RequestorEntryWrapper changeRequestor(NameId nameId, String type, String conf) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public SignerEntry changeSigner(String name, String type, String conf, String base64Cert, CaManagerImpl signerManager) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public KeypairGenEntryWrapper changeKeypairGen(String name, String type, String conf, CaManagerImpl manager) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public IdentifiedCertPublisher changePublisher(String name, String type, String conf, CaManagerImpl publisherManager) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void removeCaAlias(String aliasName) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void removeDbSchema(String name) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void addKeypairGen(KeypairGenEntry dbEntry) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void addSigner(SignerEntry dbEntry) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void unlockCa() throws CaMgmtException {
    }

    @Override
    public void unrevokeCa(String caName) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public int getDbSchemaVersion() {
        return 9;
    }

    @Override
    public void addDbSchema(String name, String value) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public void changeDbSchema(String name, String value) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public Map<String, String> getDbSchemas() throws CaMgmtException {
        return this.dbSchemas;
    }

    @Override
    public List<String> getCaNames() throws CaMgmtException {
        return this.caNames;
    }

    @Override
    public boolean deleteCa(String name) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public List<String> getKeyPairGenNames() throws CaMgmtException {
        return this.keyPairGenNames;
    }

    @Override
    public boolean deleteKeyPairGen(String name) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public List<String> getProfileNames() throws CaMgmtException {
        return this.profileNames;
    }

    @Override
    public boolean deleteProfile(String name) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public List<String> getPublisherNames() throws CaMgmtException {
        return this.publisherNames;
    }

    @Override
    public boolean deletePublisher(String name) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public List<String> getRequestorNames() throws CaMgmtException {
        return this.requestorNames;
    }

    @Override
    public boolean deleteRequestor(String name) throws CaMgmtException {
        throw readOnlyException;
    }

    @Override
    public List<String> getSignerNames() throws CaMgmtException {
        return this.signerNames;
    }

    @Override
    public boolean deleteSigner(String name) throws CaMgmtException {
        throw readOnlyException;
    }
}

