/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.kpgen.KeypairGenerator;
import org.xipki.ca.api.mgmt.CaProfileEntry;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.CtLogClient;
import org.xipki.ca.server.CtLogPublicKeyFinder;
import org.xipki.ca.server.GrandCertTemplateBuilder;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.X509CaModule;
import org.xipki.ca.server.X509CrlModule;
import org.xipki.ca.server.X509PublisherModule;
import org.xipki.ca.server.X509RemoverModule;
import org.xipki.ca.server.X509RevokerModule;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.license.api.CmLicense;
import org.xipki.pki.BadCertTemplateException;
import org.xipki.pki.ErrorCode;
import org.xipki.pki.OperationException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.ctlog.CtLog;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConcurrentBag;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class X509Ca
extends X509CaModule
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(X509Ca.class);
    private final CtLogClient ctlogClient;
    private final CertStore certstore;
    private final CaIdNameMap caIdNameMap;
    private final CaManagerImpl caManager;
    private final X509PublisherModule publisherModule;
    private final X509CrlModule crlModule;
    private final GrandCertTemplateBuilder grandCertTemplateBuilder;
    private final X509RevokerModule revokerModule;
    private final X509RemoverModule removerModule;
    private final boolean saveCert;
    private final boolean saveKeypair;

    public X509Ca(CaManagerImpl caManager, CaInfo caInfo, CertStore certstore, CtLogClient ctlogClient) throws OperationException {
        super(caInfo);
        if (caInfo.isSignerRequired()) {
            try {
                caInfo.initSigner(caManager.getSecurityFactory());
            }
            catch (XiSecurityException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("security.createSigner caSigner for CA " + this.caIdent));
                throw new OperationException(ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
            }
        }
        this.caManager = (CaManagerImpl)Args.notNull((Object)caManager, (String)"caManager");
        this.caIdNameMap = caManager.idNameMap();
        this.ctlogClient = ctlogClient;
        this.certstore = (CertStore)Args.notNull((Object)certstore, (String)"certstore");
        this.publisherModule = new X509PublisherModule(caManager, caInfo, certstore);
        this.crlModule = new X509CrlModule(caManager, caInfo, certstore, this.publisherModule);
        this.grandCertTemplateBuilder = new GrandCertTemplateBuilder(caInfo);
        this.revokerModule = new X509RevokerModule(caManager, caInfo, certstore, this.publisherModule);
        this.removerModule = new X509RemoverModule(caManager, caInfo, certstore, this.publisherModule);
        this.saveKeypair = caInfo.isSaveKeypair();
        this.saveCert = caInfo.isSaveCert();
        if (!this.saveCert) {
            LOG.warn("CA {}: Certificates will not be saved in the database and will not be published!", (Object)caInfo.getIdent().getName());
        }
    }

    public NameId getCaIdent() {
        return this.caIdent;
    }

    public CaInfo getCaInfo() {
        return this.caInfo;
    }

    public X509Cert getCaCert() {
        return this.caCert;
    }

    public List<byte[]> getEncodedCaCertChain() {
        return this.encodedCaCertChain;
    }

    public X509Cert getCert(BigInteger serialNumber) throws OperationException {
        CertificateInfo certInfo = this.certstore.getCertInfo(this.caIdent, this.caCert, serialNumber, this.caIdNameMap);
        return certInfo == null ? null : certInfo.getCert().getCert();
    }

    public X509Cert getCert(X500Name subjectName, String transactionId) throws OperationException {
        return this.certstore.getCert(subjectName, transactionId);
    }

    public CertWithRevocationInfo getCertWithRevocationInfo(BigInteger serialNumber) throws OperationException {
        return this.certstore.getCertWithRevocationInfo(this.caIdent.getId(), serialNumber, this.caIdNameMap);
    }

    public CertWithRevocationInfo getCertWithRevocationInfoBySubject(X500Name subject, byte[] san) throws OperationException {
        return this.certstore.getCertWithRevocationInfoBySubject(this.caIdent.getId(), subject, san, this.caIdNameMap);
    }

    public List<CertListInfo> listCerts(X500Name subjectPattern, Instant validFrom, Instant validTo, CertListOrderBy orderBy, int numEntries) throws OperationException {
        return this.certstore.listCerts(this.caIdent, subjectPattern, validFrom, validTo, orderBy, numEntries);
    }

    public X509CRLHolder getCurrentCrl(RequestorInfo requestor) throws OperationException {
        return this.getCrl(requestor, null);
    }

    public X509CRLHolder getCrl(RequestorInfo requestor, BigInteger crlNumber) throws OperationException {
        return this.crlModule.getCrl(requestor, crlNumber);
    }

    public X509CRLHolder generateCrlOnDemand(RequestorInfo requestor) throws OperationException {
        return this.crlModule.generateCrlOnDemand(requestor);
    }

    public boolean republishCerts(List<String> publisherNames, int numThreads) {
        return this.publisherModule.republishCerts(publisherNames, numThreads);
    }

    public CertWithRevocationInfo revokeCert(RequestorInfo requestor, BigInteger serialNumber, CrlReason reason, Instant invalidityTime) throws OperationException {
        AuditEvent event = this.newAuditEvent(reason == CrlReason.CERTIFICATE_HOLD ? "suspend_cert" : "revoke_cert", requestor);
        try {
            CertWithRevocationInfo ret = this.revokerModule.revokeCert(serialNumber, reason, invalidityTime, event);
            this.finish(event, true);
            return ret;
        }
        catch (OperationException ex) {
            if (!(ex instanceof OperationExceptionWithIndex)) {
                event.addEventData("message", (Object)ex.getErrorMessage());
            }
            this.finish(event, false);
            throw ex;
        }
    }

    public CertWithDbId unsuspendCert(RequestorInfo requestor, BigInteger serialNumber) throws OperationException {
        AuditEvent event = this.newAuditEvent("unsuspend_cert", requestor);
        try {
            CertWithDbId ret = this.revokerModule.unsuspendCert(serialNumber, event);
            this.finish(event, true);
            return ret;
        }
        catch (OperationException ex) {
            if (!(ex instanceof OperationExceptionWithIndex)) {
                event.addEventData("message", (Object)ex.getErrorMessage());
            }
            this.finish(event, false);
            throw ex;
        }
    }

    public CertWithDbId removeCert(RequestorInfo requestor, BigInteger serialNumber) throws OperationException {
        AuditEvent event = this.newAuditEvent("remove_cert", requestor);
        try {
            CertWithDbId ret = this.removerModule.removeCert(serialNumber, event);
            this.finish(event, true);
            return ret;
        }
        catch (OperationException ex) {
            if (!(ex instanceof OperationExceptionWithIndex)) {
                event.addEventData("message", (Object)ex.getErrorMessage());
            }
            this.finish(event, false);
            throw ex;
        }
    }

    public void revokeCa(RequestorInfo requestor, CertRevocationInfo revocationInfo) throws OperationException {
        this.revokerModule.revokeCa(requestor, revocationInfo);
    }

    public void unrevokeCa(RequestorInfo requestor) throws OperationException {
        this.revokerModule.unrevokeCa(requestor);
    }

    public List<CertificateInfo> generateCerts(RequestorInfo requestor, List<CertTemplateData> certTemplates, String transactionId) throws OperationException {
        AuditEvent event = this.newAuditEvent("gen_cert", requestor);
        try {
            List<CertificateInfo> ret = this.generateCerts(requestor, certTemplates, transactionId, event);
            this.finish(event, true);
            return ret;
        }
        catch (OperationExceptionWithIndex ex) {
            this.finish(event, false);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private List<CertificateInfo> generateCerts(RequestorInfo requestor, List<CertTemplateData> certTemplates, String transactionId, AuditEvent event) throws OperationExceptionWithIndex {
        GrantedCertTemplate gct;
        List<String> keypairGenNames;
        Args.notEmpty(certTemplates, (String)"certTemplates");
        CmLicense license = this.caManager.getLicense();
        if (!license.isValid()) {
            LOG.error("License not valid yet or expired, need new license");
            throw new OperationExceptionWithIndex(0, new OperationException(ErrorCode.SYSTEM_FAILURE, "License not valid yet or expired"));
        }
        int n = certTemplates.size();
        ArrayList<GrantedCertTemplate> gcts = new ArrayList<GrantedCertTemplate>(n);
        ArrayList<KeypairGenerator> keypairGenerators = null;
        boolean caGenKeypair = false;
        for (Object certTemplate : certTemplates) {
            if (!((CertTemplateData)certTemplate).isServerkeygen()) continue;
            caGenKeypair = true;
            break;
        }
        if (caGenKeypair && CollectionUtil.isNotEmpty(keypairGenNames = this.caInfo.getKeypairGenNames())) {
            keypairGenerators = new ArrayList<KeypairGenerator>(keypairGenNames.size());
            for (String name : keypairGenNames) {
                KeypairGenerator keypairGen = this.caManager.getKeypairGenerator(name);
                if (keypairGen == null) continue;
                keypairGenerators.add(keypairGen);
            }
        }
        boolean batch = n > 1;
        for (int i = 0; i < n; ++i) {
            CertTemplateData certTemplate = certTemplates.get(i);
            try {
                IdentifiedCertprofile certprofile = Optional.ofNullable(this.getX509Certprofile(certTemplate.getCertprofileName())).orElseThrow(() -> new OperationException(ErrorCode.UNKNOWN_CERT_PROFILE, "unknown cert profile " + certTemplate.getCertprofileName()));
                gct = this.grandCertTemplateBuilder.create(batch, certprofile, certTemplate, keypairGenerators);
                gct.audit(event);
                gcts.add(gct);
                continue;
            }
            catch (OperationException ex) {
                LOG.error("     FAILED createGrantedCertTemplate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certTemplate.getCertprofileName(), certTemplate.getSubject()});
                event.addEventData((String)(batch ? certTemplate.getCertReqId() + "." : "") + "message", (Object)ex.getMessage());
                throw new OperationExceptionWithIndex(i, ex);
            }
        }
        ArrayList<CertificateInfo> certInfos = new ArrayList<CertificateInfo>(n);
        OperationExceptionWithIndex exception = null;
        for (int i = 0; i < n && exception == null; ++i) {
            gct = (GrantedCertTemplate)gcts.get(i);
            NameId certprofilIdent = gct.certprofile.getIdent();
            String subjectText = gct.grantedSubjectText;
            LOG.info("     START generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
            boolean successful = false;
            try {
                long numOfCerts;
                String caSubject = this.caInfo.getCert().getSubjectText();
                if (!license.grantAllCAs() && !license.grant(caSubject)) {
                    LOG.error("Not granted for CA {}, need new license", (Object)caSubject);
                    throw new OperationException(ErrorCode.SYSTEM_FAILURE, "new license needed");
                }
                long maxNumOfCerts = license.getMaxNumberOfCerts();
                if (maxNumOfCerts >= 0L && (numOfCerts = this.certstore.getCountOfCerts(0L)) >= maxNumOfCerts) {
                    LOG.error("Maximal {} certificates is allowed, {} already issued, need new license", (Object)maxNumOfCerts, (Object)numOfCerts);
                    throw new OperationException(ErrorCode.SYSTEM_FAILURE, "new license needed");
                }
                license.regulateSpeed();
                CertificateInfo certInfo = this.generateCert(requestor, i, gct, transactionId, event);
                successful = true;
                certInfos.add(certInfo);
                if (LOG.isInfoEnabled()) {
                    String prefix = certInfo.isAlreadyIssued() ? "RETURN_OLD_CERT" : "SUCCESSFUL";
                    CertWithDbId cert = certInfo.getCert();
                    LOG.info("{} generateCertificate: CA={}, profile={}, subject='{}', serialNumber={}", new Object[]{prefix, this.caIdent.getName(), certprofilIdent.getName(), cert.getCert().getSubjectText(), cert.getCert().getSerialNumberHex()});
                }
                if (successful) continue;
            }
            catch (OperationException ex) {
                exception = new OperationExceptionWithIndex(i, ex);
                if (successful) continue;
                LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
                continue;
            }
            catch (Throwable th) {
                exception = new OperationExceptionWithIndex(i, new OperationException(ErrorCode.SYSTEM_FAILURE, th));
                if (successful) continue;
                {
                    catch (Throwable throwable) {
                        if (!successful) {
                            LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
                        }
                        throw throwable;
                    }
                }
                LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
                continue;
            }
            LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
            continue;
        }
        if (exception != null) {
            LOG.error("could not generate certificate for request[{}], reverted all generated certificates", (Object)exception.getIndex());
            for (CertificateInfo m : certInfos) {
                BigInteger serial = m.getCert().getCert().getSerialNumber();
                try {
                    this.removeCert(requestor, serial);
                }
                catch (Throwable thr) {
                    LogUtil.error((Logger)LOG, (Throwable)thr, (String)("could not delete certificate serial=" + serial));
                }
            }
            LogUtil.warn((Logger)LOG, (Throwable)((Object)exception));
            throw exception;
        }
        return certInfos;
    }

    public CertificateInfo generateCert(RequestorInfo requestor, CertTemplateData certTemplate, String transactionId) throws OperationException {
        Args.notNull((Object)certTemplate, (String)"certTemplate");
        AuditEvent event = this.newAuditEvent("gen_cert", requestor);
        try {
            CertificateInfo ret = this.generateCerts(requestor, Collections.singletonList(certTemplate), transactionId, event).get(0);
            this.finish(event, true);
            return ret;
        }
        catch (OperationException ex) {
            if (!(ex instanceof OperationExceptionWithIndex)) {
                event.addEventData("message", (Object)ex.getErrorMessage());
            }
            this.finish(event, false);
            throw ex;
        }
    }

    private CertificateInfo generateCert(RequestorInfo requestor, int index, GrantedCertTemplate gct, String transactionId, AuditEvent event) throws OperationExceptionWithIndex {
        try {
            CertificateInfo ret = this.generateCert0(requestor, gct, transactionId, event);
            this.setEventStatus(event, ret != null);
            return ret;
        }
        catch (OperationException ex) {
            event.addEventData(gct.auditPrefix() + "message", (Object)ex.getMessage());
            this.setEventStatus(event, false);
            if (ex instanceof OperationExceptionWithIndex) {
                throw (OperationExceptionWithIndex)ex;
            }
            throw new OperationExceptionWithIndex(index, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertificateInfo generateCert0(RequestorInfo requestor, GrantedCertTemplate gct, String transactionId, AuditEvent event) throws OperationException {
        CertificateInfo ret;
        boolean ctlogEnabled;
        Args.notNull((Object)gct, (String)"gct");
        IdentifiedCertprofile certprofile = gct.certprofile;
        Certprofile.ExtensionControl extnSctCtrl = certprofile.getExtensionControls().get(ObjectIdentifiers.Extn.id_SCTs);
        boolean bl = ctlogEnabled = this.caInfo.getCtlogControl() != null && this.caInfo.getCtlogControl().isEnabled();
        if (!ctlogEnabled && extnSctCtrl != null && extnSctCtrl.isRequired()) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "extension " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)ObjectIdentifiers.Extn.id_SCTs) + " is required but CTLog of the CA is not activated");
        }
        String auditPrefix = gct.auditPrefix();
        String serialNumberMode = certprofile.getSerialNumberMode();
        BigInteger serialNumber = null;
        do {
            if (StringUtil.isBlank((String)serialNumberMode) || "CA".equalsIgnoreCase(serialNumberMode)) {
                serialNumber = this.caInfo.nextSerial();
                if (this.caInfo.getCaEntry().getSnSize() <= 12) continue;
                break;
            }
            if ("PROFILE".equalsIgnoreCase(serialNumberMode)) {
                try {
                    BigInteger previousSerialNumber = serialNumber;
                    ConfPairs extraControl = this.caInfo.getExtraControl();
                    serialNumber = certprofile.generateSerialNumber(this.caInfo.getCert().getSubject(), this.caInfo.getCert().getSubjectPublicKeyInfo(), gct.requestedSubject, gct.grantedPublicKey, extraControl == null ? null : extraControl.unmodifiable());
                    if (serialNumber.equals(previousSerialNumber)) {
                        String message = "serialNumber generated by the profile " + certprofile.getIdent().getName() + " has been used before.";
                        throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, message);
                    }
                    continue;
                }
                catch (CertprofileException ex) {
                    String message = "error generateSerialNumber";
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)message);
                    throw new OperationException(ErrorCode.SYSTEM_FAILURE, message);
                }
            }
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "unknown SerialNumberMode '" + serialNumberMode + "'");
        } while (this.certstore.getCertId(this.caIdent, serialNumber) != 0L);
        event.addEventData(auditPrefix + "serial", (Object)LogUtil.formatCsn((BigInteger)serialNumber));
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(this.caInfo.getPublicCaInfo().getSubject(), serialNumber, Date.from(gct.grantedNotBefore), Date.from(gct.grantedNotAfter), gct.grantedSubject, gct.grantedPublicKey);
        try {
            int certSize;
            X509CertificateHolder bcCert;
            ConcurrentBag.BagEntry signer0;
            boolean addCtlog;
            SignerEntry crlSigner = this.crlModule.getCrlSigner();
            X509Cert crlSignerCert = crlSigner == null ? null : crlSigner.getCertificate();
            ExtensionValues extensionTuples = certprofile.getExtensions(gct.requestedSubject, gct.grantedSubject, gct.extensions, gct.grantedPublicKey, this.caInfo.getPublicCaInfo(), crlSignerCert, gct.grantedNotBefore, gct.grantedNotAfter);
            CaUtil.addExtensions(extensionTuples, certBuilder);
            boolean bl2 = addCtlog = ctlogEnabled && extnSctCtrl != null;
            if (addCtlog) {
                DEROctetString extnValue;
                X509CertificateHolder precert;
                certBuilder.addExtension(ObjectIdentifiers.Extn.id_precertificate, true, (ASN1Encodable)DERNull.INSTANCE);
                try {
                    signer0 = gct.signer.borrowSigner();
                }
                catch (NoIdleSignerException ex) {
                    throw new OperationException(ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
                }
                try {
                    precert = certBuilder.build((ContentSigner)signer0.value());
                }
                finally {
                    gct.signer.requiteSigner(signer0);
                }
                CtLogPublicKeyFinder finder = Optional.ofNullable(this.caManager.getCtLogPublicKeyFinder()).orElseThrow(() -> new OperationException(ErrorCode.SYSTEM_FAILURE, "ctLog not configured for CA " + this.caInfo.getIdent().getName()));
                CtLog.SignedCertificateTimestampList scts = this.ctlogClient.getCtLogScts(precert, this.caCert, this.caInfo.getCertchain(), finder);
                certBuilder.removeExtension(ObjectIdentifiers.Extn.id_precertificate);
                try {
                    extnValue = new DEROctetString(new DEROctetString(scts.getEncoded()).getEncoded());
                }
                catch (IOException ex) {
                    throw new CertIOException("could not encode SCT extension", (Throwable)ex);
                }
                certBuilder.addExtension(new Extension(ObjectIdentifiers.Extn.id_SCTs, extnSctCtrl.isCritical(), (ASN1OctetString)extnValue));
            }
            try {
                signer0 = gct.signer.borrowSigner();
            }
            catch (NoIdleSignerException ex) {
                throw new OperationException(ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
            }
            try {
                bcCert = certBuilder.build((ContentSigner)signer0.value());
            }
            finally {
                gct.signer.requiteSigner(signer0);
            }
            byte[] encodedCert = bcCert.getEncoded();
            int maxCertSize = gct.certprofile.getMaxCertSize();
            if (maxCertSize > 0 && (certSize = encodedCert.length) > maxCertSize) {
                throw new OperationException(ErrorCode.NOT_PERMITTED, String.format("certificate exceeds the maximal allowed size: %d > %d", certSize, maxCertSize));
            }
            X509Cert cert = new X509Cert(bcCert, encodedCert);
            if (!this.verifySignature(cert)) {
                throw new OperationException(ErrorCode.SYSTEM_FAILURE, "could not verify the signature of generated certificate");
            }
            CertWithDbId certWithMeta = new CertWithDbId(cert);
            ret = new CertificateInfo(certWithMeta, gct.privateKey, this.caIdent, this.caCert, gct.certprofile.getIdent(), requestor.getIdent());
            ret.setTransactionId(transactionId);
            ret.setRequestedSubject(gct.requestedSubject);
            if (this.saveCert && this.publisherModule.publishCert(ret, this.saveKeypair) == 1) {
                throw new OperationException(ErrorCode.SYSTEM_FAILURE, "could not save certificate");
            }
        }
        catch (BadCertTemplateException ex) {
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        catch (OperationException ex) {
            throw ex;
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not generate certificate");
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, th);
        }
        if (gct.warning != null) {
            ret.setWarningMessage(gct.warning);
        }
        return ret;
    }

    public IdentifiedCertprofile getX509Certprofile(String certprofileName) {
        if (certprofileName == null) {
            return null;
        }
        Set<CaProfileEntry> profileNameAndAliases = this.caManager.getCertprofilesForCa(this.caIdent.getName());
        CaProfileEntry matchedEntry = null;
        for (CaProfileEntry entry : profileNameAndAliases) {
            if (!entry.containsNameOrAlias(certprofileName)) continue;
            matchedEntry = entry;
            break;
        }
        return matchedEntry == null ? null : this.caManager.getIdentifiedCertprofile(matchedEntry.getProfileName());
    }

    public RequestorInfo.CertRequestorInfo getRequestor(X509Cert requestorCert) {
        Set<CaHasRequestorEntry> requestorEntries = this.caManager.getRequestorsForCa(this.caIdent.getName());
        if (CollectionUtil.isEmpty(requestorEntries)) {
            return null;
        }
        for (CaHasRequestorEntry m : requestorEntries) {
            RequestorEntryWrapper entry = this.caManager.getRequestorWrapper(m.getRequestorIdent().getName());
            if (!"cert".equals(entry.getDbEntry().getType()) || entry.getDbEntry().faulty() || !entry.getCert().getCert().equals((Object)requestorCert)) continue;
            return new RequestorInfo.CertRequestorInfo(m, entry.getCert());
        }
        return null;
    }

    public boolean healthy() {
        ConcurrentContentSigner signer = this.caInfo.getSigner(null);
        boolean healthy = true;
        if (signer != null) {
            healthy = signer.isHealthy();
        }
        if (healthy) {
            healthy = this.certstore.isHealthy();
        }
        if (healthy) {
            healthy = this.crlModule.healthy();
        }
        return healthy;
    }

    public String getHexSha1OfCert() {
        return this.caInfo.getHexSha1OfCert();
    }

    @Override
    public void close() {
        this.crlModule.close();
        this.revokerModule.close();
        ScheduledThreadPoolExecutor executor = this.caManager.getScheduledThreadPoolExecutor();
        if (executor != null) {
            executor.purge();
        }
    }

    static class OperationExceptionWithIndex
    extends OperationException {
        private final int index;

        public OperationExceptionWithIndex(int index, OperationException underlying) {
            super(underlying.getErrorCode(), underlying.getErrorMessage());
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    static class GrantedCertTemplate {
        private final BigInteger certId;
        private final boolean batch;
        private final ConcurrentContentSigner signer;
        private final Extensions extensions;
        private final IdentifiedCertprofile certprofile;
        private final Instant grantedNotBefore;
        private final Instant grantedNotAfter;
        private final X500Name requestedSubject;
        private final SubjectPublicKeyInfo grantedPublicKey;
        private final PrivateKeyInfo privateKey;
        private final String warning;
        private X500Name grantedSubject;
        private String grantedSubjectText;

        GrantedCertTemplate(boolean batch, BigInteger certId, Extensions extensions, IdentifiedCertprofile certprofile, Instant grantedNotBefore, Instant grantedNotAfter, X500Name requestedSubject, SubjectPublicKeyInfo grantedPublicKey, PrivateKeyInfo privateKey, ConcurrentContentSigner signer, String warning) {
            this.batch = batch;
            this.certId = certId == null ? BigInteger.ZERO : certId;
            this.extensions = extensions;
            this.certprofile = certprofile;
            this.grantedNotBefore = grantedNotBefore;
            this.grantedNotAfter = grantedNotAfter;
            this.requestedSubject = requestedSubject;
            this.grantedPublicKey = grantedPublicKey;
            this.privateKey = privateKey;
            this.signer = signer;
            this.warning = warning;
        }

        void setGrantedSubject(X500Name subject) {
            this.grantedSubject = subject;
            this.grantedSubjectText = X509Util.x500NameText((X500Name)subject);
        }

        String auditPrefix() {
            return this.batch ? this.certId + "." : "";
        }

        void audit(AuditEvent event) {
            String prefix = this.auditPrefix();
            if (!this.grantedSubject.equals((Object)this.requestedSubject)) {
                event.addEventData(prefix + "req_subject", (Object)("\"" + X509Util.x500NameText((X500Name)this.requestedSubject) + "\""));
            }
            event.addEventData(prefix + "subject", (Object)("\"" + X509Util.x500NameText((X500Name)this.grantedSubject) + "\""));
            event.addEventData(prefix + "certprofile", (Object)this.certprofile.getIdent().getName());
            event.addEventData(prefix + "not_before", (Object)DateUtil.toUtcTimeyyyyMMddhhmmss((Instant)this.grantedNotBefore));
            event.addEventData(prefix + "not_after", (Object)DateUtil.toUtcTimeyyyyMMddhhmmss((Instant)this.grantedNotAfter));
        }
    }
}

