/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CertRepublisher;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.X509CaModule;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;

class X509PublisherModule
extends X509CaModule {
    private final CertStore certstore;
    private final CaIdNameMap caIdNameMap;
    private final CaManagerImpl caManager;

    X509PublisherModule(CaManagerImpl caManager, CaInfo caInfo, CertStore certstore) {
        super(caInfo);
        this.caManager = (CaManagerImpl)Args.notNull((Object)caManager, (String)"caManager");
        this.caIdNameMap = caManager.idNameMap();
        this.certstore = (CertStore)Args.notNull((Object)certstore, (String)"certstore");
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            publisher.caAdded(this.caCert);
        }
    }

    int publishCert(CertificateInfo certInfo, boolean saveKeypair) {
        if (((CertificateInfo)Args.notNull((Object)certInfo, (String)"certInfo")).isAlreadyIssued()) {
            return 0;
        }
        if (!this.certstore.addCert(certInfo, saveKeypair)) {
            return 1;
        }
        ArrayList<String> failedPublishers = null;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            boolean successful;
            try {
                successful = publisher.certificateAdded(certInfo);
            }
            catch (RuntimeException ex) {
                successful = false;
            }
            if (successful) continue;
            if (failedPublishers == null) {
                failedPublishers = new ArrayList<String>(1);
            }
            failedPublishers.add(publisher.getIdent().getName());
        }
        if (failedPublishers == null) {
            return 0;
        }
        if (this.LOG.isWarnEnabled()) {
            this.LOG.warn("could not publish to publishers {}: {}", failedPublishers, (Object)Base64.encodeToString((byte[])certInfo.getCert().getCert().getEncoded(), (boolean)true));
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean republishCerts(List<String> publisherNames, int numThreads) {
        List<IdentifiedCertPublisher> publishers;
        if (publisherNames == null) {
            publishers = this.publishers();
        } else {
            publishers = new ArrayList<IdentifiedCertPublisher>(publisherNames.size());
            for (String publisherName : publisherNames) {
                Object publisher = null;
                for (IdentifiedCertPublisher p : this.publishers()) {
                    if (!p.getIdent().getName().equals(publisherName)) continue;
                    publisher = p;
                    break;
                }
                if (publisher == null) {
                    throw new IllegalArgumentException("could not find publisher " + publisherName + " for CA " + this.caIdent.getName());
                }
                publishers.add((IdentifiedCertPublisher)publisher);
            }
        }
        if (CollectionUtil.isEmpty(publishers)) {
            return true;
        }
        CaStatus status = this.caInfo.getStatus();
        this.caInfo.setStatus(CaStatus.inactive);
        boolean onlyRevokedCerts = true;
        for (IdentifiedCertPublisher publisher : publishers) {
            if (!publisher.publishsGoodCert()) continue;
            onlyRevokedCerts = false;
            break;
        }
        try {
            for (IdentifiedCertPublisher publisher : publishers) {
                boolean successful = publisher.caAdded(this.caCert);
                if (successful) continue;
                this.LOG.error("republish CA certificate {} to publisher {} failed", (Object)this.caIdent.getName(), (Object)publisher.getIdent().getName());
                boolean bl = false;
                return bl;
            }
            if (this.caInfo.getRevocationInfo() != null) {
                for (IdentifiedCertPublisher publisher : publishers) {
                    boolean successful = publisher.caRevoked(this.caCert, this.caInfo.getRevocationInfo());
                    if (successful) continue;
                    this.LOG.error("republishing CA revocation to publisher {} failed", (Object)publisher.getIdent().getName());
                    boolean bl = false;
                    return bl;
                }
            }
            CertRepublisher republisher = new CertRepublisher(this.caIdent, this.caCert, this.caIdNameMap, this.certstore, publishers, onlyRevokedCerts, numThreads);
            boolean bl = republisher.republish();
            return bl;
        }
        finally {
            this.caInfo.setStatus(status);
        }
    }

    void publishCrl(X509CRLHolder crl) {
        try {
            this.certstore.addCrl(this.caIdent, crl);
        }
        catch (Exception ex) {
            this.LOG.error("could not add CRL ca={}, thisUpdate={}: {}, ", new Object[]{this.caIdent.getName(), crl.getThisUpdate(), ex.getMessage()});
            this.LOG.debug("Exception", (Throwable)ex);
            return;
        }
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            try {
                publisher.crlAdded(this.caCert, crl);
            }
            catch (RuntimeException ex) {
                LogUtil.error((Logger)this.LOG, (Throwable)ex, (String)("could not publish CRL to the publisher " + publisher.getIdent()));
            }
        }
    }

    boolean publishCertRemoved(CertWithDbId certToRemove) {
        boolean successful = true;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            boolean singleSuccessful;
            try {
                singleSuccessful = publisher.certificateRemoved(this.caCert, certToRemove);
            }
            catch (RuntimeException ex) {
                singleSuccessful = false;
                LogUtil.warn((Logger)this.LOG, (Throwable)ex, (String)("could not remove certificate from the publisher " + publisher.getIdent()));
            }
            if (singleSuccessful) continue;
            successful = false;
            X509Cert cert = certToRemove.getCert();
            if (!this.LOG.isErrorEnabled()) continue;
            this.LOG.error("removing certificate issuer='{}', serial={}, subject='{}' from publisher {} failed.", new Object[]{cert.getIssuerText(), cert.getSerialNumberHex(), cert.getSubjectText(), publisher.getIdent()});
        }
        return successful;
    }

    void publishCertRevoked(CertWithRevocationInfo revokedCert) {
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            boolean successful;
            try {
                successful = publisher.certificateRevoked(this.caCert, revokedCert.getCert(), revokedCert.getCertprofile(), revokedCert.getRevInfo());
            }
            catch (RuntimeException ex) {
                successful = false;
            }
            if (successful) continue;
            this.LOG.error("could not publish revocation of certificate to the publisher {}", (Object)publisher.getIdent());
        }
    }

    void publishCertUnrevoked(CertWithDbId unrevokedCert) {
        ArrayList<String> failedPublishers = null;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            boolean successful;
            try {
                successful = publisher.certificateUnrevoked(this.caCert, unrevokedCert);
            }
            catch (RuntimeException ex) {
                successful = false;
            }
            if (successful) continue;
            if (failedPublishers == null) {
                failedPublishers = new ArrayList<String>(1);
            }
            failedPublishers.add(publisher.getIdent().getName());
        }
        if (failedPublishers == null) {
            return;
        }
        this.LOG.error("could not publishCertUnrevoked of certificate {} to publishers {}", (Object)unrevokedCert.getCertId(), failedPublishers);
    }

    boolean publishCaRevoked(CertRevocationInfo revocationInfo) {
        boolean succ = true;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            NameId ident = publisher.getIdent();
            boolean successful = publisher.caRevoked(this.caCert, revocationInfo);
            if (successful) {
                this.LOG.info("published event caRevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
                continue;
            }
            succ = false;
            this.LOG.error("could not publish event caRevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
        }
        return succ;
    }

    boolean publishCaUnrevoked() {
        boolean succ = true;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            NameId ident = publisher.getIdent();
            boolean successful = publisher.caUnrevoked(this.caCert);
            if (successful) {
                this.LOG.info("published event caUnrevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
                continue;
            }
            succ = false;
            this.LOG.error("could not publish event caUnrevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
        }
        return succ;
    }

    private List<IdentifiedCertPublisher> publishers() {
        return this.caManager.getIdentifiedPublishersForCa(this.caIdent.getName());
    }
}

