/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.db;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.util.Pack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.server.CaConfStore;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertRevInfoWithSerial;
import org.xipki.ca.server.UniqueIdGenerator;
import org.xipki.ca.server.db.QueryExecutor;
import org.xipki.ca.server.db.ResultRow;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.Passwords;
import org.xipki.pki.ErrorCode;
import org.xipki.pki.OperationException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.FpIdCalculator;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.LruCache;
import org.xipki.util.SqlUtil;

public class CertStore
extends QueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CertStore.class);
    private final String sqlCertForId;
    private final String sqlCertWithRevInfo;
    private final String sqlCertWithRevInfoBySubjectAndSan;
    private final String sqlCertIdByCaSn;
    private final String sqlCertInfo;
    private final String sqlCertStatusForSubjectFp;
    private final String sqlCrl;
    private final String sqlCrlWithNo;
    private final String sqlSelectUnrevokedSn100;
    private final String sqlSelectUnrevokedSn;
    private final LruCache<Integer, String> cacheSqlExpiredSerials = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlSuspendedSerials = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlRevokedCerts = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlSerials = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlSerialsRevoked = new LruCache(5);
    private final UniqueIdGenerator idGenerator;
    private final AtomicInteger cachedCrlId = new AtomicInteger(0);
    private final long earliestNotBefore;
    private final String SQL_ADD_CERT;
    private static final String SQL_REVOKE_CERT = "UPDATE CERT SET LUPDATE=?,REV=?,RT=?,RIT=?,RR=? WHERE ID=?";
    private static final String SQL_REVOKE_SUSPENDED_CERT = "UPDATE CERT SET LUPDATE=?,RR=? WHERE ID=?";
    private static final String SQL_MAX_CRLNO = "SELECT MAX(CRL_NO) FROM CRL WHERE CA_ID=?";
    private static final String SQL_MAX_FULL_CRLNO = "SELECT MAX(CRL_NO) FROM CRL WHERE CA_ID=? AND DELTACRL = 0";
    private static final String SQL_MAX_THISUPDAATE_CRL = "SELECT MAX(THISUPDATE) FROM CRL WHERE CA_ID=? AND DELTACRL=?";
    private final String SQL_ADD_CRL;
    private static final String SQL_REMOVE_CERT_FOR_ID = "DELETE FROM CERT WHERE ID=?";
    private final int dbSchemaVersion;
    private final int maxX500nameLen;
    private final String keypairEncAlg = "AES/GCM/NoPadding";
    private final int keypairEncAlgId = 1;
    private String keypairEncProvider;
    private String keypairEncKeyId;
    private SecretKey keypairEncKey;
    private final CaConfStore caConfStore;

    public CertStore(DataSourceWrapper datasource, CaConfStore caConfStore, UniqueIdGenerator idGenerator) throws DataAccessException, CaMgmtException {
        super(datasource);
        this.caConfStore = (CaConfStore)Args.notNull((Object)caConfStore, (String)"caConfStore");
        Map<String, String> caConfDbSchemaInfo = caConfStore.getDbSchemas();
        String vendor = caConfStore.getDbSchemas().get("VENDOR");
        if (vendor != null && !vendor.equalsIgnoreCase("XIPKI")) {
            throw new CaMgmtException("unsupported vendor " + vendor);
        }
        this.dbSchemaVersion = Integer.parseInt(caConfDbSchemaInfo.get("VERSION"));
        if (this.dbSchemaVersion < 9) {
            throw new CaMgmtException("dbSchemaVersion < 9 unsupported: " + this.dbSchemaVersion);
        }
        String str = caConfDbSchemaInfo.get("X500NAME_MAXLEN");
        this.maxX500nameLen = str == null ? 350 : Integer.parseInt(str);
        String addCertSql = "ID,LUPDATE,SN,SUBJECT,FP_S,FP_RS,FP_SAN,NBEFORE,NAFTER,REV,PID,CA_ID,RID,EE,TID,SHA1,REQ_SUBJECT,CRL_SCOPE,CERT,PRIVATE_KEY";
        this.SQL_ADD_CERT = SqlUtil.buildInsertSql((String)"CERT", (String)addCertSql);
        this.SQL_ADD_CRL = SqlUtil.buildInsertSql((String)"CRL", (String)"ID,CA_ID,CRL_NO,THISUPDATE,NEXTUPDATE,DELTACRL,BASECRL_NO,CRL_SCOPE,SHA1,CRL");
        this.updateDbInfo();
        this.idGenerator = (UniqueIdGenerator)Args.notNull((Object)idGenerator, (String)"idGenerator");
        this.sqlCertForId = this.buildSelectFirstSql("PID,RID,REV,RR,RT,RIT,CERT FROM CERT WHERE ID=?");
        this.sqlCertWithRevInfo = this.buildSelectFirstSql("ID,REV,RR,RT,RIT,PID,CERT FROM CERT WHERE CA_ID=? AND SN=?");
        this.sqlCertWithRevInfoBySubjectAndSan = this.buildSelectFirstSql("NBEFORE DESC", "ID,NBEFORE,REV,RR,RT,RIT,PID,CERT FROM CERT WHERE CA_ID=? AND FP_S=? AND FP_SAN=?");
        this.sqlCertIdByCaSn = this.buildSelectFirstSql("ID FROM CERT WHERE CA_ID=? AND SN=?");
        this.sqlCertInfo = this.buildSelectFirstSql("PID,RID,REV,RR,RT,RIT,CERT FROM CERT WHERE CA_ID=? AND SN=?");
        this.sqlCertStatusForSubjectFp = this.buildSelectFirstSql("REV FROM CERT WHERE FP_S=? AND CA_ID=?");
        this.sqlCrl = this.buildSelectFirstSql("THISUPDATE DESC", "THISUPDATE,CRL FROM CRL WHERE CA_ID=?");
        this.sqlCrlWithNo = this.buildSelectFirstSql("THISUPDATE DESC", "THISUPDATE,CRL FROM CRL WHERE CA_ID=? AND CRL_NO=?");
        this.sqlSelectUnrevokedSn = this.buildSelectFirstSql("LUPDATE FROM CERT WHERE REV=0 AND SN=?");
        String prefix = "SN,LUPDATE FROM CERT WHERE REV=0 AND SN";
        this.sqlSelectUnrevokedSn100 = CertStore.buildArraySql(datasource, "SN,LUPDATE FROM CERT WHERE REV=0 AND SN", 100);
        this.earliestNotBefore = datasource.getMin(null, "CERT", "NBEFORE");
    }

    public void removeCa(String name) throws CaMgmtException {
        this.removeEntry(name, "CA");
    }

    public void removeCertProfile(String name) throws CaMgmtException {
        this.removeEntry(name, "PROFILE");
    }

    public void removeRequestor(String name) throws CaMgmtException {
        this.removeEntry(name, "REQUESTOR");
    }

    private void removeEntry(String name, String table) throws CaMgmtException {
        Args.notBlank((String)name, (String)"name");
        String sql = "DELETE FROM " + table + " WHERE NAME=?";
        try {
            this.execUpdatePrepStmt0(sql, CertStore.col2Str(name));
        }
        catch (OperationException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public void addCertProfile(NameId ident) throws CaMgmtException {
        this.addNameId(ident, "PROFILE");
    }

    public void addRequestor(NameId ident) throws CaMgmtException {
        this.addNameId(ident, "REQUESTOR");
    }

    private void addNameId(NameId ident, String table) throws CaMgmtException {
        int num;
        Args.notNull((Object)ident, (String)"ident");
        if (this.existsIdent(ident, table)) {
            return;
        }
        try {
            String sql = SqlUtil.buildInsertSql((String)table, (String)"ID,NAME");
            num = this.execUpdatePrepStmt0(sql, CertStore.col2Int(ident.getId()), CertStore.col2Str(ident.getName()));
        }
        catch (OperationException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        if (num == 0) {
            throw new CaMgmtException("could not add requestor " + ident);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("added {} '{}'", (Object)table, (Object)ident);
        }
    }

    public void addCa(NameId ident, X509Cert caCert, CertRevocationInfo caRevInfo) throws CaMgmtException {
        int num;
        Args.notNull((Object)ident, (String)"ident");
        Args.notNull((Object)caCert, (String)"caCert");
        if (this.existsIdent(ident, "CA")) {
            byte[] existingCert;
            try {
                existingCert = Base64.decode((String)this.datasource.getFirstStringValue(null, "CA", "CERT", "ID=" + ident.getId()));
            }
            catch (DataAccessException e) {
                throw new CaMgmtException((Throwable)e);
            }
            if (Arrays.equals(existingCert, caCert.getEncoded())) {
                return;
            }
            throw new CaMgmtException("an entry in table CA with ID=" + ident.getId() + " exists, but the certificate differs");
        }
        try {
            String subjectText = X509Util.cutText((String)caCert.getSubjectText(), (int)this.maxX500nameLen);
            String sql = SqlUtil.buildInsertSql((String)"CA", (String)"ID,NAME,REV_INFO,SUBJECT,CERT");
            String caRevInfoStr = caRevInfo == null ? null : caRevInfo.encode();
            num = this.execUpdatePrepStmt0(sql, CertStore.col2Int(ident.getId()), CertStore.col2Str(ident.getName()), CertStore.col2Str(caRevInfoStr), CertStore.col2Str(subjectText), CertStore.col2Str(Base64.encodeToString((byte[])caCert.getEncoded())));
        }
        catch (OperationException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        if (num == 0) {
            throw new CaMgmtException("could not add CA " + ident);
        }
    }

    private boolean existsIdent(NameId ident, String table) throws CaMgmtException {
        String existingName;
        try {
            existingName = this.datasource.getFirstStringValue(null, table, "NAME", "ID=" + ident.getId());
        }
        catch (DataAccessException e) {
            throw new CaMgmtException((Throwable)e);
        }
        if (existingName == null) {
            return false;
        }
        if (ident.getName().equals(existingName)) {
            return true;
        }
        throw new CaMgmtException("an entry in table " + table + " with ID=" + ident.getId() + " exists, but the name differs (expected " + ident.getName() + ", is " + existingName + ")");
    }

    public void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        try {
            this.execUpdatePrepStmt0("UPDATE CA SET REV_INFO=? WHERE NAME=?", CertStore.col2Str(revocationInfo.encode()), CertStore.col2Str(caName));
        }
        catch (OperationException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public void unrevokeCa(String caName) throws CaMgmtException {
        try {
            this.execUpdatePrepStmt0("UPDATE CA SET REV_INFO=? WHERE NAME=?", CertStore.col2Str(null), CertStore.col2Str(caName));
        }
        catch (OperationException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public boolean addCert(CertificateInfo certInfo, boolean saveKeypair) {
        if (saveKeypair && certInfo.getPrivateKey() != null && this.keypairEncKey == null) {
            LOG.error("no keypair encryption key is configured");
            return false;
        }
        Args.notNull((Object)certInfo, (String)"certInfo");
        byte[] encodedCert = null;
        try {
            String privateKeyInfo = null;
            CertWithDbId cert = certInfo.getCert();
            String tid = certInfo.getTransactionId();
            X500Name reqSubject = certInfo.getRequestedSubject();
            long certId = this.idGenerator.nextId();
            if (saveKeypair && certInfo.getPrivateKey() != null) {
                byte[] nonce = new byte[12];
                Pack.longToBigEndian((long)certId, (byte[])nonce, (int)4);
                byte[] encodedPrivateKey = certInfo.getPrivateKey().getEncoded();
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", this.keypairEncProvider);
                GCMParameterSpec spec = new GCMParameterSpec(96, nonce);
                cipher.init(1, (Key)this.keypairEncKey, spec);
                byte[] encrypted = cipher.doFinal(encodedPrivateKey);
                privateKeyInfo = "1:" + this.keypairEncKeyId + ":" + Base64.encodeToString((byte[])nonce) + ":" + Base64.encodeToString((byte[])encrypted);
            }
            String subjectText = X509Util.cutText((String)cert.getCert().getSubjectText(), (int)this.maxX500nameLen);
            long fpSubject = X509Util.fpCanonicalizedName((X500Name)cert.getCert().getSubject());
            byte[] san = cert.getCert().getSubjectAltNames();
            Long fpSan = san == null ? null : Long.valueOf(FpIdCalculator.hash((byte[])san));
            String reqSubjectText = null;
            Long fpReqSubject = null;
            if (reqSubject != null) {
                fpReqSubject = X509Util.fpCanonicalizedName((X500Name)reqSubject);
                if (fpSubject == fpReqSubject) {
                    fpReqSubject = null;
                } else {
                    reqSubjectText = X509Util.cutX500Name((X500Name)CaUtil.sortX509Name(reqSubject), (int)this.maxX500nameLen);
                }
            }
            encodedCert = cert.getCert().getEncoded();
            String b64FpCert = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{encodedCert});
            X509Cert cert0 = cert.getCert();
            boolean isEeCert = cert0.getBasicConstraints() == -1;
            ArrayList<QueryExecutor.SqlColumn2> columns = new ArrayList<QueryExecutor.SqlColumn2>(20);
            columns.add(CertStore.col2Long(certId));
            columns.add(CertStore.col2Long(Instant.now().getEpochSecond()));
            columns.add(CertStore.col2Str(cert0.getSerialNumber().toString(16)));
            columns.add(CertStore.col2Str(subjectText));
            columns.add(CertStore.col2Long(fpSubject));
            columns.add(CertStore.col2Long(fpReqSubject));
            columns.add(CertStore.col2Long(fpSan));
            columns.add(CertStore.col2Long(cert0.getNotBefore().getEpochSecond()));
            columns.add(CertStore.col2Long(cert0.getNotAfter().getEpochSecond()));
            columns.add(CertStore.col2Bool(false));
            columns.add(CertStore.col2Int(certInfo.getProfile().getId()));
            columns.add(CertStore.col2Int(certInfo.getIssuer().getId()));
            columns.add(CertStore.col2Int(certInfo.getRequestor().getId()));
            columns.add(CertStore.col2Int(isEeCert ? 1 : 0));
            columns.add(CertStore.col2Str(tid));
            columns.add(CertStore.col2Str(b64FpCert));
            columns.add(CertStore.col2Str(reqSubjectText));
            columns.add(CertStore.col2Int(0));
            columns.add(CertStore.col2Str(Base64.encodeToString((byte[])encodedCert)));
            columns.add(CertStore.col2Str(privateKeyInfo));
            this.execUpdatePrepStmt0(this.SQL_ADD_CERT, columns.toArray(new QueryExecutor.SqlColumn2[0]));
            cert.setCertId(Long.valueOf(certId));
        }
        catch (Exception ex) {
            LOG.error("could not save certificate {}: {}. Message: {}", new Object[]{certInfo.getCert().getCert().getSubject(), encodedCert == null ? "null" : Base64.encodeToString(encodedCert, (boolean)true), ex.getMessage()});
            LOG.debug("error", (Throwable)ex);
            return false;
        }
        return true;
    }

    public long getMaxFullCrlNumber(NameId ca) throws OperationException {
        return this.getMaxCrlNumber(ca, SQL_MAX_FULL_CRLNO);
    }

    public long getMaxCrlNumber(NameId ca) throws OperationException {
        return this.getMaxCrlNumber(ca, SQL_MAX_CRLNO);
    }

    private long getMaxCrlNumber(NameId ca, String sql) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        long maxCrlNumber = this.execQueryLongPrepStmt(sql, CertStore.col2Int(ca.getId()));
        return maxCrlNumber < 0L ? 0L : maxCrlNumber;
    }

    public long getThisUpdateOfCurrentCrl(NameId ca, boolean deltaCrl) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        return this.execQueryLongPrepStmt(SQL_MAX_THISUPDAATE_CRL, CertStore.col2Int(ca.getId()), CertStore.col2Int(deltaCrl ? 1 : 0));
    }

    public void addCrl(NameId ca, X509CRLHolder crl) throws OperationException, CRLException {
        byte[] encodedCrl;
        this.notNulls(ca, "ca", crl, "crl");
        Extensions extns = crl.getExtensions();
        byte[] extnValue = X509Util.getCoreExtValue((Extensions)extns, (ASN1ObjectIdentifier)Extension.cRLNumber);
        Long crlNumber = extnValue == null ? null : Long.valueOf(ASN1Integer.getInstance((Object)extnValue).getPositiveValue().longValue());
        extnValue = X509Util.getCoreExtValue((Extensions)extns, (ASN1ObjectIdentifier)Extension.deltaCRLIndicator);
        Long baseCrlNumber = null;
        if (extnValue != null) {
            baseCrlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue().longValue();
        }
        int currentMaxCrlId = (int)this.getMax("CRL", "ID");
        int crlId = Math.max(this.cachedCrlId.get(), currentMaxCrlId) + 1;
        this.cachedCrlId.set(crlId);
        try {
            encodedCrl = crl.getEncoded();
        }
        catch (IOException ex) {
            throw new CRLException(ex.getMessage(), ex);
        }
        String b64Sha1 = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{encodedCrl});
        String b64Crl = Base64.encodeToString((byte[])encodedCrl);
        ArrayList<QueryExecutor.SqlColumn2> columns = new ArrayList<QueryExecutor.SqlColumn2>(10);
        columns.add(CertStore.col2Int(crlId));
        columns.add(CertStore.col2Int(ca.getId()));
        columns.add(CertStore.col2Long(crlNumber));
        columns.add(CertStore.col2Long(DateUtil.toEpochSecond((Date)crl.getThisUpdate())));
        columns.add(CertStore.col2Long(CertStore.getDateSeconds(crl.getNextUpdate())));
        columns.add(CertStore.col2Bool(baseCrlNumber != null));
        columns.add(CertStore.col2Long(baseCrlNumber));
        columns.add(CertStore.col2Int(0));
        columns.add(CertStore.col2Str(b64Sha1));
        columns.add(CertStore.col2Str(b64Crl));
        this.execUpdatePrepStmt0(this.SQL_ADD_CRL, columns.toArray(new QueryExecutor.SqlColumn2[0]));
    }

    public CertWithRevocationInfo revokeCert(NameId ca, BigInteger serialNumber, CertRevocationInfo revInfo, boolean force, CaIdNameMap idNameMap) throws OperationException {
        int count;
        this.notNulls(ca, "ca", serialNumber, "serialNumber", revInfo, "revInfo");
        CertWithRevocationInfo certWithRevInfo = this.getCertWithRevocationInfo(ca.getId(), serialNumber, idNameMap);
        if (certWithRevInfo == null) {
            LOG.warn("certificate with CA={} and serialNumber={} does not exist", (Object)ca.getName(), (Object)LogUtil.formatCsn((BigInteger)serialNumber));
            return null;
        }
        CertRevocationInfo currentRevInfo = certWithRevInfo.getRevInfo();
        if (currentRevInfo != null) {
            CrlReason currentReason = currentRevInfo.getReason();
            if (currentReason == CrlReason.CERTIFICATE_HOLD) {
                if (revInfo.getReason() == CrlReason.CERTIFICATE_HOLD) {
                    throw new OperationException(ErrorCode.CERT_REVOKED, "certificate already revoked with the requested reason " + currentReason.getDescription());
                }
                revInfo.setRevocationTime(currentRevInfo.getRevocationTime());
                revInfo.setInvalidityTime(currentRevInfo.getInvalidityTime());
            } else if (!force) {
                throw new OperationException(ErrorCode.CERT_REVOKED, "certificate already revoked with reason " + currentReason.getDescription());
            }
        }
        Long invTimeSeconds = null;
        if (revInfo.getInvalidityTime() != null) {
            invTimeSeconds = revInfo.getInvalidityTime().getEpochSecond();
        }
        if ((count = this.execUpdatePrepStmt0(SQL_REVOKE_CERT, CertStore.col2Long(Instant.now().getEpochSecond()), CertStore.col2Bool(true), CertStore.col2Long(revInfo.getRevocationTime().getEpochSecond()), CertStore.col2Long(invTimeSeconds), CertStore.col2Int(revInfo.getReason().getCode()), CertStore.col2Long(certWithRevInfo.getCert().getCertId()))) != 1) {
            Object message = count > 1 ? count + " rows modified, but exactly one is expected" : "no row is modified, but exactly one is expected";
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, (String)message);
        }
        certWithRevInfo.setRevInfo(revInfo);
        return certWithRevInfo;
    }

    public CertWithRevocationInfo revokeSuspendedCert(NameId ca, SerialWithId serialNumber, CrlReason reason, CaIdNameMap idNameMap) throws OperationException {
        this.notNulls(ca, "ca", serialNumber, "serialNumber", reason, "reason");
        CertWithRevocationInfo certWithRevInfo = this.getCertWithRevocationInfo(serialNumber.getId(), idNameMap);
        if (certWithRevInfo == null) {
            LOG.warn("certificate with CA={} and serialNumber={} does not exist", (Object)ca.getName(), (Object)LogUtil.formatCsn((BigInteger)serialNumber.getSerial()));
            return null;
        }
        CertRevocationInfo currentRevInfo = Optional.ofNullable(certWithRevInfo.getRevInfo()).orElseThrow(() -> new OperationException(ErrorCode.CERT_UNREVOKED, "certificate is not revoked"));
        CrlReason currentReason = currentRevInfo.getReason();
        if (currentReason != CrlReason.CERTIFICATE_HOLD) {
            throw new OperationException(ErrorCode.CERT_REVOKED, "certificate is revoked but not with reason " + CrlReason.CERTIFICATE_HOLD.getDescription());
        }
        int count = this.execUpdatePrepStmt0(SQL_REVOKE_SUSPENDED_CERT, CertStore.col2Long(Instant.now().getEpochSecond()), CertStore.col2Int(reason.getCode()), CertStore.col2Long(serialNumber.getId()));
        if (count != 1) {
            Object message = count > 1 ? count + " rows modified, but exactly one is expected" : "no row is modified, but exactly one is expected";
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, (String)message);
        }
        currentRevInfo.setReason(reason);
        return certWithRevInfo;
    }

    public CertWithDbId unsuspendCert(NameId ca, BigInteger serialNumber, boolean force, CaIdNameMap idNamMap) throws OperationException {
        this.notNulls(ca, "ca", serialNumber, "serialNumber");
        CertWithRevocationInfo certWithRevInfo = this.getCertWithRevocationInfo(ca.getId(), serialNumber, idNamMap);
        if (certWithRevInfo == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("certificate with CA={} and serialNumber={} does not exist", (Object)ca.getName(), (Object)LogUtil.formatCsn((BigInteger)serialNumber));
            }
            return null;
        }
        CertRevocationInfo currentRevInfo = Optional.ofNullable(certWithRevInfo.getRevInfo()).orElseThrow(() -> new OperationException(ErrorCode.CERT_UNREVOKED, "certificate is not revoked"));
        CrlReason currentReason = currentRevInfo.getReason();
        if (!force && currentReason != CrlReason.CERTIFICATE_HOLD) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "could not unsuspend certificate revoked with reason " + currentReason.getDescription());
        }
        QueryExecutor.SqlColumn2 nullInt = new QueryExecutor.SqlColumn2(QueryExecutor.ColumnType.INT, null);
        int count = this.execUpdatePrepStmt0(SQL_REVOKE_CERT, CertStore.col2Long(Instant.now().getEpochSecond()), CertStore.col2Bool(false), nullInt, nullInt, nullInt, CertStore.col2Long(certWithRevInfo.getCert().getCertId()));
        if (count != 1) {
            Object message = count > 1 ? count + " rows modified, but exactly one is expected" : "no row is modified, but exactly one is expected";
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, (String)message);
        }
        return certWithRevInfo.getCert();
    }

    public void removeCert(long id) throws OperationException {
        this.execUpdatePrepStmt0(SQL_REMOVE_CERT_FOR_ID, CertStore.col2Long(id));
    }

    public long getCountOfCerts(NameId ca, boolean onlyRevoked) throws OperationException {
        String sql = onlyRevoked ? "SELECT COUNT(*) FROM CERT WHERE CA_ID=? AND REV=1" : "SELECT COUNT(*) FROM CERT WHERE CA_ID=?";
        return this.execQueryLongPrepStmt(sql, CertStore.col2Int(ca.getId()));
    }

    public long getCountOfCerts(long notBeforeSince) throws OperationException {
        if (notBeforeSince <= this.earliestNotBefore) {
            String sql = "SELECT COUNT(*) FROM CERT";
            return this.execQueryLongPrepStmt("SELECT COUNT(*) FROM CERT", new QueryExecutor.SqlColumn2[0]);
        }
        String sql = "SELECT COUNT(*) FROM CERT WHERE NBEFORE>?";
        return this.execQueryLongPrepStmt("SELECT COUNT(*) FROM CERT WHERE NBEFORE>?", CertStore.col2Long(notBeforeSince - 1L));
    }

    public List<SerialWithId> getSerialNumbers(NameId ca, long startId, int numEntries, boolean onlyRevoked) throws OperationException {
        this.notNulls(ca, "ca", numEntries, "numEntries");
        LruCache<Integer, String> cache = onlyRevoked ? this.cacheSqlSerialsRevoked : this.cacheSqlSerials;
        String sql = (String)cache.get((Object)numEntries);
        if (sql == null) {
            Object coreSql = "ID,SN FROM CERT WHERE ID>? AND CA_ID=?";
            if (onlyRevoked) {
                coreSql = (String)coreSql + "AND REV=1";
            }
            sql = this.datasource.buildSelectFirstSql(numEntries, "ID ASC", (String)coreSql);
            cache.put((Object)numEntries, (Object)sql);
        }
        return this.getSerialWithIds(sql, numEntries, CertStore.col2Long(startId - 1L), CertStore.col2Int(ca.getId()));
    }

    private List<SerialWithId> getSerialWithIds(String sql, int numEntries, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, params);
        ArrayList<SerialWithId> ret = new ArrayList<SerialWithId>();
        for (ResultRow rs : rows) {
            ret.add(new SerialWithId(rs.getLong("ID"), new BigInteger(rs.getString("SN"), 16)));
            if (ret.size() < numEntries) continue;
            break;
        }
        return ret;
    }

    public List<SerialWithId> getExpiredUnrevokedSerialNumbers(NameId ca, long expiredAt, int numEntries) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numEntries, (String)"numEntries");
        String sql = (String)this.cacheSqlExpiredSerials.get((Object)numEntries);
        if (sql == null) {
            sql = this.datasource.buildSelectFirstSql(numEntries, "ID,SN FROM CERT WHERE CA_ID=? AND NAFTER<? AND REV=0");
            this.cacheSqlExpiredSerials.put((Object)numEntries, (Object)sql);
        }
        return this.getSerialNumbers0(sql, numEntries, CertStore.col2Int(ca.getId()), CertStore.col2Long(expiredAt));
    }

    public List<SerialWithId> getSuspendedCertSerials(NameId ca, Instant latestLastUpdate, int numEntries) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        String sql = (String)this.cacheSqlSuspendedSerials.get((Object)Args.positive((int)numEntries, (String)"numEntries"));
        if (sql == null) {
            sql = this.datasource.buildSelectFirstSql(numEntries, "ID,SN FROM CERT WHERE CA_ID=? AND LUPDATE<? AND RR=?");
            this.cacheSqlSuspendedSerials.put((Object)numEntries, (Object)sql);
        }
        return this.getSerialNumbers0(sql, numEntries, CertStore.col2Int(ca.getId()), CertStore.col2Long(latestLastUpdate.getEpochSecond() + 1L), CertStore.col2Int(CrlReason.CERTIFICATE_HOLD.getCode()));
    }

    private List<SerialWithId> getSerialNumbers0(String sql, int numEntries, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, params);
        ArrayList<SerialWithId> ret = new ArrayList<SerialWithId>();
        for (ResultRow row : rows) {
            ret.add(new SerialWithId(row.getLong("ID"), new BigInteger(row.getString("SN"), 16)));
            if (ret.size() < numEntries) continue;
            break;
        }
        return ret;
    }

    private byte[] getEncodedCrl(NameId ca) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        List<ResultRow> rows = this.execQueryPrepStmt0(this.sqlCrl, CertStore.col2Int(ca.getId()));
        long currentThisUpdate = 0L;
        String b64Crl = null;
        for (ResultRow rs : rows) {
            long thisUpdate = rs.getLong("THISUPDATE");
            if (thisUpdate < currentThisUpdate) continue;
            b64Crl = rs.getString("CRL");
            currentThisUpdate = thisUpdate;
        }
        return b64Crl == null ? null : Base64.decodeFast(b64Crl);
    }

    public byte[] getEncodedCrl(NameId ca, BigInteger crlNumber) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        if (crlNumber == null) {
            return this.getEncodedCrl(ca);
        }
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCrlWithNo, CertStore.col2Int(ca.getId()), CertStore.col2Long(crlNumber.longValue()));
        return rs == null ? null : Base64.decodeFast((String)rs.getString("CRL"));
    }

    public int cleanupCrls(NameId ca, int numCrls) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numCrls, (String)"numCrls");
        LinkedList<Long> crlNumbers = new LinkedList<Long>();
        List<ResultRow> rows = this.execQueryPrepStmt0("SELECT CRL_NO FROM CRL WHERE CA_ID=? AND DELTACRL=?", CertStore.col2Int(ca.getId()), CertStore.col2Bool(false));
        for (ResultRow rs : rows) {
            crlNumbers.add(rs.getLong("CRL_NO"));
        }
        int size = crlNumbers.size();
        Collections.sort(crlNumbers);
        int numCrlsToDelete = size - numCrls;
        if (numCrlsToDelete < 1) {
            return 0;
        }
        long crlNumber = (Long)crlNumbers.get(numCrlsToDelete - 1);
        this.execUpdatePrepStmt0("DELETE FROM CRL WHERE CA_ID=? AND CRL_NO<?", CertStore.col2Int(ca.getId()), CertStore.col2Long(crlNumber + 1L));
        return numCrlsToDelete;
    }

    public CertificateInfo getCertForId(NameId ca, X509Cert caCert, long certId, CaIdNameMap idNameMap) throws OperationException {
        this.notNulls(ca, "ca", caCert, "caCert", idNameMap, "idNameMap");
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertForId, CertStore.col2Long(certId));
        if (rs == null) {
            return null;
        }
        X509Cert cert = CertStore.parseCert(Base64.decodeFast((String)rs.getString("CERT")));
        CertWithDbId certWithMeta = new CertWithDbId(cert);
        certWithMeta.setCertId(Long.valueOf(certId));
        CertificateInfo certInfo = new CertificateInfo(certWithMeta, null, ca, caCert, idNameMap.getCertprofile(rs.getInt("PID")), idNameMap.getRequestor(rs.getInt("RID")));
        certInfo.setRevocationInfo(CertStore.buildCertRevInfo(rs));
        return certInfo;
    }

    public CertWithRevocationInfo getCertWithRevocationInfo(long certId, CaIdNameMap idNameMap) throws OperationException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertForId, CertStore.col2Long(certId));
        if (rs == null) {
            return null;
        }
        return this.buildCertWithRevInfo(certId, rs, idNameMap);
    }

    public CertWithRevocationInfo getCertWithRevocationInfo(int caId, BigInteger serial, CaIdNameMap idNameMap) throws OperationException {
        this.notNulls(serial, "serial", idNameMap, "idNameMap");
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertWithRevInfo, CertStore.col2Int(caId), CertStore.col2Str(serial.toString(16)));
        if (rs == null) {
            return null;
        }
        return this.buildCertWithRevInfo(rs.getLong("ID"), rs, idNameMap);
    }

    public CertWithRevocationInfo getCertWithRevocationInfoBySubject(int caId, X500Name subject, byte[] san, CaIdNameMap idNameMap) throws OperationException {
        Args.notNull((Object)subject, (String)"subject");
        long fpSubject = X509Util.fpCanonicalizedName((X500Name)subject);
        Long fpSan = san == null ? null : Long.valueOf(FpIdCalculator.hash((byte[])san));
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertWithRevInfoBySubjectAndSan, CertStore.col2Int(caId), CertStore.col2Long(fpSubject), CertStore.col2Long(fpSan));
        if (rs == null) {
            return null;
        }
        return this.buildCertWithRevInfo(rs.getLong("ID"), rs, idNameMap);
    }

    private CertWithRevocationInfo buildCertWithRevInfo(long certId, ResultRow rs, CaIdNameMap idNameMap) throws OperationException {
        X509Cert cert = CertStore.parseCert(Base64.decodeFast((String)rs.getString("CERT")));
        CertWithDbId certWithMeta = new CertWithDbId(cert);
        certWithMeta.setCertId(Long.valueOf(certId));
        CertWithRevocationInfo ret = new CertWithRevocationInfo();
        ret.setCertprofile(idNameMap.getCertprofileName(rs.getInt("PID")));
        ret.setCert(certWithMeta);
        ret.setRevInfo(CertStore.buildCertRevInfo(rs));
        return ret;
    }

    public long getCertId(NameId ca, BigInteger serial) throws OperationException {
        this.notNulls(ca, "ca", serial, "serial");
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertIdByCaSn, CertStore.col2Int(ca.getId()), CertStore.col2Str(serial.toString(16)));
        return rs == null ? 0L : rs.getLong("ID");
    }

    public CertificateInfo getCertInfo(NameId ca, X509Cert caCert, BigInteger serial, CaIdNameMap idNameMap) throws OperationException {
        this.notNulls(ca, "ca", caCert, "caCert", idNameMap, "idNameMap", serial, "serial");
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertInfo, CertStore.col2Int(ca.getId()), CertStore.col2Str(serial.toString(16)));
        if (rs == null) {
            return null;
        }
        byte[] encodedCert = Base64.decodeFast((String)rs.getString("CERT"));
        CertWithDbId certWithMeta = new CertWithDbId(CertStore.parseCert(encodedCert));
        CertificateInfo certInfo = new CertificateInfo(certWithMeta, null, ca, caCert, idNameMap.getCertprofile(rs.getInt("PID")), idNameMap.getRequestor(rs.getInt("RID")));
        certInfo.setRevocationInfo(CertStore.buildCertRevInfo(rs));
        return certInfo;
    }

    public X509Cert getCert(X500Name subjectName, String transactionId) throws OperationException {
        String sql = this.buildSelectFirstSql("CERT FROM CERT WHERE TID=? AND (FP_S=? OR FP_RS=?)");
        long fpSubject = X509Util.fpCanonicalizedName((X500Name)subjectName);
        QueryExecutor.SqlColumn2[] params = new QueryExecutor.SqlColumn2[]{CertStore.col2Str(transactionId), CertStore.col2Long(fpSubject), CertStore.col2Long(fpSubject)};
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, params);
        return rows == null || rows.isEmpty() ? null : CertStore.parseCert(Base64.decodeFast((String)rows.get(0).getString("CERT")));
    }

    public List<CertListInfo> listCerts(NameId ca, X500Name subjectPattern, Instant validFrom, Instant validTo, CertListOrderBy orderBy, int numEntries) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numEntries, (String)"numEntries");
        StringBuilder sb = new StringBuilder(200);
        sb.append("SN,NBEFORE,NAFTER,SUBJECT FROM CERT WHERE CA_ID=?");
        ArrayList<QueryExecutor.SqlColumn2> params = new ArrayList<QueryExecutor.SqlColumn2>(4);
        params.add(CertStore.col2Int(ca.getId()));
        if (validFrom != null) {
            sb.append(" AND NBEFORE<?");
            params.add(CertStore.col2Long(validFrom.getEpochSecond() - 1L));
        }
        if (validTo != null) {
            sb.append(" AND NAFTER>?");
            params.add(CertStore.col2Long(validTo.getEpochSecond()));
        }
        if (subjectPattern != null) {
            RDN[] rdns;
            sb.append(" AND SUBJECT LIKE ?");
            StringBuilder buffer = new StringBuilder(100);
            buffer.append("%");
            for (RDN rdn : rdns = subjectPattern.getRDNs()) {
                X500Name rdnName = new X500Name(new RDN[]{rdn});
                String rdnStr = X509Util.x500NameText((X500Name)rdnName);
                if (rdnStr.indexOf(37) != -1) {
                    throw new OperationException(ErrorCode.BAD_REQUEST, "the character '%' is not allowed in subjectPattern");
                }
                if (rdnStr.indexOf(42) != -1) {
                    rdnStr = rdnStr.replace('*', '%');
                }
                buffer.append(rdnStr);
                buffer.append("%");
            }
            params.add(CertStore.col2Str(buffer.toString()));
        }
        String sortByStr = null;
        if (orderBy != null) {
            if (orderBy == CertListOrderBy.NOT_BEFORE) {
                sortByStr = "NBEFORE";
            } else if (orderBy == CertListOrderBy.NOT_BEFORE_DESC) {
                sortByStr = "NBEFORE DESC";
            } else if (orderBy == CertListOrderBy.NOT_AFTER) {
                sortByStr = "NAFTER";
            } else if (orderBy == CertListOrderBy.NOT_AFTER_DESC) {
                sortByStr = "NAFTER DESC";
            } else if (orderBy == CertListOrderBy.SUBJECT) {
                sortByStr = "SUBJECT";
            } else if (orderBy == CertListOrderBy.SUBJECT_DESC) {
                sortByStr = "SUBJECT DESC";
            } else {
                throw new IllegalStateException("unknown CertListOrderBy " + orderBy);
            }
        }
        String sql = this.datasource.buildSelectFirstSql(numEntries, sortByStr, sb.toString());
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, params.toArray(new QueryExecutor.SqlColumn2[0]));
        LinkedList<CertListInfo> ret = new LinkedList<CertListInfo>();
        for (ResultRow rs : rows) {
            CertListInfo info = new CertListInfo(new BigInteger(rs.getString("SN"), 16), rs.getString("SUBJECT"), Instant.ofEpochSecond(rs.getLong("NBEFORE")), Instant.ofEpochSecond(rs.getLong("NAFTER")));
            ret.add(info);
        }
        return ret;
    }

    public List<CertRevInfoWithSerial> getRevokedCerts(NameId ca, Instant notExpiredAt, long startId, int numEntries) throws OperationException {
        this.notNulls(ca, "ca", notExpiredAt, "notExpiredAt");
        Args.positive((int)numEntries, (String)"numEntries");
        String sql = (String)this.cacheSqlRevokedCerts.get((Object)numEntries);
        if (sql == null) {
            String coreSql = "ID,SN,RR,RT,RIT FROM CERT WHERE ID>? AND CA_ID=? AND REV=1 AND NAFTER>?";
            sql = this.datasource.buildSelectFirstSql(numEntries, "ID ASC", coreSql);
            this.cacheSqlRevokedCerts.put((Object)numEntries, (Object)sql);
        }
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, CertStore.col2Long(startId - 1L), CertStore.col2Int(ca.getId()), CertStore.col2Long(notExpiredAt.getEpochSecond() + 1L));
        LinkedList<CertRevInfoWithSerial> ret = new LinkedList<CertRevInfoWithSerial>();
        for (ResultRow rs : rows) {
            long revInvalidityTime = rs.getLong("RIT");
            Instant invalidityTime = revInvalidityTime == 0L ? null : Instant.ofEpochSecond(revInvalidityTime);
            CertRevInfoWithSerial revInfo = new CertRevInfoWithSerial(rs.getLong("ID"), new BigInteger(rs.getString("SN"), 16), rs.getInt("RR"), Instant.ofEpochSecond(rs.getLong("RT")), invalidityTime);
            ret.add(revInfo);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CertRevInfoWithSerial> getCertsForDeltaCrl(NameId ca, BigInteger baseCrlNumber, Instant notExpiredAt) throws OperationException {
        ResultSet rs;
        this.notNulls(ca, "ca", notExpiredAt, "notExpiredAt", baseCrlNumber, "baseCrlNumber");
        byte[] encodedCrl = this.getEncodedCrl(ca, baseCrlNumber);
        CertificateList crl = CertificateList.getInstance((Object)encodedCrl);
        Enumeration revokedCertsInCrl = crl.getRevokedCertificateEnumeration();
        HashSet<BigInteger> allSnSet = null;
        boolean supportInSql = this.datasource.getDatabaseType().supportsInArray();
        LinkedList<BigInteger> snList = new LinkedList<BigInteger>();
        LinkedList<CertRevInfoWithSerial> ret = new LinkedList<CertRevInfoWithSerial>();
        PreparedStatement ps = null;
        try {
            while (revokedCertsInCrl.hasMoreElements()) {
                TBSCertList.CRLEntry crlEntry = (TBSCertList.CRLEntry)revokedCertsInCrl.nextElement();
                if (allSnSet == null) {
                    int averageSize = encodedCrl.length / crlEntry.getEncoded().length;
                    allSnSet = new HashSet<BigInteger>((int)(1.1 * (double)averageSize));
                }
                BigInteger sn = crlEntry.getUserCertificate().getPositiveValue();
                snList.add(sn);
                allSnSet.add(sn);
                if (!supportInSql || snList.size() != 100) continue;
                if (ps == null) {
                    ps = this.prepareStatement(this.sqlSelectUnrevokedSn100);
                }
                for (int i = 1; i < 101; ++i) {
                    ps.setString(i, ((BigInteger)snList.get(i - 1)).toString(16));
                }
                snList.clear();
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        ret.add(new CertRevInfoWithSerial(0L, new BigInteger(rs.getString("SN"), 16), CrlReason.REMOVE_FROM_CRL, Instant.ofEpochSecond(rs.getLong("LUPDATE")), null));
                    }
                }
                finally {
                    this.datasource.releaseResources(null, rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, this.datasource.translate(this.sqlSelectUnrevokedSn100, ex).getMessage());
        }
        catch (IOException ex) {
            throw new OperationException(ErrorCode.CRL_FAILURE, ex.getMessage());
        }
        finally {
            this.datasource.releaseResources(ps, null);
        }
        if (!snList.isEmpty()) {
            ps = this.prepareStatement(this.sqlSelectUnrevokedSn);
            try {
                for (BigInteger sn : snList) {
                    ps.setString(1, sn.toString(16));
                    rs = ps.executeQuery();
                    try {
                        if (!rs.next()) continue;
                        ret.add(new CertRevInfoWithSerial(0L, sn, CrlReason.REMOVE_FROM_CRL, Instant.ofEpochSecond(rs.getLong("LUPDATE")), null));
                    }
                    finally {
                        this.datasource.releaseResources(null, rs);
                    }
                }
            }
            catch (SQLException ex) {
                throw new OperationException(ErrorCode.DATABASE_FAILURE, this.datasource.translate(this.sqlSelectUnrevokedSn, ex).getMessage());
            }
            finally {
                this.datasource.releaseResources((Statement)ps, null);
            }
        }
        int numEntries = 1000;
        String coreSql = "ID,SN,RR,RT,RIT FROM CERT WHERE ID>? AND CA_ID=? AND REV=1 AND NAFTER>? AND LUPDATE>?";
        String sql = this.datasource.buildSelectFirstSql(1000, "ID ASC", coreSql);
        ps = this.prepareStatement(sql);
        long startId = 1L;
        long updatedSince = DateUtil.toEpochSecond((Date)crl.getThisUpdate().getDate()) - 1L;
        try {
            while (true) {
                ps.setLong(1, startId - 1L);
                ps.setInt(2, ca.getId());
                ps.setLong(3, notExpiredAt.getEpochSecond() + 1L);
                ps.setLong(4, updatedSince);
                ResultSet rs2 = ps.executeQuery();
                try {
                    int num = 0;
                    while (rs2.next()) {
                        ++num;
                        long id = rs2.getLong("ID");
                        if (id > startId) {
                            startId = id;
                        }
                        BigInteger sn = new BigInteger(rs2.getString("SN"), 16);
                        if (allSnSet != null && allSnSet.contains(sn)) continue;
                        long revInvalidityTime = rs2.getLong("RIT");
                        Instant invalidityTime = revInvalidityTime == 0L ? null : Instant.ofEpochSecond(revInvalidityTime);
                        CertRevInfoWithSerial revInfo = new CertRevInfoWithSerial(id, sn, rs2.getInt("RR"), Instant.ofEpochSecond(rs2.getLong("RT")), invalidityTime);
                        ret.add(revInfo);
                    }
                    if (num >= 1000) continue;
                }
                finally {
                    this.datasource.releaseResources(null, rs2);
                    continue;
                }
                break;
            }
        }
        catch (SQLException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
        return ret;
    }

    public CertStatus getCertStatusForSubject(NameId ca, X500Name subject) throws OperationException {
        long subjectFp = X509Util.fpCanonicalizedName((X500Name)subject);
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertStatusForSubjectFp, CertStore.col2Long(subjectFp), CertStore.col2Int(ca.getId()));
        return rs == null ? CertStatus.UNKNOWN : (rs.getBoolean("REV") ? CertStatus.REVOKED : CertStatus.GOOD);
    }

    public boolean isHealthy() {
        try {
            this.execUpdateStmt("SELECT ID FROM CA");
            return true;
        }
        catch (Exception ex) {
            LOG.error("isHealthy(). {}: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            LOG.debug("isHealthy()", (Throwable)ex);
            return false;
        }
    }

    private static Long getDateSeconds(Date date) {
        return date == null ? null : Long.valueOf(DateUtil.toEpochSecond((Date)date));
    }

    public void updateDbInfo() throws DataAccessException, CaMgmtException {
        String str = this.caConfStore.getDbSchemas().get("KEYPAIR_ENC_KEY");
        if (str == null) {
            return;
        }
        try {
            char[] keyChars = Passwords.resolvePassword((String)str);
            byte[] encodedEncKey = Hex.decode((char[])keyChars);
            int n = encodedEncKey.length;
            if (n != 16 && n != 24 && n != 32) {
                throw new CaMgmtException("error resolving KEYPAIR_ENC_KEY");
            }
            this.keypairEncKey = new SecretKeySpec(encodedEncKey, "AES");
            this.keypairEncKeyId = Hex.encode((byte[])Arrays.copyOf(HashAlgo.SHA1.hash((byte[][])new byte[][]{encodedEncKey}), 8));
        }
        catch (PasswordResolverException ex) {
            throw new CaMgmtException("error resolving KEYPAIR_ENC_KEY", (Throwable)ex);
        }
        try {
            Cipher.getInstance("AES/GCM/NoPadding", "SunJCE");
            this.keypairEncProvider = "SunJCE";
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException ex) {
            try {
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                this.keypairEncProvider = cipher.getProvider().getName();
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException ex2) {
                throw new IllegalStateException("Unsupported cipher AES/GCM/NoPadding");
            }
        }
    }

    private static CertRevocationInfo buildCertRevInfo(ResultRow rs) {
        boolean revoked = rs.getBoolean("REV");
        if (!revoked) {
            return null;
        }
        long revTime = rs.getLong("RT");
        long revInvTime = rs.getLong("RIT");
        Instant invalidityTime = revInvTime == 0L ? null : Instant.ofEpochSecond(revInvTime);
        return new CertRevocationInfo(rs.getInt("RR"), Instant.ofEpochSecond(revTime), invalidityTime);
    }

    private long getMax(String table, String column) throws OperationException {
        try {
            return this.datasource.getMax(null, table, column);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, ex.getMessage());
        }
    }

    private int execUpdatePrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        try {
            return this.execUpdatePrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)ex);
        }
    }

    private ResultRow execQuery1PrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        try {
            return this.execQuery1PrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)ex);
        }
    }

    private List<ResultRow> execQueryPrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        try {
            return this.execQueryPrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)ex);
        }
    }

    private PreparedStatement buildPrepStmt0(String sql, QueryExecutor.SqlColumn2 ... columns) throws OperationException {
        try {
            return this.buildPrepStmt(sql, columns);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)ex);
        }
    }

    private long execQueryLongPrepStmt(String sql, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        PreparedStatement ps = this.buildPrepStmt0(sql, params);
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            long l = rs.next() ? rs.getLong(1) : 0L;
            return l;
        }
        catch (SQLException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)this.datasource.translate(sql, ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
    }

    private PreparedStatement prepareStatement(String sqlQuery) throws OperationException {
        try {
            return this.datasource.prepareStatement(sqlQuery);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)ex);
        }
    }

    private static String buildArraySql(DataSourceWrapper datasource, String prefix, int num) {
        String sql = prefix + " IN (?" + ",?".repeat(Math.max(0, num - 1)) + ")";
        return datasource.buildSelectFirstSql(num, sql);
    }

    private static X509Cert parseCert(byte[] encodedCert) throws OperationException {
        try {
            return X509Util.parseCert((byte[])encodedCert);
        }
        catch (CertificateException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
    }

    public static class SerialWithId {
        private final long id;
        private final BigInteger serial;

        public SerialWithId(long id, BigInteger serial) {
            this.id = id;
            this.serial = serial;
        }

        public BigInteger getSerial() {
            return this.serial;
        }

        public long getId() {
            return this.id;
        }
    }

    public static enum CertStatus {
        UNKNOWN,
        REVOKED,
        GOOD;

    }
}

