/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.db;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.Permissions;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.entry.BaseCaInfo;
import org.xipki.ca.api.mgmt.entry.CaConfColumn;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.server.CaConfStore;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.KeypairGenEntryWrapper;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.SystemEvent;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.db.QueryExecutor;
import org.xipki.ca.server.db.ResultRow;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.ca.server.mgmt.CaProfileIdAliases;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.pki.OperationException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.SqlUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;

public class DbCaConfStore
extends QueryExecutor
implements CaConfStore {
    private static final Logger LOG = LoggerFactory.getLogger(DbCaConfStore.class);
    private final String sqlSelectProfileId;
    private final String sqlSelectProfile;
    private final String sqlSelectPublisherId;
    private final String sqlSelectPublisher;
    private final String sqlSelectRequestorId;
    private final String sqlSelectRequestor;
    private final String sqlSelectSigner;
    private final String sqlSelectKeypairGen;
    private final String sqlSelectCaId;
    private final String sqlSelectCa;
    private final String sqlNextSelectCrlNo;
    private final String sqlSelectSystemEvent;
    private final Map<Table, AtomicLong> cachedIdMap = new HashMap<Table, AtomicLong>();
    private final int dbSchemaVersion;
    private final int maxX500nameLen;

    public DbCaConfStore(DataSourceWrapper datasource) throws CaMgmtException {
        super(datasource);
        try {
            Integer i = datasource.getFirstIntValue(null, "DBSCHEMA", "VALUE2", "NAME='VERSION'");
            this.dbSchemaVersion = i == null ? 9 : i;
            i = datasource.getFirstIntValue(null, "DBSCHEMA", "VALUE2", "NAME='X500NAME_MAXLEN'");
            this.maxX500nameLen = i != null ? i : 350;
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        if (this.dbSchemaVersion < 7) {
            throw new CaMgmtException("DB version < 7 is not supported: " + this.dbSchemaVersion);
        }
        for (Table m : Table.values()) {
            this.cachedIdMap.put(m, new AtomicLong(0L));
        }
        this.sqlSelectProfileId = this.buildSelectFirstSql("ID FROM PROFILE WHERE NAME=?");
        this.sqlSelectCaId = this.buildSelectFirstSql("ID FROM CA WHERE NAME=?");
        this.sqlSelectPublisherId = this.buildSelectFirstSql("ID FROM PUBLISHER WHERE NAME=?");
        this.sqlSelectRequestorId = this.buildSelectFirstSql("ID FROM REQUESTOR WHERE NAME=?");
        this.sqlSelectProfile = this.buildSelectFirstSql("ID,TYPE,CONF FROM PROFILE WHERE NAME=?");
        this.sqlSelectPublisher = this.buildSelectFirstSql("ID,TYPE,CONF FROM PUBLISHER WHERE NAME=?");
        this.sqlSelectRequestor = this.buildSelectFirstSql("ID,TYPE,CONF FROM REQUESTOR WHERE NAME=?");
        this.sqlSelectSigner = this.buildSelectFirstSql("TYPE,CERT,CONF FROM SIGNER WHERE NAME=?");
        this.sqlSelectKeypairGen = this.buildSelectFirstSql("TYPE,CONF FROM KEYPAIR_GEN WHERE NAME=?");
        this.sqlSelectCa = this.buildSelectFirstSql("ID,STATUS,NEXT_CRLNO,CRL_SIGNER_NAME,SUBJECT,REV_INFO,SIGNER_TYPE,SIGNER_CONF,CERT,CERTCHAIN,CONF FROM CA WHERE NAME=?");
        this.sqlNextSelectCrlNo = this.buildSelectFirstSql("NEXT_CRLNO FROM CA WHERE ID=?");
        this.sqlSelectSystemEvent = this.buildSelectFirstSql("EVENT_TIME,EVENT_OWNER FROM SYSTEM_EVENT WHERE NAME=?");
    }

    @Override
    public boolean needsCertStore() {
        return true;
    }

    @Override
    public SystemEvent getSystemEvent(String eventName) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectSystemEvent, DbCaConfStore.col2Str(eventName));
        return rs == null ? null : new SystemEvent(eventName, rs.getString("EVENT_OWNER"), DbCaConfStore.getLong(rs, "EVENT_TIME"));
    }

    private void deleteSystemEvent(String eventName) throws CaMgmtException {
        this.execUpdatePrepStmt0("DELETE FROM SYSTEM_EVENT WHERE NAME=?", DbCaConfStore.col2Str(eventName));
    }

    private void addSystemEvent(SystemEvent systemEvent) throws CaMgmtException {
        String sql = SqlUtil.buildInsertSql((String)"SYSTEM_EVENT", (String)"NAME,EVENT_TIME,EVENT_TIME2,EVENT_OWNER");
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Str(systemEvent.getName()), DbCaConfStore.col2Long(systemEvent.getEventTime()), DbCaConfStore.col2Timestamp(new Timestamp(systemEvent.getEventTime() * 1000L)), DbCaConfStore.col2Str(systemEvent.getOwner()));
        if (num == 0) {
            throw new CaMgmtException("could not add system event " + systemEvent.getName());
        }
        LOG.info("added system event {}", (Object)systemEvent.getName());
    }

    @Override
    public int getDbSchemaVersion() {
        return this.dbSchemaVersion;
    }

    @Override
    public void changeSystemEvent(SystemEvent systemEvent) throws CaMgmtException {
        this.deleteSystemEvent(systemEvent.getName());
        this.addSystemEvent(systemEvent);
    }

    @Override
    public Map<String, Integer> createCaAliases() throws CaMgmtException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<ResultRow> rows = this.execQueryStmt0("SELECT NAME,CA_ID FROM CAALIAS");
        for (ResultRow m : rows) {
            map.put(m.getString("NAME"), DbCaConfStore.getInt(m, "CA_ID"));
        }
        return map;
    }

    @Override
    public CertprofileEntry createCertprofile(String name) throws CaMgmtException {
        ResultRow rs = Optional.ofNullable(this.execQuery1PrepStmt0(this.sqlSelectProfile, DbCaConfStore.col2Str(name))).orElseThrow(() -> new CaMgmtException("unknown Certprofile " + name));
        return new CertprofileEntry(new NameId(Integer.valueOf(DbCaConfStore.getInt(rs, "ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
    }

    @Override
    public PublisherEntry createPublisher(String name) throws CaMgmtException {
        ResultRow rs = Optional.ofNullable(this.execQuery1PrepStmt0(this.sqlSelectPublisher, DbCaConfStore.col2Str(name))).orElseThrow(() -> new CaMgmtException("unknown Publisher " + name));
        return new PublisherEntry(new NameId(Integer.valueOf(DbCaConfStore.getInt(rs, "ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
    }

    @Override
    public Integer getRequestorId(String requestorName) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectRequestorId, DbCaConfStore.col2Str(requestorName));
        return rs == null ? null : Integer.valueOf(DbCaConfStore.getInt(rs, "ID"));
    }

    @Override
    public RequestorEntry createRequestor(String name) throws CaMgmtException {
        ResultRow rs = Optional.ofNullable(this.execQuery1PrepStmt0(this.sqlSelectRequestor, DbCaConfStore.col2Str(name))).orElseThrow(() -> new CaMgmtException("unknown Requestor " + name));
        return new RequestorEntry(new NameId(Integer.valueOf(DbCaConfStore.getInt(rs, "ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
    }

    @Override
    public SignerEntry createSigner(String name) throws CaMgmtException {
        ResultRow rs = Optional.ofNullable(this.execQuery1PrepStmt0(this.sqlSelectSigner, DbCaConfStore.col2Str(name))).orElseThrow(() -> new CaMgmtException("unknown signer " + name));
        return new SignerEntry(name, rs.getString("TYPE"), rs.getString("CONF"), rs.getString("CERT"));
    }

    @Override
    public KeypairGenEntry createKeypairGen(String name) throws CaMgmtException {
        ResultRow rs = Optional.ofNullable(this.execQuery1PrepStmt0(this.sqlSelectKeypairGen, DbCaConfStore.col2Str(name))).orElseThrow(() -> new CaMgmtException("unknown keypair generation " + name));
        return new KeypairGenEntry(name, rs.getString("TYPE"), rs.getString("CONF"));
    }

    @Override
    public CaInfo createCaInfo(String name, CertStore certstore) throws CaMgmtException {
        String revInfo;
        ResultRow rs = Optional.ofNullable(this.execQuery1PrepStmt0(this.sqlSelectCa, DbCaConfStore.col2Str(name))).orElseThrow(() -> new CaMgmtException("unknown CA " + name));
        String encodedConf = rs.getString("CONF");
        CaConfColumn conf = CaConfColumn.decode((String)encodedConf);
        CaEntry entry = new CaEntry(new NameId(Integer.valueOf(DbCaConfStore.getInt(rs, "ID")), name));
        entry.setNextCrlNo(DbCaConfStore.getLong(rs, "NEXT_CRLNO"));
        entry.setSignerType(rs.getString("SIGNER_TYPE"));
        entry.setSignerConf(rs.getString("SIGNER_CONF"));
        entry.setCaUris(conf.caUris());
        entry.setNumCrls(conf.getNumCrls());
        entry.setExpirationPeriod(conf.getExpirationPeriod());
        entry.setCert(DbCaConfStore.generateCert(rs.getString("CERT")));
        List<X509Cert> certchain = DbCaConfStore.generateCertchain(rs.getString("CERTCHAIN"));
        if (CollectionUtil.isNotEmpty(certchain)) {
            CaUtil.buildCertChain(entry.getCert(), certchain);
            entry.setCertchain(certchain);
        }
        entry.setStatus(CaStatus.forName((String)rs.getString("STATUS")));
        String crlsignerName = rs.getString("CRL_SIGNER_NAME");
        if (StringUtil.isNotBlank((String)crlsignerName)) {
            entry.setCrlSignerName(crlsignerName);
        }
        CertRevocationInfo revocationInfo = (revInfo = rs.getString("REV_INFO")) == null ? null : CertRevocationInfo.fromEncoded((String)revInfo);
        entry.setRevocationInfo(revocationInfo);
        conf.fillBaseCaInfo((BaseCaInfo)entry);
        try {
            return new CaInfo(entry, conf, certstore);
        }
        catch (OperationException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    @Override
    public Set<CaHasRequestorEntry> createCaHasRequestors(NameId ca) throws CaMgmtException {
        Map<Integer, String> idNameMap = this.getIdNameMap("REQUESTOR");
        String sql = "SELECT REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR WHERE CA_ID=?";
        List<ResultRow> rows = this.execQueryPrepStmt0("SELECT REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR WHERE CA_ID=?", DbCaConfStore.col2Int(ca.getId()));
        HashSet<CaHasRequestorEntry> ret = new HashSet<CaHasRequestorEntry>();
        for (ResultRow rs : rows) {
            int id = DbCaConfStore.getInt(rs, "REQUESTOR_ID");
            String name = idNameMap.get(id);
            List list = StringUtil.split((String)rs.getString("PROFILES"), (String)",");
            HashSet profiles = list == null ? null : new HashSet(list);
            CaHasRequestorEntry entry = new CaHasRequestorEntry(new NameId(Integer.valueOf(id), name));
            entry.setPermissions(new Permissions(DbCaConfStore.getInt(rs, "PERMISSION")));
            entry.setProfiles(profiles);
            ret.add(entry);
        }
        return ret;
    }

    @Override
    public Set<CaProfileIdAliases> createCaHasProfiles(NameId ca) throws CaMgmtException {
        String sql = "SELECT PROFILE_ID,ALIASES FROM CA_HAS_PROFILE WHERE CA_ID=?";
        List<ResultRow> rows = this.execQueryPrepStmt0("SELECT PROFILE_ID,ALIASES FROM CA_HAS_PROFILE WHERE CA_ID=?", DbCaConfStore.col2Int(ca.getId()));
        HashSet<CaProfileIdAliases> ret = new HashSet<CaProfileIdAliases>();
        for (ResultRow row : rows) {
            int id = DbCaConfStore.getInt(row, "PROFILE_ID");
            String encodedAliases = row.getString("ALIASES");
            ret.add(new CaProfileIdAliases(id, encodedAliases));
        }
        return ret;
    }

    @Override
    public Set<Integer> createCaHasPublishers(NameId ca) throws CaMgmtException {
        return this.createCaHasEntities("CA_HAS_PUBLISHER", "PUBLISHER_ID", ca);
    }

    private Set<Integer> createCaHasEntities(String table, String column, NameId ca) throws CaMgmtException {
        String sql = "SELECT " + column + " FROM " + table + " WHERE CA_ID=?";
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, DbCaConfStore.col2Int(ca.getId()));
        HashSet<Integer> ret = new HashSet<Integer>();
        for (ResultRow rs : rows) {
            ret.add(DbCaConfStore.getInt(rs, column));
        }
        return ret;
    }

    private long getNextId(Table table) throws CaMgmtException {
        try {
            long idInDb = this.datasource.getMax(null, table.name(), "ID");
            AtomicLong cachedId = this.cachedIdMap.get((Object)table);
            long nextId = Math.max(idInDb, cachedId.get()) + 1L;
            cachedId.set(nextId);
            return nextId;
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    @Override
    public void addCa(CaEntry caEntry) throws CaMgmtException {
        List<QueryExecutor.SqlColumn2> cols;
        int num;
        Args.notNull((Object)caEntry, (String)"caEntry");
        caEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(Table.CA)));
        String colNames = "ID,NAME,STATUS,NEXT_CRLNO,CRL_SIGNER_NAME,SUBJECT,REV_INFO,SIGNER_TYPE,SIGNER_CONF,CERT,CERTCHAIN,CONF";
        String sql = SqlUtil.buildInsertSql((String)"CA", (String)colNames);
        byte[] encodedCert = caEntry.getCert().getEncoded();
        List certchain = caEntry.getCertchain();
        String certchainStr = CollectionUtil.isEmpty((Collection)certchain) ? null : CaUtil.encodeCertchain(CaUtil.buildCertChain(caEntry.getCert(), certchain));
        CaConfColumn cc = CaConfColumn.fromBaseCaInfo((BaseCaInfo)caEntry);
        String revInfoStr = null;
        if (caEntry.getRevocationInfo() != null) {
            revInfoStr = caEntry.getRevocationInfo().encode();
        }
        if ((num = this.execUpdatePrepStmt0(sql, (cols = CaUtil.asModifiableList(DbCaConfStore.col2Int(caEntry.getIdent().getId()), DbCaConfStore.col2Str(caEntry.getIdent().getName()), DbCaConfStore.col2Str(caEntry.getStatus().getStatus()), DbCaConfStore.col2Long(caEntry.getNextCrlNo()), DbCaConfStore.col2Str(caEntry.getCrlSignerName()), DbCaConfStore.col2Str(X509Util.cutText((String)caEntry.subject(), (int)this.getMaxX500nameLen())), DbCaConfStore.col2Str(revInfoStr), DbCaConfStore.col2Str(caEntry.getSignerType()), DbCaConfStore.col2Str(caEntry.getSignerConf()), DbCaConfStore.col2Str(Base64.encodeToString((byte[])encodedCert)), DbCaConfStore.col2Str(certchainStr), DbCaConfStore.col2Str(cc.encode()))).toArray(new QueryExecutor.SqlColumn2[0]))) == 0) {
            throw new CaMgmtException("could not add CA " + caEntry.getIdent());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("added CA '{}':\n{}", (Object)caEntry.getIdent(), (Object)caEntry.toString(false, true));
        }
    }

    @Override
    public void addCaAlias(String aliasName, NameId ca) throws CaMgmtException {
        this.notNulls(aliasName, "aliasName", ca, "ca");
        String sql = SqlUtil.buildInsertSql((String)"CAALIAS", (String)"NAME,CA_ID");
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Str(aliasName), DbCaConfStore.col2Int(ca.getId()));
        if (num == 0) {
            throw new CaMgmtException("could not add CA alias " + aliasName);
        }
        LOG.info("added CA alias '{}' for CA '{}'", (Object)aliasName, (Object)ca);
    }

    @Override
    public void addCertprofile(CertprofileEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        String sql = SqlUtil.buildInsertSql((String)"PROFILE", (String)"ID,NAME,TYPE,CONF");
        dbEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(Table.PROFILE)));
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Int(dbEntry.getIdent().getId()), DbCaConfStore.col2Str(dbEntry.getIdent().getName()), DbCaConfStore.col2Str(dbEntry.getType()), DbCaConfStore.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add certprofile " + dbEntry.getIdent());
        }
        LOG.info("added profile '{}':\n{}", (Object)dbEntry.getIdent(), (Object)dbEntry);
    }

    @Override
    public void addCertprofileToCa(NameId profile, NameId ca, List<String> aliases) throws CaMgmtException {
        String aliasesStr;
        this.notNulls(profile, "profile", ca, "ca");
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_PROFILE", (String)"CA_ID,PROFILE_ID,ALIASES");
        if (CollectionUtil.isEmpty(aliases)) {
            aliasesStr = null;
        } else if (aliases.size() == 1) {
            aliasesStr = aliases.get(0);
        } else {
            StringBuilder sb = new StringBuilder();
            for (String alias : aliases) {
                sb.append(alias).append(",");
            }
            aliasesStr = sb.substring(0, sb.length() - 1);
        }
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Int(ca.getId()), DbCaConfStore.col2Int(profile.getId()), DbCaConfStore.col2Str(aliasesStr));
        if (num == 0) {
            throw new CaMgmtException("could not add profile " + profile + " (aliases " + aliases + ") to CA " + ca);
        }
        LOG.info("added profile '{}' (aliases {}) to CA '{}'", new Object[]{profile, aliases, ca});
    }

    @Override
    public void addPublisherToCa(NameId publisher, NameId ca) throws CaMgmtException {
        this.notNulls(publisher, "publisher", ca, "ca");
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_PUBLISHER", (String)"CA_ID,PUBLISHER_ID");
        this.addEntityToCa("publisher", publisher, ca, sql);
    }

    private void addEntityToCa(String desc, NameId entity, NameId ca, String sql) throws CaMgmtException {
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Int(ca.getId()), DbCaConfStore.col2Int(entity.getId()));
        if (num == 0) {
            throw new CaMgmtException("could not add " + desc + " " + entity + " to CA " + ca);
        }
        LOG.info("added {} '{}' to CA '{}'", new Object[]{desc, entity, ca});
    }

    @Override
    public void addRequestor(RequestorEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        dbEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(Table.REQUESTOR)));
        String sql = SqlUtil.buildInsertSql((String)"REQUESTOR", (String)"ID,NAME,TYPE,CONF");
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Int(dbEntry.getIdent().getId()), DbCaConfStore.col2Str(dbEntry.getIdent().getName()), DbCaConfStore.col2Str(dbEntry.getType()), DbCaConfStore.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add requestor " + dbEntry.getIdent());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("added requestor '{}':\n{}", (Object)dbEntry.getIdent(), (Object)dbEntry.toString(false));
        }
    }

    @Override
    public NameId addEmbeddedRequestor(String requestorName) throws CaMgmtException {
        requestorName = requestorName.toLowerCase();
        String sql = SqlUtil.buildInsertSql((String)"REQUESTOR", (String)"ID,NAME,TYPE,CONF");
        int nextId = (int)this.getNextId(Table.REQUESTOR);
        String name = "EMBEDDED";
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Int(nextId), DbCaConfStore.col2Str(requestorName), DbCaConfStore.col2Str(name), DbCaConfStore.col2Str("DEFAULT"));
        if (num == 0) {
            throw new CaMgmtException("could not add requestor " + requestorName);
        }
        LOG.info("added requestor '{}'", (Object)requestorName);
        return new NameId(Integer.valueOf(nextId), name);
    }

    @Override
    public void addRequestorToCa(CaHasRequestorEntry requestor, NameId ca) throws CaMgmtException {
        this.notNulls(requestor, "requestor", ca, "ca");
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_REQUESTOR", (String)"CA_ID,REQUESTOR_ID,PERMISSION,PROFILES");
        String profilesText = StringUtil.collectionAsString((Collection)requestor.getProfiles(), (String)",");
        NameId requestorIdent = requestor.getRequestorIdent();
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Int(ca.getId()), DbCaConfStore.col2Int(requestorIdent.getId()), DbCaConfStore.col2Int(requestor.getPermissions().getValue()), DbCaConfStore.col2Str(profilesText));
        if (num == 0) {
            throw new CaMgmtException("could not add requestor " + requestorIdent + " to CA " + ca);
        }
        LOG.info("added requestor '{}' to CA '{}': permission: {} ({}); profile: {}", new Object[]{requestorIdent, ca, requestor.getPermissions().getValue(), requestor.getPermissions(), profilesText});
    }

    @Override
    public void addPublisher(PublisherEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        String sql = SqlUtil.buildInsertSql((String)"PUBLISHER", (String)"ID,NAME,TYPE,CONF");
        dbEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(Table.PUBLISHER)));
        String name = dbEntry.getIdent().getName();
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Int(dbEntry.getIdent().getId()), DbCaConfStore.col2Str(name), DbCaConfStore.col2Str(dbEntry.getType()), DbCaConfStore.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add publisher " + dbEntry.getIdent());
        }
        LOG.info("added publisher '{}':\n{}", (Object)dbEntry.getIdent(), (Object)dbEntry);
    }

    @Override
    public void changeCa(ChangeCaEntry changeCaEntry, CaConfColumn currentCaConfColumn, SecurityFactory securityFactory) throws CaMgmtException {
        QueryExecutor.SqlColumn colConfColumn;
        this.notNulls(changeCaEntry, "changeCaEntry", currentCaConfColumn, "currentCaConfColumn", securityFactory, "securityFactory");
        byte[] encodedCert = changeCaEntry.getEncodedCert();
        if (encodedCert != null) {
            boolean anyCertIssued;
            try {
                anyCertIssued = this.datasource.columnExists(null, "CERT", "CA_ID", (Object)changeCaEntry.getIdent().getId());
            }
            catch (DataAccessException ex) {
                throw new CaMgmtException((Throwable)ex);
            }
            if (anyCertIssued) {
                throw new CaMgmtException("Cannot change certificate of CA which has issued certificates");
            }
        }
        String signerType = changeCaEntry.getSignerType();
        String signerConf = changeCaEntry.getSignerConf();
        X509Cert caCert = null;
        if (signerType != null || signerConf != null || encodedCert != null || CollectionUtil.isNotEmpty((Collection)changeCaEntry.getEncodedCertchain())) {
            ResultRow rs;
            String sql;
            if (encodedCert != null) {
                caCert = CaUtil.parseCert(encodedCert);
            } else {
                sql = "SELECT CERT FROM CA WHERE ID=?";
                rs = Optional.ofNullable(this.execQuery1PrepStmt0("SELECT CERT FROM CA WHERE ID=?", DbCaConfStore.col2Int(changeCaEntry.getIdent().getId()))).orElseThrow(() -> new CaMgmtException("unknown CA '" + changeCaEntry.getIdent()));
                caCert = CaUtil.parseCert(Base64.decode((String)rs.getString("CERT")));
            }
            if (signerType != null || signerConf != null || encodedCert != null) {
                sql = "SELECT SIGNER_TYPE,SIGNER_CONF FROM CA WHERE ID=?";
                rs = Optional.ofNullable(this.execQuery1PrepStmt0("SELECT SIGNER_TYPE,SIGNER_CONF FROM CA WHERE ID=?", DbCaConfStore.col2Int(changeCaEntry.getIdent().getId()))).orElseThrow(() -> new CaMgmtException("unknown CA '" + changeCaEntry.getIdent()));
                if (signerType == null) {
                    signerType = rs.getString("SIGNER_TYPE");
                }
                signerConf = signerConf == null ? rs.getString("SIGNER_CONF") : CaUtil.canonicalizeSignerConf(signerConf);
                try {
                    List signerConfs = CaEntry.splitCaSignerConfs((String)signerConf);
                    for (CaEntry.CaSignerConf m : signerConfs) {
                        ConcurrentContentSigner ignored = securityFactory.createSigner(signerType, new SignerConf(m.getConf()), caCert);
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
                catch (IOException | XiSecurityException | ObjectCreationException ex) {
                    throw new CaMgmtException("could not create signer for CA '" + changeCaEntry.getIdent() + "'" + ex.getMessage(), ex);
                }
            }
        }
        String subject = null;
        String base64Cert = null;
        if (encodedCert != null) {
            try {
                subject = X509Util.parseCert((byte[])encodedCert).getIssuerText();
                base64Cert = Base64.encodeToString((byte[])encodedCert);
            }
            catch (CertificateException ex) {
                throw new CaMgmtException("could not parse the certificate", (Throwable)ex);
            }
        }
        String certchainStr = null;
        if (changeCaEntry.getEncodedCertchain() != null) {
            List encodedCertchain = changeCaEntry.getEncodedCertchain();
            if (encodedCertchain.isEmpty()) {
                certchainStr = "null";
            } else {
                List<X509Cert> certs = new LinkedList<X509Cert>();
                for (byte[] m : changeCaEntry.getEncodedCertchain()) {
                    certs.add(CaUtil.parseCert(m));
                }
                certs = CaUtil.buildCertChain(caCert, certs);
                certchainStr = CaUtil.encodeCertchain(certs);
            }
        }
        String status = changeCaEntry.getStatus() == null ? null : changeCaEntry.getStatus().name();
        List<QueryExecutor.SqlColumn> cols = CaUtil.asModifiableList(DbCaConfStore.colStr("STATUS", status), DbCaConfStore.colStr("CRL_SIGNER_NAME", changeCaEntry.getCrlSignerName()), DbCaConfStore.colStr("SUBJECT", subject), DbCaConfStore.colStr("SIGNER_TYPE", signerType), DbCaConfStore.colStr("SIGNER_CONF", signerConf, false, true), DbCaConfStore.colStr("CERT", base64Cert), DbCaConfStore.colStr("CERTCHAIN", certchainStr));
        try {
            colConfColumn = this.buildChangeCaConfColumn(changeCaEntry, currentCaConfColumn);
        }
        catch (InvalidConfException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
        if (colConfColumn != null) {
            cols.add(colConfColumn);
        }
        this.changeIfNotNull("CA", DbCaConfStore.colInt("ID", changeCaEntry.getIdent().getId()), cols.toArray(new QueryExecutor.SqlColumn[0]));
    }

    private QueryExecutor.SqlColumn buildChangeCaConfColumn(ChangeCaEntry changeCaEntry, CaConfColumn currentCaConfColumn) throws InvalidConfException {
        String encodedOrigConf;
        String encodedConf;
        List list;
        List names;
        CaUris changeUris;
        String str;
        CaConfColumn newCC = currentCaConfColumn.copy();
        if (changeCaEntry.getMaxValidity() != null) {
            newCC.setMaxValidity(changeCaEntry.getMaxValidity());
        }
        if ((str = changeCaEntry.getExtraControl()) != null) {
            newCC.setExtraControl("null".equalsIgnoreCase(str) ? null : new ConfPairs(str));
        }
        if (changeCaEntry.getValidityMode() != null) {
            newCC.setValidityMode(changeCaEntry.getValidityMode());
        }
        if ((changeUris = changeCaEntry.getCaUris()) != null) {
            List uris = changeUris.getCacertUris();
            if (uris != null) {
                newCC.setCacertUris(uris.isEmpty() ? null : uris);
            }
            if ((uris = changeUris.getCrlUris()) != null) {
                newCC.setCrlUris(uris.isEmpty() ? null : uris);
            }
            if ((uris = changeUris.getDeltaCrlUris()) != null) {
                newCC.setDeltaCrlUris(uris.isEmpty() ? null : uris);
            }
            if ((uris = changeUris.getOcspUris()) != null) {
                newCC.setOcspUris(uris.isEmpty() ? null : uris);
            }
        }
        if ((names = changeCaEntry.getKeypairGenNames()) != null) {
            newCC.setKeypairGenNames(names.isEmpty() || ((String)names.get(0)).equalsIgnoreCase("null") ? null : names);
        }
        if (changeCaEntry.getSerialNoLen() != null) {
            newCC.setSnSize(changeCaEntry.getSerialNoLen().intValue());
        }
        if ((str = changeCaEntry.getCrlControl()) != null) {
            newCC.setCrlControl("null".equalsIgnoreCase(str) ? null : new CrlControl(str));
        }
        if ((str = changeCaEntry.getCtlogControl()) != null) {
            newCC.setCtlogControl("null".equalsIgnoreCase(str) ? null : new CtlogControl(str));
        }
        if (changeCaEntry.getSaveCert() != null) {
            newCC.setSaveCert(changeCaEntry.getSaveCert().booleanValue());
        }
        if (changeCaEntry.getSaveKeypair() != null) {
            newCC.setSaveKeypair(changeCaEntry.getSaveKeypair().booleanValue());
        }
        if ((list = changeCaEntry.getPermission()) != null && !list.isEmpty()) {
            newCC.setPermission(new Permissions(PermissionConstants.toIntPermission((Collection)list)));
        }
        if (changeCaEntry.getNumCrls() != null) {
            newCC.setNumCrls(changeCaEntry.getNumCrls().intValue());
        }
        if (changeCaEntry.getExpirationPeriod() != null) {
            newCC.setExpirationPeriod(changeCaEntry.getExpirationPeriod().intValue());
        }
        if (changeCaEntry.getKeepExpiredCertDays() != null) {
            newCC.setKeepExpiredCertDays(changeCaEntry.getKeepExpiredCertDays().intValue());
        }
        if ((str = changeCaEntry.getRevokeSuspendedControl()) != null) {
            newCC.setRevokeSuspendedControl("null".equalsIgnoreCase(str) ? null : new RevokeSuspendedControl(str));
        }
        if ((encodedConf = newCC.encode()).equals(encodedOrigConf = currentCaConfColumn.encode())) {
            return null;
        }
        boolean confIsSensitive = encodedConf.contains("password");
        return DbCaConfStore.colStr("CONF", encodedConf, confIsSensitive, false);
    }

    @Override
    public void commitNextCrlNoIfLess(NameId ca, long nextCrlNo) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlNextSelectCrlNo, DbCaConfStore.col2Int(ca.getId()));
        long nextCrlNoInDb = DbCaConfStore.getLong(rs, "NEXT_CRLNO");
        if (nextCrlNoInDb < nextCrlNo) {
            this.execUpdatePrepStmt0("UPDATE CA SET NEXT_CRLNO=? WHERE ID=?", DbCaConfStore.col2Long(nextCrlNo), DbCaConfStore.col2Int(ca.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdentifiedCertprofile changeCertprofile(NameId nameId, String type, String conf, CaManagerImpl certprofileManager) throws CaMgmtException {
        CertprofileEntry currentDbEntry = this.createCertprofile(nameId.getName());
        CertprofileEntry newDbEntry = new CertprofileEntry(currentDbEntry.getIdent(), DbCaConfStore.str(type, currentDbEntry.getType()), DbCaConfStore.str(conf, currentDbEntry.getConf()));
        IdentifiedCertprofile profile = Optional.ofNullable(certprofileManager.createCertprofile(newDbEntry)).orElseThrow(() -> new CaMgmtException("could not create certprofile object"));
        boolean failed = true;
        try {
            this.changeIfNotNull("PROFILE", DbCaConfStore.colInt("ID", nameId.getId()), DbCaConfStore.colStr("TYPE", type), DbCaConfStore.colStr("CONF", conf));
            failed = false;
            IdentifiedCertprofile identifiedCertprofile = profile;
            return identifiedCertprofile;
        }
        finally {
            if (failed) {
                profile.close();
            }
        }
    }

    @Override
    public RequestorEntryWrapper changeRequestor(NameId nameId, String type, String conf) throws CaMgmtException {
        Args.notNull((Object)nameId, (String)"nameId");
        RequestorEntryWrapper requestor = new RequestorEntryWrapper();
        requestor.setDbEntry(new RequestorEntry(nameId, type, conf));
        if (requestor.getDbEntry().faulty()) {
            throw new CaMgmtException("invalid requestor configuration");
        }
        this.changeIfNotNull("REQUESTOR", DbCaConfStore.colInt("ID", nameId.getId()), DbCaConfStore.colStr("TYPE", type), DbCaConfStore.colStr("CONF", conf));
        return requestor;
    }

    @Override
    public SignerEntry changeSigner(String name, String type, String conf, String base64Cert, CaManagerImpl signerManager) throws CaMgmtException {
        String tmpType;
        Args.notNull((Object)signerManager, (String)"signerManager");
        SignerEntry dbEntry = this.createSigner(Args.notBlank((String)name, (String)"name"));
        String string = tmpType = type == null ? dbEntry.getType() : type;
        if (conf != null) {
            conf = CaUtil.canonicalizeSignerConf(conf);
        }
        SignerEntry signer = new SignerEntry(name, tmpType, conf == null ? dbEntry.getConf() : conf, base64Cert == null ? dbEntry.base64Cert() : base64Cert);
        signerManager.createSigner(signer);
        this.changeIfNotNull("SIGNER", DbCaConfStore.colStr("NAME", name), DbCaConfStore.colStr("TYPE", type), DbCaConfStore.colStr("CERT", base64Cert), DbCaConfStore.colStr("CONF", conf, false, true));
        return signer;
    }

    @Override
    public KeypairGenEntryWrapper changeKeypairGen(String name, String type, String conf, CaManagerImpl manager) throws CaMgmtException {
        Args.notNull((Object)manager, (String)"manager");
        KeypairGenEntry dbEntry = this.createKeypairGen(Args.notBlank((String)name, (String)"name"));
        String tmpType = type == null ? dbEntry.getType() : type;
        KeypairGenEntry newDbEntry = new KeypairGenEntry(name, tmpType, conf == null ? dbEntry.getConf() : conf);
        KeypairGenEntryWrapper wrapper = manager.createKeypairGenerator(newDbEntry);
        this.changeIfNotNull("KEYPAIR_GEN", DbCaConfStore.colStr("NAME", name), DbCaConfStore.colStr("TYPE", type), DbCaConfStore.colStr("CONF", conf, true, false));
        return wrapper;
    }

    @Override
    public IdentifiedCertPublisher changePublisher(String name, String type, String conf, CaManagerImpl publisherManager) throws CaMgmtException {
        Args.notNull((Object)publisherManager, (String)"publisherManager");
        PublisherEntry currentDbEntry = this.createPublisher(Args.notBlank((String)name, (String)"name"));
        PublisherEntry dbEntry = new PublisherEntry(currentDbEntry.getIdent(), type == null ? currentDbEntry.getType() : type, conf == null ? currentDbEntry.getConf() : conf);
        IdentifiedCertPublisher publisher = publisherManager.createPublisher(dbEntry);
        this.changeIfNotNull("PUBLISHER", DbCaConfStore.colStr("NAME", name), DbCaConfStore.colStr("TYPE", type), DbCaConfStore.colStr("CONF", conf));
        return publisher;
    }

    @Override
    public void removeCaAlias(String aliasName) throws CaMgmtException {
        Args.notBlank((String)aliasName, (String)"aliasName");
        int num = this.execUpdatePrepStmt0("DELETE FROM CAALIAS WHERE NAME=?", DbCaConfStore.col2Str(aliasName));
        if (num == 0) {
            throw new CaMgmtException("could not remove CA Alias " + aliasName);
        }
    }

    @Override
    public void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        Args.notBlank((String)profileName, (String)"profileName");
        Args.notBlank((String)caName, (String)"caName");
        this.removeEntityFromCa("profile", profileName, caName, this.sqlSelectProfileId, "DELETE FROM CA_HAS_PROFILE WHERE CA_ID=? AND PROFILE_ID=?");
    }

    @Override
    public void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        Args.notBlank((String)requestorName, (String)"requestorName");
        Args.notBlank((String)caName, (String)"caName");
        this.removeEntityFromCa("requestor", requestorName, caName, this.sqlSelectRequestorId, "DELETE FROM CA_HAS_REQUESTOR WHERE CA_ID=? AND REQUESTOR_ID=?");
    }

    @Override
    public void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        this.removeEntityFromCa("publisher", Args.notBlank((String)publisherName, (String)"publisherName"), Args.notBlank((String)caName, (String)"caName"), this.sqlSelectPublisherId, "DELETE FROM CA_HAS_PUBLISHER WHERE CA_ID=? AND PUBLISHER_ID=?");
    }

    @Override
    public void removeDbSchema(String name) throws CaMgmtException {
        Args.notBlank((String)name, (String)"name");
        String sql = "DELETE FROM DBSCHEMA WHERE NAME=?";
        int num = this.execUpdatePrepStmt0("DELETE FROM DBSCHEMA WHERE NAME=?", DbCaConfStore.col2Str(name));
        if (num == 0) {
            throw new CaMgmtException("could not delete DBSCHEMA " + name);
        }
    }

    private void removeEntityFromCa(String desc, String name, String caName, String sqlSelectId, String sqlRemove) throws CaMgmtException {
        Integer id = Optional.ofNullable(this.getIdForName(sqlSelectId, name)).orElseThrow(() -> new CaMgmtException(String.format("unknown %s %s ", desc, name)));
        int caId = this.getNonNullIdForName(this.sqlSelectCaId, caName);
        int num = this.execUpdatePrepStmt0(sqlRemove, DbCaConfStore.col2Int(caId), DbCaConfStore.col2Int(id));
        if (num == 0) {
            throw new CaMgmtException(String.format("could not remove %s from CA %s", name, caName));
        }
    }

    @Override
    public void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        Args.notBlank((String)caName, (String)"caName");
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        int num = this.execUpdatePrepStmt0("UPDATE CA SET REV_INFO=? WHERE NAME=?", DbCaConfStore.col2Str(revocationInfo.encode()), DbCaConfStore.col2Str(caName));
        if (num == 0) {
            throw new CaMgmtException("could not revoke CA " + caName);
        }
    }

    @Override
    public void addKeypairGen(KeypairGenEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        int num = this.execUpdatePrepStmt0("INSERT INTO KEYPAIR_GEN (NAME,TYPE,CONF) VALUES (?,?,?)", DbCaConfStore.col2Str(dbEntry.getName()), DbCaConfStore.col2Str(dbEntry.getType()), DbCaConfStore.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add keypair generation " + dbEntry.getName());
        }
        LOG.info("added keypair generation: \n{}", (Object)dbEntry.toString(true));
    }

    @Override
    public void addSigner(SignerEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        int num = this.execUpdatePrepStmt0(SqlUtil.buildInsertSql((String)"SIGNER", (String)"NAME,TYPE,CERT,CONF"), DbCaConfStore.col2Str(dbEntry.getName()), DbCaConfStore.col2Str(dbEntry.getType()), DbCaConfStore.col2Str(dbEntry.base64Cert()), DbCaConfStore.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add signer " + dbEntry.getName());
        }
        LOG.info("added signer: {}", (Object)dbEntry.toString(false, true));
    }

    @Override
    public void unlockCa() throws CaMgmtException {
        int num;
        try {
            num = this.execUpdateStmt0("DELETE FROM SYSTEM_EVENT WHERE NAME='LOCK'");
        }
        catch (CaMgmtException ex) {
            throw new CaMgmtException("could not unlock CA", (Throwable)ex);
        }
        if (num == 0) {
            LOG.info("CA system is not locked");
        } else {
            LOG.info("Unlocked CA system");
        }
    }

    @Override
    public void unrevokeCa(String caName) throws CaMgmtException {
        Args.notBlank((String)caName, (String)"caName");
        LOG.info("Unrevoking of CA '{}'", (Object)caName);
        int num = this.execUpdatePrepStmt0("UPDATE CA SET REV_INFO=? WHERE NAME=?", DbCaConfStore.col2Str(null), DbCaConfStore.col2Str(caName));
        if (num == 0) {
            throw new CaMgmtException("could not unrevoke CA " + caName);
        }
    }

    @Override
    public void addDbSchema(String name, String value) throws CaMgmtException {
        String sql = SqlUtil.buildInsertSql((String)"DBSCHEMA", (String)"NAME,VALUE2");
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Str(name), DbCaConfStore.col2Str(value));
        if (num == 0) {
            throw new CaMgmtException("could not add DBSCHEMA " + name);
        }
        LOG.info("added DBSCHEMA '{}'", (Object)name);
    }

    @Override
    public void changeDbSchema(String name, String value) throws CaMgmtException {
        String sql = "UPDATE DBSCHEMA SET VALUE2=? WHERE NAME=?";
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Str(value), DbCaConfStore.col2Str(name));
        if (num == 0) {
            throw new CaMgmtException("could not update DBSCHEMA " + name);
        }
        LOG.info("added DBSCHEMA '{}'", (Object)name);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> getDbSchemas() throws CaMgmtException {
        Args.notNull((Object)this.datasource, (String)"datasource");
        String sql = "SELECT NAME,VALUE2 FROM DBSCHEMA";
        HashMap<String, String> dbSchemas = new HashMap<String, String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = Optional.ofNullable(this.datasource.prepareStatement("SELECT NAME,VALUE2 FROM DBSCHEMA")).orElseThrow(() -> new DataAccessException("could not create statement"));
            rs = stmt.executeQuery();
            while (rs.next()) {
                dbSchemas.put(rs.getString("NAME"), rs.getString("VALUE2"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate("SELECT NAME,VALUE2 FROM DBSCHEMA", ex));
                catch (DataAccessException ex2) {
                    throw new CaMgmtException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)stmt, rs);
        return dbSchemas;
    }

    @Override
    public List<String> getCaNames() throws CaMgmtException {
        return this.namesFromTable("CA");
    }

    @Override
    public boolean deleteCa(String name) throws CaMgmtException {
        return this.deleteRowWithName(name, "CA");
    }

    @Override
    public List<String> getKeyPairGenNames() throws CaMgmtException {
        return this.namesFromTable("KEYPAIR_GEN");
    }

    @Override
    public boolean deleteKeyPairGen(String name) throws CaMgmtException {
        return this.deleteRowWithName(name, "KEYPAIR_GEN");
    }

    @Override
    public List<String> getProfileNames() throws CaMgmtException {
        return this.namesFromTable("PROFILE");
    }

    @Override
    public boolean deleteProfile(String name) throws CaMgmtException {
        return this.deleteRowWithName(name, "PROFILE");
    }

    @Override
    public List<String> getPublisherNames() throws CaMgmtException {
        return this.namesFromTable("PUBLISHER");
    }

    @Override
    public boolean deletePublisher(String name) throws CaMgmtException {
        return this.deleteRowWithName(name, "PUBLISHER");
    }

    @Override
    public List<String> getRequestorNames() throws CaMgmtException {
        return this.namesFromTable("REQUESTOR");
    }

    @Override
    public boolean deleteRequestor(String name) throws CaMgmtException {
        return this.deleteRowWithName(name, "REQUESTOR");
    }

    @Override
    public List<String> getSignerNames() throws CaMgmtException {
        return this.namesFromTable("SIGNER");
    }

    @Override
    public boolean deleteSigner(String name) throws CaMgmtException {
        return this.deleteRowWithName(name, "SIGNER");
    }

    private static X509Cert generateCert(String b64Cert) throws CaMgmtException {
        return b64Cert == null ? null : CaUtil.parseCert(Base64.decode((String)b64Cert));
    }

    private static List<X509Cert> generateCertchain(String encodedCertchain) throws CaMgmtException {
        if (StringUtil.isBlank((String)encodedCertchain)) {
            return null;
        }
        try {
            List certs = X509Util.listCertificates((String)encodedCertchain);
            return CollectionUtil.isEmpty((Collection)certs) ? null : certs;
        }
        catch (IOException | CertificateException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private static int getInt(ResultRow rs, String label) {
        return rs.getInt(label);
    }

    private static long getLong(ResultRow rs, String label) {
        return rs.getLong(label);
    }

    public int getMaxX500nameLen() {
        return this.maxX500nameLen;
    }

    private PreparedStatement prepareStatement(String sql) throws CaMgmtException {
        try {
            return this.datasource.prepareStatement(sql);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public List<String> namesFromTable(String table) throws CaMgmtException {
        String sql = "SELECT NAME FROM " + table;
        List<ResultRow> rows = this.execQueryStmt0(sql);
        LinkedList<String> names = new LinkedList<String>();
        for (ResultRow rs : rows) {
            String name = rs.getString("NAME");
            if (!StringUtil.isNotBlank((String)name)) continue;
            names.add(name);
        }
        return names;
    }

    public boolean deleteRowWithName(String name, String table) throws CaMgmtException {
        String sql = "DELETE FROM " + table + " WHERE NAME=?";
        int num = this.execUpdatePrepStmt0(sql, DbCaConfStore.col2Str(name));
        return num > 0;
    }

    private static String str(String sa, String sb) {
        return sa != null ? DbCaConfStore.getRealString(sa) : sb;
    }

    private int execUpdateStmt0(String sql) throws CaMgmtException {
        try {
            return this.execUpdateStmt(sql);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private int execUpdatePrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws CaMgmtException {
        try {
            return this.execUpdatePrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private List<ResultRow> execQueryStmt0(String sql) throws CaMgmtException {
        try {
            return this.execQueryStmt(sql);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private ResultRow execQuery1PrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws CaMgmtException {
        try {
            return this.execQuery1PrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private List<ResultRow> execQueryPrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws CaMgmtException {
        try {
            return this.execQueryPrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private void changeIfNotNull(String tableName, QueryExecutor.SqlColumn whereColumn, QueryExecutor.SqlColumn ... columns) throws CaMgmtException {
        StringBuilder buf = new StringBuilder("UPDATE ");
        buf.append(tableName).append(" SET ");
        boolean noAction = true;
        for (QueryExecutor.SqlColumn col : columns) {
            if (col.value() == null) continue;
            noAction = false;
            buf.append(col.name()).append("=?,");
        }
        if (noAction) {
            LOG.info("nothing to update");
            return;
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append(" WHERE ").append(whereColumn.name()).append("=?");
        String sql = buf.toString();
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            HashMap<String, String> changedColumns = new HashMap<String, String>();
            int index = 1;
            for (QueryExecutor.SqlColumn col : columns) {
                if (col.value() == null) continue;
                this.setColumn(changedColumns, ps, index, col);
                ++index;
            }
            this.setColumn(null, ps, index, whereColumn);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not update table " + tableName);
            }
            LOG.info("updated table {} WHERE {}={}: {}", new Object[]{tableName, whereColumn.name(), whereColumn.value(), changedColumns});
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    private void setColumn(Map<String, String> changedColumns, PreparedStatement ps, int index, QueryExecutor.SqlColumn column) throws SQLException {
        String valText;
        String name = column.name();
        QueryExecutor.ColumnType type = column.type();
        Object value = column.value();
        boolean sensitive = column.sensitive();
        if (type == QueryExecutor.ColumnType.STRING) {
            String val = DbCaConfStore.getRealString((String)value);
            ps.setString(index, val);
            valText = val;
            if (val != null && column.isSignerConf() && (valText = SignerConf.eraseSensitiveData((String)valText)).length() > 100) {
                valText = StringUtil.concat((String)valText.substring(0, 97), (String[])new String[]{"..."});
            }
        } else if (type == QueryExecutor.ColumnType.INT) {
            if (value == null) {
                ps.setNull(index, 4);
                valText = "null";
            } else {
                int val = (Integer)value;
                ps.setInt(index, val);
                valText = Integer.toString(val);
            }
        } else if (type == QueryExecutor.ColumnType.LONG) {
            if (value == null) {
                ps.setNull(index, -5);
                valText = "null";
            } else {
                long val = (Long)value;
                ps.setLong(index, val);
                valText = Long.toString(val);
            }
        } else if (type == QueryExecutor.ColumnType.BOOL) {
            if (value == null) {
                ps.setNull(index, 4);
                valText = "null";
            } else {
                int val = (Boolean)value != false ? 1 : 0;
                ps.setInt(index, val);
                valText = Integer.toString(val);
            }
        } else if (type == QueryExecutor.ColumnType.TIMESTAMP) {
            if (value == null) {
                ps.setNull(index, 93);
                valText = "null";
            } else {
                Timestamp val = (Timestamp)value;
                ps.setTimestamp(index, val);
                valText = val.toString();
            }
        } else {
            throw new IllegalStateException("should not reach here, unknown type " + column.type());
        }
        if (changedColumns != null) {
            changedColumns.put(name, sensitive ? "*****" : valText);
        }
    }

    private static String getRealString(String str) {
        return "null".equalsIgnoreCase(str) ? null : str;
    }

    private int getNonNullIdForName(String sql, String name) throws CaMgmtException {
        Integer id = this.getIdForName(sql, name);
        if (id != null) {
            return id;
        }
        throw new CaMgmtException("Found no entry named " + name);
    }

    private Integer getIdForName(String sql, String name) throws CaMgmtException {
        Integer n;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            ps = null;
            rs = null;
            ps = this.prepareStatement(sql);
            ps.setString(1, name);
            rs = ps.executeQuery();
            if (rs.next()) break block5;
            Integer n2 = null;
            this.datasource.releaseResources((Statement)ps, rs);
            return n2;
        }
        try {
            n = rs.getInt("ID");
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return n;
    }

    private Map<Integer, String> getIdNameMap(String tableName) throws CaMgmtException {
        String sql = "SELECT ID,NAME FROM " + tableName;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        try {
            ps = this.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                ret.put(rs.getInt("ID"), rs.getString("NAME"));
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
        return ret;
    }

    private static enum Table {
        REQUESTOR,
        PUBLISHER,
        PROFILE,
        CA;

    }
}

