/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.SocketException;
import java.sql.Connection;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.audit.PciAuditEvent;
import org.xipki.ca.api.DataSourceMap;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.kpgen.KeypairGenerator;
import org.xipki.ca.api.kpgen.KeypairGeneratorFactory;
import org.xipki.ca.api.mgmt.CaConfs;
import org.xipki.ca.api.mgmt.CaManager;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaProfileEntry;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CaSystemStatus;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.sdk.CaIdentifierRequest;
import org.xipki.ca.sdk.CertprofileInfoResponse;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.ca.server.CaConfStore;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaServerConf;
import org.xipki.ca.server.CertPublisherFactoryRegister;
import org.xipki.ca.server.CertprofileFactoryRegister;
import org.xipki.ca.server.CtLogPublicKeyFinder;
import org.xipki.ca.server.FileCaConfStore;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.KeypairGenEntryWrapper;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.SystemEvent;
import org.xipki.ca.server.UniqueIdGenerator;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.db.DbCaConfStore;
import org.xipki.ca.server.mgmt.Ca2Manager;
import org.xipki.ca.server.mgmt.CertprofileManager;
import org.xipki.ca.server.mgmt.ConfLoader;
import org.xipki.ca.server.mgmt.KeypairGenManager;
import org.xipki.ca.server.mgmt.PublisherManager;
import org.xipki.ca.server.mgmt.RequestorManager;
import org.xipki.ca.server.mgmt.SignerManager;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceConf;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.license.api.CmLicense;
import org.xipki.pki.OperationException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.KeyCertBytesPair;
import org.xipki.security.SecurityFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.FileOrValue;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class CaManagerImpl
implements CaManager,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CaManagerImpl.class);
    private static final String EVENT_LOCK = "LOCK";
    private static final String EVENT_CACHANGE = "CA_CHANGE";
    final CaIdNameMap idNameMap = new CaIdNameMap();
    final Map<String, CaInfo> caInfos = new ConcurrentHashMap<String, CaInfo>();
    final Map<String, SignerEntry> signers = new ConcurrentHashMap<String, SignerEntry>();
    final Map<String, SignerEntry> signerDbEntries = new ConcurrentHashMap<String, SignerEntry>();
    final Map<String, IdentifiedCertprofile> certprofiles = new ConcurrentHashMap<String, IdentifiedCertprofile>();
    final Map<String, CertprofileEntry> certprofileDbEntries = new ConcurrentHashMap<String, CertprofileEntry>();
    final Map<String, IdentifiedCertPublisher> publishers = new ConcurrentHashMap<String, IdentifiedCertPublisher>();
    final Map<String, PublisherEntry> publisherDbEntries = new ConcurrentHashMap<String, PublisherEntry>();
    final Map<String, RequestorEntryWrapper> requestors = new ConcurrentHashMap<String, RequestorEntryWrapper>();
    final Map<String, RequestorEntry> requestorDbEntries = new ConcurrentHashMap<String, RequestorEntry>();
    final Map<String, KeypairGenEntryWrapper> keypairGens = new ConcurrentHashMap<String, KeypairGenEntryWrapper>();
    final Map<String, KeypairGenEntry> keypairGenDbEntries = new ConcurrentHashMap<String, KeypairGenEntry>();
    final Map<String, Set<CaProfileEntry>> caHasProfiles = new ConcurrentHashMap<String, Set<CaProfileEntry>>();
    final Map<String, Set<String>> caHasPublishers = new ConcurrentHashMap<String, Set<String>>();
    final Map<String, Set<CaHasRequestorEntry>> caHasRequestors = new ConcurrentHashMap<String, Set<CaHasRequestorEntry>>();
    final Map<String, Integer> caAliases = new ConcurrentHashMap<String, Integer>();
    final Map<String, X509Ca> x509cas = new ConcurrentHashMap<String, X509Ca>();
    RequestorInfo byCaRequestor;
    boolean masterMode;
    boolean noLock;
    int shardId;
    private Map<String, DataSourceWrapper> allDataSources;
    CaServerConf caServerConf;
    CertprofileFactoryRegister certprofileFactoryRegister;
    CertPublisherFactoryRegister certPublisherFactoryRegister;
    Set<KeypairGeneratorFactory> keypairGeneratorFactories;
    CertStore certstore;
    SecurityFactory securityFactory;
    P11CryptServiceFactory p11CryptServiceFactory;
    CaConfStore caConfStore;
    private final CmLicense license;
    private DataSourceWrapper certstoreDatasource;
    private final String lockInstanceId;
    private boolean caLockedByMe;
    private ScheduledThreadPoolExecutor persistentScheduledThreadPoolExecutor;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final DataSourceFactory datasourceFactory;
    private CtLogPublicKeyFinder ctLogPublicKeyFinder;
    private boolean caSystemSetuped;
    private Instant lastStartTime;
    private boolean initializing;
    private final Ca2Manager ca2Manager;
    private final CertprofileManager certprofileManager;
    private final ConfLoader confLoader;
    private final PublisherManager publisherManager;
    private final RequestorManager requestorManager;
    private final SignerManager signerManager;
    private final KeypairGenManager keypairGenManager;
    private final String calockFilePath;

    public CaManagerImpl(CmLicense license) {
        this.license = (CmLicense)Args.notNull((Object)license, (String)"license");
        this.datasourceFactory = new DataSourceFactory();
        this.calockFilePath = IoUtil.expandFilepath((String)"calock", (boolean)true);
        String calockId = null;
        File calockFile = new File(this.calockFilePath);
        if (calockFile.exists()) {
            try {
                calockId = StringUtil.toUtf8String((byte[])IoUtil.read((File)calockFile));
            }
            catch (IOException ex) {
                LOG.error("could not read {}: {}", (Object)calockFile.getName(), (Object)ex.getMessage());
            }
        }
        if (calockId == null) {
            calockId = UUID.randomUUID().toString();
            try {
                IoUtil.save((File)calockFile, (byte[])StringUtil.toUtf8Bytes((String)calockId));
            }
            catch (IOException ex) {
                LOG.error("could not save {}: {}", (Object)calockFile.getName(), (Object)ex.getMessage());
            }
        }
        String hostAddress = null;
        try {
            hostAddress = IoUtil.getHostAddress();
        }
        catch (SocketException ex) {
            LOG.warn("could not get host address: {}", (Object)ex.getMessage());
        }
        this.lockInstanceId = hostAddress == null ? calockId : hostAddress + "/" + calockId;
        this.ca2Manager = new Ca2Manager(this);
        this.certprofileManager = new CertprofileManager(this);
        this.confLoader = new ConfLoader(this);
        this.publisherManager = new PublisherManager(this);
        this.requestorManager = new RequestorManager(this);
        this.signerManager = new SignerManager(this);
        this.keypairGenManager = new KeypairGenManager(this);
    }

    public int getShardId() {
        return this.shardId;
    }

    public SecurityFactory getSecurityFactory() {
        return this.securityFactory;
    }

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    public P11CryptServiceFactory getP11CryptServiceFactory() {
        return this.p11CryptServiceFactory;
    }

    public void setP11CryptServiceFactory(P11CryptServiceFactory p11CryptServiceFactory) {
        this.p11CryptServiceFactory = p11CryptServiceFactory;
    }

    public boolean isMasterMode() {
        return this.masterMode;
    }

    public Set<String> getSupportedSignerTypes() {
        return this.securityFactory.getSupportedSignerTypes();
    }

    public Set<String> getSupportedCertprofileTypes() {
        return this.certprofileFactoryRegister.getSupportedTypes();
    }

    public Set<String> getSupportedPublisherTypes() {
        return this.certPublisherFactoryRegister.getSupportedTypes();
    }

    public String getTokenInfoP11(String moduleName, Integer slotIndex, boolean verbose) throws CaMgmtException {
        return this.signerManager.getTokenInfoP11(moduleName, slotIndex, verbose);
    }

    private void init() throws CaMgmtException {
        if (this.securityFactory == null) {
            throw new IllegalStateException("securityFactory is not set");
        }
        if (this.datasourceFactory == null) {
            throw new IllegalStateException("datasourceFactory is not set");
        }
        if (this.certprofileFactoryRegister == null) {
            throw new IllegalStateException("certprofileFactoryRegister is not set");
        }
        if (this.certPublisherFactoryRegister == null) {
            throw new IllegalStateException("certPublisherFactoryRegister is not set");
        }
        if (this.keypairGeneratorFactories == null) {
            throw new IllegalStateException("keypairGeneratorFactories is not set");
        }
        if (this.caServerConf == null) {
            throw new IllegalStateException("caServerConf is not set");
        }
        this.masterMode = this.caServerConf.isMaster();
        LOG.info("ca.masterMode: {}", (Object)this.masterMode);
        this.noLock = this.caServerConf.isNoLock();
        LOG.info("ca.noLock: {}", (Object)this.noLock);
        this.shardId = this.caServerConf.getShardId();
        LOG.info("ca.shardId: {}", (Object)this.shardId);
        this.caServerConf.initSsl();
        if (this.caServerConf.getCtLog() != null) {
            try {
                this.ctLogPublicKeyFinder = new CtLogPublicKeyFinder(this.caServerConf.getCtLog());
            }
            catch (Exception ex) {
                throw new CaMgmtException("could not load CtLogPublicKeyFinder: " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (this.allDataSources == null) {
            this.allDataSources = new HashMap<String, DataSourceWrapper>();
            String caDataSourceName = "ca";
            FileOrValue caDataSourceConf = null;
            for (DataSourceConf datasource : this.caServerConf.getDatasources()) {
                String name = datasource.getName().toLowerCase(Locale.ROOT);
                FileOrValue fileOrValue = datasource.getConf();
                if ("ca".equals(name)) {
                    caDataSourceConf = fileOrValue;
                    continue;
                }
                this.addDataSource(name, fileOrValue);
            }
            if (this.caServerConf.getCaConfFiles() == null) {
                LOG.info("loading CAConf from database");
                DataSourceWrapper caconfDatasource = this.allDataSources.get("caconf");
                this.caConfStore = new DbCaConfStore(caconfDatasource);
            } else {
                LOG.info("loading CAConf from files {}", this.caServerConf.getCaConfFiles());
                try {
                    this.caConfStore = new FileCaConfStore(this.securityFactory, this.certprofileFactoryRegister, this.caServerConf.getCaConfFiles());
                }
                catch (IOException ex) {
                    throw new CaMgmtException("IO error: " + ex.getMessage(), (Throwable)ex);
                }
                catch (InvalidConfException ex) {
                    throw new CaMgmtException("Invalid Configuration: " + ex.getMessage(), (Throwable)ex);
                }
            }
            boolean needsCertStore = this.caConfStore.needsCertStore();
            LOG.info("needsCertStore: {}", (Object)needsCertStore);
            if (needsCertStore) {
                if (caDataSourceConf == null) {
                    throw new CaMgmtException("no datasource named 'ca' configured");
                }
                this.addDataSource("ca", caDataSourceConf);
                this.certstoreDatasource = this.allDataSources.get("ca");
            }
            LOG.info("dbSchemaVersion: {}", (Object)this.caConfStore.getDbSchemaVersion());
        }
        long epochSecond = ZonedDateTime.of(2010, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toEpochSecond();
        UniqueIdGenerator idGen = new UniqueIdGenerator(epochSecond, this.shardId);
        if (this.masterMode) {
            String[] embeddedNames;
            if (!this.noLock) {
                this.lockCa();
            }
            List<String> names = this.caConfStore.getRequestorNames();
            for (String embeddedName : embeddedNames = new String[]{"by-ca"}) {
                boolean contained = false;
                for (String name : names) {
                    if (!embeddedName.equalsIgnoreCase(name)) continue;
                    contained = true;
                    break;
                }
                if (contained) continue;
                this.caConfStore.addEmbeddedRequestor(embeddedName);
            }
        }
        boolean initSucc = true;
        if (this.caConfStore.needsCertStore()) {
            try {
                this.certstore = new CertStore(this.certstoreDatasource, this.caConfStore, idGen);
            }
            catch (DataAccessException ex) {
                initSucc = false;
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error constructing CertStore");
            }
        }
        try {
            this.ca2Manager.initCaAliases();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initCaAliases");
        }
        try {
            this.certprofileManager.initCertprofiles();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initCertprofiles");
        }
        try {
            this.publisherManager.initPublishers();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initPublishers");
        }
        try {
            this.requestorManager.initRequestors();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initRequestors");
        }
        try {
            this.signerManager.initSigners();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initSigners");
        }
        try {
            this.keypairGenManager.initKeypairGens();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initKeypairGens");
        }
        try {
            this.ca2Manager.initCas();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initCas");
        }
        if (this.masterMode && this.certstore != null) {
            for (CertprofileEntry certprofileEntry : this.certprofileDbEntries.values()) {
                this.certstore.addCertProfile(certprofileEntry.getIdent());
            }
            if (this.byCaRequestor != null) {
                this.certstore.addRequestor(this.byCaRequestor.getIdent());
            }
            for (RequestorEntry requestorEntry : this.requestorDbEntries.values()) {
                this.certstore.addRequestor(requestorEntry.getIdent());
            }
            for (CaInfo caInfo : this.caInfos.values()) {
                this.certstore.addCa(caInfo.getIdent(), caInfo.getCert(), caInfo.getRevocationInfo());
            }
        }
        if (!initSucc) {
            throw new CaMgmtException("error initializing CA system");
        }
    }

    private void addDataSource(String name, FileOrValue conf) throws CaMgmtException {
        DataSourceWrapper datasource;
        try {
            datasource = this.datasourceFactory.createDataSource(name, conf);
            Connection conn = datasource.getConnection();
            datasource.returnConnection(conn);
            LOG.info("loaded datasource.{}", (Object)name);
        }
        catch (IOException | RuntimeException | DataAccessException | InvalidConfException ex) {
            throw new CaMgmtException(ex.getClass().getName() + " while parsing datasource " + name + ": " + ex.getMessage(), ex);
        }
        this.allDataSources.put(name, datasource);
        if (conf.getFile() != null) {
            LOG.info("associate datasource {} to the file {}", (Object)name, (Object)conf.getFile());
        } else {
            LOG.info("associate datasource {} to text value", (Object)name);
        }
    }

    public int getDbSchemaVersion() {
        return this.caConfStore.getDbSchemaVersion();
    }

    public CaSystemStatus getCaSystemStatus() {
        if (this.caSystemSetuped) {
            return this.masterMode ? CaSystemStatus.STARTED_AS_MASTER : CaSystemStatus.STARTED_AS_SLAVE;
        }
        if (this.initializing) {
            return CaSystemStatus.INITIALIZING;
        }
        if (!this.caLockedByMe) {
            return CaSystemStatus.LOCK_FAILED;
        }
        return CaSystemStatus.ERROR;
    }

    private void lockCa() throws CaMgmtException {
        SystemEvent lockInfo = this.caConfStore.getSystemEvent(EVENT_LOCK);
        if (lockInfo != null) {
            String lockedBy = lockInfo.getOwner();
            Instant lockedAt = Instant.ofEpochSecond(lockInfo.getEventTime());
            if (!this.lockInstanceId.equals(lockedBy)) {
                String msg = "could not lock CA, it has been locked by " + lockedBy + " since " + lockedAt + ". In general this indicates that another CA software in master mode is accessing the database or the last shutdown of CA software in master mode is abnormal. If you know what you do, you can unlock it executing the ca:unlock command.";
                throw this.logAndCreateException(msg);
            }
            LOG.info("CA has been locked by me since {}, re-lock it", (Object)lockedAt);
        }
        SystemEvent newLockInfo = new SystemEvent(EVENT_LOCK, this.lockInstanceId, Instant.now().getEpochSecond());
        this.caConfStore.changeSystemEvent(newLockInfo);
        this.caLockedByMe = true;
    }

    public void unlockCa() throws CaMgmtException {
        if (!this.masterMode) {
            throw this.logAndCreateException("could not unlock CA in slave mode");
        }
        boolean succ = false;
        try {
            this.caConfStore.unlockCa();
            LOG.info("unlocked CA");
            succ = true;
        }
        finally {
            CaManagerImpl.auditLogPciEvent(succ, "UNLOCK");
        }
    }

    private void reset() {
        this.caSystemSetuped = false;
        this.ctLogPublicKeyFinder = null;
        this.signerManager.reset();
        this.requestorManager.reset();
        this.ca2Manager.reset();
        this.certprofileManager.reset();
        this.publisherManager.reset();
        this.keypairGenManager.reset();
        this.shutdownScheduledThreadPoolExecutor();
    }

    public void restartCa(String name) throws CaMgmtException {
        this.ca2Manager.restartCa(name);
    }

    public void restartCaSystem() throws CaMgmtException {
        this.reset();
        boolean caSystemStarted = this.startCaSystem0();
        CaManagerImpl.auditLogPciEvent(caSystemStarted, EVENT_CACHANGE);
        if (!caSystemStarted) {
            throw this.logAndCreateException("could not restart CA system");
        }
    }

    public void notifyCaChange() throws CaMgmtException {
        try {
            SystemEvent systemEvent = new SystemEvent(EVENT_CACHANGE, this.lockInstanceId, Instant.now().getEpochSecond());
            this.caConfStore.changeSystemEvent(systemEvent);
            LOG.info("notified the change of CA system");
        }
        catch (CaMgmtException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not notify slave CAs to restart");
            throw ex;
        }
    }

    public void addDbSchema(String name, String value) throws CaMgmtException {
        CaManagerImpl.checkModificationOfDbSchema(name);
        this.caConfStore.addDbSchema(name, value);
        try {
            this.certstore.updateDbInfo();
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public void changeDbSchema(String name, String value) throws CaMgmtException {
        CaManagerImpl.checkModificationOfDbSchema(name);
        this.caConfStore.changeDbSchema(name, value);
        try {
            this.certstore.updateDbInfo();
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public void removeDbSchema(String name) throws CaMgmtException {
        CaManagerImpl.checkModificationOfDbSchema(name);
        this.caConfStore.removeDbSchema(name);
        try {
            this.certstore.updateDbInfo();
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public Map<String, String> getDbSchemas() throws CaMgmtException {
        Map<String, String> all = this.caConfStore.getDbSchemas();
        HashMap<String, String> noReserved = new HashMap<String, String>(all.size() * 5 / 4);
        block8: for (Map.Entry<String, String> entry : all.entrySet()) {
            switch (entry.getKey()) {
                case "VERSION": 
                case "VENDOR": 
                case "X500NAME_MAXLEN": {
                    continue block8;
                }
            }
            noReserved.put(entry.getKey(), entry.getValue());
        }
        return noReserved;
    }

    private static void checkModificationOfDbSchema(String name) throws CaMgmtException {
        if (StringUtil.orEqualsIgnoreCase((String)name, (String[])new String[]{"VERSION", "VENDOR", "X500NAME_MAXLEN"})) {
            throw new CaMgmtException("modification of reserved DBSCHEMA " + name + " is not allowed");
        }
    }

    public void startCaSystem() {
        boolean caSystemStarted = false;
        try {
            caSystemStarted = this.startCaSystem0();
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not start CA system");
        }
        if (!caSystemStarted) {
            LOG.error("could not start CA system");
        }
        CaManagerImpl.auditLogPciEvent(caSystemStarted, "START");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startCaSystem0() {
        if (this.caSystemSetuped) {
            return true;
        }
        this.initializing = true;
        this.shutdownScheduledThreadPoolExecutor();
        try {
            String name;
            LOG.info("starting CA system");
            try {
                this.init();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initializing CA system");
                boolean bl = false;
                this.initializing = false;
                if (!this.masterMode && this.persistentScheduledThreadPoolExecutor == null) {
                    this.persistentScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                    this.persistentScheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
                    this.persistentScheduledThreadPoolExecutor.scheduleAtFixedRate(new CaRestarter(), 300L, 300L, TimeUnit.SECONDS);
                }
                return bl;
            }
            this.lastStartTime = Instant.now();
            this.x509cas.clear();
            this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(10);
            this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
            LinkedList<String> failedCaNames = new LinkedList<String>();
            for (Map.Entry<String, CaInfo> entry : this.caInfos.entrySet()) {
                String caName = entry.getKey();
                CaStatus status = entry.getValue().getStatus();
                if (CaStatus.active != status) continue;
                if (this.ca2Manager.startCa(caName)) {
                    LOG.info("started CA {}", (Object)caName);
                    continue;
                }
                failedCaNames.add(caName);
                LOG.error("could not start CA {}", (Object)caName);
            }
            this.caSystemSetuped = true;
            StringBuilder sb = new StringBuilder();
            sb.append("started CA system");
            Set<String> caAliasNames = this.getCaAliasNames();
            HashSet<String> names = new HashSet<String>(this.getCaNames());
            if (!names.isEmpty()) {
                sb.append(" with following CAs: ");
                for (String aliasName : caAliasNames) {
                    name = this.getCaNameForAlias(aliasName);
                    if (name == null) continue;
                    names.remove(name);
                    sb.append(name).append(" (alias ").append(aliasName).append("), ");
                }
                for (String name2 : names) {
                    sb.append(name2).append(", ");
                }
                int len = sb.length();
                sb.delete(len - 2, len);
            } else {
                sb.append(": no CA is configured");
            }
            if (!failedCaNames.isEmpty()) {
                sb.append(", and following CAs could not be started: ");
                for (String aliasName : caAliasNames) {
                    name = this.getCaNameForAlias(aliasName);
                    if (!failedCaNames.remove(name)) continue;
                    sb.append(name).append(" (alias ").append(aliasName).append("), ");
                }
                for (String name2 : failedCaNames) {
                    sb.append(name2).append(", ");
                }
                int len = sb.length();
                sb.delete(len - 2, len);
            }
            LOG.info("{}", (Object)sb);
        }
        finally {
            this.initializing = false;
            if (!this.masterMode && this.persistentScheduledThreadPoolExecutor == null) {
                this.persistentScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                this.persistentScheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
                this.persistentScheduledThreadPoolExecutor.scheduleAtFixedRate(new CaRestarter(), 300L, 300L, TimeUnit.SECONDS);
            }
        }
        return true;
    }

    @Override
    public void close() {
        LOG.info("stopping CA system");
        this.shutdownScheduledThreadPoolExecutor();
        if (this.persistentScheduledThreadPoolExecutor != null) {
            this.persistentScheduledThreadPoolExecutor.shutdown();
            while (!this.persistentScheduledThreadPoolExecutor.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.error("interrupted: {}", (Object)ex.getMessage());
                }
            }
            this.persistentScheduledThreadPoolExecutor = null;
        }
        this.ca2Manager.close();
        if (this.caLockedByMe) {
            try {
                this.unlockCa();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not unlock CA system");
            }
        }
        for (Map.Entry<String, DataSourceWrapper> m : this.allDataSources.entrySet()) {
            try {
                m.getValue().close();
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not close datasource " + m.getKey()));
            }
        }
        this.keypairGenManager.close();
        this.publisherManager.close();
        this.certprofileManager.close();
        File caLockFile = new File(this.calockFilePath);
        if (caLockFile.exists() && !caLockFile.delete()) {
            LOG.warn("could not delete file " + caLockFile.getAbsolutePath());
        }
        CaManagerImpl.auditLogPciEvent(true, "SHUTDOWN");
        LOG.info("stopped CA system");
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public Set<String> getCertprofileNames() {
        return this.certprofileDbEntries.keySet();
    }

    public Set<String> getKeypairGenNames() {
        return this.keypairGenDbEntries.keySet();
    }

    public Set<String> getPublisherNames() {
        return this.publisherDbEntries.keySet();
    }

    public Set<String> getRequestorNames() {
        return this.requestorDbEntries.keySet();
    }

    public Set<String> getSignerNames() {
        return this.signerDbEntries.keySet();
    }

    public Set<String> getCaNames() {
        return this.caInfos.keySet();
    }

    public Set<String> getSuccessfulCaNames() {
        return this.ca2Manager.getSuccessfulCaNames();
    }

    public Set<String> getFailedCaNames() {
        return this.ca2Manager.getFailedCaNames();
    }

    public Set<String> getInactiveCaNames() {
        return this.ca2Manager.getInactiveCaNames();
    }

    public void commitNextCrlNo(NameId ca, long nextCrlNo) throws OperationException {
        this.ca2Manager.commitNextCrlNo(ca, nextCrlNo);
    }

    public void addCa(CaEntry caEntry) throws CaMgmtException {
        this.ca2Manager.addCa(caEntry, this.certstore);
    }

    public CaEntry getCa(String name) {
        CaInfo caInfo = this.caInfos.get(Args.toNonBlankLower((String)name, (String)"name"));
        return caInfo == null ? null : caInfo.getCaEntry();
    }

    public List<X509Cert> getCaCerts(String name) {
        CaInfo caInfo = this.caInfos.get(Args.toNonBlankLower((String)name, (String)"name"));
        if (caInfo == null) {
            return null;
        }
        LinkedList<X509Cert> ret = new LinkedList<X509Cert>();
        ret.add(caInfo.getCert());
        if (caInfo.getCertchain() != null) {
            ret.addAll(caInfo.getCertchain());
        }
        return ret;
    }

    public void changeCa(ChangeCaEntry entry) throws CaMgmtException {
        this.ca2Manager.changeCa(entry);
    }

    public void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        this.certprofileManager.removeCertprofileFromCa(profileName, caName);
    }

    public void addCertprofileToCa(String profileNameAndAliases, String caName) throws CaMgmtException {
        this.certprofileManager.addCertprofileToCa(profileNameAndAliases, caName);
    }

    public void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        this.publisherManager.removePublisherFromCa(publisherName, caName);
    }

    public void addPublisherToCa(String publisherName, String caName) throws CaMgmtException {
        this.publisherManager.addPublisherToCa(publisherName, caName);
    }

    public Set<CaProfileEntry> getCertprofilesForCa(String caName) {
        Set<CaProfileEntry> caProfileEntries = this.caHasProfiles.get(Args.toNonBlankLower((String)caName, (String)"caName"));
        if (CollectionUtil.isEmpty(caProfileEntries)) {
            return Collections.emptySet();
        }
        return new HashSet<CaProfileEntry>(caProfileEntries);
    }

    public Set<CaHasRequestorEntry> getRequestorsForCa(String caName) {
        return this.caHasRequestors.get(Args.toNonBlankLower((String)caName, (String)"caName"));
    }

    public RequestorEntry getRequestor(String name) {
        return this.requestorDbEntries.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public RequestorEntryWrapper getRequestorWrapper(String name) {
        return this.requestors.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public void addRequestor(RequestorEntry requestorEntry) throws CaMgmtException {
        this.requestorManager.addRequestor(requestorEntry);
        this.certstore.addRequestor(requestorEntry.getIdent());
    }

    public void removeRequestor(String name) throws CaMgmtException {
        this.assertMasterMode();
        this.certstore.removeRequestor(name);
        this.requestorManager.removeRequestor(name);
    }

    public void changeRequestor(String name, String type, String conf) throws CaMgmtException {
        this.requestorManager.changeRequestor(name, type, conf);
    }

    public void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        this.requestorManager.removeRequestorFromCa(requestorName, caName);
    }

    public void addRequestorToCa(CaHasRequestorEntry requestor, String caName) throws CaMgmtException {
        this.requestorManager.addRequestorToCa(requestor, caName);
    }

    public CertprofileEntry getCertprofile(String name) {
        return this.certprofileDbEntries.get(name.toLowerCase());
    }

    public void removeCertprofile(String name) throws CaMgmtException {
        this.assertMasterMode();
        this.certstore.removeCertProfile(name);
        this.certprofileManager.removeCertprofile(name);
    }

    public void changeCertprofile(String name, String type, String conf) throws CaMgmtException {
        this.certprofileManager.changeCertprofile(name, type, conf);
    }

    public void addCertprofile(CertprofileEntry certprofileEntry) throws CaMgmtException {
        this.certprofileManager.addCertprofile(certprofileEntry);
        this.certstore.addCertProfile(certprofileEntry.getIdent());
    }

    public CertprofileInfoResponse getCertprofileInfo(String profileName) throws OperationException {
        return this.certprofileManager.getCertprofileInfo(profileName);
    }

    public KeypairGenEntry getKeypairGen(String name) {
        return this.keypairGenDbEntries.get(name);
    }

    public void removeKeypairGen(String name) throws CaMgmtException {
        this.keypairGenManager.removeKeypairGen(name);
    }

    public void changeKeypairGen(String name, String type, String conf) throws CaMgmtException {
        this.keypairGenManager.changeKeypairGen(name, type, conf);
    }

    public void addKeypairGen(KeypairGenEntry keypairGenEntry) throws CaMgmtException {
        this.keypairGenManager.addKeypairGen(keypairGenEntry);
    }

    public void addSigner(SignerEntry signerEntry) throws CaMgmtException {
        this.signerManager.addSigner(signerEntry);
    }

    public void removeSigner(String name) throws CaMgmtException {
        this.signerManager.removeSigner(name);
    }

    public void changeSigner(String name, String type, String conf, String base64Cert) throws CaMgmtException {
        this.signerManager.changeSigner(name, type, conf, base64Cert);
    }

    public SignerEntry getSigner(String name) {
        return this.signerDbEntries.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public SignerEntry getSignerWrapper(String name) {
        return this.signers.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public void addPublisher(PublisherEntry entry) throws CaMgmtException {
        this.publisherManager.addPublisher(entry);
    }

    public List<PublisherEntry> getPublishersForCa(String caName) {
        return this.publisherManager.getPublishersForCa(caName);
    }

    public PublisherEntry getPublisher(String name) {
        return this.publisherDbEntries.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public void removePublisher(String name) throws CaMgmtException {
        this.publisherManager.removePublisher(name);
    }

    public void changePublisher(String name, String type, String conf) throws CaMgmtException {
        this.publisherManager.changePublisher(name, type, conf);
    }

    public void setCaServerConf(CaServerConf caServerConf) {
        this.caServerConf = (CaServerConf)((Object)Args.notNull((Object)((Object)caServerConf), (String)"caServerConf"));
    }

    public void addCaAlias(String aliasName, String caName) throws CaMgmtException {
        CaManagerImpl.checkName(aliasName, "CA alias");
        this.ca2Manager.addCaAlias(aliasName, caName);
    }

    public void removeCaAlias(String name) throws CaMgmtException {
        this.ca2Manager.removeCaAlias(name);
    }

    public String getCaNameForAlias(String aliasName) {
        return this.ca2Manager.getCaNameForAlias(aliasName);
    }

    public Set<String> getAliasesForCa(String caName) {
        return this.ca2Manager.getAliasesForCa(caName);
    }

    public Set<String> getCaAliasNames() {
        return this.caAliases.keySet();
    }

    public void removeCa(String name) throws CaMgmtException {
        this.assertMasterMode();
        this.certstore.removeCa(name);
        this.ca2Manager.removeCa(name);
    }

    public void republishCertificates(String caName, List<String> publisherNames, int numThreads) throws CaMgmtException {
        this.publisherManager.republishCertificates(caName, publisherNames, numThreads);
    }

    public void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        this.ca2Manager.revokeCa(caName, revocationInfo);
        this.certstore.revokeCa(caName, revocationInfo);
    }

    public void unrevokeCa(String caName) throws CaMgmtException {
        this.ca2Manager.unrevokeCa(caName);
        this.certstore.unrevokeCa(caName);
    }

    public void setCertprofileFactoryRegister(CertprofileFactoryRegister register) {
        this.certprofileFactoryRegister = register;
    }

    public void setKeyPairGeneratorFactories(Set<KeypairGeneratorFactory> factories) {
        this.keypairGeneratorFactories = factories == null ? Collections.emptySet() : factories;
    }

    public void setCertPublisherFactoryRegister(CertPublisherFactoryRegister register) {
        this.certPublisherFactoryRegister = register;
    }

    static void auditLogPciEvent(boolean successful, String eventType) {
        PciAuditEvent event = new PciAuditEvent();
        event.setUserId("CA-SYSTEM");
        event.setEventType(eventType);
        event.setAffectedResource("CORE");
        event.setStatus((successful ? AuditStatus.SUCCESSFUL : AuditStatus.FAILED).name());
        event.setLevel(successful ? AuditLevel.INFO : AuditLevel.ERROR);
        Audits.getAuditService().logEvent(event);
    }

    private void shutdownScheduledThreadPoolExecutor() {
        if (this.scheduledThreadPoolExecutor == null) {
            return;
        }
        this.scheduledThreadPoolExecutor.shutdown();
        this.scheduledThreadPoolExecutor = null;
    }

    protected DataSourceMap getDataSourceMap() {
        return new MyDataSourceMap(this.allDataSources);
    }

    public void revokeCertificate(String caName, BigInteger serialNumber, CrlReason reason, Instant invalidityTime) throws CaMgmtException {
        this.ca2Manager.revokeCertificate(caName, serialNumber, reason, invalidityTime);
    }

    public void unsuspendCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        this.ca2Manager.unsuspendCertificate(caName, serialNumber);
    }

    public void removeCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        this.ca2Manager.removeCertificate(caName, serialNumber);
    }

    public X509Cert generateCertificate(String caName, String profileName, byte[] encodedCsr, Instant notBefore, Instant notAfter) throws CaMgmtException {
        return this.ca2Manager.generateCertificate(caName, profileName, encodedCsr, notBefore, notAfter);
    }

    public X509Cert generateCrossCertificate(String caName, String profileName, byte[] encodedCsr, byte[] encodedTargetCert, Instant notBefore, Instant notAfter) throws CaMgmtException {
        return this.ca2Manager.generateCrossCertificate(caName, profileName, encodedCsr, encodedTargetCert, notBefore, notAfter);
    }

    public KeyCertBytesPair generateKeyCert(String caName, String profileName, String subject, Instant notBefore, Instant notAfter) throws CaMgmtException {
        return this.ca2Manager.generateKeyCert(caName, profileName, subject, notBefore, notAfter);
    }

    public X509Ca getX509Ca(String name) throws CaMgmtException {
        return this.ca2Manager.getX509Ca(name);
    }

    public KeypairGenerator getKeypairGenerator(String keypairGenName) {
        KeypairGenEntryWrapper keypairGen = this.keypairGens.get(keypairGenName = Args.toNonBlankLower((String)keypairGenName, (String)"keypairGenName"));
        return keypairGen == null ? null : keypairGen.getGenerator();
    }

    public IdentifiedCertprofile getIdentifiedCertprofile(String profileName) {
        return this.certprofiles.get(Args.toNonBlankLower((String)profileName, (String)"profileName"));
    }

    public List<IdentifiedCertPublisher> getIdentifiedPublishersForCa(String caName) {
        return this.publisherManager.getIdentifiedPublishersForCa(caName);
    }

    public X509Cert generateRootCa(CaEntry caEntry, String profileName, String subject, String serialNumber, Instant notBefore, Instant notAfter) throws CaMgmtException {
        return this.ca2Manager.generateRootCa(caEntry, profileName, subject, serialNumber, notBefore, notAfter, this.certstore);
    }

    void assertMasterMode() throws CaMgmtException {
        if (!this.masterMode) {
            throw new CaMgmtException("operation not allowed in slave mode");
        }
    }

    void assertMasterModeAndSetuped() throws CaMgmtException {
        this.assertMasterMode();
        if (!this.caSystemSetuped) {
            throw new CaMgmtException("CA system is not initialized yet.");
        }
    }

    public void createSigner(SignerEntry entry) throws CaMgmtException {
        this.signerManager.createSigner(entry);
    }

    public IdentifiedCertprofile createCertprofile(CertprofileEntry entry) throws CaMgmtException {
        return this.certprofileManager.createCertprofile(entry);
    }

    public IdentifiedCertPublisher createPublisher(PublisherEntry entry) throws CaMgmtException {
        return this.publisherManager.createPublisher(entry);
    }

    public KeypairGenEntryWrapper createKeypairGenerator(KeypairGenEntry entry) throws CaMgmtException {
        return this.keypairGenManager.createKeypairGen(entry);
    }

    public CaIdNameMap idNameMap() {
        return this.idNameMap;
    }

    public X509CRLHolder generateCrlOnDemand(String caName) throws CaMgmtException {
        return this.ca2Manager.generateCrlOnDemand(caName);
    }

    public X509CRLHolder getCrl(String caName, BigInteger crlNumber) throws CaMgmtException {
        return this.ca2Manager.getCrl(caName, crlNumber);
    }

    public X509CRLHolder getCurrentCrl(String caName) throws CaMgmtException {
        return this.ca2Manager.getCurrentCrl(caName);
    }

    public CertWithRevocationInfo getCert(String caName, BigInteger serialNumber) throws CaMgmtException {
        return this.ca2Manager.getCert(caName, serialNumber);
    }

    public CertWithRevocationInfo getCert(X500Name issuer, BigInteger serialNumber) throws CaMgmtException {
        return this.ca2Manager.getCert(issuer, serialNumber);
    }

    public List<CertListInfo> listCertificates(String caName, X500Name subjectPattern, Instant validFrom, Instant validTo, CertListOrderBy orderBy, int numEntries) throws CaMgmtException {
        return this.ca2Manager.listCertificates(caName, subjectPattern, validFrom, validTo, orderBy, numEntries);
    }

    public void loadConf(byte[] zippedConfBytes) throws CaMgmtException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(zippedConfBytes);){
            this.confLoader.loadConf(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadConfAndClose(InputStream zippedConfStream) throws CaMgmtException {
        this.confLoader.loadConf(zippedConfStream);
    }

    public InputStream exportConf(List<String> caNames) throws CaMgmtException, IOException {
        return this.confLoader.exportConf(caNames);
    }

    public CtLogPublicKeyFinder getCtLogPublicKeyFinder() {
        return this.ctLogPublicKeyFinder;
    }

    public CmLicense getLicense() {
        return this.license;
    }

    public X509Ca getCa(CaIdentifierRequest req) {
        X500NameType issuer = req.getIssuer();
        X500Name x500Issuer = null;
        if (issuer != null) {
            try {
                x500Issuer = issuer.toX500Name();
            }
            catch (IOException e) {
                return null;
            }
        }
        byte[] authorityKeyId = req.getAuthorityKeyIdentifier();
        byte[] issuerCertSha1Fp = req.getIssuerCertSha1Fp();
        if (x500Issuer == null && authorityKeyId == null && issuerCertSha1Fp == null) {
            return null;
        }
        for (Map.Entry<String, X509Ca> entry : this.x509cas.entrySet()) {
            X509Ca ca = entry.getValue();
            if (x500Issuer != null && !x500Issuer.equals((Object)ca.getCaCert().getSubject()) || authorityKeyId != null && !Arrays.equals(ca.getCaCert().getSubjectKeyId(), authorityKeyId) || issuerCertSha1Fp != null && !Hex.encode((byte[])issuerCertSha1Fp).equalsIgnoreCase(ca.getHexSha1OfCert())) continue;
            return ca;
        }
        return null;
    }

    CaMgmtException logAndCreateException(String msg) {
        LOG.error(msg);
        return new CaMgmtException(msg);
    }

    static void checkName(String param, String paramName) throws CaMgmtException {
        try {
            CaConfs.checkName((String)param, (String)paramName);
        }
        catch (InvalidConfException e) {
            throw new CaMgmtException(e.getMessage());
        }
    }

    static {
        LOG.info("XiPKI CA version {}", (Object)StringUtil.getBundleVersion(X509Ca.class));
    }

    private class CaRestarter
    implements Runnable {
        private boolean inProcess;

        private CaRestarter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            try {
                SystemEvent event = CaManagerImpl.this.caConfStore.getSystemEvent(CaManagerImpl.EVENT_CACHANGE);
                long caChangedTime = event == null ? 0L : event.getEventTime();
                LOG.info("check the restart CA system event: changed at={}, lastStartTime={}", (Object)Instant.ofEpochSecond(caChangedTime), (Object)CaManagerImpl.this.lastStartTime);
                if (caChangedTime > CaManagerImpl.this.lastStartTime.getEpochSecond()) {
                    LOG.info("received event to restart CA");
                    CaManagerImpl.this.restartCaSystem();
                } else {
                    LOG.debug("received no event to restart CA");
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"ScheduledCaRestarter");
            }
            finally {
                this.inProcess = false;
            }
        }
    }

    private static class MyDataSourceMap
    implements DataSourceMap {
        private final Map<String, DataSourceWrapper> underlying;

        public MyDataSourceMap(Map<String, DataSourceWrapper> underlying) {
            this.underlying = underlying;
        }

        public DataSourceWrapper getDataSource(String name) {
            if (this.underlying == null) {
                return null;
            }
            if ("ca".equalsIgnoreCase(name) || "caconf".equalsIgnoreCase(name)) {
                return null;
            }
            return this.underlying.get(name.toLowerCase());
        }
    }
}

