/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.math.BigInteger;
import java.security.SecureRandom;

class RandomSerialNumberGenerator {
    private static RandomSerialNumberGenerator instance;
    private final SecureRandom random = new SecureRandom();

    private RandomSerialNumberGenerator() {
    }

    public BigInteger nextSerialNumber(int byteLen) {
        byte[] rndBytes = new byte[byteLen];
        this.random.nextBytes(rndBytes);
        rndBytes[0] = (byte)(rndBytes[0] & 0x7F);
        rndBytes[0] = (byte)(rndBytes[0] | 0x40);
        return new BigInteger(rndBytes);
    }

    public static synchronized RandomSerialNumberGenerator getInstance() {
        if (instance == null) {
            instance = new RandomSerialNumberGenerator();
        }
        return instance;
    }
}

