/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.slf4j.Logger;
import org.xipki.audit.AuditEvent;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertRevInfoWithSerial;
import org.xipki.ca.server.CertStore;
import org.xipki.ca.server.X509CaModule;
import org.xipki.ca.server.X509PublisherModule;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.pki.ErrorCode;
import org.xipki.pki.OperationException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.KeyUsage;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConcurrentBag;
import org.xipki.util.DateUtil;
import org.xipki.util.HourMinute;
import org.xipki.util.LogUtil;

public class X509CrlModule
extends X509CaModule
implements Closeable {
    private final X509Cert caCert;
    private final int shardId;
    private final CertStore certstore;
    private final CaManagerImpl caManager;
    private final AtomicBoolean crlGenInProcess = new AtomicBoolean(false);
    private ScheduledFuture<?> crlGenerationService;
    private final X509PublisherModule publisher;

    public X509CrlModule(CaManagerImpl caManager, CaInfo caInfo, CertStore certstore, X509PublisherModule publisher) throws OperationException {
        super(caInfo);
        X509Cert crlSignerCert;
        this.shardId = caManager.getShardId();
        this.publisher = publisher;
        this.caManager = (CaManagerImpl)Args.notNull((Object)caManager, (String)"caManager");
        this.caCert = caInfo.getCert();
        this.certstore = (CertStore)Args.notNull((Object)certstore, (String)"certstore");
        if (caInfo.getCrlControl() != null && !(crlSignerCert = caInfo.getCrlSignerName() != null ? this.getCrlSigner().getCertificate() : this.caCert).hasKeyusage(KeyUsage.cRLSign)) {
            String msg = "CRL signer does not have keyusage cRLSign";
            this.LOG.error("CRL signer does not have keyusage cRLSign");
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "CRL signer does not have keyusage cRLSign");
        }
        Random random = new Random();
        ScheduledThreadPoolExecutor executor = caManager.getScheduledThreadPoolExecutor();
        this.crlGenerationService = executor.scheduleAtFixedRate(new CrlGenerationService(), 60 + random.nextInt(60), 60L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (this.crlGenerationService != null) {
            this.crlGenerationService.cancel(false);
            this.crlGenerationService = null;
        }
    }

    public X509CRLHolder getCurrentCrl(RequestorInfo requstor) throws OperationException {
        return this.getCrl(requstor, null);
    }

    public X509CRLHolder getCrl(RequestorInfo requestor, BigInteger crlNumber) throws OperationException {
        this.LOG.info("     START getCrl: ca={}, crlNumber={}", (Object)this.caIdent.getName(), (Object)crlNumber);
        boolean successful = false;
        AuditEvent event = this.newAuditEvent(crlNumber == null ? "download_crl" : "download_crl4number", requestor);
        if (crlNumber != null) {
            event.addEventData("crl_number", (Object)crlNumber);
        }
        try {
            byte[] encodedCrl = this.certstore.getEncodedCrl(this.caIdent, crlNumber);
            if (encodedCrl == null) {
                X509CRLHolder x509CRLHolder = null;
                return x509CRLHolder;
            }
            X509CRLHolder crl = X509Util.parseCrl((byte[])encodedCrl);
            successful = true;
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info("SUCCESSFUL getCrl: ca={}, thisUpdate={}", (Object)this.caIdent.getName(), (Object)crl.getThisUpdate());
            }
            X509CRLHolder x509CRLHolder = crl;
            return x509CRLHolder;
        }
        finally {
            if (!successful) {
                this.LOG.info("    FAILED getCrl: ca={}", (Object)this.caIdent.getName());
            }
            this.finish(event, successful);
        }
    }

    public CertificateList getBcCurrentCrl(RequestorInfo requestor) throws OperationException {
        return this.getBcCrl(requestor, null);
    }

    public CertificateList getBcCrl(RequestorInfo requestor, BigInteger crlNumber) throws OperationException {
        this.LOG.info("     START getCrl: ca={}, crlNumber={}", (Object)this.caIdent.getName(), (Object)crlNumber);
        boolean successful = false;
        AuditEvent event0 = this.newAuditEvent(crlNumber == null ? "download_crl" : "download_crl4number", requestor);
        if (crlNumber != null) {
            event0.addEventData("crl_number", (Object)crlNumber);
        }
        try {
            byte[] encodedCrl = this.certstore.getEncodedCrl(this.caIdent, crlNumber);
            if (encodedCrl == null) {
                CertificateList certificateList = null;
                return certificateList;
            }
            CertificateList crl = CertificateList.getInstance((Object)encodedCrl);
            successful = true;
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info("SUCCESSFUL getCrl: ca={}, thisUpdate={}", (Object)this.caIdent.getName(), (Object)crl.getThisUpdate().getTime());
            }
            CertificateList certificateList = crl;
            return certificateList;
        }
        finally {
            if (!successful) {
                this.LOG.info("    FAILED getCrl: ca={}", (Object)this.caIdent.getName());
            }
            this.finish(event0, successful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupCrlsWithoutException() {
        try {
            int numCrls = this.caInfo.getNumCrls();
            this.LOG.info("     START cleanupCrls: ca={}, numCrls={}", (Object)this.caIdent.getName(), (Object)numCrls);
            AuditEvent event0 = this.newAuditEvent("cleanup_crl", null);
            boolean succ = false;
            try {
                int num = numCrls <= 0 ? 0 : this.certstore.cleanupCrls(this.caIdent, this.caInfo.getNumCrls());
                succ = true;
                event0.addEventData("num", (Object)num);
                this.LOG.info("SUCCESSFUL cleanupCrls: ca={}, num={}", (Object)this.caIdent.getName(), (Object)num);
            }
            finally {
                if (!succ) {
                    this.LOG.info("    FAILED cleanupCrls: ca={}", (Object)this.caIdent.getName());
                }
                this.finish(event0, succ);
            }
        }
        catch (Throwable th) {
            this.LOG.warn("could not cleanup CRLs.{}: {}", (Object)th.getClass().getName(), (Object)th.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CRLHolder generateCrlOnDemand(RequestorInfo requestor) throws OperationException {
        CrlControl control = Optional.ofNullable(this.caInfo.getCrlControl()).orElseThrow(() -> new OperationException(ErrorCode.NOT_PERMITTED, "CA could not generate CRL"));
        if (this.crlGenInProcess.get()) {
            throw new OperationException(ErrorCode.SYSTEM_UNAVAILABLE, "TRY_LATER");
        }
        this.crlGenInProcess.set(true);
        try {
            Instant thisUpdate = Instant.now();
            Instant nearestScheduledIssueTime = this.getScheduledCrlGenTimeNotAfter(thisUpdate);
            int intervals = !control.isExtendedNextUpdate() && control.getDeltaCrlIntervals() > 0 ? control.getDeltaCrlIntervals() : control.getFullCrlIntervals();
            Instant nextUpdate = nearestScheduledIssueTime.plus((long)intervals * (long)control.getIntervalHours(), ChronoUnit.HOURS);
            nextUpdate = control.getOverlap().add(nextUpdate);
            X509CRLHolder x509CRLHolder = this.generateCrl(false, requestor, false, thisUpdate, nextUpdate);
            return x509CRLHolder;
        }
        finally {
            this.crlGenInProcess.set(false);
        }
    }

    private void scheduledGenerateCrl(boolean deltaCrl, Instant thisUpdate, Instant nextUpdate) throws OperationException {
        AuditEvent event = this.newAuditEvent("gen_crl", null);
        try {
            this.generateCrl0(true, deltaCrl, thisUpdate, nextUpdate, event);
            this.finish(event, true);
        }
        catch (OperationException ex) {
            this.finish(event, false);
            throw ex;
        }
    }

    private X509CRLHolder generateCrl(boolean scheduled, RequestorInfo requestor, boolean deltaCrl, Instant thisUpdate, Instant nextUpdate) throws OperationException {
        AuditEvent event = this.newAuditEvent("gen_crl", requestor);
        try {
            X509CRLHolder ret = this.generateCrl0(scheduled, deltaCrl, thisUpdate, nextUpdate, event);
            this.finish(event, true);
            return ret;
        }
        catch (OperationException ex) {
            this.finish(event, false);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CRLHolder generateCrl0(boolean scheduled, boolean deltaCrl, Instant thisUpdate, Instant nextUpdate, AuditEvent event) throws OperationException {
        CrlControl control = Optional.ofNullable(this.caInfo.getCrlControl()).orElseThrow(() -> new OperationException(ErrorCode.NOT_PERMITTED, "CRL generation is not allowed"));
        BigInteger baseCrlNumber = null;
        if (deltaCrl) {
            baseCrlNumber = Optional.ofNullable(this.caInfo.getMaxFullCrlNumber()).orElseThrow(() -> new OperationException(ErrorCode.SYSTEM_FAILURE, "Should not happen. No FullCRL is available while generating DeltaCRL"));
        }
        this.LOG.info("     START generateCrl: ca={}, deltaCRL={}, thisUpdate={}, nextUpdate={}, baseCRLNumber={}", new Object[]{this.caIdent.getName(), deltaCrl, thisUpdate, nextUpdate, deltaCrl ? baseCrlNumber : "-"});
        event.addEventData("crl_type", (Object)(deltaCrl ? "DELTA_CRL" : "FULL_CRL"));
        if (nextUpdate == null) {
            event.addEventData("next_update", (Object)"null");
        } else {
            event.addEventData("next_update", (Object)DateUtil.toUtcTimeyyyyMMddhhmmss((Instant)nextUpdate));
            if (nextUpdate.getEpochSecond() - thisUpdate.getEpochSecond() < 600L) {
                throw new OperationException(ErrorCode.CRL_FAILURE, "nextUpdate and thisUpdate are too close");
            }
        }
        boolean successful = false;
        try {
            long lastIssueTimeOfFullCrl;
            X509CRLHolder crl;
            ConcurrentBag.BagEntry bagEntry;
            SignerEntry crlSigner = this.getCrlSigner();
            PublicCaInfo pci = this.caInfo.getPublicCaInfo();
            boolean indirectCrl = crlSigner != null;
            X500Name crlIssuer = indirectCrl ? crlSigner.getCertificate().getSubject() : pci.getSubject();
            X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(crlIssuer, Date.from(thisUpdate));
            if (nextUpdate != null) {
                crlBuilder.setNextUpdate(Date.from(nextUpdate));
            }
            int numEntries = 100;
            CrlControl crlControl = this.caInfo.getCrlControl();
            boolean withExpiredCerts = crlControl.isIncludeExpiredcerts();
            Instant notExpiredAt = withExpiredCerts ? Instant.ofEpochSecond(0L) : thisUpdate.minus(600L, ChronoUnit.SECONDS);
            List<Object> allRevInfos = new LinkedList();
            if (deltaCrl) {
                allRevInfos = this.certstore.getCertsForDeltaCrl(this.caIdent, baseCrlNumber, notExpiredAt);
            } else {
                List<CertRevInfoWithSerial> list;
                long startId = 1L;
                do {
                    list = this.certstore.getRevokedCerts(this.caIdent, notExpiredAt, startId, 100);
                    allRevInfos.addAll(list);
                    long maxId = 1L;
                    for (CertRevInfoWithSerial revInfo : list) {
                        if (revInfo.getId() <= maxId) continue;
                        maxId = revInfo.getId();
                    }
                    startId = maxId + 1L;
                } while (list.size() >= 100);
                list.clear();
            }
            if (indirectCrl && allRevInfos.isEmpty()) {
                Extensions extensions = new Extensions(X509CrlModule.createCertificateIssuerExtension(pci.getSubject()));
                crlBuilder.addCRLEntry(BigInteger.ZERO, new Date(0L), extensions);
                this.LOG.debug("added cert ca={} serial=0 to the indirect CRL", (Object)this.caIdent);
            } else {
                Collections.sort(allRevInfos);
                boolean isFirstCrlEntry = true;
                for (CertRevInfoWithSerial certRevInfoWithSerial : allRevInfos) {
                    Extension ext;
                    CrlReason reason = certRevInfoWithSerial.getReason();
                    if (crlControl.isExcludeReason() && reason != CrlReason.REMOVE_FROM_CRL) {
                        reason = CrlReason.UNSPECIFIED;
                    }
                    Instant revocationTime = certRevInfoWithSerial.getRevocationTime();
                    Instant invalidityTime = certRevInfoWithSerial.getInvalidityTime();
                    switch (crlControl.getInvalidityDateMode()) {
                        case forbidden: {
                            invalidityTime = null;
                            break;
                        }
                        case optional: {
                            break;
                        }
                        case required: {
                            if (invalidityTime != null) break;
                            invalidityTime = revocationTime;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown TripleState " + crlControl.getInvalidityDateMode());
                        }
                    }
                    BigInteger serial = certRevInfoWithSerial.getSerial();
                    this.LOG.debug("added cert ca={} serial={} to CRL", (Object)this.caIdent, (Object)serial);
                    if (!indirectCrl || !isFirstCrlEntry) {
                        if (invalidityTime != null) {
                            crlBuilder.addCRLEntry(serial, Date.from(revocationTime), reason.getCode(), Date.from(invalidityTime));
                            continue;
                        }
                        crlBuilder.addCRLEntry(serial, Date.from(revocationTime), reason.getCode());
                        continue;
                    }
                    ArrayList<Extension> extensions = new ArrayList<Extension>(3);
                    if (reason != CrlReason.UNSPECIFIED) {
                        ext = X509CrlModule.createReasonExtension(reason.getCode());
                        extensions.add(ext);
                    }
                    if (invalidityTime != null) {
                        ext = X509CrlModule.createInvalidityDateExtension(invalidityTime);
                        extensions.add(ext);
                    }
                    ext = X509CrlModule.createCertificateIssuerExtension(pci.getSubject());
                    extensions.add(ext);
                    crlBuilder.addCRLEntry(serial, Date.from(revocationTime), new Extensions(extensions.toArray(new Extension[0])));
                    isFirstCrlEntry = false;
                }
                allRevInfos.clear();
            }
            BigInteger crlNumber = this.caInfo.nextCrlNumber();
            event.addEventData("crl_number", (Object)crlNumber);
            if (baseCrlNumber != null) {
                event.addEventData("basecrl_number", (Object)baseCrlNumber);
            }
            try {
                byte[] akiValues = indirectCrl ? crlSigner.getCertificate().getSubjectKeyId() : pci.getSubjectKeyIdentifer();
                AuthorityKeyIdentifier authorityKeyIdentifier = new AuthorityKeyIdentifier(akiValues);
                crlBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)authorityKeyIdentifier);
                crlBuilder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new ASN1Integer(crlNumber));
                if (indirectCrl) {
                    IssuingDistributionPoint idp = new IssuingDistributionPoint(null, false, false, null, true, false);
                    crlBuilder.addExtension(Extension.issuingDistributionPoint, true, (ASN1Encodable)idp);
                }
                if (deltaCrl) {
                    crlBuilder.addExtension(Extension.deltaCRLIndicator, true, (ASN1Encodable)new ASN1Integer(baseCrlNumber));
                }
                List deltaCrlUris = pci.getCaUris().getDeltaCrlUris();
                if (control.getDeltaCrlIntervals() > 0 && CollectionUtil.isNotEmpty((Collection)deltaCrlUris)) {
                    CRLDistPoint cdp = CaUtil.createCrlDistributionPoints(deltaCrlUris, pci.getSubject(), crlIssuer);
                    crlBuilder.addExtension(Extension.freshestCRL, false, (ASN1Encodable)cdp);
                }
                if (withExpiredCerts) {
                    DERGeneralizedTime statusSince = new DERGeneralizedTime(Date.from(this.caCert.getNotBefore()));
                    crlBuilder.addExtension(Extension.expiredCertsOnCRL, false, (ASN1Encodable)statusSince);
                }
            }
            catch (CertIOException ex) {
                LogUtil.error((Logger)this.LOG, (Throwable)ex, (String)"crlBuilder.addExtension");
                throw new OperationException(ErrorCode.INVALID_EXTENSION, (Throwable)ex);
            }
            ConcurrentContentSigner concurrentSigner = crlSigner == null ? this.caInfo.getSigner(null) : crlSigner.signer();
            try {
                bagEntry = concurrentSigner.borrowSigner();
            }
            catch (NoIdleSignerException ex) {
                throw new OperationException(ErrorCode.SYSTEM_FAILURE, "NoIdleSignerException: " + ex.getMessage());
            }
            try {
                crl = crlBuilder.build((ContentSigner)bagEntry.value());
            }
            finally {
                concurrentSigner.requiteSigner(bagEntry);
            }
            if (scheduled && (lastIssueTimeOfFullCrl = this.certstore.getThisUpdateOfCurrentCrl(this.caIdent, deltaCrl)) > thisUpdate.getEpochSecond() - 10L) {
                successful = true;
                this.LOG.info("IGNORE generateCrl: ca={}", (Object)this.caIdent.getName());
                X509CRLHolder x509CRLHolder = null;
                return x509CRLHolder;
            }
            this.caInfo.setNextCrlNumber(crlNumber.longValue() + 1L);
            this.caManager.commitNextCrlNo(this.caIdent, this.caInfo.getNextCrlNumber());
            this.publisher.publishCrl(crl);
            successful = true;
            this.LOG.info("SUCCESSFUL generateCrl: ca={}, crlNumber={}, thisUpdate={}", new Object[]{this.caIdent.getName(), crlNumber, crl.getThisUpdate()});
            if (!deltaCrl) {
                this.cleanupCrlsWithoutException();
            }
            X509CRLHolder x509CRLHolder = crl;
            return x509CRLHolder;
        }
        finally {
            if (!successful) {
                this.LOG.info("    FAILED generateCrl: ca={}", (Object)this.caIdent.getName());
            }
        }
    }

    private Instant getScheduledCrlGenTimeNotAfter(Instant date) {
        ZonedDateTime cal = ZonedDateTime.ofInstant(date, ZoneOffset.UTC);
        int minutesInDay = cal.getHour() * 60 + cal.getMinute();
        int intervalMinutes = this.caInfo.getCrlControl().getIntervalHours() * 60;
        HourMinute hm = this.caInfo.getCrlControl().getIntervalDayTime();
        int hmInMinutes = hm.getHour() * 60 + hm.getMinute();
        Instant midNight = ZonedDateTime.of(cal.getYear(), cal.getMonthValue(), cal.getDayOfMonth(), 0, 0, 0, 0, cal.getZone()).toInstant();
        if (minutesInDay == hmInMinutes) {
            return midNight.plus((long)hmInMinutes, ChronoUnit.MINUTES);
        }
        if (minutesInDay < hmInMinutes) {
            return midNight.plus((long)(hmInMinutes - intervalMinutes), ChronoUnit.MINUTES);
        }
        int i = 0;
        while (minutesInDay >= hmInMinutes + (i + 1) * intervalMinutes) {
            ++i;
        }
        return midNight.plus((long)hmInMinutes + (long)i * (long)intervalMinutes, ChronoUnit.MINUTES);
    }

    SignerEntry getCrlSigner() {
        if (this.caInfo.getCrlControl() == null) {
            return null;
        }
        String crlSignerName = this.caInfo.getCrlSignerName();
        return crlSignerName == null ? null : this.caManager.getSignerWrapper(crlSignerName);
    }

    boolean healthy() {
        SignerEntry signer = this.getCrlSigner();
        if (signer != null) {
            return signer.signerIsHealthy();
        }
        return true;
    }

    private static Extension createReasonExtension(int reasonCode) {
        CRLReason crlReason = CRLReason.lookup((int)reasonCode);
        try {
            return new Extension(Extension.reasonCode, false, crlReason.getEncoded());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error encoding reason: " + ex.getMessage(), ex);
        }
    }

    private static Extension createInvalidityDateExtension(Instant invalidityDate) {
        try {
            ASN1GeneralizedTime asnTime = new ASN1GeneralizedTime(Date.from(invalidityDate));
            return new Extension(Extension.invalidityDate, false, asnTime.getEncoded());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error encoding reason: " + ex.getMessage(), ex);
        }
    }

    private static Extension createCertificateIssuerExtension(X500Name certificateIssuer) {
        try {
            GeneralNames generalNames = new GeneralNames(new GeneralName(certificateIssuer));
            return new Extension(Extension.certificateIssuer, true, generalNames.getEncoded());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error encoding reason: " + ex.getMessage(), ex);
        }
    }

    private class CrlGenerationService
    implements Runnable {
        private CrlGenerationService() {
        }

        @Override
        public void run() {
            CrlControl crlControl = X509CrlModule.this.caInfo.getCrlControl();
            if (crlControl == null) {
                return;
            }
            if (X509CrlModule.this.crlGenInProcess.get()) {
                return;
            }
            X509CrlModule.this.crlGenInProcess.set(true);
            try {
                this.run0();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)X509CrlModule.this.LOG, (Throwable)th);
            }
            finally {
                X509CrlModule.this.crlGenInProcess.set(false);
            }
        }

        private void run0() throws OperationException {
            long lastIssueTimeOfDeltaCrl;
            long lastIssueTime;
            Instant nearestScheduledCrlIssueTime;
            Instant nextScheduledCrlIssueTime;
            boolean createFullCrlNow;
            CrlControl control = X509CrlModule.this.caInfo.getCrlControl();
            long lastIssueTimeOfFullCrl = X509CrlModule.this.certstore.getThisUpdateOfCurrentCrl(X509CrlModule.this.caIdent, false);
            Instant now = Instant.now();
            if (lastIssueTimeOfFullCrl == 0L) {
                createFullCrlNow = true;
            } else {
                Instant nearestScheduledCrlIssueTime2 = X509CrlModule.this.getScheduledCrlGenTimeNotAfter(Instant.ofEpochSecond(lastIssueTimeOfFullCrl));
                Instant nextScheduledCrlIssueTime2 = nearestScheduledCrlIssueTime2.plus((long)control.getFullCrlIntervals() * (long)control.getIntervalHours(), ChronoUnit.HOURS);
                createFullCrlNow = nextScheduledCrlIssueTime2.isBefore(now);
                if (createFullCrlNow && Duration.between(nextScheduledCrlIssueTime2, now).getSeconds() < (long)X509CrlModule.this.shardId * 10L) {
                    createFullCrlNow = false;
                }
            }
            boolean createDeltaCrlNow = false;
            if (control.getDeltaCrlIntervals() > 0 && !createFullCrlNow && (createDeltaCrlNow = (nextScheduledCrlIssueTime = (nearestScheduledCrlIssueTime = X509CrlModule.this.getScheduledCrlGenTimeNotAfter(Instant.ofEpochSecond(lastIssueTime = Math.max(lastIssueTimeOfDeltaCrl = X509CrlModule.this.certstore.getThisUpdateOfCurrentCrl(X509CrlModule.this.caIdent, true), lastIssueTimeOfFullCrl)))).plus((long)control.getDeltaCrlIntervals() * (long)control.getIntervalHours(), ChronoUnit.HOURS)).isBefore(now)) && Duration.between(nextScheduledCrlIssueTime, now).getSeconds() < (long)X509CrlModule.this.shardId * 10L) {
                createDeltaCrlNow = false;
            }
            if (!createFullCrlNow && !createDeltaCrlNow) {
                X509CrlModule.this.LOG.debug("No CRL is needed to be created");
                return;
            }
            int intervals = createDeltaCrlNow ? control.getDeltaCrlIntervals() : (!control.isExtendedNextUpdate() && control.getDeltaCrlIntervals() > 0 ? control.getDeltaCrlIntervals() : control.getFullCrlIntervals());
            Instant scheduledCrlGenTime = X509CrlModule.this.getScheduledCrlGenTimeNotAfter(now);
            Instant nextUpdate = scheduledCrlGenTime.plus((long)intervals * (long)control.getIntervalHours(), ChronoUnit.HOURS);
            nextUpdate = control.getOverlap().add(nextUpdate);
            try {
                X509CrlModule.this.scheduledGenerateCrl(createDeltaCrlNow, now, nextUpdate);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)X509CrlModule.this.LOG, (Throwable)th);
            }
        }
    }
}

