/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.sdk.ErrorResponse;
import org.xipki.ca.sdk.SdkResponse;
import org.xipki.ca.server.SdkResponder;
import org.xipki.pki.ErrorCode;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.exception.EncodeException;
import org.xipki.util.http.HttpResponse;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

class HttpRaServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRaServlet.class);
    private final boolean logReqResp;
    private final SdkResponder responder;

    public HttpRaServlet(boolean logReqResp, SdkResponder responder) {
        this.logReqResp = logReqResp;
        this.responder = (SdkResponder)Args.notNull((Object)responder, (String)"responder");
    }

    public void service(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        String method = req.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            this.service0(req, false).fillResponse(resp);
        } else if ("POST".equalsIgnoreCase(method)) {
            this.service0(req, true).fillResponse(resp);
        } else {
            resp.setStatus(405);
        }
    }

    private HttpResponse service0(XiHttpRequest req, boolean post) throws IOException {
        try {
            String path = (String)req.getAttribute("xipki_path");
            byte[] requestBytes = post ? IoUtil.readAllBytesAndClose((InputStream)req.getInputStream()) : null;
            SdkResponse response = this.responder.service(path, requestBytes, req);
            byte[] respBody = response == null ? null : response.encode();
            int httpStatus = 200;
            if (response instanceof ErrorResponse) {
                ErrorCode errCode = ((ErrorResponse)response).getCode();
                switch (errCode) {
                    case UNAUTHORIZED: 
                    case NOT_PERMITTED: {
                        httpStatus = 401;
                        break;
                    }
                    case BAD_CERT_TEMPLATE: 
                    case BAD_POP: 
                    case BAD_REQUEST: 
                    case INVALID_EXTENSION: 
                    case UNKNOWN_CERT_PROFILE: 
                    case UNKNOWN_CERT: 
                    case ALREADY_ISSUED: 
                    case CERT_REVOKED: 
                    case CERT_UNREVOKED: {
                        httpStatus = 400;
                        break;
                    }
                    case PATH_NOT_FOUND: {
                        httpStatus = 404;
                        break;
                    }
                    default: {
                        httpStatus = 500;
                    }
                }
            }
            if (this.logReqResp && LOG.isDebugEnabled()) {
                String respBodyStr = respBody == null ? null : Base64.encodeToString((byte[])respBody, (boolean)true);
                LOG.debug("HTTP RA path: {}\nResponse:\n{}", (Object)req.getRequestURI(), (Object)respBodyStr);
            }
            return new HttpResponse(httpStatus, "application/cbor", null, respBody);
        }
        catch (EncodeException ex) {
            LOG.error("Error encoding SdkResponse", (Throwable)ex);
            return new HttpResponse(500);
        }
        catch (RuntimeException ex) {
            LOG.error("RuntimeException thrown, this should not happen!", (Throwable)ex);
            return new HttpResponse(500);
        }
    }
}

