/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.math.BigInteger;
import java.time.Instant;
import org.xipki.security.CrlReason;
import org.xipki.util.Args;

public class CertRevInfoWithSerial
implements Comparable<CertRevInfoWithSerial> {
    private final long id;
    private final BigInteger serial;
    private final CrlReason reason;
    private Instant revocationTime;
    private final Instant invalidityTime;

    public CertRevInfoWithSerial(long id, BigInteger serial, CrlReason reason, Instant revocationTime, Instant invalidityTime) {
        this.reason = (CrlReason)Args.notNull((Object)reason, (String)"reason");
        this.revocationTime = (Instant)Args.notNull((Object)revocationTime, (String)"revocationTime");
        this.invalidityTime = invalidityTime;
        this.id = id;
        this.serial = (BigInteger)Args.notNull((Object)serial, (String)"serial");
    }

    public CertRevInfoWithSerial(long id, BigInteger serial, int reasonCode, Instant revocationTime, Instant invalidityTime) {
        this(id, serial, CrlReason.forReasonCode((int)reasonCode), revocationTime, invalidityTime);
    }

    public BigInteger getSerial() {
        return this.serial;
    }

    public long getId() {
        return this.id;
    }

    public CrlReason getReason() {
        return this.reason;
    }

    public Instant getRevocationTime() {
        if (this.revocationTime == null) {
            this.revocationTime = Instant.now();
        }
        return this.revocationTime;
    }

    public Instant getInvalidityTime() {
        return this.invalidityTime;
    }

    @Override
    public int compareTo(CertRevInfoWithSerial other) {
        return this.serial.compareTo(other.serial);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CertRevInfoWithSerial)) {
            return false;
        }
        CertRevInfoWithSerial o = (CertRevInfoWithSerial)obj;
        return this.id == o.id && this.serial.equals(o.serial);
    }

    public int hashCode() {
        return this.serial.intValue() + 37 * (int)this.id;
    }
}

