/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.kpgen;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECPoint;
import java.util.Locale;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.xipki.ca.api.kpgen.KeypairGenerator;
import org.xipki.security.EdECConstants;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.DSAParameterCache;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.ConfPairs;

public class SoftwareKeypairGenerator
extends KeypairGenerator {
    private final SecureRandom random;

    public SoftwareKeypairGenerator(SecureRandom random) {
        this.random = random == null ? new SecureRandom() : random;
    }

    public void initialize0(ConfPairs conf) {
    }

    public PrivateKeyInfo generateKeypair(String keyspec) throws XiSecurityException {
        if (!this.supports(keyspec)) {
            throw new XiSecurityException(this.name + " cannot generate keypair of keyspec " + keyspec);
        }
        try {
            return this.generateKeypair0(keyspec);
        }
        catch (XiSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XiSecurityException((Throwable)ex);
        }
    }

    private PrivateKeyInfo generateKeypair0(String keyspec) throws Exception {
        String type;
        String[] tokens = keyspec.split("/");
        switch (type = tokens[0].toUpperCase(Locale.ROOT)) {
            case "RSA": {
                int keysize = Integer.parseInt(tokens[1]);
                if (keysize > 4096) {
                    throw new XiSecurityException("keysize too large");
                }
                KeyPair kp = KeyUtil.generateRSAKeypair((int)keysize, (BigInteger)this.rsaE, (SecureRandom)this.random);
                return KeyUtil.toPrivateKeyInfo((RSAPrivateCrtKey)((RSAPrivateCrtKey)kp.getPrivate()));
            }
            case "EC": {
                ASN1ObjectIdentifier curveOid = new ASN1ObjectIdentifier(tokens[1]);
                KeyPair kp = KeyUtil.generateECKeypair((ASN1ObjectIdentifier)curveOid, (SecureRandom)this.random);
                ECPublicKey pub = (ECPublicKey)kp.getPublic();
                int fieldBitLength = pub.getParams().getCurve().getField().getFieldSize();
                byte[] publicKey = KeyUtil.getUncompressedEncodedECPoint((ECPoint)pub.getW(), (int)fieldBitLength);
                int orderBitLength = pub.getParams().getOrder().bitLength();
                java.security.interfaces.ECPrivateKey priv = (java.security.interfaces.ECPrivateKey)kp.getPrivate();
                return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveOid), (ASN1Encodable)new ECPrivateKey(orderBitLength, priv.getS(), (ASN1BitString)new DERBitString(publicKey), null));
            }
            case "DSA": {
                int pLength = Integer.parseInt(tokens[1]);
                int qLength = Integer.parseInt(tokens[2]);
                DSAParameterSpec spec = DSAParameterCache.getDSAParameterSpec((int)pLength, (int)qLength, null);
                KeyPair kp = KeyUtil.generateDSAKeypair((DSAParameterSpec)spec, (SecureRandom)this.random);
                DSAParameter parameter = new DSAParameter(spec.getP(), spec.getQ(), spec.getG());
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)parameter);
                byte[] publicKey = new ASN1Integer(((DSAPublicKey)kp.getPublic()).getY()).getEncoded();
                DSAPrivateKey priv = (DSAPrivateKey)kp.getPrivate();
                return new PrivateKeyInfo(algId, (ASN1Encodable)new ASN1Integer(priv.getX()), null, publicKey);
            }
            case "ED25519": 
            case "ED448": 
            case "X25519": 
            case "X448": {
                ASN1ObjectIdentifier curveId = EdECConstants.getCurveOid((String)keyspec);
                KeyPair kp = KeyUtil.generateEdECKeypair((ASN1ObjectIdentifier)curveId, (SecureRandom)this.random);
                return PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
            }
        }
        throw new IllegalArgumentException("unknown keyspec " + keyspec);
    }

    public boolean isHealthy() {
        return true;
    }

    public void close() throws IOException {
    }
}

