/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.mgmt.CaJson;
import org.xipki.ca.api.mgmt.CaManager;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaProfileEntry;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.MgmtAction;
import org.xipki.ca.api.mgmt.MgmtRequest;
import org.xipki.ca.api.mgmt.MgmtResponse;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.security.KeyCertBytesPair;
import org.xipki.security.X509Cert;
import org.xipki.security.util.TlsHelper;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.http.HttpResponse;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

class CaHttpMgmtServlet {
    private static final Logger LOG = LoggerFactory.getLogger(CaHttpMgmtServlet.class);
    private static final String CT_RESPONSE = "application/json";
    private final Set<X509Cert> mgmtCerts;
    private final CaManager caManager;
    private final String reverseProxyMode;

    public CaHttpMgmtServlet(CaManager caManager, String reverseProxyMode, Collection<X509Cert> mgmtCerts) {
        this.caManager = (CaManager)Args.notNull((Object)caManager, (String)"caManager");
        this.reverseProxyMode = reverseProxyMode;
        this.mgmtCerts = new HashSet<X509Cert>(Args.notEmpty(mgmtCerts, (String)"mgmtCerts"));
    }

    public void service(XiHttpRequest request, XiHttpResponse response) throws IOException {
        String method = request.getMethod();
        if (!"POST".equalsIgnoreCase(method)) {
            response.setStatus(405);
        }
        try {
            X509Cert clientCert = Optional.ofNullable(TlsHelper.getTlsClientCert((XiHttpRequest)request, (String)this.reverseProxyMode)).orElseThrow(() -> new MyException(401, "remote management is not permitted if TLS client certificate is not present"));
            if (!this.mgmtCerts.contains(clientCert)) {
                throw new MyException(401, "remote management is not permitted to the client without valid certificate");
            }
            String path = (String)request.getAttribute("xipki_path");
            if (path == null || path.length() < 2) {
                throw new MyException(404, "no action is specified");
            }
            String actionStr = path.substring(1);
            MgmtAction action = Optional.ofNullable(MgmtAction.ofName((String)actionStr)).orElseThrow(() -> new MyException(404, "unknown action '" + actionStr + "'"));
            MgmtResponse.StringSet resp = null;
            InputStream requestStream = request.getInputStream();
            switch (action) {
                case addCa: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddCa.class);
                    this.caManager.addCa(req.getCaEntry());
                    break;
                }
                case addCaAlias: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddCaAlias.class);
                    this.caManager.addCaAlias(req.getAliasName(), req.getCaName());
                    break;
                }
                case addCertprofile: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddCertprofile.class);
                    this.caManager.addCertprofile(req.getCertprofileEntry());
                    break;
                }
                case addCertprofileToCa: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddCertprofileToCa.class);
                    this.caManager.addCertprofileToCa(req.getProfileName(), req.getCaName());
                    break;
                }
                case addPublisher: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddPublisher.class);
                    this.caManager.addPublisher(req.getPublisherEntry());
                    break;
                }
                case addPublisherToCa: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddPublisherToCa.class);
                    this.caManager.addPublisherToCa(req.getPublisherName(), req.getCaName());
                    break;
                }
                case addRequestor: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddRequestor.class);
                    this.caManager.addRequestor(req.getRequestorEntry());
                    break;
                }
                case addRequestorToCa: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddRequestorToCa.class);
                    this.caManager.addRequestorToCa(req.getRequestor(), req.getCaName());
                    break;
                }
                case addSigner: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddSigner.class);
                    this.caManager.addSigner(req.getSignerEntry());
                    break;
                }
                case changeCa: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.ChangeCa.class);
                    this.caManager.changeCa(req.getChangeCaEntry());
                    break;
                }
                case changeCertprofile: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.ChangeTypeConfEntity.class);
                    this.caManager.changeCertprofile(req.getName(), req.getType(), req.getConf());
                    break;
                }
                case changePublisher: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.ChangeTypeConfEntity.class);
                    this.caManager.changePublisher(req.getName(), req.getType(), req.getConf());
                    break;
                }
                case changeRequestor: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.ChangeTypeConfEntity.class);
                    this.caManager.changeRequestor(req.getName(), req.getType(), req.getConf());
                    break;
                }
                case changeSigner: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.ChangeSigner.class);
                    this.caManager.changeSigner(req.getName(), req.getType(), req.getConf(), req.getBase64Cert());
                    break;
                }
                case exportConf: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.ExportConf.class);
                    InputStream confStream = this.caManager.exportConf(req.getCaNames());
                    resp = new MgmtResponse.ByteArray(IoUtil.readAllBytesAndClose((InputStream)confStream));
                    break;
                }
                case generateCertificate: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.GenerateCert.class);
                    X509Cert cert = this.caManager.generateCertificate(req.getCaName(), req.getProfileName(), req.getEncodedCsr(), req.getNotBefore(), req.getNotAfter());
                    resp = CaHttpMgmtServlet.toByteArray(cert);
                    break;
                }
                case generateCrossCertificate: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.GenerateCrossCertificate.class);
                    X509Cert cert = this.caManager.generateCrossCertificate(req.getCaName(), req.getProfileName(), req.getEncodedCsr(), req.getEncodedTargetCert(), req.getNotBefore(), req.getNotAfter());
                    resp = CaHttpMgmtServlet.toByteArray(cert);
                    break;
                }
                case generateKeyCert: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.GenerateKeyCert.class);
                    KeyCertBytesPair keyCertBytesPair = this.caManager.generateKeyCert(req.getCaName(), req.getProfileName(), req.getSubject(), req.getNotBefore(), req.getNotAfter());
                    resp = new MgmtResponse.KeyCertBytes(keyCertBytesPair.getKey(), keyCertBytesPair.getCert());
                    break;
                }
                case generateCrlOnDemand: {
                    resp = CaHttpMgmtServlet.toByteArray(action, this.caManager.generateCrlOnDemand(CaHttpMgmtServlet.getNameFromRequest(requestStream)));
                    break;
                }
                case generateRootCa: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.GenerateRootCa.class);
                    X509Cert cert = this.caManager.generateRootCa(req.getCaEntry(), req.getCertprofileName(), req.getSubject(), req.getSerialNumber(), req.getNotBefore(), req.getNotAfter());
                    resp = CaHttpMgmtServlet.toByteArray(cert);
                    break;
                }
                case getAliasesForCa: {
                    resp = new MgmtResponse.StringSet(this.caManager.getAliasesForCa(CaHttpMgmtServlet.getNameFromRequest(requestStream)));
                    break;
                }
                case getCa: {
                    String name = CaHttpMgmtServlet.getNameFromRequest(requestStream);
                    CaEntry caEntry = Optional.ofNullable(this.caManager.getCa(name)).orElseThrow(() -> new CaMgmtException("Unknown CA " + name));
                    resp = new MgmtResponse.GetCa(caEntry);
                    break;
                }
                case getCaCerts: {
                    String name = CaHttpMgmtServlet.getNameFromRequest(requestStream);
                    List caCerts = Optional.ofNullable(this.caManager.getCaCerts(name)).orElseThrow(() -> new CaMgmtException("Unknown CA " + name));
                    resp = new MgmtResponse.StringResponse(X509Util.encodeCertificates((X509Cert[])caCerts.toArray(new X509Cert[0])));
                    break;
                }
                case getCaAliasNames: {
                    resp = new MgmtResponse.StringSet(this.caManager.getCaAliasNames());
                    break;
                }
                case getCaNameForAlias: {
                    String aliasName = CaHttpMgmtServlet.getNameFromRequest(requestStream);
                    resp = new MgmtResponse.StringResponse(this.caManager.getCaNameForAlias(aliasName));
                    break;
                }
                case getCaNames: {
                    resp = new MgmtResponse.StringSet(this.caManager.getCaNames());
                    break;
                }
                case getCaSystemStatus: {
                    resp = new MgmtResponse.GetCaSystemStatus(this.caManager.getCaSystemStatus());
                    break;
                }
                case getCert: {
                    CertWithRevocationInfo cert;
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.GetCert.class);
                    if (req.getCaName() != null) {
                        cert = this.caManager.getCert(req.getCaName(), req.getSerialNumber());
                    } else {
                        X500Name issuer = X500Name.getInstance((Object)req.getEncodedIssuerDn());
                        cert = this.caManager.getCert(issuer, req.getSerialNumber());
                    }
                    if (cert != null) {
                        resp = new MgmtResponse.GetCert(new MgmtResponse.CertWithRevocationInfoWrapper(cert));
                        break;
                    }
                    resp = new MgmtResponse.GetCert(null);
                    break;
                }
                case getCertprofile: {
                    String name = CaHttpMgmtServlet.getNameFromRequest(requestStream);
                    CertprofileEntry result = Optional.ofNullable(this.caManager.getCertprofile(name)).orElseThrow(() -> new CaMgmtException("Unknown Certprofile " + name));
                    resp = new MgmtResponse.GetCertprofile(result);
                    break;
                }
                case getCertprofileNames: {
                    resp = new MgmtResponse.StringSet(this.caManager.getCertprofileNames());
                    break;
                }
                case getCertprofilesForCa: {
                    Set list = this.caManager.getCertprofilesForCa(CaHttpMgmtServlet.getNameFromRequest(requestStream));
                    HashSet<String> strList = new HashSet<String>();
                    for (CaProfileEntry entry : list) {
                        strList.add(entry.getEncoded());
                    }
                    resp = new MgmtResponse.StringSet(strList);
                    break;
                }
                case getCrl: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.GetCrl.class);
                    X509CRLHolder crl = Optional.ofNullable(this.caManager.getCrl(req.getCaName(), req.getCrlNumber())).orElseThrow(() -> CaHttpMgmtServlet.lambda$service$5((MgmtRequest.GetCrl)req));
                    resp = CaHttpMgmtServlet.toByteArray(action, crl);
                    break;
                }
                case getCurrentCrl: {
                    String caName = CaHttpMgmtServlet.getNameFromRequest(requestStream);
                    X509CRLHolder crl = Optional.ofNullable(this.caManager.getCurrentCrl(caName)).orElseThrow(() -> new CaMgmtException("No current CRL for CA " + caName));
                    resp = CaHttpMgmtServlet.toByteArray(action, crl);
                    break;
                }
                case getFailedCaNames: {
                    resp = new MgmtResponse.StringSet(this.caManager.getFailedCaNames());
                    break;
                }
                case getInactiveCaNames: {
                    resp = new MgmtResponse.StringSet(this.caManager.getInactiveCaNames());
                    break;
                }
                case getPublisher: {
                    String name = CaHttpMgmtServlet.getNameFromRequest(requestStream);
                    PublisherEntry result = Optional.ofNullable(this.caManager.getPublisher(name)).orElseThrow(() -> new CaMgmtException("Unknown publisher " + name));
                    resp = new MgmtResponse.GetPublisher(result);
                    break;
                }
                case getPublisherNames: {
                    resp = new MgmtResponse.StringSet(this.caManager.getPublisherNames());
                    break;
                }
                case getPublisherNamesForCa: {
                    resp = new MgmtResponse.StringSet(this.caManager.getPublisherNamesForCa(CaHttpMgmtServlet.getNameFromRequest(requestStream)));
                    break;
                }
                case getPublishersForCa: {
                    resp = new MgmtResponse.GetPublischersForCa(this.caManager.getPublishersForCa(CaHttpMgmtServlet.getNameFromRequest(requestStream)));
                    break;
                }
                case getRequestor: {
                    String name = CaHttpMgmtServlet.getNameFromRequest(requestStream);
                    RequestorEntry result = Optional.ofNullable(this.caManager.getRequestor(name)).orElseThrow(() -> new CaMgmtException("Unknown requestor " + name));
                    resp = new MgmtResponse.GetRequestor(result);
                    break;
                }
                case getRequestorNames: {
                    resp = new MgmtResponse.StringSet(this.caManager.getRequestorNames());
                    break;
                }
                case getRequestorsForCa: {
                    resp = new MgmtResponse.GetRequestorsForCa(this.caManager.getRequestorsForCa(CaHttpMgmtServlet.getNameFromRequest(requestStream)));
                    break;
                }
                case getSigner: {
                    String name = CaHttpMgmtServlet.getNameFromRequest(requestStream);
                    SignerEntry result = Optional.ofNullable(this.caManager.getSigner(name)).orElseThrow(() -> new CaMgmtException("Unknown signer " + name));
                    resp = new MgmtResponse.GetSigner(result);
                    break;
                }
                case getSignerNames: {
                    resp = new MgmtResponse.StringSet(this.caManager.getSignerNames());
                    break;
                }
                case getSuccessfulCaNames: {
                    resp = new MgmtResponse.StringSet(this.caManager.getSuccessfulCaNames());
                    break;
                }
                case getSupportedCertprofileTypes: {
                    resp = new MgmtResponse.StringSet(this.caManager.getSupportedCertprofileTypes());
                    break;
                }
                case getSupportedPublisherTypes: {
                    resp = new MgmtResponse.StringSet(this.caManager.getSupportedPublisherTypes());
                    break;
                }
                case getSupportedSignerTypes: {
                    resp = new MgmtResponse.StringSet(this.caManager.getSupportedSignerTypes());
                    break;
                }
                case listCertificates: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.ListCertificates.class);
                    X500Name subjectPattern = X500Name.getInstance((Object)req.getEncodedSubjectDnPattern());
                    List result = this.caManager.listCertificates(req.getCaName(), subjectPattern, req.getValidFrom(), req.getValidTo(), req.getOrderBy(), req.getNumEntries());
                    resp = new MgmtResponse.ListCertificates(result);
                    break;
                }
                case loadConf: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse2(requestStream, MgmtRequest.LoadConf.class);
                    this.caManager.loadConf(req.getConfBytes());
                    break;
                }
                case notifyCaChange: {
                    this.caManager.notifyCaChange();
                    break;
                }
                case removeCa: {
                    this.caManager.removeCa(CaHttpMgmtServlet.getNameFromRequest(requestStream));
                    break;
                }
                case removeCaAlias: {
                    this.caManager.removeCaAlias(CaHttpMgmtServlet.getNameFromRequest(requestStream));
                    break;
                }
                case removeCertificate: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.RemoveCertificate.class);
                    this.caManager.removeCertificate(req.getCaName(), req.getSerialNumber());
                    break;
                }
                case removeCertprofile: {
                    this.caManager.removeCertprofile(CaHttpMgmtServlet.getNameFromRequest(requestStream));
                    break;
                }
                case removeCertprofileFromCa: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.RemoveEntityFromCa.class);
                    this.caManager.removeCertprofileFromCa(req.getEntityName(), req.getCaName());
                    break;
                }
                case removePublisher: {
                    this.caManager.removePublisher(CaHttpMgmtServlet.getNameFromRequest(requestStream));
                    break;
                }
                case removePublisherFromCa: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.RemoveEntityFromCa.class);
                    this.caManager.removePublisherFromCa(req.getEntityName(), req.getCaName());
                    break;
                }
                case removeRequestor: {
                    this.caManager.removeRequestor(CaHttpMgmtServlet.getNameFromRequest(requestStream));
                    break;
                }
                case removeRequestorFromCa: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.RemoveEntityFromCa.class);
                    this.caManager.removeRequestorFromCa(req.getEntityName(), req.getCaName());
                    break;
                }
                case removeSigner: {
                    this.caManager.removeSigner(CaHttpMgmtServlet.getNameFromRequest(requestStream));
                    break;
                }
                case republishCertificates: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.RepublishCertificates.class);
                    this.caManager.republishCertificates(req.getCaName(), req.getPublisherNames(), req.getNumThreads());
                    break;
                }
                case restartCa: {
                    this.caManager.restartCa(CaHttpMgmtServlet.getNameFromRequest(requestStream));
                    break;
                }
                case restartCaSystem: {
                    this.caManager.restartCaSystem();
                    break;
                }
                case revokeCa: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.RevokeCa.class);
                    this.caManager.revokeCa(req.getCaName(), req.getRevocationInfo());
                    break;
                }
                case revokeCertficate: 
                case revokeCertificate: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.RevokeCertificate.class);
                    this.caManager.revokeCertificate(req.getCaName(), req.getSerialNumber(), req.getReason(), req.getInvalidityTime());
                    break;
                }
                case tokenInfoP11: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.TokenInfoP11.class);
                    String info = this.caManager.getTokenInfoP11(req.getModuleName(), req.getSlotIndex(), req.isVerbose());
                    resp = new MgmtResponse.StringResponse(info);
                    break;
                }
                case unlockCa: {
                    this.caManager.unlockCa();
                    break;
                }
                case unrevokeCa: {
                    this.caManager.unrevokeCa(CaHttpMgmtServlet.getNameFromRequest(requestStream));
                    break;
                }
                case unsuspendCertificate: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.UnsuspendCertificate.class);
                    this.caManager.unsuspendCertificate(req.getCaName(), req.getSerialNumber());
                    break;
                }
                case addDbSchema: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddOrChangeDbSchema.class);
                    this.caManager.addDbSchema(req.getName(), req.getValue());
                    break;
                }
                case changeDbSchema: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddOrChangeDbSchema.class);
                    this.caManager.changeDbSchema(req.getName(), req.getValue());
                    break;
                }
                case removeDbSchema: {
                    this.caManager.removeDbSchema(CaHttpMgmtServlet.getNameFromRequest(requestStream));
                    break;
                }
                case getDbSchemas: {
                    resp = new MgmtResponse.GetDbSchemas(this.caManager.getDbSchemas());
                    break;
                }
                case addKeypairGen: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.AddKeypairGen.class);
                    this.caManager.addKeypairGen(req.getEntry());
                    break;
                }
                case changeKeypairGen: {
                    MgmtRequest.AddCa req = CaHttpMgmtServlet.parse(requestStream, MgmtRequest.ChangeTypeConfEntity.class);
                    this.caManager.changeKeypairGen(req.getName(), req.getType(), req.getConf());
                    break;
                }
                case removeKeypairGen: {
                    this.caManager.removeKeypairGen(CaHttpMgmtServlet.getNameFromRequest(requestStream));
                    break;
                }
                case getKeypairGenNames: {
                    resp = new MgmtResponse.StringSet(this.caManager.getKeypairGenNames());
                    break;
                }
                case getKeypairGen: {
                    String name = CaHttpMgmtServlet.getNameFromRequest(requestStream);
                    KeypairGenEntry result = Optional.ofNullable(this.caManager.getKeypairGen(name)).orElseThrow(() -> new CaMgmtException("Unknown KeypairGen " + name));
                    resp = new MgmtResponse.GetKeypairGen(result);
                    break;
                }
                default: {
                    throw new MyException(404, "unsupported action " + actionStr);
                }
            }
            byte[] respBytes = resp == null ? new byte[]{} : CaJson.toJSONBytes((Object)resp);
            new HttpResponse(200, CT_RESPONSE, null, respBytes).fillResponse(response);
        }
        catch (MyException ex) {
            Map<String, String> headers = Collections.singletonMap("x-xipki-error", ex.getMessage());
            new HttpResponse(ex.getStatus(), null, headers, null).fillResponse(response);
        }
        catch (CaMgmtException ex) {
            LOG.error("CaMgmtException", (Throwable)ex);
            Map<String, String> headers = Collections.singletonMap("x-xipki-error", ex.getMessage());
            new HttpResponse(500, null, headers, null).fillResponse(response);
        }
        catch (Throwable th) {
            LOG.error("Throwable thrown, this should not happen!", th);
            new HttpResponse(500).fillResponse(response);
        }
    }

    private static MgmtResponse.ByteArray toByteArray(X509Cert cert) {
        if (cert == null) {
            return new MgmtResponse.ByteArray(null);
        }
        byte[] encoded = cert.getEncoded();
        return new MgmtResponse.ByteArray(encoded);
    }

    private static MgmtResponse.ByteArray toByteArray(MgmtAction action, X509CRLHolder crl) throws MyException {
        byte[] encoded;
        if (crl == null) {
            return new MgmtResponse.ByteArray(null);
        }
        try {
            encoded = crl.getEncoded();
        }
        catch (IOException ex) {
            LOG.error(action + ": could not encode the generated CRL", (Throwable)ex);
            throw new MyException(500, "could not encode the generated CRL");
        }
        return new MgmtResponse.ByteArray(encoded);
    }

    private static String getNameFromRequest(InputStream in) throws CaMgmtException {
        MgmtRequest.Name req = CaHttpMgmtServlet.parse(in, MgmtRequest.Name.class);
        return req.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T extends MgmtRequest> T parse(InputStream in, Class<T> clazz) throws CaMgmtException {
        try (InputStream nin = in;){
            if (LOG.isDebugEnabled()) {
                byte[] reqBytes = IoUtil.readAllBytes((InputStream)nin);
                LOG.debug("received request ({}): {}", (Object)clazz.getName(), (Object)new String(reqBytes));
                MgmtRequest mgmtRequest = (MgmtRequest)CaJson.parseObject((byte[])reqBytes, clazz);
                return (T)mgmtRequest;
            }
            MgmtRequest reqBytes = (MgmtRequest)CaJson.parseObject((InputStream)nin, clazz);
            return (T)reqBytes;
        }
        catch (IOException | RuntimeException ex) {
            String msg = "cannot parse request " + clazz + " from InputStream";
            LOG.error(msg, (Throwable)ex);
            throw new CaMgmtException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T extends MgmtRequest> T parse2(InputStream in, Class<T> clazz) throws CaMgmtException {
        try (InputStream nin = in;){
            MgmtRequest mgmtRequest = (MgmtRequest)CaJson.parseObject((InputStream)nin, clazz);
            return (T)mgmtRequest;
        }
        catch (IOException | RuntimeException ex) {
            String msg = "cannot parse request " + clazz + " from InputStream";
            LOG.error(msg, (Throwable)ex);
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private static /* synthetic */ CaMgmtException lambda$service$5(MgmtRequest.GetCrl req) {
        return new CaMgmtException("Found no CRL for CA " + req.getCaName() + " with CRL number 0x" + req.getCrlNumber().toString(16));
    }

    private static final class MyException
    extends Exception {
        private final int status;

        public MyException(int status, String message) {
            super(message);
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

