/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.servlet;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.Audits;
import org.xipki.ca.api.kpgen.KeypairGeneratorFactory;
import org.xipki.ca.api.profile.CertprofileFactory;
import org.xipki.ca.server.CaServerConf;
import org.xipki.ca.server.CertPublisherFactoryRegister;
import org.xipki.ca.server.CertprofileFactoryRegister;
import org.xipki.ca.server.SdkResponder;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.ca.server.publisher.OcspCertPublisherFactory;
import org.xipki.ca.server.servlet.CaHttpMgmtServlet;
import org.xipki.ca.server.servlet.HttpRaServlet;
import org.xipki.license.api.LicenseFactory;
import org.xipki.security.Securities;
import org.xipki.security.util.X509Util;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.FileOrBinary;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ReflectiveUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.XiHttpFilter;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

public class CaHttpFilter
implements XiHttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CaHttpFilter.class);
    private static final String XIJSON_CERTFACTORY = "org.xipki.ca.certprofile.xijson.CertprofileFactoryImpl";
    private static final String DFLT_CFG = "etc/ca/ca.json";
    private final Securities securities;
    private final LicenseFactory licenseFactory;
    private final CaManagerImpl caManager;
    private SdkResponder responder;
    private HttpRaServlet raServlet;
    private final boolean remoteMgmtEnabled;
    private CaHttpMgmtServlet mgmtServlet;

    public CaHttpFilter(String licenseFactoryClazz) throws Exception {
        CaServerConf.RemoteMgmt remoteMgmt;
        CaServerConf conf;
        XipkiBaseDir.init();
        try {
            conf = CaServerConf.readConfFromFile(IoUtil.expandFilepath((String)DFLT_CFG, (boolean)true));
        }
        catch (IOException ex) {
            throw new IOException("could not parse configuration file etc/ca/ca.json", ex);
        }
        catch (InvalidConfException ex) {
            throw new InvalidConfException("could not parse configuration file etc/ca/ca.json", (Throwable)ex);
        }
        boolean logReqResp = conf.isLogReqResp();
        LOG.info("logReqResp: {}", (Object)logReqResp);
        Audits.AuditConf audit = conf.getAudit();
        String auditType = audit.getType();
        if (StringUtil.isBlank((String)auditType)) {
            auditType = "embed";
        }
        this.securities = new Securities();
        this.securities.init(conf.getSecurity());
        int shardId = conf.getShardId();
        ConfPairs auditConf = audit.getConf();
        if ("file-mac".equals(auditType) || "database-mac".equals(auditType)) {
            auditConf.putPair("shard-id", Integer.toString(shardId));
        }
        Audits.init((String)auditType, (ConfPairs)auditConf);
        if (Audits.getAuditService() == null) {
            throw new IllegalStateException("could not init AuditService");
        }
        LOG.info("Use licenseFactory: {}", (Object)licenseFactoryClazz);
        this.licenseFactory = (LicenseFactory)ReflectiveUtil.newInstance((String)licenseFactoryClazz);
        this.caManager = new CaManagerImpl(this.licenseFactory.createCmLicense());
        this.caManager.setSecurityFactory(this.securities.getSecurityFactory());
        this.caManager.setP11CryptServiceFactory(this.securities.getP11CryptServiceFactory());
        this.caManager.setCertprofileFactoryRegister(this.initCertprofileFactoryRegister(conf.getCertprofileFactories()));
        HashSet<KeypairGeneratorFactory> keypairGeneratorFactories = new HashSet<KeypairGeneratorFactory>();
        if (conf.getKeypairGeneratorFactories() != null) {
            for (String className : conf.getKeypairGeneratorFactories()) {
                try {
                    KeypairGeneratorFactory factory = (KeypairGeneratorFactory)ReflectiveUtil.newInstance((String)className);
                    keypairGeneratorFactories.add(factory);
                }
                catch (ObjectCreationException ex) {
                    LOG.error("error creating KeypairGeneratorFactory " + ((Object)((Object)ex)).getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
        this.caManager.setKeyPairGeneratorFactories(keypairGeneratorFactories);
        CertPublisherFactoryRegister publisherFactoryRegister = new CertPublisherFactoryRegister();
        publisherFactoryRegister.registFactory(new OcspCertPublisherFactory());
        this.caManager.setCertPublisherFactoryRegister(publisherFactoryRegister);
        this.caManager.setCaServerConf(conf);
        this.caManager.startCaSystem();
        LOG.info("ca.noRA: {}", (Object)conf.isNoRA());
        if (!conf.isNoRA()) {
            this.responder = new SdkResponder(conf.getReverseProxyMode(), this.caManager);
            this.raServlet = new HttpRaServlet(logReqResp, this.responder);
        }
        this.remoteMgmtEnabled = (remoteMgmt = conf.getRemoteMgmt()) != null && remoteMgmt.isEnabled();
        LOG.info("remote management is {}", (Object)(this.remoteMgmtEnabled ? "enabled" : "disabled"));
        if (this.remoteMgmtEnabled) {
            List<FileOrBinary> certFiles = remoteMgmt.getCerts();
            if (CollectionUtil.isEmpty(certFiles)) {
                LOG.error("no client certificate is configured, disable the remote management");
            } else {
                List certs = null;
                try {
                    certs = X509Util.parseCerts(certFiles);
                }
                catch (InvalidConfException ex) {
                    LOG.error("error parsing remote management's client certificates", (Throwable)ex);
                }
                if (CollectionUtil.isEmpty((Collection)certs)) {
                    LOG.error("could not find any valid client certificates, disable the remote management");
                } else {
                    this.mgmtServlet = new CaHttpMgmtServlet(this.caManager, conf.getReverseProxyMode(), certs);
                }
            }
        }
    }

    public void destroy() {
        if (this.securities != null) {
            this.securities.close();
        }
        if (this.caManager != null) {
            this.caManager.close();
        }
        if (this.licenseFactory != null) {
            this.licenseFactory.close();
        }
        if (this.responder != null) {
            this.responder.close();
        }
        if (Audits.getAuditService() != null) {
            try {
                Audits.getAuditService().close();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
            }
        }
    }

    private CertprofileFactoryRegister initCertprofileFactoryRegister(List<String> factories) {
        CertprofileFactoryRegister certprofileFactoryRegister = new CertprofileFactoryRegister();
        try {
            CertprofileFactory certprofileFactory = (CertprofileFactory)ReflectiveUtil.newInstance((String)XIJSON_CERTFACTORY);
            certprofileFactoryRegister.registFactory(certprofileFactory);
        }
        catch (ObjectCreationException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex);
        }
        if (factories != null) {
            for (String className : factories) {
                try {
                    CertprofileFactory factory = (CertprofileFactory)ReflectiveUtil.newInstance((String)className);
                    certprofileFactoryRegister.registFactory(factory);
                }
                catch (ObjectCreationException ex) {
                    LogUtil.warn((Logger)LOG, (Throwable)ex);
                }
            }
        }
        return certprofileFactoryRegister;
    }

    public void doFilter(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        String path = req.getServletPath();
        if (path.startsWith("/ra/")) {
            if (this.raServlet != null) {
                req.setAttribute("xipki_path", path.substring(3));
                this.raServlet.service(req, resp);
            } else {
                resp.sendError(404);
            }
        } else if (path.startsWith("/mgmt/")) {
            if (this.mgmtServlet != null) {
                req.setAttribute("xipki_path", path.substring(5));
                this.mgmtServlet.service(req, resp);
            } else {
                resp.sendError(403);
            }
        } else {
            resp.sendError(404);
        }
    }
}

