/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient;

import java.io.Closeable;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.cmpclient.CertIdOrError;
import org.xipki.cmpclient.CertprofileInfo;
import org.xipki.cmpclient.CmpClientException;
import org.xipki.cmpclient.EnrollCertRequest;
import org.xipki.cmpclient.EnrollCertResult;
import org.xipki.cmpclient.PkiErrorException;
import org.xipki.cmpclient.RevokeCertRequest;
import org.xipki.cmpclient.UnrevokeOrRemoveCertRequest;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.ReqRespDebug;

public interface CmpClient
extends Closeable {
    public boolean init();

    public Set<String> getCaNames() throws CmpClientException;

    public Set<CertprofileInfo> getCertprofiles(String var1) throws CmpClientException;

    public EnrollCertResult enrollCert(String var1, CertificationRequest var2, String var3, Date var4, Date var5, ReqRespDebug var6) throws CmpClientException, PkiErrorException;

    public EnrollCertResult enrollCerts(String var1, EnrollCertRequest var2, ReqRespDebug var3) throws CmpClientException, PkiErrorException;

    public CertIdOrError revokeCert(String var1, BigInteger var2, int var3, Date var4, ReqRespDebug var5) throws CmpClientException, PkiErrorException;

    public CertIdOrError revokeCert(String var1, X509Certificate var2, int var3, Date var4, ReqRespDebug var5) throws CmpClientException, PkiErrorException;

    public Map<String, CertIdOrError> revokeCerts(RevokeCertRequest var1, ReqRespDebug var2) throws CmpClientException, PkiErrorException;

    public X509CRL downloadCrl(String var1, ReqRespDebug var2) throws CmpClientException, PkiErrorException;

    public X509CRL downloadCrl(String var1, BigInteger var2, ReqRespDebug var3) throws CmpClientException, PkiErrorException;

    public X509CRL generateCrl(String var1, ReqRespDebug var2) throws CmpClientException, PkiErrorException;

    public String getCaNameByIssuer(X500Name var1) throws CmpClientException;

    public CertIdOrError unrevokeCert(String var1, BigInteger var2, ReqRespDebug var3) throws CmpClientException, PkiErrorException;

    public CertIdOrError unrevokeCert(String var1, X509Certificate var2, ReqRespDebug var3) throws CmpClientException, PkiErrorException;

    public Map<String, CertIdOrError> unrevokeCerts(UnrevokeOrRemoveCertRequest var1, ReqRespDebug var2) throws CmpClientException, PkiErrorException;

    public CertIdOrError removeCert(String var1, BigInteger var2, ReqRespDebug var3) throws CmpClientException, PkiErrorException;

    public CertIdOrError removeCert(String var1, X509Certificate var2, ReqRespDebug var3) throws CmpClientException, PkiErrorException;

    public Map<String, CertIdOrError> removeCerts(UnrevokeOrRemoveCertRequest var1, ReqRespDebug var2) throws CmpClientException, PkiErrorException;

    public HealthCheckResult getHealthCheckResult(String var1) throws CmpClientException;

    public Certificate getCaCert(String var1) throws CmpClientException;

    public X500Name getCaCertSubject(String var1) throws CmpClientException;
}

