/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.cmpclient.CertIdOrError;
import org.xipki.cmpclient.CertprofileInfo;
import org.xipki.cmpclient.CmpClient;
import org.xipki.cmpclient.CmpClientConf;
import org.xipki.cmpclient.CmpClientException;
import org.xipki.cmpclient.EnrollCertRequest;
import org.xipki.cmpclient.EnrollCertResult;
import org.xipki.cmpclient.PkiErrorException;
import org.xipki.cmpclient.RevokeCertRequest;
import org.xipki.cmpclient.UnrevokeOrRemoveCertRequest;
import org.xipki.cmpclient.internal.CaConf;
import org.xipki.cmpclient.internal.CmpAgent;
import org.xipki.cmpclient.internal.CsrEnrollCertRequest;
import org.xipki.cmpclient.internal.EnrollCertResponse;
import org.xipki.cmpclient.internal.Requestor;
import org.xipki.cmpclient.internal.Responder;
import org.xipki.cmpclient.internal.ResultEntry;
import org.xipki.cmpclient.internal.RevokeCertResponse;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.CollectionAlgorithmValidator;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.ValidatableConf;
import org.xipki.util.http.HostnameVerifiers;
import org.xipki.util.http.SSLContextBuilder;

public final class CmpClientImpl
implements CmpClient {
    private static final Logger LOG = LoggerFactory.getLogger(CmpClientImpl.class);
    private final Map<String, CaConf> casMap = new HashMap<String, CaConf>();
    private final Set<String> autoConfCaNames = new HashSet<String>();
    private SecurityFactory securityFactory;
    private String confFile;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    private Set<String> autoConfCas(Set<String> caNames) {
        if (caNames.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> caNamesWithError = new HashSet<String>();
        HashSet<String> errorCaNames = new HashSet<String>();
        for (String name : caNames) {
            CaConf ca = this.casMap.get(name);
            try {
                CaConf.CaInfo caInfo = ca.getAgent().retrieveCaInfo(name, null);
                if (ca.isCertAutoconf()) {
                    ca.setCert(caInfo.getCert());
                }
                if (ca.isCertprofilesAutoconf()) {
                    ca.setCertprofiles(caInfo.getCertprofiles());
                }
                if (ca.isCmpControlAutoconf()) {
                    ca.setCmpControl(caInfo.getCmpControl());
                }
                LOG.info("retrieved CAInfo for CA " + name);
            }
            catch (RuntimeException | CertificateEncodingException | CmpClientException | PkiErrorException ex) {
                errorCaNames.add(name);
                caNamesWithError.add(name);
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not retrieve CAInfo for CA " + name));
            }
        }
        return caNamesWithError;
    }

    private synchronized void initIfNotInitialized() throws CmpClientException {
        if (this.confFile == null) {
            throw new IllegalStateException("confFile is not set");
        }
        if (this.securityFactory == null) {
            throw new IllegalStateException("securityFactory is not set");
        }
        if (this.initialized.get()) {
            return;
        }
        if (!this.init()) {
            throw new CmpClientException("initialization of CA client failed");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean init() {
        CmpClientConf conf;
        this.casMap.clear();
        this.autoConfCaNames.clear();
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdownNow();
        }
        this.initialized.set(false);
        LOG.info("initializing ...");
        File configFile = new File(IoUtil.expandFilepath((String)this.confFile));
        if (!configFile.exists()) {
            LOG.error("could not find configuration file {}", (Object)this.confFile);
            return false;
        }
        try {
            conf = CmpClientImpl.parse(Files.newInputStream(configFile.toPath(), new OpenOption[0]));
        }
        catch (IOException | CmpClientException ex) {
            LOG.error("could not read file {}", (Object)this.confFile);
            return false;
        }
        if (CollectionUtil.isEmpty(conf.getCas())) {
            LOG.warn("no CA is configured");
        }
        HashMap<String, SslConf> sslConfs = new HashMap<String, SslConf>();
        if (conf.getSsls() != null) {
            for (CmpClientConf.Ssl ssl : conf.getSsls()) {
                SSLContextBuilder sSLContextBuilder = new SSLContextBuilder();
                if (ssl.getStoreType() != null) {
                    sSLContextBuilder.setKeyStoreType(ssl.getStoreType());
                }
                try {
                    if (ssl.getKeystoreFile() != null) {
                        char[] cArray = ssl.getKeystorePassword() == null ? null : ssl.getKeystorePassword().toCharArray();
                        sSLContextBuilder.loadKeyMaterial(new File(ssl.getKeystoreFile()), cArray, cArray);
                    }
                    if (ssl.getTruststoreFile() != null) {
                        char[] cArray = ssl.getTruststorePassword() == null ? null : ssl.getTruststorePassword().toCharArray();
                        sSLContextBuilder.loadTrustMaterial(new File(ssl.getTruststoreFile()), cArray);
                    }
                    SSLSocketFactory sSLSocketFactory = sSLContextBuilder.build().getSocketFactory();
                    HostnameVerifier hostnameVerifier = HostnameVerifiers.createHostnameVerifier((String)ssl.getHostnameVerifier());
                    sslConfs.put(ssl.getName(), new SslConf(sSLSocketFactory, hostnameVerifier));
                }
                catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | ObjectCreationException throwable) {
                    LOG.error("could not initialize SSL configuration " + ssl.getName() + ": " + throwable.getMessage(), throwable);
                    return false;
                }
            }
        }
        HashMap<String, Responder.PbmMacCmpResponder> responders = new HashMap<String, Responder.PbmMacCmpResponder>();
        for (CmpClientConf.Responder responder : conf.getResponders()) {
            Responder responder2;
            X509Certificate x509Certificate;
            try {
                x509Certificate = X509Util.parseCert((byte[])responder.getCert().readContent());
            }
            catch (IOException | CertificateException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not configure responder " + responder.getName()));
                return false;
            }
            if (responder.getSignature() != null) {
                CollectionAlgorithmValidator sigAlgoValidator;
                HashSet<String> algoNames = new HashSet<String>();
                for (String algo : responder.getSignature().getSignatureAlgos()) {
                    algoNames.add(algo);
                }
                try {
                    sigAlgoValidator = new CollectionAlgorithmValidator(algoNames);
                }
                catch (NoSuchAlgorithmException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not initialize CollectionAlgorithmValidator");
                    return false;
                }
                responder2 = new Responder.SignaturetCmpResponder(x509Certificate, (AlgorithmValidator)sigAlgoValidator);
            } else {
                CmpClientConf.Responder.PbmMac mac = responder.getPbmMac();
                X500Name subject = X500Name.getInstance((Object)x509Certificate.getSubjectX500Principal().getEncoded());
                responder2 = new Responder.PbmMacCmpResponder(subject, mac.getOwfAlgos(), mac.getMacAlgos());
            }
            responders.put(responder.getName(), (Responder.PbmMacCmpResponder)responder2);
        }
        HashSet<CaConf> hashSet = new HashSet<CaConf>();
        for (CmpClientConf.Ca ca : conf.getCas()) {
            String caName = ca.getName();
            try {
                Responder responder = (Responder)responders.get(ca.getResponder());
                if (responder == null) {
                    LOG.error("no responder named {} is configured", (Object)ca.getResponder());
                    return false;
                }
                SslConf sslConf = null;
                if (ca.getSsl() != null && (sslConf = (SslConf)sslConfs.get(ca.getSsl())) == null) {
                    LOG.error("no ssl named {} is configured", (Object)ca.getSsl());
                    return false;
                }
                CaConf ca2 = new CaConf(caName, ca.getUrl(), ca.getHealthUrl(), ca.getRequestor(), responder, sslConf.getSslSocketFactory(), sslConf.getHostnameVerifier());
                if (ca.getCaCert().isAutoconf()) {
                    ca2.setCertAutoconf(true);
                } else {
                    ca2.setCertAutoconf(false);
                    ca2.setCert(X509Util.parseCert((byte[])ca.getCaCert().getCert().getBinary()));
                }
                CmpClientConf.Cmpcontrol cmpCtrlType = ca.getCmpcontrol();
                ca2.setCmpControlAutoconf(cmpCtrlType.isAutoconf());
                if (!ca2.isCmpControlAutoconf()) {
                    Boolean tmpBo = cmpCtrlType.getRrAkiRequired();
                    CaConf.CmpControl control = new CaConf.CmpControl(tmpBo == null ? false : tmpBo);
                    ca2.setCmpControl(control);
                }
                CmpClientConf.Certprofiles certprofilesType = ca.getCertprofiles();
                ca2.setCertprofilesAutoconf(certprofilesType.isAutoconf());
                if (!ca2.isCertprofilesAutoconf()) {
                    List<CmpClientConf.Certprofile> types = certprofilesType.getProfiles();
                    HashSet<CertprofileInfo> profiles = new HashSet<CertprofileInfo>(types.size());
                    for (CmpClientConf.Certprofile m : types) {
                        String conf0 = null;
                        if (m.getConf() != null && (conf0 = m.getConf().getValue()) == null) {
                            conf0 = new String(IoUtil.read((String)m.getConf().getFile()));
                        }
                        CertprofileInfo profile = new CertprofileInfo(m.getName(), m.getType(), conf0);
                        profiles.add(profile);
                    }
                    ca2.setCertprofiles(profiles);
                }
                hashSet.add(ca2);
                if (!ca2.isCertAutoconf() && !ca2.isCertprofilesAutoconf() && !ca2.isCmpControlAutoconf()) continue;
                this.autoConfCaNames.add(caName);
            }
            catch (IOException | CertificateException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not configure CA " + caName));
                return false;
            }
        }
        HashMap<String, Requestor.SignatureCmpRequestor> hashMap = new HashMap<String, Requestor.SignatureCmpRequestor>();
        for (CmpClientConf.Requestor requestorConf : conf.getRequestors()) {
            Requestor requestor;
            ValidatableConf cf;
            boolean signRequest = requestorConf.isSignRequest();
            String name = requestorConf.getName();
            if (requestorConf.getSignature() != null) {
                cf = requestorConf.getSignature();
                X509Certificate requestorCert = null;
                if (cf.getCert() != null) {
                    try {
                        requestorCert = X509Util.parseCert((byte[])cf.getCert().getBinary());
                    }
                    catch (Exception ex) {
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not parse certificate of rquestor " + requestorConf.getName()));
                        return false;
                    }
                }
                if (cf.getSignerType() != null) {
                    try {
                        SignerConf signerConf = new SignerConf(cf.getSignerConf());
                        ConcurrentContentSigner requestorSigner = this.securityFactory.createSigner(cf.getSignerType(), signerConf, requestorCert);
                        requestor = new Requestor.SignatureCmpRequestor(signRequest, requestorSigner, this.securityFactory);
                    }
                    catch (ObjectCreationException ex) {
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not create rquestor " + requestorConf.getName()));
                        return false;
                    }
                } else {
                    if (signRequest) {
                        LOG.error("signer of requestor must be configured");
                        return false;
                    }
                    if (requestorCert == null) {
                        LOG.error("at least one of certificate and signer of requestor must be configured");
                        return false;
                    }
                    requestor = new Requestor.SignatureCmpRequestor(requestorCert);
                }
            } else {
                AlgorithmIdentifier mac;
                cf = requestorConf.getPbmMac();
                X500Name x500name = new X500Name(cf.getSender());
                AlgorithmIdentifier owf = HashAlgo.getNonNullInstance((String)cf.getOwf()).getAlgorithmIdentifier();
                try {
                    mac = AlgorithmUtil.getMacAlgId((String)cf.getMac());
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.error("Unknown MAC algorithm {}", (Object)cf.getMac());
                    return false;
                }
                requestor = new Requestor.PbmMacCmpRequestor(signRequest, x500name, cf.getPassword().toCharArray(), cf.getKid(), owf, cf.getIterationCount(), mac);
            }
            hashMap.put(name, (Requestor.SignatureCmpRequestor)requestor);
        }
        for (CaConf ca : hashSet) {
            if (this.casMap.containsKey(ca.getName())) {
                LOG.error("duplicate CAs with the same name {}", (Object)ca.getName());
                return false;
            }
            String requestorName = ca.getRequestorName();
            if (!hashMap.containsKey(requestorName)) {
                LOG.error("could not find requestor named {} for CA {}", (Object)requestorName, (Object)ca.getName());
                return false;
            }
            CmpAgent agent = new CmpAgent((Requestor)hashMap.get(requestorName), ca.getResponder(), ca.getUrl(), this.securityFactory, ca.getSslSocketFactory(), ca.getHostnameVerifier());
            ca.setAgent(agent);
            this.casMap.put(ca.getName(), ca);
        }
        if (!this.autoConfCaNames.isEmpty()) {
            void var7_30;
            Integer n = conf.getCainfoUpdateInterval();
            if (n == null) {
                Integer n2 = 10;
            } else if (n <= 0) {
                Integer n3 = 0;
            } else if (n < 5) {
                Integer n4 = 5;
            }
            LOG.info("configuring CAs {}", this.autoConfCaNames);
            Set<String> failedCaNames = this.autoConfCas(this.autoConfCaNames);
            if (CollectionUtil.isNonEmpty(failedCaNames)) {
                LOG.error("could not configure following CAs {}", failedCaNames);
                return false;
            }
            if (var7_30.intValue() > 0) {
                this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new ClientConfigUpdater(), var7_30.intValue(), var7_30.intValue(), TimeUnit.MINUTES);
            }
        }
        this.initialized.set(true);
        LOG.info("initialized");
        return true;
    }

    @Override
    public void close() {
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
            while (!this.scheduledThreadPoolExecutor.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.warn("interrupted: {}", (Object)ex.getMessage());
                }
            }
            this.scheduledThreadPoolExecutor = null;
        }
    }

    @Override
    public EnrollCertResult enrollCert(String caName, CertificationRequest csr, String profile, Date notBefore, Date notAfter, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)csr, (String)"csr");
        this.initIfNotInitialized();
        caName = caName == null ? this.getCaNameForProfile(profile) : caName.toLowerCase();
        if (caName == null) {
            throw new CmpClientException("certprofile " + profile + " is not supported by any CA");
        }
        CaConf ca = this.casMap.get(caName);
        if (ca == null) {
            throw new CmpClientException("could not find CA named " + caName);
        }
        String id = "cert-1";
        CsrEnrollCertRequest request = new CsrEnrollCertRequest("cert-1", profile, csr);
        EnrollCertResponse result = ca.getAgent().requestCertificate(request, notBefore, notAfter, debug);
        return this.parseEnrollCertResult(result);
    }

    @Override
    public EnrollCertResult enrollCerts(String caName, EnrollCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        CaConf ca;
        boolean bo;
        List<EnrollCertRequest.Entry> requestEntries = ((EnrollCertRequest)Args.notNull((Object)request, (String)"request")).getRequestEntries();
        if (CollectionUtil.isEmpty(requestEntries)) {
            return null;
        }
        this.initIfNotInitialized();
        boolean bl = bo = caName != null;
        if (caName == null) {
            String profile = requestEntries.get(0).getCertprofile();
            caName = this.getCaNameForProfile(profile);
            if (caName == null) {
                throw new CmpClientException("certprofile " + (String)profile + " is not supported by any CA");
            }
        } else {
            caName = caName.toLowerCase();
        }
        if (bo || request.getRequestEntries().size() > 1) {
            for (EnrollCertRequest.Entry entry : request.getRequestEntries()) {
                String profile = entry.getCertprofile();
                if (profile == null) continue;
                this.checkCertprofileSupportInCa(profile, caName);
            }
        }
        if ((ca = this.casMap.get(caName)) == null) {
            throw new CmpClientException("could not find CA named " + caName);
        }
        EnrollCertResponse result = ca.getAgent().requestCertificate(request, debug);
        return this.parseEnrollCertResult(result);
    }

    private void checkCertprofileSupportInCa(String certprofile, String caName) throws CmpClientException {
        if (caName != null) {
            CaConf ca = this.casMap.get(caName = caName.toLowerCase());
            if (ca == null) {
                throw new CmpClientException("unknown ca: " + caName);
            }
            if (!ca.supportsProfile(certprofile)) {
                throw new CmpClientException("certprofile " + certprofile + " is not supported by the CA " + caName);
            }
            return;
        }
        for (CaConf ca : this.casMap.values()) {
            if (!ca.isCaInfoConfigured() || !ca.supportsProfile(certprofile)) continue;
            if (caName == null) {
                caName = ca.getName();
                continue;
            }
            throw new CmpClientException("certprofile " + certprofile + " supported by more than one CA, please specify the CA name.");
        }
        if (caName == null) {
            throw new CmpClientException("unsupported certprofile " + certprofile);
        }
    }

    @Override
    public CertIdOrError revokeCert(String caName, X509Certificate cert, int reason, Date invalidityDate, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)cert, (String)"cert");
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        CmpClientImpl.assertIssuedByCa(cert, ca);
        return this.revokeCert(ca, cert.getSerialNumber(), reason, invalidityDate, debug);
    }

    @Override
    public CertIdOrError revokeCert(String caName, BigInteger serial, int reason, Date invalidityDate, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        return this.revokeCert(ca, serial, reason, invalidityDate, debug);
    }

    private CertIdOrError revokeCert(CaConf ca, BigInteger serial, int reason, Date invalidityDate, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)serial, (String)"serial");
        String id = "cert-1";
        RevokeCertRequest.Entry entry = new RevokeCertRequest.Entry("cert-1", ca.getSubject(), serial, reason, invalidityDate);
        if (ca.getCmpControl().isRrAkiRequired()) {
            entry.setAuthorityKeyIdentifier(ca.getSubjectKeyIdentifier());
        }
        RevokeCertRequest request = new RevokeCertRequest();
        request.addRequestEntry(entry);
        Map<String, CertIdOrError> result = this.revokeCerts(request, debug);
        return result == null ? null : result.get("cert-1");
    }

    @Override
    public Map<String, CertIdOrError> revokeCerts(RevokeCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        List<RevokeCertRequest.Entry> requestEntries = ((RevokeCertRequest)Args.notNull((Object)request, (String)"request")).getRequestEntries();
        if (CollectionUtil.isEmpty(requestEntries)) {
            return Collections.emptyMap();
        }
        X500Name issuer = requestEntries.get(0).getIssuer();
        for (int i = 1; i < requestEntries.size(); ++i) {
            if (issuer.equals((Object)requestEntries.get(i).getIssuer())) continue;
            throw new PkiErrorException(2, 32, "revoking certificates issued by more than one CA is not allowed");
        }
        this.initIfNotInitialized();
        String caName = this.getCaNameByIssuer(issuer);
        CaConf caConf = this.casMap.get(caName);
        if (caConf.getCmpControl().isRrAkiRequired()) {
            byte[] aki = caConf.getSubjectKeyIdentifier();
            List<RevokeCertRequest.Entry> entries = request.getRequestEntries();
            for (RevokeCertRequest.Entry entry : entries) {
                if (entry.getAuthorityKeyIdentifier() != null) continue;
                entry.setAuthorityKeyIdentifier(aki);
            }
        }
        RevokeCertResponse result = caConf.getAgent().revokeCertificate(request, debug);
        return this.parseRevokeCertResult(result);
    }

    private Map<String, CertIdOrError> parseRevokeCertResult(RevokeCertResponse result) throws CmpClientException {
        HashMap<String, CertIdOrError> ret = new HashMap<String, CertIdOrError>();
        for (ResultEntry re : result.getResultEntries()) {
            CertIdOrError certIdOrError;
            ResultEntry entry;
            if (re instanceof ResultEntry.RevokeCert) {
                entry = (ResultEntry.RevokeCert)re;
                certIdOrError = new CertIdOrError(((ResultEntry.RevokeCert)entry).getCertId());
            } else if (re instanceof ResultEntry.Error) {
                entry = (ResultEntry.Error)re;
                certIdOrError = new CertIdOrError(((ResultEntry.Error)entry).getStatusInfo());
            } else {
                throw new CmpClientException("unknown type " + re.getClass().getName());
            }
            ret.put(re.getId(), certIdOrError);
        }
        return ret;
    }

    @Override
    public X509CRL downloadCrl(String caName, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        return this.downloadCrl(caName, null, debug);
    }

    @Override
    public X509CRL downloadCrl(String caName, BigInteger crlNumber, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.initIfNotInitialized();
        CaConf ca = this.casMap.get(caName);
        if (ca == null) {
            throw new IllegalArgumentException("unknown CA " + caName);
        }
        CmpAgent agent = ca.getAgent();
        X509CRL result = crlNumber == null ? agent.downloadCurrentCrl(debug) : agent.downloadCrl(crlNumber, debug);
        return result;
    }

    @Override
    public X509CRL generateCrl(String caName, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.initIfNotInitialized();
        CaConf ca = this.casMap.get(caName);
        if (ca == null) {
            throw new IllegalArgumentException("unknown CA " + caName);
        }
        return ca.getAgent().generateCrl(debug);
    }

    @Override
    public String getCaNameByIssuer(X500Name issuer) throws CmpClientException {
        Args.notNull((Object)issuer, (String)"issuer");
        this.initIfNotInitialized();
        for (String name : this.casMap.keySet()) {
            CaConf ca = this.casMap.get(name);
            if (!ca.isCaInfoConfigured() || !CompareUtil.equalsObject((Object)ca.getSubject(), (Object)issuer)) continue;
            return name;
        }
        throw new CmpClientException("unknown CA for issuer: " + issuer);
    }

    private String getCaNameForProfile(String certprofile) throws CmpClientException {
        String caName = null;
        for (CaConf ca : this.casMap.values()) {
            if (!ca.isCaInfoConfigured() || !ca.supportsProfile(certprofile)) continue;
            if (caName == null) {
                caName = ca.getName();
                continue;
            }
            throw new CmpClientException("certprofile " + certprofile + " supported by more than one CA, please specify the CA name.");
        }
        return caName;
    }

    private java.security.cert.Certificate getCertificate(CMPCertificate cmpCert) throws CertificateException {
        Certificate bcCert = cmpCert.getX509v3PKCert();
        return bcCert == null ? null : X509Util.toX509Cert((Certificate)bcCert);
    }

    public String getConfFile() {
        return this.confFile;
    }

    public void setConfFile(String confFile) {
        this.confFile = Args.notBlank((String)confFile, (String)"confFile");
    }

    @Override
    public Set<String> getCaNames() throws CmpClientException {
        this.initIfNotInitialized();
        return this.casMap.keySet();
    }

    private static boolean verify(java.security.cert.Certificate caCert, java.security.cert.Certificate cert) {
        if (!(caCert instanceof X509Certificate)) {
            return false;
        }
        if (!(cert instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509caCert = (X509Certificate)caCert;
        X509Certificate x509cert = (X509Certificate)cert;
        if (!x509cert.getIssuerX500Principal().equals(x509caCert.getSubjectX500Principal())) {
            return false;
        }
        boolean inBenchmark = Boolean.getBoolean("org.xipki.benchmark");
        if (inBenchmark) {
            return true;
        }
        PublicKey caPublicKey = x509caCert.getPublicKey();
        try {
            x509cert.verify(caPublicKey);
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException ex) {
            LOG.debug("{} while verifying signature: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            return false;
        }
    }

    @Override
    public CertIdOrError unrevokeCert(String caName, X509Certificate cert, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)cert, (String)"cert");
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        CmpClientImpl.assertIssuedByCa(cert, ca);
        return this.unrevokeCert(ca, cert.getSerialNumber(), debug);
    }

    @Override
    public CertIdOrError unrevokeCert(String caName, BigInteger serial, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        return this.unrevokeCert(ca, serial, debug);
    }

    private CertIdOrError unrevokeCert(CaConf ca, BigInteger serial, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)serial, (String)"serial");
        String id = "cert-1";
        ResultEntry.UnrevokeOrRemoveCert entry = new ResultEntry.UnrevokeOrRemoveCert("cert-1", ca.getSubject(), serial);
        if (ca.getCmpControl().isRrAkiRequired()) {
            entry.setAuthorityKeyIdentifier(ca.getSubjectKeyIdentifier());
        }
        UnrevokeOrRemoveCertRequest request = new UnrevokeOrRemoveCertRequest();
        UnrevokeOrRemoveCertRequest.Entry entry2 = new UnrevokeOrRemoveCertRequest.Entry(entry.getId(), entry.getIssuer(), entry.getSerialNumber());
        entry2.setAuthorityKeyIdentifier(entry.getAuthorityKeyIdentifier());
        request.addRequestEntry(entry2);
        Map<String, CertIdOrError> result = this.unrevokeCerts(request, debug);
        return result == null ? null : result.get("cert-1");
    }

    @Override
    public Map<String, CertIdOrError> unrevokeCerts(UnrevokeOrRemoveCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)request, (String)"request");
        this.initIfNotInitialized();
        List<UnrevokeOrRemoveCertRequest.Entry> requestEntries = request.getRequestEntries();
        if (CollectionUtil.isEmpty(requestEntries)) {
            return Collections.emptyMap();
        }
        X500Name issuer = requestEntries.get(0).getIssuer();
        for (int i = 1; i < requestEntries.size(); ++i) {
            if (issuer.equals((Object)requestEntries.get(i).getIssuer())) continue;
            throw new PkiErrorException(2, 32, "unrevoking certificates issued by more than one CA is not allowed");
        }
        String caName = this.getCaNameByIssuer(issuer);
        CmpAgent agent = this.casMap.get(caName).getAgent();
        RevokeCertResponse result = agent.unrevokeCertificate(request, debug);
        return this.parseRevokeCertResult(result);
    }

    @Override
    public CertIdOrError removeCert(String caName, X509Certificate cert, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)cert, (String)"cert");
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        CmpClientImpl.assertIssuedByCa(cert, ca);
        return this.removeCert(ca, cert.getSerialNumber(), debug);
    }

    @Override
    public CertIdOrError removeCert(String caName, BigInteger serial, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        return this.removeCert(ca, serial, debug);
    }

    private CertIdOrError removeCert(CaConf ca, BigInteger serial, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)serial, (String)"serial");
        String id = "cert-1";
        UnrevokeOrRemoveCertRequest.Entry entry = new UnrevokeOrRemoveCertRequest.Entry("cert-1", ca.getSubject(), serial);
        if (ca.getCmpControl().isRrAkiRequired()) {
            entry.setAuthorityKeyIdentifier(ca.getSubjectKeyIdentifier());
        }
        UnrevokeOrRemoveCertRequest request = new UnrevokeOrRemoveCertRequest();
        request.addRequestEntry(entry);
        Map<String, CertIdOrError> result = this.removeCerts(request, debug);
        return result == null ? null : result.get("cert-1");
    }

    @Override
    public Map<String, CertIdOrError> removeCerts(UnrevokeOrRemoveCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)request, (String)"request");
        this.initIfNotInitialized();
        List<UnrevokeOrRemoveCertRequest.Entry> requestEntries = request.getRequestEntries();
        if (CollectionUtil.isEmpty(requestEntries)) {
            return Collections.emptyMap();
        }
        X500Name issuer = requestEntries.get(0).getIssuer();
        for (int i = 1; i < requestEntries.size(); ++i) {
            if (issuer.equals((Object)requestEntries.get(i).getIssuer())) continue;
            throw new PkiErrorException(2, 32, "removing certificates issued by more than one CA is not allowed");
        }
        String caName = this.getCaNameByIssuer(issuer);
        CmpAgent agent = this.casMap.get(caName).getAgent();
        RevokeCertResponse result = agent.removeCertificate(request, debug);
        return this.parseRevokeCertResult(result);
    }

    @Override
    public Set<CertprofileInfo> getCertprofiles(String caName) throws CmpClientException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.initIfNotInitialized();
        CaConf ca = this.casMap.get(caName);
        if (ca == null) {
            return Collections.emptySet();
        }
        Set<String> profileNames = ca.getProfileNames();
        if (CollectionUtil.isEmpty(profileNames)) {
            return Collections.emptySet();
        }
        HashSet<CertprofileInfo> ret = new HashSet<CertprofileInfo>(profileNames.size());
        for (String m : profileNames) {
            ret.add(ca.getProfile(m));
        }
        return ret;
    }

    @Override
    public HealthCheckResult getHealthCheckResult(String caName) throws CmpClientException {
        URL serverUrl;
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        String name = "X509CA";
        HealthCheckResult healthCheckResult = new HealthCheckResult();
        healthCheckResult.setName(name);
        try {
            this.initIfNotInitialized();
        }
        catch (CmpClientException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not initialize CaCleint");
            healthCheckResult.setHealthy(false);
            return healthCheckResult;
        }
        CaConf ca = this.casMap.get(caName);
        if (ca == null) {
            throw new IllegalArgumentException("unknown CA " + caName);
        }
        String healthUrlStr = ca.getHealthUrl();
        try {
            serverUrl = new URL(healthUrlStr);
        }
        catch (MalformedURLException ex) {
            throw new CmpClientException("invalid URL '" + healthUrlStr + "'");
        }
        try {
            HttpURLConnection httpUrlConnection = IoUtil.openHttpConn((URL)serverUrl);
            if (httpUrlConnection instanceof HttpsURLConnection) {
                if (ca.getHostnameVerifier() != null) {
                    ((HttpsURLConnection)httpUrlConnection).setHostnameVerifier(ca.getHostnameVerifier());
                }
                if (ca.getSslSocketFactory() != null) {
                    ((HttpsURLConnection)httpUrlConnection).setSSLSocketFactory(ca.getSslSocketFactory());
                }
            }
            InputStream inputStream = httpUrlConnection.getInputStream();
            int responseCode = httpUrlConnection.getResponseCode();
            if (responseCode != 200 && responseCode != 500) {
                inputStream.close();
                throw new IOException(String.format("bad response: code='%s', message='%s'", httpUrlConnection.getResponseCode(), httpUrlConnection.getResponseMessage()));
            }
            String responseContentType = httpUrlConnection.getContentType();
            boolean isValidContentType = false;
            if (responseContentType != null && "application/json".equalsIgnoreCase(responseContentType)) {
                isValidContentType = true;
            }
            if (!isValidContentType) {
                inputStream.close();
                throw new IOException("bad response: mime type " + responseContentType + " not supported!");
            }
            byte[] responseBytes = IoUtil.read((InputStream)inputStream);
            if (responseBytes.length == 0) {
                healthCheckResult.setHealthy(responseCode == 200);
            } else {
                try {
                    healthCheckResult = (HealthCheckResult)JSON.parseObject((byte[])responseBytes, HealthCheckResult.class, (Feature[])new Feature[0]);
                }
                catch (RuntimeException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)"IOException while parsing the health json message");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("json message: {}", (Object)new String(responseBytes));
                    }
                    healthCheckResult.setHealthy(false);
                }
            }
        }
        catch (IOException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("IOException while fetching the URL " + healthUrlStr));
            healthCheckResult.setHealthy(false);
        }
        return healthCheckResult;
    }

    private EnrollCertResult parseEnrollCertResult(EnrollCertResponse result) throws CmpClientException {
        java.security.cert.Certificate cert;
        HashMap<String, EnrollCertResult.CertifiedKeyPairOrError> certOrErrors = new HashMap<String, EnrollCertResult.CertifiedKeyPairOrError>();
        for (ResultEntry resultEntry : result.getResultEntries()) {
            Object certOrError;
            if (resultEntry instanceof ResultEntry.EnrollCert) {
                ResultEntry.EnrollCert entry = (ResultEntry.EnrollCert)resultEntry;
                try {
                    java.security.cert.Certificate cert2 = this.getCertificate(entry.getCert());
                    certOrError = new EnrollCertResult.CertifiedKeyPairOrError(cert2, entry.getPrivateKeyInfo());
                }
                catch (CertificateException ex) {
                    throw new CmpClientException(String.format("CertificateParsingException for request (id=%s): %s", entry.getId(), ex.getMessage()));
                }
            } else {
                certOrError = resultEntry instanceof ResultEntry.Error ? new EnrollCertResult.CertifiedKeyPairOrError(((ResultEntry.Error)resultEntry).getStatusInfo()) : null;
            }
            certOrErrors.put(resultEntry.getId(), (EnrollCertResult.CertifiedKeyPairOrError)certOrError);
        }
        List<CMPCertificate> cmpCaPubs = result.getCaCertificates();
        if (CollectionUtil.isEmpty(cmpCaPubs)) {
            return new EnrollCertResult(null, certOrErrors);
        }
        ArrayList<java.security.cert.Certificate> caPubs = new ArrayList<java.security.cert.Certificate>(cmpCaPubs.size());
        for (CMPCertificate cmpCaPub : cmpCaPubs) {
            try {
                caPubs.add(this.getCertificate(cmpCaPub));
            }
            catch (CertificateException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not extract the caPub from CMPCertificate");
            }
        }
        java.security.cert.Certificate caCert = null;
        for (EnrollCertResult.CertifiedKeyPairOrError certOrError : certOrErrors.values()) {
            cert = certOrError.getCertificate();
            if (cert == null) continue;
            for (java.security.cert.Certificate caPub : caPubs) {
                if (!CmpClientImpl.verify(caPub, cert)) continue;
                caCert = caPub;
                break;
            }
            if (caCert == null) continue;
            break;
        }
        if (caCert == null) {
            return new EnrollCertResult(null, certOrErrors);
        }
        for (EnrollCertResult.CertifiedKeyPairOrError certOrError : certOrErrors.values()) {
            cert = certOrError.getCertificate();
            if (cert == null || CmpClientImpl.verify(caCert, cert)) continue;
            LOG.warn("not all certificates are issued by CA embedded in caPubs, ignore the caPubs");
            return new EnrollCertResult(null, certOrErrors);
        }
        return new EnrollCertResult(caCert, certOrErrors);
    }

    private static CmpClientConf parse(InputStream configStream) throws CmpClientException {
        CmpClientConf conf;
        try {
            conf = (CmpClientConf)((Object)JSON.parseObject((InputStream)configStream, CmpClientConf.class, (Feature[])new Feature[0]));
            conf.validate();
        }
        catch (IOException | RuntimeException | InvalidConfException ex) {
            throw new CmpClientException("parsing profile failed, message: " + ex.getMessage(), ex);
        }
        finally {
            try {
                configStream.close();
            }
            catch (IOException ex) {
                LOG.warn("could not close confStream: {}", (Object)ex.getMessage());
            }
        }
        for (CmpClientConf.Requestor requestor : conf.getRequestors()) {
            requestor.setName(requestor.getName().toLowerCase());
        }
        for (CmpClientConf.Responder responder : conf.getResponders()) {
            responder.setName(responder.getName().toLowerCase());
        }
        for (CmpClientConf.Ca ca : conf.getCas()) {
            ca.setName(ca.getName().toLowerCase());
            ca.setRequestor(ca.getRequestor().toLowerCase());
            ca.setResponder(ca.getResponder().toLowerCase());
        }
        return conf;
    }

    private CaConf getCa(String caName) throws CmpClientException {
        if (caName == null) {
            Iterator<String> names = this.casMap.keySet().iterator();
            if (!names.hasNext()) {
                throw new CmpClientException("no CA is configured");
            }
            caName = names.next();
        } else {
            caName = caName.toLowerCase();
        }
        CaConf ca = this.casMap.get(caName);
        if (ca == null) {
            throw new CmpClientException("could not find CA named " + caName);
        }
        return ca;
    }

    private static void assertIssuedByCa(X509Certificate cert, CaConf ca) throws CmpClientException {
        boolean issued;
        try {
            issued = X509Util.issues((X509Certificate)ca.getCert(), (X509Certificate)cert);
        }
        catch (CertificateEncodingException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            issued = false;
        }
        if (!issued) {
            throw new CmpClientException("the given certificate is not issued by the CA");
        }
    }

    @Override
    public java.security.cert.Certificate getCaCert(String caName) throws CmpClientException {
        this.initIfNotInitialized();
        CaConf ca = this.casMap.get(caName.toLowerCase());
        return ca == null ? null : ca.getCert();
    }

    @Override
    public X500Name getCaCertSubject(String caName) throws CmpClientException {
        this.initIfNotInitialized();
        CaConf ca = this.casMap.get(caName.toLowerCase());
        return ca == null ? null : ca.getSubject();
    }

    private class SslConf {
        private final SSLSocketFactory sslSocketFactory;
        private final HostnameVerifier hostnameVerifier;

        SslConf(SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) {
            this.sslSocketFactory = sslSocketFactory;
            this.hostnameVerifier = hostnameVerifier;
        }

        public SSLSocketFactory getSslSocketFactory() {
            return this.sslSocketFactory;
        }

        public HostnameVerifier getHostnameVerifier() {
            return this.hostnameVerifier;
        }
    }

    private class ClientConfigUpdater
    implements Runnable {
        private static final long MINUTE = 60000L;
        private AtomicBoolean inProcess = new AtomicBoolean(false);
        private long lastUpdate;

        ClientConfigUpdater() {
        }

        @Override
        public void run() {
            if (this.inProcess.get()) {
                return;
            }
            this.inProcess.set(true);
            try {
                if (System.currentTimeMillis() - this.lastUpdate < 120000L) {
                    return;
                }
                LOG.info("scheduled configuring CAs {}", (Object)CmpClientImpl.this.autoConfCaNames);
                Set failedCaNames = CmpClientImpl.this.autoConfCas(CmpClientImpl.this.autoConfCaNames);
                if (CollectionUtil.isNonEmpty((Collection)failedCaNames)) {
                    LOG.warn("could not configure following CAs {}", (Object)failedCaNames);
                }
            }
            finally {
                this.lastUpdate = System.currentTimeMillis();
                this.inProcess.set(false);
            }
        }
    }
}

