/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient;

import java.security.cert.Certificate;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.xipki.security.cmp.PkiStatusInfo;
import org.xipki.util.Args;

public class EnrollCertResult {
    private final Certificate caCert;
    private final Map<String, CertifiedKeyPairOrError> certsOrErrors;

    public EnrollCertResult(Certificate caCert, Map<String, CertifiedKeyPairOrError> certsOrErrors) {
        this.certsOrErrors = Args.notEmpty(certsOrErrors, (String)"certsOrErrors");
        this.caCert = caCert;
    }

    public Certificate getCaCert() {
        return this.caCert;
    }

    public CertifiedKeyPairOrError getCertOrError(String id) {
        Args.notBlank((String)id, (String)"id");
        return this.certsOrErrors.get(id);
    }

    public Set<String> getAllIds() {
        return this.certsOrErrors.keySet();
    }

    public static class CertifiedKeyPairOrError {
        private final Certificate certificate;
        private final PrivateKeyInfo privateKeyInfo;
        private final PkiStatusInfo error;

        public CertifiedKeyPairOrError(Certificate certificate, PrivateKeyInfo privateKeyInfo) {
            this.certificate = (Certificate)Args.notNull((Object)certificate, (String)"certificate");
            this.privateKeyInfo = privateKeyInfo;
            this.error = null;
        }

        public CertifiedKeyPairOrError(PkiStatusInfo error) {
            this.certificate = null;
            this.privateKeyInfo = null;
            this.error = (PkiStatusInfo)Args.notNull((Object)error, (String)"error");
        }

        public Certificate getCertificate() {
            return this.certificate;
        }

        public PrivateKeyInfo getPrivateKeyInfo() {
            return this.privateKeyInfo;
        }

        public PkiStatusInfo getError() {
            return this.error;
        }
    }
}

