/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.internal;

import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.cmpclient.CertprofileInfo;
import org.xipki.cmpclient.internal.CmpAgent;
import org.xipki.cmpclient.internal.Responder;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

class CaConf {
    private final String name;
    private final String url;
    private final String healthUrl;
    private final String requestorName;
    private final Responder responder;
    private CmpAgent agent;
    private boolean certAutoconf;
    private boolean certprofilesAutoconf;
    private boolean cmpControlAutoconf;
    private boolean dhpocAutoconf;
    private X509Cert cert;
    private List<X509Cert> certchain;
    private X500Name subject;
    private byte[] subjectKeyIdentifier;
    private CmpControl cmpControl;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private Map<String, CertprofileInfo> profiles = Collections.emptyMap();
    private List<X509Cert> dhpocs;

    CaConf(String name, String url, String healthUrl, String requestorName, Responder responder, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) {
        this.name = Args.toNonBlankLower((String)name, (String)"name");
        this.url = Args.notBlank((String)url, (String)"url");
        this.requestorName = (String)Args.notNull((Object)requestorName, (String)"requestorName");
        this.responder = (Responder)Args.notNull((Object)responder, (String)"responder");
        this.healthUrl = StringUtil.isBlank((String)healthUrl) ? url.replace("cmp", "health") : healthUrl;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHealthUrl() {
        return this.healthUrl;
    }

    public void setCertchain(List<X509Cert> certchain) throws CertificateEncodingException {
        Args.notEmpty(certchain, (String)"certchain");
        this.certchain = certchain;
        this.cert = certchain.get(0);
        this.subject = this.cert.getSubject();
        this.subjectKeyIdentifier = this.cert.getSubjectKeyId();
    }

    public void setCertprofiles(Set<CertprofileInfo> certprofiles) {
        if (this.profiles == null) {
            this.profiles = Collections.emptyMap();
        } else {
            this.profiles = new HashMap<String, CertprofileInfo>();
            for (CertprofileInfo m : certprofiles) {
                this.profiles.put(m.getName(), m);
            }
        }
    }

    public X509Cert getCert() {
        return this.cert;
    }

    public List<X509Cert> getCertchain() {
        return this.certchain;
    }

    public boolean isDhpocAutoconf() {
        return this.dhpocAutoconf;
    }

    public void setDhpocAutoconf(boolean dhpocAutoconf) {
        this.dhpocAutoconf = dhpocAutoconf;
    }

    public List<X509Cert> getDhpocs() {
        return this.dhpocs;
    }

    public void setDhpocs(List<X509Cert> dhpocs) {
        this.dhpocs = dhpocs;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public boolean isCertAutoconf() {
        return this.certAutoconf;
    }

    public Set<String> getProfileNames() {
        return this.profiles.keySet();
    }

    public boolean supportsProfile(String profileName) {
        return this.profiles.containsKey(Args.toNonBlankLower((String)profileName, (String)"profileName"));
    }

    public CertprofileInfo getProfile(String profileName) {
        return this.profiles.get(Args.toNonBlankLower((String)profileName, (String)"profileName"));
    }

    public boolean isCaInfoConfigured() {
        return this.cert != null;
    }

    public Responder getResponder() {
        return this.responder;
    }

    public void setCertAutoconf(boolean autoconf) {
        this.certAutoconf = autoconf;
    }

    public boolean isCertprofilesAutoconf() {
        return this.certprofilesAutoconf;
    }

    public void setCertprofilesAutoconf(boolean autoconf) {
        this.certprofilesAutoconf = autoconf;
    }

    public void setAgent(CmpAgent agent) {
        this.agent = agent;
    }

    public String getRequestorName() {
        return this.requestorName;
    }

    public CmpAgent getAgent() {
        return this.agent;
    }

    public void setCmpControlAutoconf(boolean autoconf) {
        this.cmpControlAutoconf = autoconf;
    }

    public boolean isCmpControlAutoconf() {
        return this.cmpControlAutoconf;
    }

    public void setCmpControl(CmpControl cmpControl) {
        this.cmpControl = cmpControl;
    }

    public CmpControl getCmpControl() {
        return this.cmpControl;
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier == null ? null : Arrays.copyOf(this.subjectKeyIdentifier, this.subjectKeyIdentifier.length);
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    static class CaInfo {
        private final List<X509Cert> certchain;
        private final List<X509Cert> dhpocs;
        private final Set<CertprofileInfo> certprofiles;
        private final CmpControl cmpControl;

        CaInfo(List<X509Cert> certchain, CmpControl cmpControl, Set<CertprofileInfo> certprofiles, List<X509Cert> dhpocs) {
            this.certchain = certchain;
            this.cmpControl = cmpControl;
            this.certprofiles = certprofiles;
            this.dhpocs = dhpocs;
        }

        List<X509Cert> getCertchain() {
            return this.certchain;
        }

        List<X509Cert> getDhpocs() {
            return this.dhpocs;
        }

        CmpControl getCmpControl() {
            return this.cmpControl;
        }

        Set<CertprofileInfo> getCertprofiles() {
            return this.certprofiles;
        }
    }

    static class CmpControl {
        private final boolean rrAkiRequired;

        public CmpControl(boolean rrAkiRequired) {
            this.rrAkiRequired = rrAkiRequired;
        }

        public boolean isRrAkiRequired() {
            return this.rrAkiRequired;
        }
    }
}

