/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.internal;

import java.math.BigInteger;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.cmpclient.IdentifiedObject;
import org.xipki.security.cmp.PkiStatusInfo;
import org.xipki.util.Args;

abstract class ResultEntry
extends IdentifiedObject {
    public ResultEntry(String id) {
        super(id);
    }

    public static class UnrevokeOrRemoveCert
    extends ResultEntry {
        private final X500Name issuer;
        private final BigInteger serialNumber;
        private byte[] authorityKeyIdentifier;

        public UnrevokeOrRemoveCert(String id, X500Name issuer, BigInteger serialNumber) {
            super(id);
            this.serialNumber = (BigInteger)Args.notNull((Object)serialNumber, (String)"serialNumber");
            this.issuer = (X500Name)Args.notNull((Object)issuer, (String)"issuer");
        }

        public X500Name getIssuer() {
            return this.issuer;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        public byte[] getAuthorityKeyIdentifier() {
            return this.authorityKeyIdentifier;
        }

        public void setAuthorityKeyIdentifier(byte[] authorityKeyIdentifier) {
            this.authorityKeyIdentifier = authorityKeyIdentifier;
        }
    }

    public static class RevokeCert
    extends ResultEntry {
        private final CertId certId;

        public RevokeCert(String id, CertId certId) {
            super(id);
            this.certId = certId;
        }

        public CertId getCertId() {
            return this.certId;
        }
    }

    public static class EnrollCert
    extends ResultEntry {
        private final CMPCertificate cert;
        private final PrivateKeyInfo privateKeyInfo;
        private final int status;

        public EnrollCert(String id, CMPCertificate cert, PrivateKeyInfo privateKeyInfo) {
            this(id, cert, privateKeyInfo, 0);
        }

        public EnrollCert(String id, CMPCertificate cert, PrivateKeyInfo privateKeyInfo, int status) {
            super(id);
            this.cert = cert;
            this.privateKeyInfo = privateKeyInfo;
            this.status = status;
        }

        public CMPCertificate getCert() {
            return this.cert;
        }

        public PrivateKeyInfo getPrivateKeyInfo() {
            return this.privateKeyInfo;
        }

        public int getStatus() {
            return this.status;
        }
    }

    public static class Error
    extends ResultEntry {
        private final PkiStatusInfo statusInfo;

        public Error(String id, PkiStatusInfo statusInfo) {
            super(id);
            this.statusInfo = (PkiStatusInfo)Args.notNull((Object)statusInfo, (String)"statusInfo");
        }

        public Error(String id, int status, int pkiFailureInfo, String statusMessage) {
            super(id);
            this.statusInfo = new PkiStatusInfo(status, pkiFailureInfo, statusMessage);
        }

        public Error(String id, int status) {
            super(id);
            this.statusInfo = new PkiStatusInfo(status);
        }

        public PkiStatusInfo getStatusInfo() {
            return this.statusInfo;
        }
    }
}

