/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.internal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.GenMsgContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PBMParameter;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cmp.RevDetails;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.CertificateConfirmationContent;
import org.bouncycastle.cert.cmp.CertificateConfirmationContentBuilder;
import org.bouncycastle.cert.cmp.GeneralPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.cmpclient.CmpClientException;
import org.xipki.cmpclient.EnrollCertRequest;
import org.xipki.cmpclient.PkiErrorException;
import org.xipki.cmpclient.RevokeCertRequest;
import org.xipki.cmpclient.UnrevokeOrRemoveCertRequest;
import org.xipki.cmpclient.internal.CaConf;
import org.xipki.cmpclient.internal.CmpAgentUtil;
import org.xipki.cmpclient.internal.CsrEnrollCertRequest;
import org.xipki.cmpclient.internal.EnrollCertResponse;
import org.xipki.cmpclient.internal.Requestor;
import org.xipki.cmpclient.internal.Responder;
import org.xipki.cmpclient.internal.ResultEntry;
import org.xipki.cmpclient.internal.RevokeCertResponse;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.cmp.CmpUtf8Pairs;
import org.xipki.security.cmp.CmpUtil;
import org.xipki.security.cmp.ProtectionResult;
import org.xipki.security.cmp.ProtectionVerificationResult;
import org.xipki.security.cmp.VerifiedPkiMessage;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.ReqRespDebug;

class CmpAgent {
    private static final Logger LOG = LoggerFactory.getLogger(CmpAgent.class);
    private static final String CMP_REQUEST_MIMETYPE = "application/pkixcmp";
    private static final String CMP_RESPONSE_MIMETYPE = "application/pkixcmp";
    private static final DigestCalculatorProvider DIGEST_CALCULATOR_PROVIDER = new BcDigestCalculatorProvider();
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    protected static final int PKISTATUS_RESPONSE_ERROR = -1;
    protected static final int PKISTATUS_NO_ANSWER = -2;
    protected final SecurityFactory securityFactory;
    private final Random random = new Random();
    private final Requestor requestor;
    private final Responder responder;
    private final X500Name recipientName;
    private boolean sendRequestorCert;
    private final boolean implicitConfirm = true;
    private final URL serverUrl;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;

    CmpAgent(Requestor requestor, Responder responder, String serverUrl, SecurityFactory securityFactory, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) {
        boolean bothMacBased;
        this.requestor = (Requestor)Args.notNull((Object)requestor, (String)"requestor");
        this.responder = (Responder)Args.notNull((Object)responder, (String)"responder");
        this.securityFactory = (SecurityFactory)Args.notNull((Object)securityFactory, (String)"securityFactory");
        Args.notBlank((String)serverUrl, (String)"serverUrl");
        boolean bothSignatureBased = requestor instanceof Requestor.SignatureCmpRequestor && responder instanceof Responder.SignaturetCmpResponder;
        boolean bl = bothMacBased = requestor instanceof Requestor.PbmMacCmpRequestor && responder instanceof Responder.PbmMacCmpResponder;
        if (!bothSignatureBased && !bothMacBased) {
            throw new IllegalArgumentException("requestor and responder do not match");
        }
        this.recipientName = (X500Name)responder.getName().getName();
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        try {
            this.serverUrl = new URL(serverUrl);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("invalid URL: " + serverUrl);
        }
    }

    private byte[] send(byte[] request) throws IOException {
        OutputStream outputstream;
        Args.notNull((Object)request, (String)"request");
        HttpURLConnection httpUrlConnection = IoUtil.openHttpConn((URL)this.serverUrl);
        if (httpUrlConnection instanceof HttpsURLConnection) {
            if (this.sslSocketFactory != null) {
                ((HttpsURLConnection)httpUrlConnection).setSSLSocketFactory(this.sslSocketFactory);
            }
            if (this.hostnameVerifier != null) {
                ((HttpsURLConnection)httpUrlConnection).setHostnameVerifier(this.hostnameVerifier);
            }
        }
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setUseCaches(false);
        int size = request.length;
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setRequestProperty("Content-Type", "application/pkixcmp");
        httpUrlConnection.setRequestProperty("Content-Length", Integer.toString(size));
        int i = 0;
        while (true) {
            try {
                outputstream = httpUrlConnection.getOutputStream();
            }
            catch (EOFException ex) {
                if (i == 2) {
                    throw ex;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            break;
        }
        outputstream.write(request);
        outputstream.flush();
        InputStream inputStream = httpUrlConnection.getInputStream();
        if (httpUrlConnection.getResponseCode() != 200) {
            inputStream.close();
            throw new IOException("bad response: " + httpUrlConnection.getResponseCode() + "    " + httpUrlConnection.getResponseMessage());
        }
        String responseContentType = httpUrlConnection.getContentType();
        boolean isValidContentType = false;
        if (responseContentType != null && responseContentType.equalsIgnoreCase("application/pkixcmp")) {
            isValidContentType = true;
        }
        if (!isValidContentType) {
            inputStream.close();
            throw new IOException("bad response: mime type " + responseContentType + " not supported!");
        }
        return IoUtil.read((InputStream)inputStream);
    }

    private PKIMessage sign(PKIMessage request) throws CmpClientException {
        Args.notNull((Object)request, (String)"request");
        if (this.requestor == null) {
            throw new CmpClientException("no request signer is configured");
        }
        if (this.requestor instanceof Requestor.SignatureCmpRequestor) {
            ConcurrentContentSigner signer = ((Requestor.SignatureCmpRequestor)this.requestor).getSigner();
            try {
                return CmpUtil.addProtection((PKIMessage)request, (ConcurrentContentSigner)signer, (GeneralName)this.requestor.getName(), (boolean)this.sendRequestorCert);
            }
            catch (CMPException | NoIdleSignerException ex) {
                throw new CmpClientException("could not sign the request", ex);
            }
        }
        Requestor.PbmMacCmpRequestor pbmRequestor = (Requestor.PbmMacCmpRequestor)this.requestor;
        try {
            return CmpUtil.addProtection((PKIMessage)request, (char[])pbmRequestor.getPassword(), (PBMParameter)pbmRequestor.getParameter(), (GeneralName)this.requestor.getName(), (byte[])pbmRequestor.getSenderKID());
        }
        catch (CMPException ex) {
            throw new CmpClientException("could not sign the request", ex);
        }
    }

    private VerifiedPkiMessage signAndSend(PKIMessage request, ReqRespDebug debug) throws CmpClientException {
        PKIBody respBody;
        int bodyType;
        ASN1OctetString respRecipientNonce;
        GeneralPKIMessage response;
        byte[] encodedResponse;
        byte[] encodedRequest;
        Args.notNull((Object)request, (String)"request");
        PKIMessage tmpRequest = this.requestor.signRequest() ? this.sign(request) : request;
        try {
            encodedRequest = tmpRequest.getEncoded();
        }
        catch (IOException ex) {
            LOG.error("could not encode the PKI request {}", (Object)tmpRequest);
            throw new CmpClientException(ex.getMessage(), ex);
        }
        ReqRespDebug.ReqRespPair reqResp = null;
        if (debug != null) {
            reqResp = new ReqRespDebug.ReqRespPair();
            debug.add(reqResp);
            if (debug.saveRequest()) {
                reqResp.setRequest(encodedRequest);
            }
        }
        try {
            encodedResponse = this.send(encodedRequest);
        }
        catch (IOException ex) {
            LOG.error("could not send the PKI request {} to server", (Object)tmpRequest);
            throw new CmpClientException("TRANSPORT_ERROR", ex);
        }
        if (reqResp != null && debug.saveResponse()) {
            reqResp.setResponse(encodedResponse);
        }
        try {
            response = new GeneralPKIMessage(encodedResponse);
        }
        catch (IOException ex) {
            LOG.error("could not decode the received PKI message: {}", (Object)Hex.encode((byte[])encodedResponse));
            throw new CmpClientException(ex.getMessage(), ex);
        }
        PKIHeader reqHeader = request.getHeader();
        PKIHeader respHeader = response.getHeader();
        ASN1OctetString tid = reqHeader.getTransactionID();
        ASN1OctetString respTid = respHeader.getTransactionID();
        if (!tid.equals((ASN1Primitive)respTid)) {
            LOG.warn("Response contains different tid ({}) than requested {}", (Object)respTid, (Object)tid);
            throw new CmpClientException("Response contains differnt tid than the request");
        }
        ASN1OctetString senderNonce = reqHeader.getSenderNonce();
        if (!senderNonce.equals((ASN1Primitive)(respRecipientNonce = respHeader.getRecipNonce()))) {
            LOG.warn("tid {}: response.recipientNonce ({}) != request.senderNonce ({})", new Object[]{tid, respRecipientNonce, senderNonce});
            throw new CmpClientException("Response contains differnt tid than the request");
        }
        GeneralName rec = respHeader.getRecipient();
        if (!this.requestor.getName().equals((Object)rec)) {
            LOG.warn("tid={}: unknown CMP requestor '{}'", (Object)tid, (Object)rec);
        }
        VerifiedPkiMessage ret = new VerifiedPkiMessage(response);
        if (response.hasProtection()) {
            try {
                ProtectionVerificationResult verifyProtection = this.verifyProtection(Hex.encode((byte[])tid.getOctets()), response);
                ret.setProtectionVerificationResult(verifyProtection);
            }
            catch (InvalidKeyException | CMPException ex) {
                throw new CmpClientException(ex.getMessage(), ex);
            }
        } else if (this.requestor.signRequest() && (bodyType = (respBody = response.getBody()).getType()) != 23) {
            throw new CmpClientException("response is not signed");
        }
        return ret;
    }

    private PKIHeader buildPkiHeader(ASN1OctetString tid) {
        return this.buildPkiHeader(false, tid, null, null);
    }

    private PKIHeader buildPkiHeader(boolean addImplictConfirm, ASN1OctetString tid) {
        return this.buildPkiHeader(addImplictConfirm, tid, null, null);
    }

    private PKIHeader buildPkiHeader(boolean addImplictConfirm, ASN1OctetString tid, CmpUtf8Pairs utf8Pairs, InfoTypeAndValue ... additionalGeneralInfos) {
        if (additionalGeneralInfos != null) {
            for (InfoTypeAndValue itv : additionalGeneralInfos) {
                ASN1ObjectIdentifier type = itv.getInfoType();
                if (CMPObjectIdentifiers.it_implicitConfirm.equals((ASN1Primitive)type)) {
                    throw new IllegalArgumentException("additionGeneralInfos contains not-permitted ITV implicitConfirm");
                }
                if (!CMPObjectIdentifiers.regInfo_utf8Pairs.equals((ASN1Primitive)type)) continue;
                throw new IllegalArgumentException("additionGeneralInfos contains not-permitted ITV utf8Pairs");
            }
        }
        PKIHeaderBuilder hdrBuilder = new PKIHeaderBuilder(2, this.requestor.getName(), this.responder.getName());
        hdrBuilder.setMessageTime(new ASN1GeneralizedTime(new Date()));
        ASN1OctetString tmpTid = tid == null ? new DEROctetString(this.randomTransactionId()) : tid;
        hdrBuilder.setTransactionID(tmpTid);
        hdrBuilder.setSenderNonce(this.randomSenderNonce());
        ArrayList<InfoTypeAndValue> itvs = new ArrayList<InfoTypeAndValue>(2);
        if (addImplictConfirm) {
            itvs.add(CmpUtil.getImplictConfirmGeneralInfo());
        }
        if (utf8Pairs != null) {
            itvs.add(CmpUtil.buildInfoTypeAndValue((CmpUtf8Pairs)utf8Pairs));
        }
        if (additionalGeneralInfos != null) {
            for (InfoTypeAndValue itv : additionalGeneralInfos) {
                if (itv == null) continue;
                itvs.add(itv);
            }
        }
        if (CollectionUtil.isNotEmpty(itvs)) {
            hdrBuilder.setGeneralInfo(itvs.toArray(new InfoTypeAndValue[0]));
        }
        return hdrBuilder.build();
    }

    private byte[] randomTransactionId() {
        byte[] tid = new byte[20];
        this.random.nextBytes(tid);
        return tid;
    }

    private byte[] randomSenderNonce() {
        byte[] bytes = new byte[16];
        this.random.nextBytes(bytes);
        return bytes;
    }

    private ProtectionVerificationResult verifyProtection(String tid, GeneralPKIMessage pkiMessage) throws CMPException, InvalidKeyException {
        SignAlgo protectionAlgo;
        ProtectedPKIMessage protectedMsg = new ProtectedPKIMessage(pkiMessage);
        PKIHeader header = protectedMsg.getHeader();
        if (this.requestor instanceof Requestor.PbmMacCmpRequestor) {
            SignAlgo mac;
            HashAlgo owf;
            if (!protectedMsg.hasPasswordBasedMacProtection()) {
                LOG.warn("NOT_MAC_BASED: {}", (Object)pkiMessage.getHeader().getProtectionAlg().getAlgorithm().getId());
                return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
            }
            Responder.PbmMacCmpResponder macResponder = (Responder.PbmMacCmpResponder)this.responder;
            PBMParameter parameter = PBMParameter.getInstance((Object)pkiMessage.getHeader().getProtectionAlg().getParameters());
            try {
                owf = HashAlgo.getInstance((AlgorithmIdentifier)parameter.getOwf());
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.owf)", (Throwable)ex);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            if (!macResponder.isPbmOwfPermitted(owf)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.owf: {})", (Object)owf);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            try {
                mac = SignAlgo.getInstance((AlgorithmIdentifier)parameter.getMac());
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.mac)", (Throwable)ex);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            if (!macResponder.isPbmMacPermitted(mac)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.mac: {})", (Object)mac);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            PKMACBuilder pkMacBuilder = new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator());
            Requestor.PbmMacCmpRequestor macRequestor = (Requestor.PbmMacCmpRequestor)this.requestor;
            boolean macValid = protectedMsg.verify(pkMacBuilder, macRequestor.getPassword());
            return new ProtectionVerificationResult((Object)this.requestor, macValid ? ProtectionResult.MAC_VALID : ProtectionResult.MAC_INVALID);
        }
        if (protectedMsg.hasPasswordBasedMacProtection()) {
            LOG.warn("NOT_SIGNATURE_BASED: {}", (Object)pkiMessage.getHeader().getProtectionAlg().getAlgorithm().getId());
            return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        if (this.recipientName != null) {
            boolean authorizedResponder;
            if (header.getSender().getTagNo() != 4) {
                authorizedResponder = false;
            } else {
                X500Name msgSender = X500Name.getInstance((Object)header.getSender().getName());
                authorizedResponder = this.recipientName.equals((Object)msgSender);
            }
            if (!authorizedResponder) {
                LOG.warn("tid={}: not authorized responder '{}'", (Object)tid, (Object)header.getSender());
                return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
            }
        }
        Responder.SignaturetCmpResponder sigResponder = (Responder.SignaturetCmpResponder)this.responder;
        try {
            protectionAlgo = SignAlgo.getInstance((AlgorithmIdentifier)protectedMsg.getHeader().getProtectionAlg());
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.warn("tid={}: unknown response protection algorithm: {}", (Object)tid, (Object)ex.getMessage());
            return new ProtectionVerificationResult(null, ProtectionResult.SIGNATURE_INVALID);
        }
        if (!sigResponder.getSigAlgoValidator().isAlgorithmPermitted(protectionAlgo)) {
            LOG.warn("tid={}: response protected by untrusted protection algorithm '{}'", (Object)tid, (Object)protectionAlgo.getJceName());
            return new ProtectionVerificationResult(null, ProtectionResult.SIGNATURE_INVALID);
        }
        X509Cert cert = sigResponder.getCert();
        ContentVerifierProvider verifierProvider = this.securityFactory.getContentVerifierProvider(cert);
        if (verifierProvider == null) {
            LOG.warn("tid={}: not authorized responder '{}'", (Object)tid, (Object)header.getSender());
            return new ProtectionVerificationResult((Object)cert, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        boolean signatureValid = protectedMsg.verify(verifierProvider);
        return new ProtectionVerificationResult((Object)cert, signatureValid ? ProtectionResult.SIGNATURE_VALID : ProtectionResult.SIGNATURE_INVALID);
    }

    private PKIMessage buildMessageWithXipkiAction(int action, ASN1Encodable value) {
        PKIHeader header = this.buildPkiHeader(null);
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1Integer((long)action));
        if (value != null) {
            vec.add(value);
        }
        InfoTypeAndValue itv = new InfoTypeAndValue(ObjectIdentifiers.Xipki.id_xipki_cmp_cmpGenmsg, (ASN1Encodable)new DERSequence(vec));
        GenMsgContent genMsgContent = new GenMsgContent(itv);
        PKIBody body = new PKIBody(21, (ASN1Encodable)genMsgContent);
        return new PKIMessage(header, body);
    }

    private PKIMessage buildMessageWithGeneralMsgContent(ASN1ObjectIdentifier type, ASN1Encodable value) {
        Args.notNull((Object)type, (String)"type");
        PKIHeader header = this.buildPkiHeader(null);
        InfoTypeAndValue itv = value != null ? new InfoTypeAndValue(type, value) : new InfoTypeAndValue(type);
        GenMsgContent genMsgContent = new GenMsgContent(itv);
        PKIBody body = new PKIBody(21, (ASN1Encodable)genMsgContent);
        return new PKIMessage(header, body);
    }

    public boolean isSendRequestorCert() {
        return this.sendRequestorCert;
    }

    public void setSendRequestorCert(boolean sendRequestorCert) {
        this.sendRequestorCert = sendRequestorCert;
    }

    public X509CRLHolder generateCrl(ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        int action = 1;
        PKIMessage request = this.buildMessageWithXipkiAction(action, null);
        VerifiedPkiMessage response = this.signAndSend(request, debug);
        return CmpAgentUtil.evaluateCrlResponse(response, action);
    }

    public X509CRLHolder downloadCurrentCrl(ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        return this.downloadCrl(null, debug);
    }

    public X509CRLHolder downloadCrl(BigInteger crlNumber, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        PKIMessage request;
        Integer action = null;
        if (crlNumber == null) {
            ASN1ObjectIdentifier type = CMPObjectIdentifiers.it_currentCRL;
            request = this.buildMessageWithGeneralMsgContent(type, null);
        } else {
            action = 2;
            request = this.buildMessageWithXipkiAction(action, (ASN1Encodable)new ASN1Integer(crlNumber));
        }
        VerifiedPkiMessage response = this.signAndSend(request, debug);
        return CmpAgentUtil.evaluateCrlResponse(response, action);
    }

    public RevokeCertResponse revokeCertificate(RevokeCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        PKIMessage reqMessage = this.buildRevokeCertRequest((RevokeCertRequest)Args.notNull((Object)request, (String)"request"));
        VerifiedPkiMessage response = this.signAndSend(reqMessage, debug);
        return CmpAgentUtil.parse(response, request.getRequestEntries());
    }

    public RevokeCertResponse unrevokeCertificate(UnrevokeOrRemoveCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        PKIMessage reqMessage = this.buildUnrevokeOrRemoveCertRequest((UnrevokeOrRemoveCertRequest)Args.notNull((Object)request, (String)"request"), CrlReason.REMOVE_FROM_CRL.getCode());
        VerifiedPkiMessage response = this.signAndSend(reqMessage, debug);
        return CmpAgentUtil.parse(response, request.getRequestEntries());
    }

    public RevokeCertResponse removeCertificate(UnrevokeOrRemoveCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        PKIMessage reqMessage = this.buildUnrevokeOrRemoveCertRequest((UnrevokeOrRemoveCertRequest)Args.notNull((Object)request, (String)"request"), -1);
        VerifiedPkiMessage response = this.signAndSend(reqMessage, debug);
        return CmpAgentUtil.parse(response, request.getRequestEntries());
    }

    public EnrollCertResponse requestCertificate(CsrEnrollCertRequest csr, Date notBefore, Date notAfter, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        PKIMessage request = this.buildPkiMessage((CsrEnrollCertRequest)Args.notNull((Object)csr, (String)"csr"), notBefore, notAfter);
        HashMap<BigInteger, String> reqIdIdMap = new HashMap<BigInteger, String>();
        reqIdIdMap.put(MINUS_ONE, csr.getId());
        return this.requestCertificate0(request, reqIdIdMap, 3, debug);
    }

    public EnrollCertResponse requestCertificate(EnrollCertRequest req, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        int exptectedBodyType;
        PKIMessage request = this.buildPkiMessage((EnrollCertRequest)Args.notNull((Object)req, (String)"req"));
        HashMap<BigInteger, String> reqIdIdMap = new HashMap<BigInteger, String>();
        List<EnrollCertRequest.Entry> reqEntries = req.getRequestEntries();
        for (EnrollCertRequest.Entry reqEntry : reqEntries) {
            reqIdIdMap.put(reqEntry.getCertReq().getCertReqId().getValue(), reqEntry.getId());
        }
        switch (req.getType()) {
            case INIT_REQ: {
                exptectedBodyType = 1;
                break;
            }
            case CERT_REQ: {
                exptectedBodyType = 3;
                break;
            }
            case KEY_UPDATE: {
                exptectedBodyType = 8;
                break;
            }
            case CROSS_CERT_REQ: {
                exptectedBodyType = 14;
                break;
            }
            default: {
                throw new IllegalStateException("unknown EnrollCertRequest.Type " + (Object)((Object)req.getType()));
            }
        }
        return this.requestCertificate0(request, reqIdIdMap, exptectedBodyType, debug);
    }

    private EnrollCertResponse requestCertificate0(PKIMessage reqMessage, Map<BigInteger, String> reqIdIdMap, int expectedBodyType, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        VerifiedPkiMessage response = this.signAndSend(reqMessage, debug);
        CmpAgentUtil.checkProtection(response);
        PKIBody respBody = response.getPkiMessage().getBody();
        int bodyType = respBody.getType();
        if (23 == bodyType) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new PkiErrorException(content.getPKIStatusInfo());
        }
        if (expectedBodyType != bodyType) {
            throw new CmpClientException(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, expectedBodyType, 23));
        }
        CertRepMessage certRep = CertRepMessage.getInstance((Object)respBody.getContent());
        CertResponse[] certResponses = certRep.getResponse();
        EnrollCertResponse result = new EnrollCertResponse();
        CMPCertificate[] caPubs = certRep.getCaPubs();
        if (caPubs != null && caPubs.length > 0) {
            for (CMPCertificate caPub : caPubs) {
                if (caPub == null) continue;
                result.addCaCertificate(caPub);
            }
        }
        CertificateConfirmationContentBuilder certConfirmBuilder = null;
        if (!CmpUtil.isImplictConfirm((PKIHeader)response.getPkiMessage().getHeader())) {
            certConfirmBuilder = new CertificateConfirmationContentBuilder();
        }
        boolean requireConfirm = false;
        for (CertResponse certResp : certResponses) {
            ResultEntry resultEntry;
            PKIStatusInfo statusInfo = certResp.getStatus();
            int status = statusInfo.getStatus().intValue();
            BigInteger certReqId = certResp.getCertReqId().getValue();
            String thisId = reqIdIdMap.get(certReqId);
            if (thisId != null) {
                reqIdIdMap.remove(certReqId);
            } else if (reqIdIdMap.size() == 1) {
                thisId = reqIdIdMap.values().iterator().next();
                reqIdIdMap.clear();
            }
            if (thisId == null) continue;
            if (status == 0 || status == 1) {
                CertifiedKeyPair cvk = certResp.getCertifiedKeyPair();
                if (cvk == null) {
                    return null;
                }
                CMPCertificate cmpCert = cvk.getCertOrEncCert().getCertificate();
                if (cmpCert == null) {
                    return null;
                }
                if (this.requestor == null) {
                    result.addResultEntry(new ResultEntry.Error(thisId, -1, 0x40000000, "could not decrypt PrivateKeyInfo/requestor is null"));
                    continue;
                }
                PrivateKeyInfo privKeyInfo = null;
                if (cvk.getPrivateKey() != null) {
                    byte[] decryptedValue;
                    try {
                        if (this.requestor instanceof Requestor.SignatureCmpRequestor) {
                            ConcurrentContentSigner requestSigner = ((Requestor.SignatureCmpRequestor)this.requestor).getSigner();
                            if (!(requestSigner.getSigningKey() instanceof PrivateKey)) {
                                throw new XiSecurityException("no decryption key is configured");
                            }
                            decryptedValue = CmpAgentUtil.decrypt(cvk.getPrivateKey(), (PrivateKey)requestSigner.getSigningKey());
                        } else {
                            decryptedValue = CmpAgentUtil.decrypt(cvk.getPrivateKey(), ((Requestor.PbmMacCmpRequestor)this.requestor).getPassword());
                        }
                    }
                    catch (XiSecurityException ex) {
                        result.addResultEntry(new ResultEntry.Error(thisId, -1, 0x40000000, "could not decrypt PrivateKeyInfo"));
                        continue;
                    }
                    privKeyInfo = PrivateKeyInfo.getInstance((Object)decryptedValue);
                }
                resultEntry = new ResultEntry.EnrollCert(thisId, cmpCert, privKeyInfo, status);
                if (certConfirmBuilder != null) {
                    requireConfirm = true;
                    X509CertificateHolder certHolder = new X509CertificateHolder(cmpCert.getX509v3PKCert());
                    certConfirmBuilder.addAcceptedCertificate(certHolder, certReqId);
                }
            } else {
                PKIFreeText statusString = statusInfo.getStatusString();
                String errorMessage = statusString == null ? null : statusString.getStringAt(0).getString();
                int failureInfo = statusInfo.getFailInfo().intValue();
                resultEntry = new ResultEntry.Error(thisId, status, failureInfo, errorMessage);
            }
            result.addResultEntry(resultEntry);
        }
        if (CollectionUtil.isNotEmpty(reqIdIdMap)) {
            for (BigInteger reqId : reqIdIdMap.keySet()) {
                ResultEntry.Error ere = new ResultEntry.Error(reqIdIdMap.get(reqId), -2);
                result.addResultEntry(ere);
            }
        }
        if (!requireConfirm) {
            return result;
        }
        PKIMessage confirmRequest = this.buildCertConfirmRequest(response.getPkiMessage().getHeader().getTransactionID(), certConfirmBuilder);
        response = this.signAndSend(confirmRequest, debug);
        CmpAgentUtil.checkProtection(response);
        return result;
    }

    private PKIMessage buildCertConfirmRequest(ASN1OctetString tid, CertificateConfirmationContentBuilder certConfirmBuilder) throws CmpClientException {
        CertificateConfirmationContent certConfirm;
        PKIHeader header = this.buildPkiHeader(true, tid, null, null);
        try {
            certConfirm = certConfirmBuilder.build(DIGEST_CALCULATOR_PROVIDER);
        }
        catch (CMPException ex) {
            throw new CmpClientException(ex.getMessage(), ex);
        }
        PKIBody body = new PKIBody(24, (ASN1Encodable)certConfirm.toASN1Structure());
        return new PKIMessage(header, body);
    }

    private PKIMessage buildRevokeCertRequest(RevokeCertRequest request) throws CmpClientException {
        PKIHeader header = this.buildPkiHeader(null);
        List<RevokeCertRequest.Entry> requestEntries = request.getRequestEntries();
        ArrayList<RevDetails> revDetailsArray = new ArrayList<RevDetails>(requestEntries.size());
        for (RevokeCertRequest.Entry requestEntry : requestEntries) {
            Date invalidityDate;
            CertTemplateBuilder certTempBuilder = new CertTemplateBuilder();
            certTempBuilder.setIssuer(requestEntry.getIssuer());
            certTempBuilder.setSerialNumber(new ASN1Integer(requestEntry.getSerialNumber()));
            byte[] aki = requestEntry.getAuthorityKeyIdentifier();
            if (aki != null) {
                Extensions certTempExts = CmpAgentUtil.getCertTempExtensions(aki);
                certTempBuilder.setExtensions(certTempExts);
            }
            int idx = (invalidityDate = requestEntry.getInvalidityDate()) == null ? 1 : 2;
            Extension[] extensions = new Extension[idx];
            try {
                ASN1Enumerated reason = new ASN1Enumerated(requestEntry.getReason());
                extensions[0] = new Extension(Extension.reasonCode, true, (ASN1OctetString)new DEROctetString(reason.getEncoded()));
                if (invalidityDate != null) {
                    ASN1GeneralizedTime time = new ASN1GeneralizedTime(invalidityDate);
                    extensions[1] = new Extension(Extension.invalidityDate, true, (ASN1OctetString)new DEROctetString(time.getEncoded()));
                }
            }
            catch (IOException ex) {
                throw new CmpClientException(ex.getMessage(), ex);
            }
            Extensions exts = new Extensions(extensions);
            RevDetails revDetails = new RevDetails(certTempBuilder.build(), exts);
            revDetailsArray.add(revDetails);
        }
        RevReqContent content = new RevReqContent(revDetailsArray.toArray(new RevDetails[0]));
        PKIBody body = new PKIBody(11, (ASN1Encodable)content);
        return new PKIMessage(header, body);
    }

    private PKIMessage buildUnrevokeOrRemoveCertRequest(UnrevokeOrRemoveCertRequest request, int reasonCode) throws CmpClientException {
        PKIHeader header = this.buildPkiHeader(null);
        List<UnrevokeOrRemoveCertRequest.Entry> requestEntries = request.getRequestEntries();
        ArrayList<RevDetails> revDetailsArray = new ArrayList<RevDetails>(requestEntries.size());
        for (UnrevokeOrRemoveCertRequest.Entry requestEntry : requestEntries) {
            CertTemplateBuilder certTempBuilder = new CertTemplateBuilder();
            certTempBuilder.setIssuer(requestEntry.getIssuer());
            certTempBuilder.setSerialNumber(new ASN1Integer(requestEntry.getSerialNumber()));
            byte[] aki = requestEntry.getAuthorityKeyIdentifier();
            if (aki != null) {
                Extensions certTempExts = CmpAgentUtil.getCertTempExtensions(aki);
                certTempBuilder.setExtensions(certTempExts);
            }
            Extension[] extensions = new Extension[1];
            try {
                ASN1Enumerated reason = new ASN1Enumerated(reasonCode);
                extensions[0] = new Extension(Extension.reasonCode, true, (ASN1OctetString)new DEROctetString(reason.getEncoded()));
            }
            catch (IOException ex) {
                throw new CmpClientException(ex.getMessage(), ex);
            }
            Extensions exts = new Extensions(extensions);
            RevDetails revDetails = new RevDetails(certTempBuilder.build(), exts);
            revDetailsArray.add(revDetails);
        }
        RevReqContent content = new RevReqContent(revDetailsArray.toArray(new RevDetails[0]));
        PKIBody body = new PKIBody(11, (ASN1Encodable)content);
        return new PKIMessage(header, body);
    }

    private PKIMessage buildPkiMessage(CsrEnrollCertRequest csr, Date notBefore, Date notAfter) {
        CmpUtf8Pairs utf8Pairs = new CmpUtf8Pairs("certprofile", csr.getCertprofile());
        if (notBefore != null) {
            utf8Pairs.putUtf8Pair("notbefore", DateUtil.toUtcTimeyyyyMMddhhmmss((Date)notBefore));
        }
        if (notAfter != null) {
            utf8Pairs.putUtf8Pair("notafter", DateUtil.toUtcTimeyyyyMMddhhmmss((Date)notAfter));
        }
        PKIHeader header = this.buildPkiHeader(true, null, utf8Pairs, new InfoTypeAndValue[0]);
        PKIBody body = new PKIBody(4, (ASN1Encodable)csr.getCsr());
        return new PKIMessage(header, body);
    }

    private PKIMessage buildPkiMessage(EnrollCertRequest req) {
        int bodyType;
        PKIHeader header = this.buildPkiHeader(true, null);
        List<EnrollCertRequest.Entry> reqEntries = req.getRequestEntries();
        CertReqMsg[] certReqMsgs = new CertReqMsg[reqEntries.size()];
        for (int i = 0; i < reqEntries.size(); ++i) {
            EnrollCertRequest.Entry reqEntry = reqEntries.get(i);
            AttributeTypeAndValue[] reginfo = null;
            CmpUtf8Pairs utf8Pairs = new CmpUtf8Pairs();
            if (reqEntry.getCertprofile() != null) {
                utf8Pairs.putUtf8Pair("certprofile", reqEntry.getCertprofile());
            }
            if (reqEntry.isCaGenerateKeypair()) {
                utf8Pairs.putUtf8Pair("ca-generate-keypair", "true");
            }
            if (!utf8Pairs.names().isEmpty()) {
                AttributeTypeAndValue atv = CmpUtil.buildAttributeTypeAndValue((CmpUtf8Pairs)utf8Pairs);
                reginfo = new AttributeTypeAndValue[]{atv};
            }
            certReqMsgs[i] = new CertReqMsg(reqEntry.getCertReq(), reqEntry.getPopo(), reginfo);
        }
        switch (req.getType()) {
            case INIT_REQ: {
                bodyType = 0;
                break;
            }
            case CERT_REQ: {
                bodyType = 2;
                break;
            }
            case KEY_UPDATE: {
                bodyType = 7;
                break;
            }
            case CROSS_CERT_REQ: {
                bodyType = 13;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown EnrollCertRequest.Type " + (Object)((Object)req.getType()));
            }
        }
        PKIBody body = new PKIBody(bodyType, (ASN1Encodable)new CertReqMessages(certReqMsgs));
        return new PKIMessage(header, body);
    }

    public CaConf.CaInfo retrieveCaInfo(String caName, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notBlank((String)caName, (String)"caName");
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1Integer(3L));
        DERSequence acceptVersions = new DERSequence(vec);
        int action = 3;
        PKIMessage request = this.buildMessageWithXipkiAction(action, (ASN1Encodable)acceptVersions);
        VerifiedPkiMessage response = this.signAndSend(request, debug);
        return CmpAgentUtil.retrieveCaInfo(response, caName);
    }
}

