/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.internal;

import java.security.SecureRandom;
import org.bouncycastle.asn1.cmp.PBMParameter;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

abstract class Requestor {
    private final GeneralName name;
    private final boolean signRequest;

    protected Requestor(boolean signRequest, GeneralName name) {
        this.signRequest = signRequest;
        this.name = (GeneralName)Args.notNull((Object)name, (String)"name");
    }

    protected Requestor(boolean signRequest, X500Name name) {
        this.signRequest = signRequest;
        this.name = new GeneralName((X500Name)Args.notNull((Object)name, (String)"name"));
    }

    public boolean signRequest() {
        return this.signRequest;
    }

    public GeneralName getName() {
        return this.name;
    }

    static class SignatureCmpRequestor
    extends Requestor {
        private final ConcurrentContentSigner signer;

        SignatureCmpRequestor(X509Cert cert) {
            super(false, ((X509Cert)Args.notNull((Object)cert, (String)"cert")).getSubject());
            this.signer = null;
        }

        public SignatureCmpRequestor(boolean signRequest, ConcurrentContentSigner signer, SecurityFactory securityFactory) {
            super(signRequest, SignatureCmpRequestor.getSignerSubject(signer));
            this.signer = signer;
        }

        public ConcurrentContentSigner getSigner() {
            return this.signer;
        }

        private static X500Name getSignerSubject(ConcurrentContentSigner signer) {
            Args.notNull((Object)signer, (String)"signer");
            if (signer.getCertificate() == null) {
                throw new IllegalArgumentException("requestor without certificate is not allowed");
            }
            return signer.getCertificate().getSubject();
        }
    }

    static class PbmMacCmpRequestor
    extends Requestor {
        private final SecureRandom random = new SecureRandom();
        private final char[] password;
        private final byte[] senderKID;
        private final HashAlgo owf;
        private final int iterationCount;
        private final SignAlgo mac;

        PbmMacCmpRequestor(boolean signRequest, X500Name x500name, char[] password, byte[] senderKID, HashAlgo owf, int iterationCount, SignAlgo mac) {
            super(signRequest, x500name);
            this.password = password;
            this.senderKID = senderKID;
            this.owf = owf;
            this.iterationCount = iterationCount;
            this.mac = mac;
        }

        public char[] getPassword() {
            return this.password;
        }

        public byte[] getSenderKID() {
            return this.senderKID;
        }

        public PBMParameter getParameter() {
            return new PBMParameter(this.randomSalt(), this.owf.getAlgorithmIdentifier(), this.iterationCount, this.mac.getAlgorithmIdentifier());
        }

        public HashAlgo getOwf() {
            return this.owf;
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        public SignAlgo getMac() {
            return this.mac;
        }

        private byte[] randomSalt() {
            byte[] bytes = new byte[64];
            this.random.nextBytes(bytes);
            return bytes;
        }
    }
}

