/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.cmpclient.CertprofileInfo;
import org.xipki.cmpclient.CmpClientConf;
import org.xipki.cmpclient.CmpClientException;
import org.xipki.cmpclient.PkiErrorException;
import org.xipki.cmpclient.internal.CaConf;
import org.xipki.cmpclient.internal.CmpAgent;
import org.xipki.cmpclient.internal.Requestor;
import org.xipki.cmpclient.internal.Responder;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.CollectionAlgorithmValidator;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.FileOrBinary;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;
import org.xipki.util.ValidatableConf;
import org.xipki.util.http.HostnameVerifiers;
import org.xipki.util.http.SSLContextBuilder;

final class CmpClientConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(CmpClientConfigurer.class);
    private static final X500Name NULL_GENERALNAME = new X500Name(new RDN[0]);
    private final Map<String, CaConf> casMap = new HashMap<String, CaConf>();
    private final Set<String> autoConfCaNames = new HashSet<String>();
    private SecurityFactory securityFactory;
    private String confFile;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    CmpClientConfigurer() {
    }

    void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    Map<String, CaConf> getCasMap() {
        return this.casMap;
    }

    CaConf getCaConf(String name) {
        return this.casMap.get(name.toLowerCase());
    }

    void close() {
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
            while (!this.scheduledThreadPoolExecutor.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.warn("interrupted: {}", (Object)ex.getMessage());
                }
            }
            this.scheduledThreadPoolExecutor = null;
        }
    }

    synchronized void initIfNotInitialized() throws CmpClientException {
        if (this.confFile == null) {
            throw new IllegalStateException("confFile is not set");
        }
        if (this.securityFactory == null) {
            throw new IllegalStateException("securityFactory is not set");
        }
        if (this.initialized.get()) {
            return;
        }
        if (!this.init()) {
            throw new CmpClientException("initialization of CA client failed");
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized boolean init() {
        CmpClientConf conf;
        this.casMap.clear();
        this.autoConfCaNames.clear();
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdownNow();
        }
        this.initialized.set(false);
        LOG.info("initializing ...");
        File configFile = new File(IoUtil.expandFilepath((String)this.confFile));
        if (!configFile.exists()) {
            LOG.error("could not find configuration file {}", (Object)this.confFile);
            return false;
        }
        try {
            conf = CmpClientConfigurer.parse(Files.newInputStream(configFile.toPath(), new OpenOption[0]));
        }
        catch (IOException | CmpClientException ex) {
            LOG.error("could not read file {}", (Object)this.confFile);
            return false;
        }
        if (CollectionUtil.isEmpty(conf.getCas())) {
            LOG.warn("no CA is configured");
        }
        HashMap<String, SslConf> sslConfs = new HashMap<String, SslConf>();
        if (conf.getSsls() != null) {
            for (CmpClientConf.Ssl ssl : conf.getSsls()) {
                SSLContextBuilder sSLContextBuilder = new SSLContextBuilder();
                if (ssl.getStoreType() != null) {
                    sSLContextBuilder.setKeyStoreType(ssl.getStoreType());
                }
                try {
                    Throwable throwable;
                    ByteArrayInputStream is;
                    if (ssl.getKeystore() != null) {
                        char[] cArray = ssl.getKeystorePassword() == null ? null : ssl.getKeystorePassword().toCharArray();
                        is = new ByteArrayInputStream(ssl.getKeystore().readContent());
                        throwable = null;
                        try {
                            sSLContextBuilder.loadKeyMaterial((InputStream)is, cArray, cArray);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        ((InputStream)is).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    ((InputStream)is).close();
                                }
                            }
                        }
                    }
                    if (ssl.getTruststore() != null) {
                        char[] cArray = ssl.getTruststorePassword() == null ? null : ssl.getTruststorePassword().toCharArray();
                        is = new ByteArrayInputStream(ssl.getTruststore().readContent());
                        throwable = null;
                        try {
                            sSLContextBuilder.loadTrustMaterial((InputStream)is, cArray);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        ((InputStream)is).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    ((InputStream)is).close();
                                }
                            }
                        }
                    }
                    SSLSocketFactory sSLSocketFactory = sSLContextBuilder.build().getSocketFactory();
                    HostnameVerifier hostnameVerifier = HostnameVerifiers.createHostnameVerifier((String)ssl.getHostnameVerifier());
                    sslConfs.put(ssl.getName(), new SslConf(sSLSocketFactory, hostnameVerifier));
                }
                catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | ObjectCreationException throwable) {
                    LOG.error("could not initialize SSL configuration " + ssl.getName() + ": " + throwable.getMessage(), throwable);
                    return false;
                }
            }
        }
        HashMap<String, Responder.PbmMacCmpResponder> responders = new HashMap<String, Responder.PbmMacCmpResponder>();
        for (CmpClientConf.Responder responder : conf.getResponders()) {
            Responder responder2;
            X509Cert x509Cert;
            try {
                x509Cert = X509Util.parseCert((byte[])responder.getCert().readContent());
            }
            catch (IOException | CertificateException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not configure responder " + responder.getName()));
                return false;
            }
            if (responder.getSignature() != null) {
                CollectionAlgorithmValidator sigAlgoValidator;
                HashSet<String> algoNames = new HashSet<String>(responder.getSignature().getSignatureAlgos());
                HashSet<SignAlgo> algos = new HashSet<SignAlgo>();
                for (String algoName : algoNames) {
                    SignAlgo sa;
                    try {
                        sa = SignAlgo.getInstance((String)algoName);
                    }
                    catch (NoSuchAlgorithmException ex) {
                        LOG.warn("algorithm is not supported {}, ignore it", (Object)algoName);
                        continue;
                    }
                    algos.add(sa);
                }
                try {
                    if (algos.isEmpty()) {
                        throw new NoSuchAlgorithmException("none of the signature algorithms " + algoNames + " are supported");
                    }
                    sigAlgoValidator = new CollectionAlgorithmValidator(algos);
                }
                catch (NoSuchAlgorithmException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not initialize CollectionAlgorithmValidator");
                    return false;
                }
                responder2 = new Responder.SignatureCmpResponder(x509Cert, (AlgorithmValidator)sigAlgoValidator);
            } else {
                CmpClientConf.Responder.PbmMac mac = responder.getPbmMac();
                X500Name subject = x509Cert.getSubject();
                try {
                    responder2 = new Responder.PbmMacCmpResponder(subject, mac.getOwfAlgos(), mac.getMacAlgos());
                }
                catch (NoSuchAlgorithmException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not initialize PbmMacCmpResponder");
                    return false;
                }
            }
            responders.put(responder.getName(), (Responder.PbmMacCmpResponder)responder2);
        }
        HashSet<CaConf> hashSet = new HashSet<CaConf>();
        for (CmpClientConf.Ca ca : conf.getCas()) {
            String caName = ca.getName();
            try {
                X509Cert cert;
                Responder responder = (Responder)responders.get(ca.getResponder());
                if (responder == null) {
                    LOG.error("no responder named {} is configured", (Object)ca.getResponder());
                    return false;
                }
                SSLSocketFactory sslSocketFactory = null;
                HostnameVerifier hostnameVerifier = null;
                if (ca.getSsl() != null) {
                    SslConf sslConf = (SslConf)sslConfs.get(ca.getSsl());
                    if (sslConf == null) {
                        LOG.error("no ssl named {} is configured", (Object)ca.getSsl());
                        return false;
                    }
                    sslSocketFactory = sslConf.sslSocketFactory;
                    hostnameVerifier = sslConf.hostnameVerifier;
                }
                CaConf ca2 = new CaConf(caName, ca.getUrl(), ca.getHealthUrl(), ca.getRequestor(), responder, sslSocketFactory, hostnameVerifier);
                CmpClientConf.Certs caCertchain = ca.getCaCertchain();
                if (caCertchain == null || caCertchain.isAutoconf()) {
                    ca2.setCertAutoconf(true);
                } else {
                    ca2.setCertAutoconf(false);
                    List<FileOrBinary> certchainConf = ca.getCaCertchain().getCertificates();
                    X509Cert caCert = X509Util.parseCert((byte[])certchainConf.get(0).readContent());
                    HashSet<X509Cert> issuers = new HashSet<X509Cert>();
                    int size = certchainConf.size();
                    if (size > 1) {
                        for (int i = 1; i < size; ++i) {
                            cert = X509Util.parseCert((byte[])certchainConf.get(i).readContent());
                            issuers.add(cert);
                        }
                        X509Cert[] certchain = X509Util.buildCertPath((X509Cert)caCert, issuers);
                        if (certchain.length != size) {
                            LOG.error("cannot build certpath containing all configured issuers");
                        }
                        ca2.setCertchain(Arrays.asList(certchain));
                    } else {
                        ca2.setCertchain(Collections.singletonList(caCert));
                    }
                }
                CmpClientConf.Certs dhpocCerts = ca.getDhpocCerts();
                if (dhpocCerts == null || dhpocCerts.isAutoconf()) {
                    ca2.setDhpocAutoconf(true);
                } else {
                    ca2.setDhpocAutoconf(false);
                    LinkedList<X509Cert> dhpocs = new LinkedList<X509Cert>();
                    List<FileOrBinary> list = dhpocCerts.getCertificates();
                    if (list != null) {
                        for (FileOrBinary m : list) {
                            cert = X509Util.parseCert((byte[])m.readContent());
                            dhpocs.add(cert);
                        }
                    }
                    ca2.setDhpocs(dhpocs);
                }
                CmpClientConf.Cmpcontrol cmpCtrlType = ca.getCmpcontrol();
                if (cmpCtrlType == null || cmpCtrlType.isAutoconf()) {
                    ca2.setCmpControlAutoconf(true);
                } else {
                    ca2.setCmpControlAutoconf(false);
                    Boolean tmpBo = cmpCtrlType.getRrAkiRequired();
                    CaConf.CmpControl control = new CaConf.CmpControl(tmpBo != null && tmpBo != false);
                    ca2.setCmpControl(control);
                }
                CmpClientConf.Certprofiles certprofilesType = ca.getCertprofiles();
                if (certprofilesType == null || certprofilesType.isAutoconf()) {
                    ca2.setCertprofilesAutoconf(true);
                } else {
                    ca2.setCertprofilesAutoconf(false);
                    List<CmpClientConf.Certprofile> types = certprofilesType.getProfiles();
                    HashSet<CertprofileInfo> profiles = new HashSet<CertprofileInfo>(types.size());
                    for (CmpClientConf.Certprofile m : types) {
                        String conf0 = null;
                        if (m.getConf() != null && (conf0 = m.getConf().getValue()) == null) {
                            conf0 = StringUtil.toUtf8String((byte[])IoUtil.read((String)m.getConf().getFile()));
                        }
                        CertprofileInfo profile = new CertprofileInfo(m.getName(), m.getType(), conf0);
                        profiles.add(profile);
                    }
                    ca2.setCertprofiles(profiles);
                }
                hashSet.add(ca2);
                if (!ca2.isCertAutoconf() && !ca2.isCertprofilesAutoconf() && !ca2.isCmpControlAutoconf() && !ca2.isDhpocAutoconf()) continue;
                this.autoConfCaNames.add(caName);
            }
            catch (IOException | CertPathBuilderException | CertificateException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not configure CA " + caName));
                return false;
            }
        }
        HashMap<String, Requestor.SignatureCmpRequestor> hashMap = new HashMap<String, Requestor.SignatureCmpRequestor>();
        for (CmpClientConf.Requestor requestorConf : conf.getRequestors()) {
            Requestor requestor;
            ValidatableConf cf;
            boolean signRequest = requestorConf.isSignRequest();
            String name = requestorConf.getName();
            if (requestorConf.getSignature() != null) {
                cf = requestorConf.getSignature();
                X509Cert requestorCert = null;
                if (cf.getCert() != null) {
                    try {
                        requestorCert = X509Util.parseCert((byte[])cf.getCert().getBinary());
                    }
                    catch (Exception ex) {
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not parse certificate of rquestor " + requestorConf.getName()));
                        return false;
                    }
                }
                if (cf.getSignerType() != null) {
                    try {
                        SignerConf signerConf = new SignerConf(cf.getSignerConf());
                        ConcurrentContentSigner requestorSigner = this.securityFactory.createSigner(cf.getSignerType(), signerConf, requestorCert);
                        requestor = new Requestor.SignatureCmpRequestor(signRequest, requestorSigner);
                    }
                    catch (ObjectCreationException ex) {
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not create rquestor " + requestorConf.getName()));
                        return false;
                    }
                } else {
                    if (signRequest) {
                        LOG.error("signer of requestor must be configured");
                        return false;
                    }
                    if (requestorCert == null) {
                        LOG.error("at least one of certificate and signer of requestor must be configured");
                        return false;
                    }
                    requestor = new Requestor.SignatureCmpRequestor(requestorCert);
                }
            } else {
                SignAlgo macAlgo;
                HashAlgo owfAlgo;
                cf = requestorConf.getPbmMac();
                try {
                    owfAlgo = HashAlgo.getInstance((String)cf.getOwf());
                }
                catch (NoSuchAlgorithmException ex1) {
                    LOG.error("Unknown OWF algorithm {}", (Object)cf.getOwf());
                    return false;
                }
                try {
                    macAlgo = SignAlgo.getInstance((String)cf.getMac());
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.error("Unknown MAC algorithm {}", (Object)cf.getMac());
                    return false;
                }
                requestor = new Requestor.PbmMacCmpRequestor(signRequest, NULL_GENERALNAME, cf.getPassword().toCharArray(), cf.getKid(), owfAlgo, cf.getIterationCount(), macAlgo);
            }
            hashMap.put(name, (Requestor.SignatureCmpRequestor)requestor);
        }
        for (CaConf ca : hashSet) {
            if (this.casMap.containsKey(ca.getName())) {
                LOG.error("duplicate CAs with the same name {}", (Object)ca.getName());
                return false;
            }
            String requestorName = ca.getRequestorName();
            if (!hashMap.containsKey(requestorName)) {
                LOG.error("could not find requestor named {} for CA {}", (Object)requestorName, (Object)ca.getName());
                return false;
            }
            CmpAgent agent = new CmpAgent((Requestor)hashMap.get(requestorName), ca.getResponder(), ca.getUrl(), this.securityFactory, ca.getSslSocketFactory(), ca.getHostnameVerifier());
            ca.setAgent(agent);
            this.casMap.put(ca.getName(), ca);
        }
        if (!this.autoConfCaNames.isEmpty()) {
            void var7_30;
            Integer n = conf.getCainfoUpdateInterval();
            if (n == null) {
                Integer n2 = 10;
            } else if (n <= 0) {
                Integer n3 = 0;
            } else if (n < 5) {
                Integer n4 = 5;
            }
            LOG.info("configuring CAs {}", this.autoConfCaNames);
            Set<String> failedCaNames = this.autoConfCas(this.autoConfCaNames);
            if (CollectionUtil.isNotEmpty(failedCaNames)) {
                LOG.error("could not configure following CAs {}", failedCaNames);
                return false;
            }
            if (var7_30.intValue() > 0) {
                this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new ClientConfigUpdater(), var7_30.intValue(), var7_30.intValue(), TimeUnit.MINUTES);
            }
        }
        this.initialized.set(true);
        LOG.info("initialized");
        return true;
    }

    void setConfFile(String confFile) {
        this.confFile = Args.notBlank((String)confFile, (String)"confFile");
    }

    private static CmpClientConf parse(InputStream configStream) throws CmpClientException {
        CmpClientConf conf;
        try {
            conf = (CmpClientConf)((Object)JSON.parseObject((InputStream)configStream, CmpClientConf.class, (Feature[])new Feature[0]));
            conf.validate();
        }
        catch (IOException | RuntimeException | InvalidConfException ex) {
            throw new CmpClientException("parsing profile failed, message: " + ex.getMessage(), ex);
        }
        finally {
            try {
                configStream.close();
            }
            catch (IOException ex) {
                LOG.warn("could not close confStream: {}", (Object)ex.getMessage());
            }
        }
        for (CmpClientConf.Requestor requestor : conf.getRequestors()) {
            requestor.setName(requestor.getName().toLowerCase());
        }
        for (CmpClientConf.Responder responder : conf.getResponders()) {
            responder.setName(responder.getName().toLowerCase());
        }
        for (CmpClientConf.Ca ca : conf.getCas()) {
            ca.setName(ca.getName().toLowerCase());
            ca.setRequestor(ca.getRequestor().toLowerCase());
            ca.setResponder(ca.getResponder().toLowerCase());
        }
        return conf;
    }

    private Set<String> autoConfCas(Set<String> caNames) {
        if (caNames.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> caNamesWithError = new HashSet<String>();
        for (String name : caNames) {
            CaConf ca = this.casMap.get(name);
            try {
                CaConf.CaInfo caInfo = ca.getAgent().retrieveCaInfo(name, null);
                if (ca.isCertAutoconf()) {
                    ca.setCertchain(caInfo.getCertchain());
                }
                if (ca.isCertprofilesAutoconf()) {
                    ca.setCertprofiles(caInfo.getCertprofiles());
                }
                if (ca.isCmpControlAutoconf()) {
                    ca.setCmpControl(caInfo.getCmpControl());
                }
                if (ca.isDhpocAutoconf()) {
                    ca.setDhpocs(caInfo.getDhpocs());
                }
                LOG.info("retrieved CAInfo for CA " + name);
            }
            catch (RuntimeException | CertificateEncodingException | CmpClientException | PkiErrorException ex) {
                caNamesWithError.add(name);
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not retrieve CAInfo for CA " + name));
            }
        }
        return caNamesWithError;
    }

    private static class SslConf {
        private final SSLSocketFactory sslSocketFactory;
        private final HostnameVerifier hostnameVerifier;

        SslConf(SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) {
            this.sslSocketFactory = sslSocketFactory;
            this.hostnameVerifier = hostnameVerifier;
        }
    }

    private class ClientConfigUpdater
    implements Runnable {
        private static final long MINUTE = 60000L;
        private final AtomicBoolean inProcess = new AtomicBoolean(false);
        private long lastUpdate;

        ClientConfigUpdater() {
        }

        @Override
        public void run() {
            if (this.inProcess.get()) {
                return;
            }
            this.inProcess.set(true);
            try {
                if (System.currentTimeMillis() - this.lastUpdate < 120000L) {
                    return;
                }
                LOG.info("scheduled configuring CAs {}", (Object)CmpClientConfigurer.this.autoConfCaNames);
                Set failedCaNames = CmpClientConfigurer.this.autoConfCas(CmpClientConfigurer.this.autoConfCaNames);
                if (CollectionUtil.isNotEmpty((Collection)failedCaNames)) {
                    LOG.warn("could not configure following CAs {}", (Object)failedCaNames);
                }
            }
            finally {
                this.lastUpdate = System.currentTimeMillis();
                this.inProcess.set(false);
            }
        }
    }
}

