/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient;

import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.xipki.security.cmp.PkiStatusInfo;
import org.xipki.security.util.CmpFailureUtil;

public class PkiErrorException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final int status;
    private final int pkiFailureInfo;
    private final String statusMessage;

    public PkiErrorException(PKIStatusInfo statusInfo) {
        this(new PkiStatusInfo(statusInfo));
    }

    public PkiErrorException(PkiStatusInfo statusInfo) {
        this(statusInfo.status(), statusInfo.pkiFailureInfo(), statusInfo.statusMessage());
    }

    public PkiErrorException(int status, int pkiFailureInfo, String statusMessage) {
        super(CmpFailureUtil.formatPkiStatusInfo((int)status, (int)pkiFailureInfo, (String)statusMessage));
        this.status = status;
        this.pkiFailureInfo = pkiFailureInfo;
        this.statusMessage = statusMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public int getPkiFailureInfo() {
        return this.pkiFailureInfo;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }
}

