/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient;

import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.cmpclient.IdentifiedObject;
import org.xipki.util.Args;

public class UnrevokeOrRemoveCertRequest {
    private final List<Entry> requestEntries = new LinkedList<Entry>();

    public boolean addRequestEntry(Entry requestEntry) {
        Args.notNull((Object)requestEntry, (String)"requestEntry");
        for (Entry re : this.requestEntries) {
            if (!re.getId().equals(requestEntry.getId())) continue;
            return false;
        }
        this.requestEntries.add(requestEntry);
        return true;
    }

    public List<Entry> getRequestEntries() {
        return Collections.unmodifiableList(this.requestEntries);
    }

    public static class Entry
    extends IdentifiedObject {
        private final X500Name issuer;
        private final BigInteger serialNumber;
        private byte[] authorityKeyIdentifier;

        public Entry(String id, X500Name issuer, BigInteger serialNumber) {
            super(id);
            this.serialNumber = (BigInteger)Args.notNull((Object)serialNumber, (String)"serialNumber");
            this.issuer = (X500Name)Args.notNull((Object)issuer, (String)"issuer");
        }

        public X500Name getIssuer() {
            return this.issuer;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        public byte[] getAuthorityKeyIdentifier() {
            return this.authorityKeyIdentifier;
        }

        public void setAuthorityKeyIdentifier(byte[] authorityKeyIdentifier) {
            this.authorityKeyIdentifier = authorityKeyIdentifier;
        }
    }
}

