/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.GenRepContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cmp.RevRepContent;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.crmf.EncryptedKey;
import org.bouncycastle.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.bc.BcPasswordEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyAgreeEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher;
import org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.operator.DefaultSecretKeySizeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.cmpclient.CertprofileInfo;
import org.xipki.cmpclient.CmpClientException;
import org.xipki.cmpclient.PkiErrorException;
import org.xipki.cmpclient.UnrevokeOrRemoveCertRequest;
import org.xipki.cmpclient.internal.CaConf;
import org.xipki.cmpclient.internal.ResultEntry;
import org.xipki.cmpclient.internal.RevokeCertResponse;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.cmp.ProtectionResult;
import org.xipki.security.cmp.ProtectionVerificationResult;
import org.xipki.security.cmp.VerifiedPkiMessage;
import org.xipki.security.util.CmpFailureUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

class CmpAgentUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CmpAgentUtil.class);
    private static final DefaultSecretKeySizeProvider KEYSIZE_PROVIDER = new DefaultSecretKeySizeProvider();
    protected static final int PKISTATUS_RESPONSE_ERROR = -1;

    CmpAgentUtil() {
    }

    private static ASN1Encodable extractGeneralRepContent(VerifiedPkiMessage response, String expectedType) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)response, (String)"response");
        Args.notNull((Object)expectedType, (String)"expectedType");
        CmpAgentUtil.checkProtection(response);
        PKIBody respBody = response.getPkiMessage().getBody();
        int bodyType = respBody.getType();
        if (23 == bodyType) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new CmpClientException(CmpFailureUtil.formatPkiStatusInfo((PKIStatusInfo)content.getPKIStatusInfo()));
        }
        if (22 != bodyType) {
            throw new CmpClientException(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, 22, 23));
        }
        GenRepContent genRep = GenRepContent.getInstance((Object)respBody.getContent());
        InfoTypeAndValue[] itvs = genRep.toInfoTypeAndValueArray();
        InfoTypeAndValue itv = null;
        if (itvs != null && itvs.length > 0) {
            for (InfoTypeAndValue entry : itvs) {
                if (!expectedType.equals(entry.getInfoType().getId())) continue;
                itv = entry;
                break;
            }
        }
        if (itv == null) {
            throw new CmpClientException("the response does not contain InfoTypeAndValue " + expectedType);
        }
        return itv.getInfoValue();
    }

    static ASN1Encodable extractXipkiActionRepContent(VerifiedPkiMessage response) throws CmpClientException, PkiErrorException {
        ASN1Encodable itvValue = CmpAgentUtil.extractGeneralRepContent((VerifiedPkiMessage)Args.notNull((Object)response, (String)"response"), ObjectIdentifiers.Xipki.id_xipki_cmp_cmpGenmsg.getId());
        return CmpAgentUtil.extractXiActionContent(itvValue, 3);
    }

    private static ASN1Encodable extractXiActionContent(ASN1Encodable itvValue, int action) throws CmpClientException {
        int tmpAction;
        ASN1Sequence seq;
        try {
            seq = ASN1Sequence.getInstance((Object)Args.notNull((Object)itvValue, (String)"itvValue"));
        }
        catch (IllegalArgumentException ex) {
            throw new CmpClientException("invalid syntax of the response");
        }
        int size = seq.size();
        if (size != 1 && size != 2) {
            throw new CmpClientException("invalid syntax of the response");
        }
        try {
            tmpAction = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue().intValue();
        }
        catch (IllegalArgumentException ex) {
            throw new CmpClientException("invalid syntax of the response");
        }
        if (action != tmpAction) {
            throw new CmpClientException("received XiPKI action '" + tmpAction + "' instead the expected '" + action + "'");
        }
        return size == 1 ? null : seq.getObjectAt(1);
    }

    static void checkProtection(VerifiedPkiMessage response) throws PkiErrorException {
        boolean valid;
        Args.notNull((Object)response, (String)"response");
        if (!response.hasProtection()) {
            return;
        }
        ProtectionVerificationResult protectionVerificationResult = response.getProtectionVerificationResult();
        if (protectionVerificationResult == null) {
            valid = false;
        } else {
            ProtectionResult protectionResult = protectionVerificationResult.getProtectionResult();
            boolean bl = valid = protectionResult == ProtectionResult.MAC_VALID || protectionResult == ProtectionResult.SIGNATURE_VALID;
        }
        if (!valid) {
            throw new PkiErrorException(-1, 64, "message check of the response failed");
        }
    }

    static byte[] decrypt(EncryptedKey ek, char[] password) throws XiSecurityException {
        ASN1Encodable ekValue = ek.getValue();
        if (ekValue instanceof EnvelopedData) {
            return CmpAgentUtil.decrypt((EnvelopedData)ekValue, password);
        }
        return CmpAgentUtil.decrypt((EncryptedValue)ekValue, password);
    }

    private static byte[] decrypt(EnvelopedData ed0, char[] password) throws XiSecurityException {
        try {
            ContentInfo ci = new ContentInfo(CMSObjectIdentifiers.envelopedData, (ASN1Encodable)ed0);
            CMSEnvelopedData ed = new CMSEnvelopedData(ci);
            RecipientInformationStore recipients = ed.getRecipientInfos();
            Iterator it = recipients.getRecipients().iterator();
            PasswordRecipientInformation recipient = (PasswordRecipientInformation)it.next();
            return recipient.getContent((Recipient)new BcPasswordEnvelopedRecipient(password));
        }
        catch (CMSException ex) {
            throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static byte[] decrypt(EncryptedValue ev, char[] password) throws XiSecurityException {
        AlgorithmIdentifier symmAlg = ev.getSymmAlg();
        if (!PKCSObjectIdentifiers.id_PBES2.equals((ASN1Primitive)symmAlg.getAlgorithm())) {
            throw new XiSecurityException("unsupported symmAlg " + symmAlg.getAlgorithm().getId());
        }
        PBES2Parameters alg = PBES2Parameters.getInstance((Object)symmAlg.getParameters());
        PBKDF2Params func = PBKDF2Params.getInstance((Object)alg.getKeyDerivationFunc().getParameters());
        AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance((Object)alg.getEncryptionScheme());
        try {
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(alg.getKeyDerivationFunc().getAlgorithm().getId());
            int iterations = func.getIterationCount().intValue();
            SecretKey key = keyFact.generateSecret((KeySpec)new PBKDF2KeySpec(password, func.getSalt(), iterations, KEYSIZE_PROVIDER.getKeySize(encScheme), func.getPrf()));
            key = new SecretKeySpec(key.getEncoded(), "AES");
            String cipherAlgOid = alg.getEncryptionScheme().getAlgorithm().getId();
            Cipher cipher = Cipher.getInstance(cipherAlgOid);
            ASN1Encodable encParams = alg.getEncryptionScheme().getParameters();
            GCMParameters gcmParameters = GCMParameters.getInstance((Object)encParams);
            GCMParameterSpec gcmParamSpec = new GCMParameterSpec(gcmParameters.getIcvLen() * 8, gcmParameters.getNonce());
            cipher.init(2, (Key)key, gcmParamSpec);
            return cipher.doFinal(ev.getEncValue().getOctets());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new XiSecurityException("Error while decrypting the EncryptedValue", (Throwable)ex);
        }
    }

    static byte[] decrypt(EncryptedKey ek, PrivateKey decKey) throws XiSecurityException {
        ASN1Encodable ekValue = ek.getValue();
        if (ekValue instanceof EnvelopedData) {
            return CmpAgentUtil.decrypt((EnvelopedData)ekValue, decKey);
        }
        return CmpAgentUtil.decrypt((EncryptedValue)ekValue, decKey);
    }

    private static byte[] decrypt(EnvelopedData ed0, PrivateKey decKey) throws XiSecurityException {
        try {
            ContentInfo ci = new ContentInfo(CMSObjectIdentifiers.envelopedData, (ASN1Encodable)ed0);
            CMSEnvelopedData ed = new CMSEnvelopedData(ci);
            RecipientInformationStore recipients = ed.getRecipientInfos();
            Iterator it = recipients.getRecipients().iterator();
            RecipientInformation ri = (RecipientInformation)it.next();
            ASN1ObjectIdentifier encAlg = ri.getKeyEncryptionAlgorithm().getAlgorithm();
            Object recipient = encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA1KDF) || encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA224KDF) || encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA256KDF) || encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA384KDF) || encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA384KDF) || encAlg.equals((ASN1Primitive)CMSAlgorithm.ECDH_SHA512KDF) ? new JceKeyAgreeEnvelopedRecipient(decKey).setProvider("BC") : new JceKeyTransEnvelopedRecipient(decKey).setProvider("BC");
            return ri.getContent((Recipient)recipient);
        }
        catch (CMSException ex) {
            throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static byte[] decrypt(EncryptedValue ev, PrivateKey decKey) throws XiSecurityException {
        AlgorithmIdentifier keyAlg = ev.getKeyAlg();
        ASN1ObjectIdentifier keyOid = keyAlg.getAlgorithm();
        try {
            byte[] symmKey;
            if (decKey instanceof RSAPrivateKey) {
                Cipher keyCipher;
                if (keyOid.equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSAES_OAEP)) {
                    if (keyAlg.getParameters() != null) {
                        RSAESOAEPparams params = RSAESOAEPparams.getInstance((Object)keyAlg.getParameters());
                        ASN1ObjectIdentifier oid = params.getHashAlgorithm().getAlgorithm();
                        if (!oid.equals((ASN1Primitive)RSAESOAEPparams.DEFAULT_HASH_ALGORITHM.getAlgorithm())) {
                            throw new XiSecurityException("unsupported RSAESOAEPparams.HashAlgorithm " + oid.getId());
                        }
                        oid = params.getMaskGenAlgorithm().getAlgorithm();
                        if (!oid.equals((ASN1Primitive)RSAESOAEPparams.DEFAULT_MASK_GEN_FUNCTION.getAlgorithm())) {
                            throw new XiSecurityException("unsupported RSAESOAEPparams.MaskGenAlgorithm " + oid.getId());
                        }
                        oid = params.getPSourceAlgorithm().getAlgorithm();
                        if (!params.getPSourceAlgorithm().equals((Object)RSAESOAEPparams.DEFAULT_P_SOURCE_ALGORITHM)) {
                            throw new XiSecurityException("unsupported RSAESOAEPparams.PSourceAlgorithm " + oid.getId());
                        }
                    }
                    keyCipher = Cipher.getInstance("RSA/NONE/OAEPPADDING");
                } else if (keyOid.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption)) {
                    keyCipher = Cipher.getInstance("RSA/NONE/PKCS1PADDING");
                } else {
                    throw new XiSecurityException("unsupported keyAlg " + keyOid.getId());
                }
                keyCipher.init(2, decKey);
                symmKey = keyCipher.doFinal(ev.getEncSymmKey().getOctets());
            } else if (decKey instanceof ECPrivateKey) {
                ASN1Sequence params = ASN1Sequence.getInstance((Object)keyAlg.getParameters());
                int n = params.size();
                for (int i = 0; i < n; ++i) {
                    AlgorithmIdentifier hashAlgorithm;
                    AlgorithmIdentifier algId;
                    if (!keyOid.equals((ASN1Primitive)ObjectIdentifiers.Secg.id_ecies_specifiedParameters)) {
                        throw new XiSecurityException("unsupported keyAlg " + keyOid.getId());
                    }
                    ASN1TaggedObject to = (ASN1TaggedObject)params.getObjectAt(i);
                    int tag = to.getTagNo();
                    if (tag == 0) {
                        algId = AlgorithmIdentifier.getInstance((Object)to.getObject());
                        if (ObjectIdentifiers.Misc.id_iso18033_kdf2.equals((ASN1Primitive)algId.getAlgorithm())) {
                            hashAlgorithm = AlgorithmIdentifier.getInstance((Object)algId.getParameters());
                            if (hashAlgorithm.getAlgorithm().equals((ASN1Primitive)HashAlgo.SHA1.getOid())) continue;
                            throw new XiSecurityException("unsupported KeyDerivationFunction.HashAlgorithm " + hashAlgorithm.getAlgorithm().getId());
                        }
                        throw new XiSecurityException("unsupported KeyDerivationFunction " + algId.getAlgorithm().getId());
                    }
                    if (tag == 1) {
                        algId = AlgorithmIdentifier.getInstance((Object)to.getObject());
                        if (ObjectIdentifiers.Secg.id_aes128_cbc_in_ecies.equals((ASN1Primitive)algId.getAlgorithm())) continue;
                        throw new XiSecurityException("unsupported SymmetricEncryption " + algId.getAlgorithm().getId());
                    }
                    if (tag != 2) continue;
                    algId = AlgorithmIdentifier.getInstance((Object)to.getObject());
                    if (ObjectIdentifiers.Secg.id_hmac_full_ecies.equals((ASN1Primitive)algId.getAlgorithm())) {
                        hashAlgorithm = AlgorithmIdentifier.getInstance((Object)algId.getParameters());
                        if (hashAlgorithm.getAlgorithm().equals((ASN1Primitive)HashAlgo.SHA1.getOid())) continue;
                        throw new XiSecurityException("unsupported MessageAuthenticationCode.HashAlgorithm " + hashAlgorithm.getAlgorithm().getId());
                    }
                    throw new XiSecurityException("unsupported MessageAuthenticationCode " + algId.getAlgorithm().getId());
                }
                int aesKeySize = 128;
                byte[] iv = new byte[16];
                IESParameterSpec spec = new IESParameterSpec(null, null, aesKeySize, aesKeySize, iv);
                CBCBlockCipher cbcCipher = new CBCBlockCipher((BlockCipher)new AESEngine());
                IESCipher keyCipher = new IESCipher(new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()), (Mac)new HMac(DigestFactory.createSHA1()), (BufferedBlockCipher)new PaddedBufferedBlockCipher((BlockCipher)cbcCipher)), 16);
                keyCipher.engineInit(2, (Key)decKey, (AlgorithmParameterSpec)spec, null);
                byte[] encSymmKey = ev.getEncSymmKey().getOctets();
                ASN1Sequence seq = DERSequence.getInstance((Object)encSymmKey);
                byte[] ephemeralPublicKey = DEROctetString.getInstance((Object)seq.getObjectAt(0)).getOctets();
                byte[] symmetricCiphertext = DEROctetString.getInstance((Object)seq.getObjectAt(1)).getOctets();
                byte[] macTag = DEROctetString.getInstance((Object)seq.getObjectAt(2)).getOctets();
                byte[] bcInput = new byte[ephemeralPublicKey.length + symmetricCiphertext.length + macTag.length];
                System.arraycopy(ephemeralPublicKey, 0, bcInput, 0, ephemeralPublicKey.length);
                int offset = ephemeralPublicKey.length;
                System.arraycopy(symmetricCiphertext, 0, bcInput, offset, symmetricCiphertext.length);
                System.arraycopy(macTag, 0, bcInput, offset += symmetricCiphertext.length, macTag.length);
                symmKey = keyCipher.engineDoFinal(bcInput, 0, bcInput.length);
            } else {
                throw new XiSecurityException("unsupported decryption key type " + decKey.getClass().getName());
            }
            AlgorithmIdentifier symmAlg = ev.getSymmAlg();
            ASN1ObjectIdentifier symmAlgOid = symmAlg.getAlgorithm();
            if (!symmAlgOid.equals((ASN1Primitive)NISTObjectIdentifiers.id_aes128_GCM)) {
                throw new XiSecurityException("unsupported symmAlg " + symmAlgOid.getId());
            }
            GCMParameters params = GCMParameters.getInstance((Object)symmAlg.getParameters());
            Cipher dataCipher = Cipher.getInstance(symmAlgOid.getId());
            GCMParameterSpec algParams = new GCMParameterSpec(params.getIcvLen() << 3, params.getNonce());
            dataCipher.init(2, (Key)new SecretKeySpec(symmKey, "AES"), algParams);
            byte[] encValue = ev.getEncValue().getOctets();
            return dataCipher.doFinal(encValue);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new XiSecurityException("Error while decrypting the EncryptedValue", (Throwable)ex);
        }
    }

    static X509CRLHolder evaluateCrlResponse(VerifiedPkiMessage response, Integer xipkiAction) throws CmpClientException, PkiErrorException {
        CmpAgentUtil.checkProtection((VerifiedPkiMessage)Args.notNull((Object)response, (String)"response"));
        PKIBody respBody = response.getPkiMessage().getBody();
        int bodyType = respBody.getType();
        if (23 == bodyType) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new PkiErrorException(content.getPKIStatusInfo());
        }
        if (22 != bodyType) {
            throw new CmpClientException(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, 22, 23));
        }
        ASN1ObjectIdentifier expectedType = xipkiAction == null ? CMPObjectIdentifiers.it_currentCRL : ObjectIdentifiers.Xipki.id_xipki_cmp_cmpGenmsg;
        GenRepContent genRep = GenRepContent.getInstance((Object)respBody.getContent());
        InfoTypeAndValue[] itvs = genRep.toInfoTypeAndValueArray();
        InfoTypeAndValue itv = null;
        if (itvs != null && itvs.length > 0) {
            for (InfoTypeAndValue m : itvs) {
                if (!expectedType.equals((ASN1Primitive)m.getInfoType())) continue;
                itv = m;
                break;
            }
        }
        if (itv == null) {
            throw new CmpClientException("the response does not contain InfoTypeAndValue " + expectedType);
        }
        ASN1Encodable certListAsn1Object = xipkiAction == null ? itv.getInfoValue() : CmpAgentUtil.extractXiActionContent(itv.getInfoValue(), xipkiAction);
        CertificateList certList = CertificateList.getInstance((Object)certListAsn1Object);
        return new X509CRLHolder(certList);
    }

    static RevokeCertResponse parse(VerifiedPkiMessage response, List<? extends UnrevokeOrRemoveCertRequest.Entry> reqEntries) throws CmpClientException, PkiErrorException {
        CmpAgentUtil.checkProtection((VerifiedPkiMessage)Args.notNull((Object)response, (String)"response"));
        PKIBody respBody = response.getPkiMessage().getBody();
        int bodyType = respBody.getType();
        if (23 == bodyType) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new PkiErrorException(content.getPKIStatusInfo());
        }
        if (12 != bodyType) {
            throw new CmpClientException(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, 12, 23));
        }
        RevRepContent content = RevRepContent.getInstance((Object)respBody.getContent());
        PKIStatusInfo[] statuses = content.getStatus();
        if (statuses == null || statuses.length != reqEntries.size()) {
            int statusesLen = 0;
            if (statuses != null) {
                statusesLen = statuses.length;
            }
            throw new CmpClientException(String.format("incorrect number of status entries in response '%s' instead the expected '%s'", statusesLen, reqEntries.size()));
        }
        CertId[] revCerts = content.getRevCerts();
        RevokeCertResponse result = new RevokeCertResponse();
        for (int i = 0; i < statuses.length; ++i) {
            PKIStatusInfo statusInfo = statuses[i];
            int status = statusInfo.getStatus().intValue();
            UnrevokeOrRemoveCertRequest.Entry re = reqEntries.get(i);
            if (status != 0 && status != 1) {
                PKIFreeText text = statusInfo.getStatusString();
                String statusString = text == null ? null : text.getStringAt(0).getString();
                ResultEntry.Error resultEntry = new ResultEntry.Error(re.getId(), status, statusInfo.getFailInfo().intValue(), statusString);
                result.addResultEntry(resultEntry);
                continue;
            }
            CertId certId = null;
            if (revCerts != null) {
                for (CertId entry : revCerts) {
                    if (!re.getIssuer().equals((Object)entry.getIssuer().getName()) || !re.getSerialNumber().equals(entry.getSerialNumber().getValue())) continue;
                    certId = entry;
                    break;
                }
            }
            if (certId == null) {
                LOG.warn("certId is not present in response for (issuer='{}', serialNumber={})", (Object)X509Util.getRfc4519Name((X500Name)re.getIssuer()), (Object)LogUtil.formatCsn((BigInteger)re.getSerialNumber()));
                certId = new CertId(new GeneralName(re.getIssuer()), re.getSerialNumber());
            }
            result.addResultEntry(new ResultEntry.RevokeCert(re.getId(), certId));
        }
        return result;
    }

    static Extensions getCertTempExtensions(byte[] authorityKeyIdentifier) throws CmpClientException {
        byte[] encodedAki;
        AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier(authorityKeyIdentifier);
        try {
            encodedAki = aki.getEncoded();
        }
        catch (IOException ex) {
            throw new CmpClientException("could not encoded AuthorityKeyIdentifier", ex);
        }
        Extension extAki = new Extension(Extension.authorityKeyIdentifier, false, encodedAki);
        return new Extensions(extAki);
    }

    static CaConf.CaInfo retrieveCaInfo(VerifiedPkiMessage response, String caName) throws CmpClientException, PkiErrorException {
        JSONObject root;
        ASN1Encodable itvValue = CmpAgentUtil.extractXipkiActionRepContent(response);
        DERUTF8String utf8Str = DERUTF8String.getInstance((Object)itvValue);
        String systemInfoStr = utf8Str.getString();
        LOG.debug("CAInfo for CA {}: {}", (Object)caName, (Object)systemInfoStr);
        try {
            root = JSON.parseObject((String)systemInfoStr);
        }
        catch (RuntimeException ex) {
            throw new CmpClientException("could not parse the returned systemInfo for CA " + caName + ": " + ex.getMessage(), ex);
        }
        int version = root.getIntValue("version");
        if (version == 3) {
            JSONArray array = root.getJSONArray("caCertchain");
            LinkedList<X509Cert> caCertchain = new LinkedList<X509Cert>();
            for (int i = 0; i < array.size(); ++i) {
                X509Cert caCert;
                String base64Cert = array.getString(i);
                try {
                    caCert = X509Util.parseCert((byte[])StringUtil.toUtf8Bytes((String)base64Cert));
                }
                catch (CertificateException ex) {
                    throw new CmpClientException("could no parse the CA certificate chain", ex);
                }
                caCertchain.add(caCert);
            }
            array = root.getJSONArray("dhpocs");
            LinkedList<X509Cert> dhpocs = null;
            if (array != null) {
                dhpocs = new LinkedList<X509Cert>();
                for (int i = 0; i < array.size(); ++i) {
                    X509Cert caCert;
                    String base64Cert = array.getString(i);
                    try {
                        caCert = X509Util.parseCert((byte[])StringUtil.toUtf8Bytes((String)base64Cert));
                    }
                    catch (CertificateException ex) {
                        throw new CmpClientException("could no parse the DHPoc (certificate)", ex);
                    }
                    dhpocs.add(caCert);
                }
            }
            CaConf.CmpControl cmpControl = null;
            JSONObject jsonCmpControl = root.getJSONObject("cmpControl");
            if (jsonCmpControl != null) {
                Boolean tmpBool = jsonCmpControl.getBoolean("rrAkiRequired");
                boolean required = tmpBool != null && tmpBool != false;
                cmpControl = new CaConf.CmpControl(required);
            }
            HashSet<String> profileNames = new HashSet<String>();
            JSONArray jsonProfiles = root.getJSONArray("certprofiles");
            HashSet<CertprofileInfo> profiles = new HashSet<CertprofileInfo>();
            if (jsonProfiles != null) {
                int size = jsonProfiles.size();
                for (int i = 0; i < size; ++i) {
                    JSONObject jsonProfile = jsonProfiles.getJSONObject(i);
                    String name = jsonProfile.getString("name");
                    String type = jsonProfile.getString("type");
                    String conf = jsonProfile.getString("conf");
                    CertprofileInfo profile = new CertprofileInfo(name, type, conf);
                    profiles.add(profile);
                    profileNames.add(name);
                    LOG.debug("configured for CA {} certprofile (name={}, type={}, conf={})", new Object[]{caName, name, type, conf});
                }
            }
            LOG.info("CA {} supports profiles {}", (Object)caName, profileNames);
            return new CaConf.CaInfo(caCertchain, cmpControl, profiles, dhpocs);
        }
        throw new CmpClientException("unknown CAInfo version " + version);
    }
}

