/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.cmpclient.CertIdOrError;
import org.xipki.cmpclient.CertprofileInfo;
import org.xipki.cmpclient.CmpClient;
import org.xipki.cmpclient.CmpClientException;
import org.xipki.cmpclient.EnrollCertRequest;
import org.xipki.cmpclient.EnrollCertResult;
import org.xipki.cmpclient.PkiErrorException;
import org.xipki.cmpclient.RevokeCertRequest;
import org.xipki.cmpclient.UnrevokeOrRemoveCertRequest;
import org.xipki.cmpclient.internal.CaConf;
import org.xipki.cmpclient.internal.CmpAgent;
import org.xipki.cmpclient.internal.CmpClientConfigurer;
import org.xipki.cmpclient.internal.CsrEnrollCertRequest;
import org.xipki.cmpclient.internal.EnrollCertResponse;
import org.xipki.cmpclient.internal.ResultEntry;
import org.xipki.cmpclient.internal.RevokeCertResponse;
import org.xipki.security.SecurityFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.StringUtil;

public final class CmpClientImpl
implements CmpClient {
    private static final Logger LOG = LoggerFactory.getLogger(CmpClientImpl.class);
    private final CmpClientConfigurer configurer = new CmpClientConfigurer();

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.configurer.setSecurityFactory(securityFactory);
    }

    public void setConfFile(String confFile) {
        this.configurer.setConfFile(confFile);
    }

    private void initIfNotInitialized() throws CmpClientException {
        this.configurer.initIfNotInitialized();
    }

    @Override
    public boolean init() {
        return this.configurer.init();
    }

    @Override
    public void close() {
        this.configurer.close();
    }

    @Override
    public EnrollCertResult enrollCert(String caName, CertificationRequest csr, String profile, Date notBefore, Date notAfter, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)csr, (String)"csr");
        this.initIfNotInitialized();
        caName = caName == null ? this.getCaNameForProfile(profile) : caName.toLowerCase();
        if (caName == null) {
            throw new CmpClientException("certprofile " + profile + " is not supported by any CA");
        }
        CaConf ca = this.configurer.getCaConf(caName);
        if (ca == null) {
            throw new CmpClientException("could not find CA named " + caName);
        }
        String id = "cert-1";
        CsrEnrollCertRequest request = new CsrEnrollCertRequest("cert-1", profile, csr);
        EnrollCertResponse result = ca.getAgent().requestCertificate(request, notBefore, notAfter, debug);
        return this.parseEnrollCertResult(result);
    }

    @Override
    public EnrollCertResult enrollCerts(String caName, EnrollCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        CaConf ca;
        boolean bo;
        List<EnrollCertRequest.Entry> requestEntries = ((EnrollCertRequest)Args.notNull((Object)request, (String)"request")).getRequestEntries();
        if (CollectionUtil.isEmpty(requestEntries)) {
            return null;
        }
        this.initIfNotInitialized();
        boolean bl = bo = caName != null;
        if (caName == null) {
            String profile = requestEntries.get(0).getCertprofile();
            caName = this.getCaNameForProfile(profile);
            if (caName == null) {
                throw new CmpClientException("certprofile " + (String)profile + " is not supported by any CA");
            }
        } else {
            caName = caName.toLowerCase();
        }
        if (bo || request.getRequestEntries().size() > 1) {
            for (EnrollCertRequest.Entry entry : request.getRequestEntries()) {
                String profile = entry.getCertprofile();
                if (profile == null) continue;
                this.checkCertprofileSupportInCa(profile, caName);
            }
        }
        if ((ca = this.configurer.getCaConf(caName)) == null) {
            throw new CmpClientException("could not find CA named " + caName);
        }
        EnrollCertResponse result = ca.getAgent().requestCertificate(request, debug);
        return this.parseEnrollCertResult(result);
    }

    private void checkCertprofileSupportInCa(String certprofile, String caName) throws CmpClientException {
        if (caName != null) {
            CaConf ca = this.configurer.getCaConf(caName = caName.toLowerCase());
            if (ca == null) {
                throw new CmpClientException("unknown ca: " + caName);
            }
            if (!ca.supportsProfile(certprofile)) {
                throw new CmpClientException("certprofile " + certprofile + " is not supported by the CA " + caName);
            }
            return;
        }
        Map<String, CaConf> casMap = this.configurer.getCasMap();
        for (CaConf ca : casMap.values()) {
            if (!ca.isCaInfoConfigured() || !ca.supportsProfile(certprofile)) continue;
            if (caName == null) {
                caName = ca.getName();
                continue;
            }
            throw new CmpClientException("certprofile " + certprofile + " supported by more than one CA, please specify the CA name.");
        }
        if (caName == null) {
            throw new CmpClientException("unsupported certprofile " + certprofile);
        }
    }

    @Override
    public CertIdOrError revokeCert(String caName, X509Cert cert, int reason, Date invalidityDate, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)cert, (String)"cert");
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        CmpClientImpl.assertIssuedByCa(cert, ca);
        return this.revokeCert(ca, cert.getSerialNumber(), reason, invalidityDate, debug);
    }

    @Override
    public CertIdOrError revokeCert(String caName, BigInteger serial, int reason, Date invalidityDate, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        return this.revokeCert(ca, serial, reason, invalidityDate, debug);
    }

    private CertIdOrError revokeCert(CaConf ca, BigInteger serial, int reason, Date invalidityDate, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)serial, (String)"serial");
        String id = "cert-1";
        RevokeCertRequest.Entry entry = new RevokeCertRequest.Entry("cert-1", ca.getSubject(), serial, reason, invalidityDate);
        if (ca.getCmpControl().isRrAkiRequired()) {
            entry.setAuthorityKeyIdentifier(ca.getSubjectKeyIdentifier());
        }
        RevokeCertRequest request = new RevokeCertRequest();
        request.addRequestEntry(entry);
        Map<String, CertIdOrError> result = this.revokeCerts(request, debug);
        return result == null ? null : result.get("cert-1");
    }

    @Override
    public Map<String, CertIdOrError> revokeCerts(RevokeCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        List<RevokeCertRequest.Entry> requestEntries = ((RevokeCertRequest)Args.notNull((Object)request, (String)"request")).getRequestEntries();
        if (CollectionUtil.isEmpty(requestEntries)) {
            return Collections.emptyMap();
        }
        X500Name issuer = requestEntries.get(0).getIssuer();
        for (int i = 1; i < requestEntries.size(); ++i) {
            if (issuer.equals((Object)requestEntries.get(i).getIssuer())) continue;
            throw new PkiErrorException(2, 32, "revoking certificates issued by more than one CA is not allowed");
        }
        this.initIfNotInitialized();
        String caName = this.getCaNameByIssuer(issuer);
        CaConf caConf = this.configurer.getCaConf(caName);
        if (caConf.getCmpControl().isRrAkiRequired()) {
            byte[] aki = caConf.getSubjectKeyIdentifier();
            List<RevokeCertRequest.Entry> entries = request.getRequestEntries();
            for (RevokeCertRequest.Entry entry : entries) {
                if (entry.getAuthorityKeyIdentifier() != null) continue;
                entry.setAuthorityKeyIdentifier(aki);
            }
        }
        RevokeCertResponse result = caConf.getAgent().revokeCertificate(request, debug);
        return this.parseRevokeCertResult(result);
    }

    private Map<String, CertIdOrError> parseRevokeCertResult(RevokeCertResponse result) throws CmpClientException {
        HashMap<String, CertIdOrError> ret = new HashMap<String, CertIdOrError>();
        for (ResultEntry re : result.getResultEntries()) {
            CertIdOrError certIdOrError;
            ResultEntry entry;
            if (re instanceof ResultEntry.RevokeCert) {
                entry = (ResultEntry.RevokeCert)re;
                certIdOrError = new CertIdOrError(((ResultEntry.RevokeCert)entry).getCertId());
            } else if (re instanceof ResultEntry.Error) {
                entry = (ResultEntry.Error)re;
                certIdOrError = new CertIdOrError(((ResultEntry.Error)entry).getStatusInfo());
            } else {
                throw new CmpClientException("unknown type " + re.getClass().getName());
            }
            ret.put(re.getId(), certIdOrError);
        }
        return ret;
    }

    @Override
    public X509CRLHolder downloadCrl(String caName, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        return this.downloadCrl(caName, null, debug);
    }

    @Override
    public X509CRLHolder downloadCrl(String caName, BigInteger crlNumber, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.initIfNotInitialized();
        CaConf ca = this.configurer.getCaConf(caName);
        if (ca == null) {
            throw new IllegalArgumentException("unknown CA " + caName);
        }
        CmpAgent agent = ca.getAgent();
        return crlNumber == null ? agent.downloadCurrentCrl(debug) : agent.downloadCrl(crlNumber, debug);
    }

    @Override
    public X509CRLHolder generateCrl(String caName, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.initIfNotInitialized();
        CaConf ca = this.configurer.getCaConf(caName);
        if (ca == null) {
            throw new IllegalArgumentException("unknown CA " + caName);
        }
        return ca.getAgent().generateCrl(debug);
    }

    @Override
    public String getCaNameByIssuer(X500Name issuer) throws CmpClientException {
        Args.notNull((Object)issuer, (String)"issuer");
        this.initIfNotInitialized();
        Map<String, CaConf> casMap = this.configurer.getCasMap();
        for (Map.Entry<String, CaConf> entry : casMap.entrySet()) {
            CaConf ca = entry.getValue();
            if (!ca.isCaInfoConfigured() || !CompareUtil.equalsObject((Object)ca.getSubject(), (Object)issuer)) continue;
            return entry.getKey();
        }
        throw new CmpClientException("unknown CA for issuer: " + issuer);
    }

    @Override
    public String getCaNameForProfile(String certprofile) throws CmpClientException {
        String caName = null;
        Map<String, CaConf> casMap = this.configurer.getCasMap();
        for (CaConf ca : casMap.values()) {
            if (!ca.isCaInfoConfigured() || !ca.supportsProfile(certprofile)) continue;
            if (caName == null) {
                caName = ca.getName();
                continue;
            }
            throw new CmpClientException("certprofile " + certprofile + " supported by more than one CA, please specify the CA name.");
        }
        return caName;
    }

    private X509Cert getCertificate(CMPCertificate cmpCert) throws CertificateException {
        Certificate bcCert = cmpCert.getX509v3PKCert();
        return bcCert == null ? null : new X509Cert(bcCert);
    }

    @Override
    public Set<String> getCaNames() throws CmpClientException {
        this.initIfNotInitialized();
        return this.configurer.getCasMap().keySet();
    }

    private static boolean verify(X509Cert caCert, X509Cert cert) {
        if (!cert.getIssuer().equals((Object)caCert.getSubject())) {
            return false;
        }
        boolean inBenchmark = Boolean.getBoolean("org.xipki.benchmark");
        if (inBenchmark) {
            return true;
        }
        PublicKey caPublicKey = caCert.getPublicKey();
        try {
            cert.verify(caPublicKey);
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException ex) {
            LOG.debug("{} while verifying signature: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            return false;
        }
    }

    @Override
    public CertIdOrError unrevokeCert(String caName, X509Cert cert, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)cert, (String)"cert");
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        CmpClientImpl.assertIssuedByCa(cert, ca);
        return this.unrevokeCert(ca, cert.getSerialNumber(), debug);
    }

    @Override
    public CertIdOrError unrevokeCert(String caName, BigInteger serial, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        return this.unrevokeCert(ca, serial, debug);
    }

    private CertIdOrError unrevokeCert(CaConf ca, BigInteger serial, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)serial, (String)"serial");
        String id = "cert-1";
        ResultEntry.UnrevokeOrRemoveCert entry = new ResultEntry.UnrevokeOrRemoveCert("cert-1", ca.getSubject(), serial);
        if (ca.getCmpControl().isRrAkiRequired()) {
            entry.setAuthorityKeyIdentifier(ca.getSubjectKeyIdentifier());
        }
        UnrevokeOrRemoveCertRequest request = new UnrevokeOrRemoveCertRequest();
        UnrevokeOrRemoveCertRequest.Entry entry2 = new UnrevokeOrRemoveCertRequest.Entry(entry.getId(), entry.getIssuer(), entry.getSerialNumber());
        entry2.setAuthorityKeyIdentifier(entry.getAuthorityKeyIdentifier());
        request.addRequestEntry(entry2);
        Map<String, CertIdOrError> result = this.unrevokeCerts(request, debug);
        return result == null ? null : result.get("cert-1");
    }

    @Override
    public Map<String, CertIdOrError> unrevokeCerts(UnrevokeOrRemoveCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)request, (String)"request");
        this.initIfNotInitialized();
        List<UnrevokeOrRemoveCertRequest.Entry> requestEntries = request.getRequestEntries();
        if (CollectionUtil.isEmpty(requestEntries)) {
            return Collections.emptyMap();
        }
        X500Name issuer = requestEntries.get(0).getIssuer();
        for (int i = 1; i < requestEntries.size(); ++i) {
            if (issuer.equals((Object)requestEntries.get(i).getIssuer())) continue;
            throw new PkiErrorException(2, 32, "unrevoking certificates issued by more than one CA is not allowed");
        }
        String caName = this.getCaNameByIssuer(issuer);
        CmpAgent agent = this.configurer.getCaConf(caName).getAgent();
        RevokeCertResponse result = agent.unrevokeCertificate(request, debug);
        return this.parseRevokeCertResult(result);
    }

    @Override
    public CertIdOrError removeCert(String caName, X509Cert cert, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)cert, (String)"cert");
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        CmpClientImpl.assertIssuedByCa(cert, ca);
        return this.removeCert(ca, cert.getSerialNumber(), debug);
    }

    @Override
    public CertIdOrError removeCert(String caName, BigInteger serial, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        this.initIfNotInitialized();
        CaConf ca = this.getCa(caName);
        return this.removeCert(ca, serial, debug);
    }

    private CertIdOrError removeCert(CaConf ca, BigInteger serial, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)serial, (String)"serial");
        String id = "cert-1";
        UnrevokeOrRemoveCertRequest.Entry entry = new UnrevokeOrRemoveCertRequest.Entry("cert-1", ca.getSubject(), serial);
        if (ca.getCmpControl().isRrAkiRequired()) {
            entry.setAuthorityKeyIdentifier(ca.getSubjectKeyIdentifier());
        }
        UnrevokeOrRemoveCertRequest request = new UnrevokeOrRemoveCertRequest();
        request.addRequestEntry(entry);
        Map<String, CertIdOrError> result = this.removeCerts(request, debug);
        return result == null ? null : result.get("cert-1");
    }

    @Override
    public Map<String, CertIdOrError> removeCerts(UnrevokeOrRemoveCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)request, (String)"request");
        this.initIfNotInitialized();
        List<UnrevokeOrRemoveCertRequest.Entry> requestEntries = request.getRequestEntries();
        if (CollectionUtil.isEmpty(requestEntries)) {
            return Collections.emptyMap();
        }
        X500Name issuer = requestEntries.get(0).getIssuer();
        for (int i = 1; i < requestEntries.size(); ++i) {
            if (issuer.equals((Object)requestEntries.get(i).getIssuer())) continue;
            throw new PkiErrorException(2, 32, "removing certificates issued by more than one CA is not allowed");
        }
        String caName = this.getCaNameByIssuer(issuer);
        CmpAgent agent = this.configurer.getCaConf(caName).getAgent();
        RevokeCertResponse result = agent.removeCertificate(request, debug);
        return this.parseRevokeCertResult(result);
    }

    @Override
    public Set<CertprofileInfo> getCertprofiles(String caName) throws CmpClientException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.initIfNotInitialized();
        CaConf ca = this.configurer.getCaConf(caName);
        if (ca == null) {
            return Collections.emptySet();
        }
        Set<String> profileNames = ca.getProfileNames();
        if (CollectionUtil.isEmpty(profileNames)) {
            return Collections.emptySet();
        }
        HashSet<CertprofileInfo> ret = new HashSet<CertprofileInfo>(profileNames.size());
        for (String m : profileNames) {
            ret.add(ca.getProfile(m));
        }
        return ret;
    }

    @Override
    public HealthCheckResult getHealthCheckResult(String caName) throws CmpClientException {
        URL serverUrl;
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        String name = "X509CA";
        HealthCheckResult healthCheckResult = new HealthCheckResult();
        healthCheckResult.setName(name);
        try {
            this.initIfNotInitialized();
        }
        catch (CmpClientException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not initialize CaCleint");
            healthCheckResult.setHealthy(false);
            return healthCheckResult;
        }
        CaConf ca = this.configurer.getCaConf(caName);
        if (ca == null) {
            throw new IllegalArgumentException("unknown CA " + caName);
        }
        String healthUrlStr = ca.getHealthUrl();
        try {
            serverUrl = new URL(healthUrlStr);
        }
        catch (MalformedURLException ex) {
            throw new CmpClientException("invalid URL '" + healthUrlStr + "'");
        }
        try {
            HttpURLConnection httpUrlConnection = IoUtil.openHttpConn((URL)serverUrl);
            if (httpUrlConnection instanceof HttpsURLConnection) {
                if (ca.getHostnameVerifier() != null) {
                    ((HttpsURLConnection)httpUrlConnection).setHostnameVerifier(ca.getHostnameVerifier());
                }
                if (ca.getSslSocketFactory() != null) {
                    ((HttpsURLConnection)httpUrlConnection).setSSLSocketFactory(ca.getSslSocketFactory());
                }
            }
            InputStream inputStream = httpUrlConnection.getInputStream();
            int responseCode = httpUrlConnection.getResponseCode();
            if (responseCode != 200 && responseCode != 500) {
                inputStream.close();
                throw new IOException(String.format("bad response: code='%s', message='%s'", httpUrlConnection.getResponseCode(), httpUrlConnection.getResponseMessage()));
            }
            String responseContentType = httpUrlConnection.getContentType();
            boolean isValidContentType = false;
            if (responseContentType != null && "application/json".equalsIgnoreCase(responseContentType)) {
                isValidContentType = true;
            }
            if (!isValidContentType) {
                inputStream.close();
                throw new IOException("bad response: mime type " + responseContentType + " not supported!");
            }
            byte[] responseBytes = IoUtil.read((InputStream)inputStream);
            if (responseBytes.length == 0) {
                healthCheckResult.setHealthy(responseCode == 200);
            } else {
                try {
                    healthCheckResult = (HealthCheckResult)JSON.parseObject((byte[])responseBytes, HealthCheckResult.class, (Feature[])new Feature[0]);
                }
                catch (RuntimeException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)"IOException while parsing the health json message");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("json message: {}", (Object)StringUtil.toUtf8String((byte[])responseBytes));
                    }
                    healthCheckResult.setHealthy(false);
                }
            }
        }
        catch (IOException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("IOException while fetching the URL " + healthUrlStr));
            healthCheckResult.setHealthy(false);
        }
        return healthCheckResult;
    }

    /*
     * WARNING - void declaration
     */
    private EnrollCertResult parseEnrollCertResult(EnrollCertResponse result) throws CmpClientException {
        void var6_14;
        X509Cert cert;
        HashMap<String, EnrollCertResult.CertifiedKeyPairOrError> certOrErrors = new HashMap<String, EnrollCertResult.CertifiedKeyPairOrError>();
        for (ResultEntry resultEntry : result.getResultEntries()) {
            Object certOrError;
            if (resultEntry instanceof ResultEntry.EnrollCert) {
                ResultEntry.EnrollCert enrollCert = (ResultEntry.EnrollCert)resultEntry;
                try {
                    X509Cert cert2 = this.getCertificate(enrollCert.getCert());
                    certOrError = new EnrollCertResult.CertifiedKeyPairOrError(cert2, enrollCert.getPrivateKeyInfo());
                }
                catch (CertificateException ex) {
                    throw new CmpClientException(String.format("CertificateParsingException for request (id=%s): %s", enrollCert.getId(), ex.getMessage()));
                }
            } else {
                certOrError = resultEntry instanceof ResultEntry.Error ? new EnrollCertResult.CertifiedKeyPairOrError(((ResultEntry.Error)resultEntry).getStatusInfo()) : null;
            }
            certOrErrors.put(resultEntry.getId(), (EnrollCertResult.CertifiedKeyPairOrError)certOrError);
        }
        List<CMPCertificate> cmpCaPubs = result.getCaCertificates();
        if (CollectionUtil.isEmpty(cmpCaPubs)) {
            return new EnrollCertResult(null, certOrErrors);
        }
        ArrayList<X509Cert> caPubs = new ArrayList<X509Cert>(cmpCaPubs.size());
        for (CMPCertificate cMPCertificate : cmpCaPubs) {
            try {
                caPubs.add(this.getCertificate(cMPCertificate));
            }
            catch (CertificateException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not extract the caPub from CMPCertificate");
            }
        }
        X509Cert caCert = null;
        for (EnrollCertResult.CertifiedKeyPairOrError certOrError : certOrErrors.values()) {
            cert = certOrError.getCertificate();
            if (cert == null) continue;
            for (X509Cert caPub : caPubs) {
                if (!CmpClientImpl.verify(caPub, cert)) continue;
                caCert = caPub;
                break;
            }
            if (caCert == null) continue;
            break;
        }
        if (caCert == null) {
            return new EnrollCertResult(null, certOrErrors);
        }
        for (EnrollCertResult.CertifiedKeyPairOrError certOrError : certOrErrors.values()) {
            cert = certOrError.getCertificate();
            if (cert == null || CmpClientImpl.verify(caCert, cert)) continue;
            LOG.warn("not all certificates are issued by CA embedded in caPubs, ignore the caPubs");
            return new EnrollCertResult(null, certOrErrors);
        }
        caPubs.remove(caCert);
        if (caPubs.isEmpty()) {
            X509Cert[] x509CertArray = new X509Cert[]{caCert};
        } else {
            try {
                X509Cert[] x509CertArray = X509Util.buildCertPath(caCert, caPubs, (boolean)true);
            }
            catch (CertPathBuilderException e) {
                LOG.warn("could not build certpath for the CA certificate");
                X509Cert[] x509CertArray = new X509Cert[]{caCert};
            }
        }
        return new EnrollCertResult((X509Cert[])var6_14, certOrErrors);
    }

    private CaConf getCa(String caName) throws CmpClientException {
        Map<String, CaConf> casMap = this.configurer.getCasMap();
        if (caName == null) {
            Iterator<String> names = casMap.keySet().iterator();
            if (!names.hasNext()) {
                throw new CmpClientException("no CA is configured");
            }
            caName = names.next();
        } else {
            caName = caName.toLowerCase();
        }
        CaConf ca = casMap.get(caName);
        if (ca == null) {
            throw new CmpClientException("could not find CA named " + caName);
        }
        return ca;
    }

    private static void assertIssuedByCa(X509Cert cert, CaConf ca) throws CmpClientException {
        boolean issued;
        try {
            issued = X509Util.issues((X509Cert)ca.getCert(), (X509Cert)cert);
        }
        catch (CertificateEncodingException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            issued = false;
        }
        if (!issued) {
            throw new CmpClientException("the given certificate is not issued by the CA");
        }
    }

    @Override
    public X509Cert getCaCert(String caName) throws CmpClientException {
        this.initIfNotInitialized();
        CaConf ca = this.configurer.getCaConf(caName);
        return ca == null ? null : ca.getCert();
    }

    @Override
    public List<X509Cert> getCaCertchain(String caName) throws CmpClientException {
        this.initIfNotInitialized();
        CaConf ca = this.configurer.getCaConf(caName);
        return ca == null ? null : ca.getCertchain();
    }

    @Override
    public X500Name getCaCertSubject(String caName) throws CmpClientException {
        this.initIfNotInitialized();
        CaConf ca = this.configurer.getCaConf(caName);
        return ca == null ? null : ca.getSubject();
    }

    @Override
    public List<X509Cert> getDhPocPeerCertificates(String caName) throws CmpClientException {
        this.initIfNotInitialized();
        CaConf ca = this.configurer.getCaConf(caName);
        return ca == null ? null : ca.getDhpocs();
    }
}

