/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.internal;

import java.math.BigInteger;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.cmpclient.IdentifiedObject;
import org.xipki.security.cmp.PkiStatusInfo;
import org.xipki.util.Args;

abstract class ResultEntry
extends IdentifiedObject {
    ResultEntry(String id) {
        super(id);
    }

    static class UnrevokeOrRemoveCert
    extends ResultEntry {
        private final X500Name issuer;
        private final BigInteger serialNumber;
        private byte[] authorityKeyIdentifier;

        UnrevokeOrRemoveCert(String id, X500Name issuer, BigInteger serialNumber) {
            super(id);
            this.serialNumber = (BigInteger)Args.notNull((Object)serialNumber, (String)"serialNumber");
            this.issuer = (X500Name)Args.notNull((Object)issuer, (String)"issuer");
        }

        X500Name getIssuer() {
            return this.issuer;
        }

        BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        byte[] getAuthorityKeyIdentifier() {
            return this.authorityKeyIdentifier;
        }

        void setAuthorityKeyIdentifier(byte[] authorityKeyIdentifier) {
            this.authorityKeyIdentifier = authorityKeyIdentifier;
        }
    }

    static class RevokeCert
    extends ResultEntry {
        private final CertId certId;

        RevokeCert(String id, CertId certId) {
            super(id);
            this.certId = certId;
        }

        CertId getCertId() {
            return this.certId;
        }
    }

    static class EnrollCert
    extends ResultEntry {
        private final CMPCertificate cert;
        private final PrivateKeyInfo privateKeyInfo;
        private final int status;

        EnrollCert(String id, CMPCertificate cert, PrivateKeyInfo privateKeyInfo, int status) {
            super(id);
            this.cert = cert;
            this.privateKeyInfo = privateKeyInfo;
            this.status = status;
        }

        CMPCertificate getCert() {
            return this.cert;
        }

        PrivateKeyInfo getPrivateKeyInfo() {
            return this.privateKeyInfo;
        }

        int getStatus() {
            return this.status;
        }
    }

    static class Error
    extends ResultEntry {
        private final PkiStatusInfo statusInfo;

        Error(String id, int status, int pkiFailureInfo, String statusMessage) {
            super(id);
            this.statusInfo = new PkiStatusInfo(status, pkiFailureInfo, statusMessage);
        }

        Error(String id, int status) {
            super(id);
            this.statusInfo = new PkiStatusInfo(status);
        }

        PkiStatusInfo getStatusInfo() {
            return this.statusInfo;
        }
    }
}

