/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.internal;

import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.util.Args;

abstract class Responder {
    private final GeneralName name;

    protected Responder(GeneralName name) {
        this.name = (GeneralName)Args.notNull((Object)name, (String)"name");
    }

    protected Responder(X500Name name) {
        this.name = new GeneralName((X500Name)Args.notNull((Object)name, (String)"name"));
    }

    public GeneralName getName() {
        return this.name;
    }

    static class SignaturetCmpResponder
    extends Responder {
        private final X509Certificate cert;
        private final AlgorithmValidator sigAlgoValidator;

        public SignaturetCmpResponder(X509Certificate cert, AlgorithmValidator sigAlgoValidator) {
            super(X500Name.getInstance((Object)((X509Certificate)Args.notNull((Object)cert, (String)"cert")).getSubjectX500Principal().getEncoded()));
            this.cert = cert;
            this.sigAlgoValidator = (AlgorithmValidator)Args.notNull((Object)sigAlgoValidator, (String)"sigAlgoValidator");
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public AlgorithmValidator getSigAlgoValidator() {
            return this.sigAlgoValidator;
        }
    }

    static class PbmMacCmpResponder
    extends Responder {
        private final List<ASN1ObjectIdentifier> owfAlgos;
        private final List<ASN1ObjectIdentifier> macAlgos;

        PbmMacCmpResponder(X500Name x500Name, List<String> owfs, List<String> macs) {
            super(x500Name);
            String algo;
            int i;
            this.owfAlgos = new ArrayList<ASN1ObjectIdentifier>(owfs.size());
            for (i = 0; i < owfs.size(); ++i) {
                HashAlgo ha;
                algo = owfs.get(i);
                try {
                    ha = HashAlgo.getNonNullInstance((String)algo);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("invalid owf " + algo, ex);
                }
                this.owfAlgos.add(ha.getOid());
            }
            this.macAlgos = new ArrayList<ASN1ObjectIdentifier>(macs.size());
            for (i = 0; i < macs.size(); ++i) {
                AlgorithmIdentifier algId;
                algo = macs.get(i);
                try {
                    algId = AlgorithmUtil.getMacAlgId((String)algo);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new IllegalArgumentException("invalid mac" + algo, ex);
                }
                this.macAlgos.add(algId.getAlgorithm());
            }
        }

        public boolean isPbmOwfPermitted(AlgorithmIdentifier pbmOwf) {
            ASN1ObjectIdentifier owfOid = pbmOwf.getAlgorithm();
            for (ASN1ObjectIdentifier oid : this.owfAlgos) {
                if (!oid.equals((Object)owfOid)) continue;
                return true;
            }
            return false;
        }

        public boolean isPbmMacPermitted(AlgorithmIdentifier pbmMac) {
            ASN1ObjectIdentifier macOid = pbmMac.getAlgorithm();
            for (ASN1ObjectIdentifier oid : this.macAlgos) {
                if (!oid.equals((Object)macOid)) continue;
                return true;
            }
            return false;
        }
    }
}

