/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ValidatableConf;

public class CmpClientConf
extends ValidatableConf {
    private List<Ssl> ssls;
    private List<Requestor> requestors;
    private List<Responder> responders;
    private Integer cainfoUpdateInterval;
    private List<Ca> cas;

    public List<Ssl> getSsls() {
        if (this.ssls == null) {
            this.ssls = new LinkedList<Ssl>();
        }
        return this.ssls;
    }

    public void setSsls(List<Ssl> ssls) {
        this.ssls = ssls;
    }

    public List<Requestor> getRequestors() {
        if (this.requestors == null) {
            this.requestors = new LinkedList<Requestor>();
        }
        return this.requestors;
    }

    public void setRequestors(List<Requestor> requestors) {
        this.requestors = requestors;
    }

    public List<Responder> getResponders() {
        if (this.responders == null) {
            this.responders = new LinkedList<Responder>();
        }
        return this.responders;
    }

    public void setResponders(List<Responder> responders) {
        this.responders = responders;
    }

    public Integer getCainfoUpdateInterval() {
        return this.cainfoUpdateInterval;
    }

    public void setCainfoUpdateInterval(Integer cainfoUpdateInterval) {
        this.cainfoUpdateInterval = cainfoUpdateInterval;
    }

    public List<Ca> getCas() {
        if (this.cas == null) {
            this.cas = new LinkedList<Ca>();
        }
        return this.cas;
    }

    public void setCas(List<Ca> cas) {
        this.cas = cas;
    }

    public void validate() throws InvalidConfException {
        CmpClientConf.validate(this.ssls);
        CmpClientConf.notEmpty(this.requestors, (String)"requestors");
        CmpClientConf.validate(this.requestors);
        CmpClientConf.notEmpty(this.responders, (String)"responders");
        CmpClientConf.validate(this.responders);
        CmpClientConf.notEmpty(this.cas, (String)"cas");
        CmpClientConf.validate(this.cas);
    }

    public static class Ssl
    extends ValidatableConf {
        private String name;
        private String storeType;
        private FileOrBinary keystore;
        private String keystorePassword;
        private FileOrBinary truststore;
        private String truststorePassword;
        private String hostnameVerifier;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getStoreType() {
            return this.storeType;
        }

        public void setStoreType(String storeType) {
            this.storeType = storeType;
        }

        public FileOrBinary getKeystore() {
            return this.keystore;
        }

        public void setKeystore(FileOrBinary keystore) {
            this.keystore = keystore;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public void setKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
        }

        public FileOrBinary getTruststore() {
            return this.truststore;
        }

        public void setTruststore(FileOrBinary truststore) {
            this.truststore = truststore;
        }

        public String getTruststorePassword() {
            return this.truststorePassword;
        }

        public void setTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
        }

        public String getHostnameVerifier() {
            return this.hostnameVerifier;
        }

        public void setHostnameVerifier(String hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        }

        public void validate() throws InvalidConfException {
            Ssl.notEmpty((String)this.name, (String)"name");
        }
    }

    public static class Responder
    extends ValidatableConf {
        private String name;
        private FileOrBinary cert;
        private PbmMac pbmMac;
        private Signature signature;

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary value) {
            this.cert = value;
        }

        public PbmMac getPbmMac() {
            return this.pbmMac;
        }

        public void setPbmMac(PbmMac value) {
            this.pbmMac = value;
        }

        public Signature getSignature() {
            return this.signature;
        }

        public void setSignature(Signature value) {
            this.signature = value;
        }

        public void validate() throws InvalidConfException {
            Responder.notEmpty((String)this.name, (String)"name");
            Responder.validate((ValidatableConf)this.cert);
            this.exactOne((Object)this.pbmMac, "pbmMac", (Object)this.signature, "signature");
            Responder.validate((ValidatableConf)this.pbmMac);
            Responder.validate((ValidatableConf)this.signature);
        }

        public static class Signature
        extends ValidatableConf {
            private List<String> signatureAlgos;

            public List<String> getSignatureAlgos() {
                if (this.signatureAlgos == null) {
                    this.signatureAlgos = new LinkedList<String>();
                }
                return this.signatureAlgos;
            }

            public void setSignatureAlgos(List<String> signatureAlgos) {
                this.signatureAlgos = signatureAlgos;
            }

            public void validate() throws InvalidConfException {
                Signature.notEmpty(this.signatureAlgos, (String)"signatureAlgos");
            }
        }

        public static class PbmMac
        extends ValidatableConf {
            private List<String> owfAlgos;
            private List<String> macAlgos;

            public List<String> getOwfAlgos() {
                if (this.owfAlgos == null) {
                    this.owfAlgos = new LinkedList<String>();
                }
                return this.owfAlgos;
            }

            public void setOwfAlgos(List<String> owfAlgos) {
                this.owfAlgos = owfAlgos;
            }

            public List<String> getMacAlgos() {
                if (this.macAlgos == null) {
                    this.macAlgos = new LinkedList<String>();
                }
                return this.macAlgos;
            }

            public void setMacAlgos(List<String> macAlgos) {
                this.macAlgos = macAlgos;
            }

            public void validate() throws InvalidConfException {
                PbmMac.notEmpty(this.owfAlgos, (String)"owfAlgos");
                PbmMac.notEmpty(this.macAlgos, (String)"macAlgos");
            }
        }
    }

    public static class Requestor
    extends ValidatableConf {
        private String name;
        private boolean signRequest;
        private PbmMac pbmMac;
        private Signature signature;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isSignRequest() {
            return this.signRequest;
        }

        public void setSignRequest(boolean signRequest) {
            this.signRequest = signRequest;
        }

        public PbmMac getPbmMac() {
            return this.pbmMac;
        }

        public void setPbmMac(PbmMac pbmMac) {
            this.pbmMac = pbmMac;
        }

        public Signature getSignature() {
            return this.signature;
        }

        public void setSignature(Signature signature) {
            this.signature = signature;
        }

        public void validate() throws InvalidConfException {
            Requestor.notEmpty((String)this.name, (String)"name");
            this.exactOne((Object)this.pbmMac, "pbmMac", (Object)this.signature, "signature");
            Requestor.validate((ValidatableConf)this.pbmMac);
            Requestor.validate((ValidatableConf)this.signature);
        }

        public static class Signature
        extends ValidatableConf {
            private FileOrBinary cert;
            private String signerType;
            private String signerConf;

            public FileOrBinary getCert() {
                return this.cert;
            }

            public void setCert(FileOrBinary cert) {
                this.cert = cert;
            }

            public String getSignerType() {
                return this.signerType;
            }

            public void setSignerType(String signerType) {
                this.signerType = signerType;
            }

            public String getSignerConf() {
                return this.signerConf;
            }

            public void setSignerConf(String signerConf) {
                this.signerConf = signerConf;
            }

            public void validate() throws InvalidConfException {
                Signature.validate((ValidatableConf)this.cert);
            }
        }

        public static class PbmMac
        extends ValidatableConf {
            private byte[] kid;
            private String sender;
            private String password;
            private String owf;
            private int iterationCount;
            private String mac;

            public byte[] getKid() {
                return this.kid;
            }

            public void setKid(byte[] kid) {
                this.kid = kid;
            }

            public String getSender() {
                return this.sender;
            }

            public void setSender(String sender) {
                this.sender = sender;
            }

            public String getPassword() {
                return this.password;
            }

            public void setPassword(String password) {
                this.password = password;
            }

            public String getOwf() {
                return this.owf;
            }

            public void setOwf(String owf) {
                this.owf = owf;
            }

            public int getIterationCount() {
                return this.iterationCount;
            }

            public void setIterationCount(int iterationCount) {
                this.iterationCount = iterationCount;
            }

            public String getMac() {
                return this.mac;
            }

            public void setMac(String mac) {
                this.mac = mac;
            }

            public void validate() throws InvalidConfException {
                PbmMac.notNull((Object)this.kid, (String)"kid");
                PbmMac.notEmpty((String)this.sender, (String)"sender");
                PbmMac.notEmpty((String)this.password, (String)"password");
                PbmMac.notEmpty((String)"owf", (String)this.owf);
                PbmMac.notEmpty((String)this.mac, (String)"mac");
            }
        }
    }

    public static class Cmpcontrol
    extends ValidatableConf {
        private boolean autoconf;
        private Boolean rrAkiRequired;

        public boolean isAutoconf() {
            return this.autoconf;
        }

        public void setAutoconf(boolean autoconf) {
            this.autoconf = autoconf;
        }

        public Boolean getRrAkiRequired() {
            return this.autoconf ? null : this.rrAkiRequired;
        }

        public void setRrAkiRequired(Boolean rrAkiRequired) {
            this.rrAkiRequired = rrAkiRequired;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class Certprofiles
    extends ValidatableConf {
        private boolean autoconf;
        private List<Certprofile> profiles;

        public boolean isAutoconf() {
            return this.autoconf;
        }

        public void setAutoconf(boolean autoconf) {
            this.autoconf = autoconf;
        }

        public List<Certprofile> getProfiles() {
            if (this.autoconf) {
                return Collections.emptyList();
            }
            if (this.profiles == null) {
                this.profiles = new LinkedList<Certprofile>();
            }
            return this.profiles;
        }

        public void setProfiles(List<Certprofile> profiles) {
            this.profiles = profiles;
        }

        public void validate() throws InvalidConfException {
            if (!this.autoconf) {
                Certprofiles.validate(this.profiles);
            }
        }
    }

    public static class Certprofile
    extends ValidatableConf {
        private String name;
        private String type;
        private FileOrValue conf;

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String value) {
            this.type = value;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue value) {
            this.conf = value;
        }

        public void validate() throws InvalidConfException {
            Certprofile.notEmpty((String)this.name, (String)"name");
            Certprofile.validate((ValidatableConf)this.conf);
        }
    }

    public static class Certs
    extends ValidatableConf {
        private boolean autoconf;
        private List<FileOrBinary> certificates;

        public boolean isAutoconf() {
            return this.autoconf;
        }

        public void setAutoconf(boolean autoconf) {
            this.autoconf = autoconf;
        }

        public List<FileOrBinary> getCertificates() {
            return this.autoconf ? null : this.certificates;
        }

        public void setCertificates(List<FileOrBinary> certificates) {
            this.certificates = certificates;
        }

        public void validate() throws InvalidConfException {
            if (!this.autoconf) {
                Certs.notEmpty(this.certificates, (String)"certificates");
                for (FileOrBinary m : this.certificates) {
                    m.validate();
                }
            }
        }
    }

    public static class Ca
    extends ValidatableConf {
        private String name;
        private String url;
        private String healthUrl;
        private String ssl;
        private String requestor;
        private String responder;
        private Cmpcontrol cmpcontrol;
        private Certs caCertchain;
        private Certs dhpocCerts;
        private Certprofiles certprofiles;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getHealthUrl() {
            return this.healthUrl;
        }

        public void setHealthUrl(String healthUrl) {
            this.healthUrl = healthUrl;
        }

        public String getSsl() {
            return this.ssl;
        }

        public void setSsl(String ssl) {
            this.ssl = ssl;
        }

        public String getRequestor() {
            return this.requestor;
        }

        public void setRequestor(String requestor) {
            this.requestor = requestor;
        }

        public String getResponder() {
            return this.responder;
        }

        public void setResponder(String responder) {
            this.responder = responder;
        }

        public Cmpcontrol getCmpcontrol() {
            return this.cmpcontrol;
        }

        public void setCmpcontrol(Cmpcontrol cmpcontrol) {
            this.cmpcontrol = cmpcontrol;
        }

        public Certs getCaCertchain() {
            return this.caCertchain;
        }

        public void setCaCertchain(Certs caCertchain) {
            this.caCertchain = caCertchain;
        }

        public Certs getDhpocCerts() {
            return this.dhpocCerts;
        }

        public void setDhpocCerts(Certs dhpocCerts) {
            this.dhpocCerts = dhpocCerts;
        }

        public Certprofiles getCertprofiles() {
            return this.certprofiles;
        }

        public void setCertprofiles(Certprofiles certprofiles) {
            this.certprofiles = certprofiles;
        }

        public void validate() throws InvalidConfException {
            Ca.notEmpty((String)this.name, (String)"name");
            Ca.notEmpty((String)this.url, (String)"url");
            Ca.notEmpty((String)this.requestor, (String)"requestor");
            Ca.notEmpty((String)this.responder, (String)"responder");
            Ca.validate((ValidatableConf)this.cmpcontrol);
            Ca.validate((ValidatableConf)this.caCertchain);
            Ca.validate((ValidatableConf)this.certprofiles);
            Ca.validate((ValidatableConf)this.dhpocCerts);
        }
    }
}

