/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.xipki.cmpclient.IdentifiedObject;
import org.xipki.util.Args;

public class EnrollCertRequest {
    private final EnrollType type;
    private final List<Entry> requestEntries = new LinkedList<Entry>();

    public EnrollCertRequest(EnrollType type) {
        this.type = (EnrollType)((Object)Args.notNull((Object)((Object)type), (String)"type"));
    }

    public EnrollType getType() {
        return this.type;
    }

    public boolean addRequestEntry(Entry requestEntry) {
        Args.notNull((Object)requestEntry, (String)"requestEntry");
        String id = requestEntry.getId();
        ASN1Integer certReqId = requestEntry.getCertReq().getCertReqId();
        for (Entry re : this.requestEntries) {
            if (re.getId().equals(id)) {
                return false;
            }
            if (!re.getCertReq().getCertReqId().equals((Object)certReqId)) continue;
            return false;
        }
        this.requestEntries.add(requestEntry);
        return true;
    }

    public List<Entry> getRequestEntries() {
        return Collections.unmodifiableList(this.requestEntries);
    }

    public static class Entry
    extends IdentifiedObject {
        private final String certprofile;
        private final CertRequest certReq;
        private final ProofOfPossession popo;
        private final boolean caGenerateKeypair;

        public Entry(String id, String certprofile, CertRequest certReq, ProofOfPossession popo) {
            super(id);
            this.certprofile = Args.notBlank((String)certprofile, (String)"certprofile");
            this.certReq = (CertRequest)Args.notNull((Object)certReq, (String)"certReq");
            this.caGenerateKeypair = false;
            this.popo = (ProofOfPossession)Args.notNull((Object)popo, (String)"popo");
        }

        public Entry(String id, String certprofile, CertRequest certReq, ProofOfPossession popo, boolean caGenerateKeypair, boolean kup) {
            super(id);
            this.certprofile = kup ? certprofile : Args.notBlank((String)certprofile, (String)"certprofile");
            this.certReq = (CertRequest)Args.notNull((Object)certReq, (String)"certReq");
            this.caGenerateKeypair = caGenerateKeypair;
            if (!caGenerateKeypair) {
                Args.notNull((Object)popo, (String)"popo");
            }
            this.popo = popo;
        }

        public String getCertprofile() {
            return this.certprofile;
        }

        public CertRequest getCertReq() {
            return this.certReq;
        }

        public ProofOfPossession getPopo() {
            return this.popo;
        }

        public boolean isCaGenerateKeypair() {
            return this.caGenerateKeypair;
        }
    }

    public static enum EnrollType {
        CERT_REQ,
        INIT_REQ,
        KEY_UPDATE,
        CROSS_CERT_REQ;

    }
}

