/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.GenMsgContent;
import org.bouncycastle.asn1.cmp.GenRepContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PBMParameter;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cmp.RevDetails;
import org.bouncycastle.asn1.cmp.RevRepContent;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.CertificateConfirmationContent;
import org.bouncycastle.cert.cmp.CertificateConfirmationContentBuilder;
import org.bouncycastle.cert.cmp.GeneralPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher;
import org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultSecretKeySizeProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.cmpclient.CertprofileInfo;
import org.xipki.cmpclient.CmpClientException;
import org.xipki.cmpclient.EnrollCertRequest;
import org.xipki.cmpclient.PkiErrorException;
import org.xipki.cmpclient.RevokeCertRequest;
import org.xipki.cmpclient.UnrevokeOrRemoveCertRequest;
import org.xipki.cmpclient.internal.CaConf;
import org.xipki.cmpclient.internal.CsrEnrollCertRequest;
import org.xipki.cmpclient.internal.EnrollCertResponse;
import org.xipki.cmpclient.internal.Requestor;
import org.xipki.cmpclient.internal.Responder;
import org.xipki.cmpclient.internal.ResultEntry;
import org.xipki.cmpclient.internal.RevokeCertResponse;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.XiSecurityException;
import org.xipki.security.cmp.CmpUtf8Pairs;
import org.xipki.security.cmp.CmpUtil;
import org.xipki.security.cmp.ProtectionResult;
import org.xipki.security.cmp.ProtectionVerificationResult;
import org.xipki.security.cmp.VerifiedPkiMessage;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.CmpFailureUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ReqRespDebug;

class CmpAgent {
    private static final Logger LOG = LoggerFactory.getLogger(CmpAgent.class);
    private static final String CMP_REQUEST_MIMETYPE = "application/pkixcmp";
    private static final String CMP_RESPONSE_MIMETYPE = "application/pkixcmp";
    private static final DigestCalculatorProvider DIGEST_CALCULATOR_PROVIDER = new BcDigestCalculatorProvider();
    private static final DefaultSecretKeySizeProvider KEYSIZE_PROVIDER = new DefaultSecretKeySizeProvider();
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    protected static final int PKISTATUS_RESPONSE_ERROR = -1;
    protected static final int PKISTATUS_NO_ANSWER = -2;
    protected final SecurityFactory securityFactory;
    private final Random random = new Random();
    private final Requestor requestor;
    private final Responder responder;
    private final X500Name recipientName;
    private boolean sendRequestorCert;
    private boolean implicitConfirm = true;
    private final URL serverUrl;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;

    CmpAgent(Requestor requestor, Responder responder, String serverUrl, SecurityFactory securityFactory, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) {
        boolean bothMacBased;
        this.requestor = (Requestor)Args.notNull((Object)requestor, (String)"requestor");
        this.responder = (Responder)Args.notNull((Object)responder, (String)"responder");
        this.securityFactory = (SecurityFactory)Args.notNull((Object)securityFactory, (String)"securityFactory");
        Args.notBlank((String)serverUrl, (String)"serverUrl");
        boolean bothSignatureBased = requestor instanceof Requestor.SignatureCmpRequestor && responder instanceof Responder.SignaturetCmpResponder;
        boolean bl = bothMacBased = requestor instanceof Requestor.PbmMacCmpRequestor && responder instanceof Responder.PbmMacCmpResponder;
        if (!bothSignatureBased && !bothMacBased) {
            throw new IllegalArgumentException("requestor and responder do not match");
        }
        this.recipientName = (X500Name)responder.getName().getName();
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        try {
            this.serverUrl = new URL(serverUrl);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("invalid URL: " + serverUrl);
        }
    }

    private byte[] send(byte[] request) throws IOException {
        Args.notNull((Object)request, (String)"request");
        HttpURLConnection httpUrlConnection = IoUtil.openHttpConn((URL)this.serverUrl);
        if (httpUrlConnection instanceof HttpsURLConnection) {
            if (this.sslSocketFactory != null) {
                ((HttpsURLConnection)httpUrlConnection).setSSLSocketFactory(this.sslSocketFactory);
            }
            if (this.hostnameVerifier != null) {
                ((HttpsURLConnection)httpUrlConnection).setHostnameVerifier(this.hostnameVerifier);
            }
        }
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setUseCaches(false);
        int size = request.length;
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setRequestProperty("Content-Type", "application/pkixcmp");
        httpUrlConnection.setRequestProperty("Content-Length", Integer.toString(size));
        OutputStream outputstream = httpUrlConnection.getOutputStream();
        outputstream.write(request);
        outputstream.flush();
        InputStream inputStream = httpUrlConnection.getInputStream();
        if (httpUrlConnection.getResponseCode() != 200) {
            inputStream.close();
            throw new IOException("bad response: " + httpUrlConnection.getResponseCode() + "    " + httpUrlConnection.getResponseMessage());
        }
        String responseContentType = httpUrlConnection.getContentType();
        boolean isValidContentType = false;
        if (responseContentType != null && responseContentType.equalsIgnoreCase("application/pkixcmp")) {
            isValidContentType = true;
        }
        if (!isValidContentType) {
            inputStream.close();
            throw new IOException("bad response: mime type " + responseContentType + " not supported!");
        }
        return IoUtil.read((InputStream)inputStream);
    }

    private PKIMessage sign(PKIMessage request) throws CmpClientException {
        Args.notNull((Object)request, (String)"request");
        if (this.requestor == null) {
            throw new CmpClientException("no request signer is configured");
        }
        if (this.requestor instanceof Requestor.SignatureCmpRequestor) {
            ConcurrentContentSigner signer = ((Requestor.SignatureCmpRequestor)this.requestor).getSigner();
            try {
                return CmpUtil.addProtection((PKIMessage)request, (ConcurrentContentSigner)signer, (GeneralName)this.requestor.getName(), (boolean)this.sendRequestorCert);
            }
            catch (CMPException | NoIdleSignerException ex) {
                throw new CmpClientException("could not sign the request", ex);
            }
        }
        Requestor.PbmMacCmpRequestor pbmRequestor = (Requestor.PbmMacCmpRequestor)this.requestor;
        try {
            return CmpUtil.addProtection((PKIMessage)request, (char[])pbmRequestor.getPassword(), (PBMParameter)pbmRequestor.getParameter(), (GeneralName)this.requestor.getName(), (byte[])pbmRequestor.getSenderKID());
        }
        catch (CMPException ex) {
            throw new CmpClientException("could not sign the request", ex);
        }
    }

    private VerifiedPkiMessage signAndSend(PKIMessage request, ReqRespDebug debug) throws CmpClientException {
        PKIBody respBody;
        int bodyType;
        ASN1OctetString respRecipientNonce;
        GeneralPKIMessage response;
        byte[] encodedResponse;
        byte[] encodedRequest;
        Args.notNull((Object)request, (String)"request");
        PKIMessage tmpRequest = this.requestor.signRequest() ? this.sign(request) : request;
        try {
            encodedRequest = tmpRequest.getEncoded();
        }
        catch (IOException ex) {
            LOG.error("could not encode the PKI request {}", (Object)tmpRequest);
            throw new CmpClientException(ex.getMessage(), ex);
        }
        ReqRespDebug.ReqRespPair reqResp = null;
        if (debug != null) {
            reqResp = new ReqRespDebug.ReqRespPair();
            debug.add(reqResp);
            if (debug.saveRequest()) {
                reqResp.setRequest(encodedRequest);
            }
        }
        try {
            encodedResponse = this.send(encodedRequest);
        }
        catch (IOException ex) {
            LOG.error("could not send the PKI request {} to server", (Object)tmpRequest);
            throw new CmpClientException("TRANSPORT_ERROR", ex);
        }
        if (reqResp != null && debug.saveResponse()) {
            reqResp.setResponse(encodedResponse);
        }
        try {
            response = new GeneralPKIMessage(encodedResponse);
        }
        catch (IOException ex) {
            LOG.error("could not decode the received PKI message: {}", (Object)Hex.encode((byte[])encodedResponse));
            throw new CmpClientException(ex.getMessage(), ex);
        }
        PKIHeader reqHeader = request.getHeader();
        PKIHeader respHeader = response.getHeader();
        ASN1OctetString tid = reqHeader.getTransactionID();
        ASN1OctetString respTid = respHeader.getTransactionID();
        if (!tid.equals((ASN1Primitive)respTid)) {
            LOG.warn("Response contains different tid ({}) than requested {}", (Object)respTid, (Object)tid);
            throw new CmpClientException("Response contains differnt tid than the request");
        }
        ASN1OctetString senderNonce = reqHeader.getSenderNonce();
        if (!senderNonce.equals((ASN1Primitive)(respRecipientNonce = respHeader.getRecipNonce()))) {
            LOG.warn("tid {}: response.recipientNonce ({}) != request.senderNonce ({})", new Object[]{tid, respRecipientNonce, senderNonce});
            throw new CmpClientException("Response contains differnt tid than the request");
        }
        GeneralName rec = respHeader.getRecipient();
        if (!this.requestor.getName().equals((Object)rec)) {
            LOG.warn("tid={}: unknown CMP requestor '{}'", (Object)tid, (Object)rec);
        }
        VerifiedPkiMessage ret = new VerifiedPkiMessage(response);
        if (response.hasProtection()) {
            try {
                ProtectionVerificationResult verifyProtection = this.verifyProtection(Hex.encode((byte[])tid.getOctets()), response);
                ret.setProtectionVerificationResult(verifyProtection);
            }
            catch (InvalidKeyException | CMPException | OperatorCreationException ex) {
                throw new CmpClientException(ex.getMessage(), ex);
            }
        } else if (this.requestor.signRequest() && (bodyType = (respBody = response.getBody()).getType()) != 23) {
            throw new CmpClientException("response is not signed");
        }
        return ret;
    }

    private ASN1Encodable extractGeneralRepContent(VerifiedPkiMessage response, String expectedType, boolean requireProtectionCheck) throws CmpClientException, PkiErrorException {
        PKIBody respBody;
        int bodyType;
        Args.notNull((Object)response, (String)"response");
        Args.notNull((Object)expectedType, (String)"expectedType");
        if (requireProtectionCheck) {
            this.checkProtection(response);
        }
        if (23 == (bodyType = (respBody = response.getPkiMessage().getBody()).getType())) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new CmpClientException(CmpFailureUtil.formatPkiStatusInfo((PKIStatusInfo)content.getPKIStatusInfo()));
        }
        if (22 != bodyType) {
            throw new CmpClientException(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, 22, 23));
        }
        GenRepContent genRep = GenRepContent.getInstance((Object)respBody.getContent());
        InfoTypeAndValue[] itvs = genRep.toInfoTypeAndValueArray();
        InfoTypeAndValue itv = null;
        if (itvs != null && itvs.length > 0) {
            for (InfoTypeAndValue entry : itvs) {
                if (!expectedType.equals(entry.getInfoType().getId())) continue;
                itv = entry;
                break;
            }
        }
        if (itv == null) {
            throw new CmpClientException("the response does not contain InfoTypeAndValue " + expectedType);
        }
        return itv.getInfoValue();
    }

    private ASN1Encodable extractXipkiActionRepContent(VerifiedPkiMessage response, int action) throws CmpClientException, PkiErrorException {
        ASN1Encodable itvValue = this.extractGeneralRepContent((VerifiedPkiMessage)Args.notNull((Object)response, (String)"response"), ObjectIdentifiers.Xipki.id_xipki_cmp_cmpGenmsg.getId(), true);
        return this.extractXiActionContent(itvValue, action);
    }

    private ASN1Encodable extractXiActionContent(ASN1Encodable itvValue, int action) throws CmpClientException {
        int tmpAction;
        ASN1Sequence seq;
        try {
            seq = ASN1Sequence.getInstance((Object)Args.notNull((Object)itvValue, (String)"itvValue"));
        }
        catch (IllegalArgumentException ex) {
            throw new CmpClientException("invalid syntax of the response");
        }
        int size = seq.size();
        if (size != 1 && size != 2) {
            throw new CmpClientException("invalid syntax of the response");
        }
        try {
            tmpAction = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue().intValue();
        }
        catch (IllegalArgumentException ex) {
            throw new CmpClientException("invalid syntax of the response");
        }
        if (action != tmpAction) {
            throw new CmpClientException("received XiPKI action '" + tmpAction + "' instead the expected '" + action + "'");
        }
        return size == 1 ? null : seq.getObjectAt(1);
    }

    private PKIHeader buildPkiHeader(ASN1OctetString tid) {
        return this.buildPkiHeader(false, tid, null, null);
    }

    private PKIHeader buildPkiHeader(boolean addImplictConfirm, ASN1OctetString tid) {
        return this.buildPkiHeader(addImplictConfirm, tid, null, null);
    }

    private PKIHeader buildPkiHeader(boolean addImplictConfirm, ASN1OctetString tid, CmpUtf8Pairs utf8Pairs, InfoTypeAndValue ... additionalGeneralInfos) {
        if (additionalGeneralInfos != null) {
            for (InfoTypeAndValue itv : additionalGeneralInfos) {
                ASN1ObjectIdentifier type = itv.getInfoType();
                if (CMPObjectIdentifiers.it_implicitConfirm.equals((ASN1Primitive)type)) {
                    throw new IllegalArgumentException("additionGeneralInfos contains not-permitted ITV implicitConfirm");
                }
                if (!CMPObjectIdentifiers.regInfo_utf8Pairs.equals((ASN1Primitive)type)) continue;
                throw new IllegalArgumentException("additionGeneralInfos contains not-permitted ITV utf8Pairs");
            }
        }
        PKIHeaderBuilder hdrBuilder = new PKIHeaderBuilder(2, this.requestor.getName(), this.responder.getName());
        hdrBuilder.setMessageTime(new ASN1GeneralizedTime(new Date()));
        ASN1OctetString tmpTid = tid == null ? new DEROctetString(this.randomTransactionId()) : tid;
        hdrBuilder.setTransactionID(tmpTid);
        hdrBuilder.setSenderNonce(this.randomSenderNonce());
        ArrayList<InfoTypeAndValue> itvs = new ArrayList<InfoTypeAndValue>(2);
        if (addImplictConfirm) {
            itvs.add(CmpUtil.getImplictConfirmGeneralInfo());
        }
        if (utf8Pairs != null) {
            itvs.add(CmpUtil.buildInfoTypeAndValue((CmpUtf8Pairs)utf8Pairs));
        }
        if (additionalGeneralInfos != null) {
            for (InfoTypeAndValue itv : additionalGeneralInfos) {
                if (itv == null) continue;
                itvs.add(itv);
            }
        }
        if (CollectionUtil.isNotEmpty(itvs)) {
            hdrBuilder.setGeneralInfo(itvs.toArray(new InfoTypeAndValue[0]));
        }
        return hdrBuilder.build();
    }

    private byte[] randomTransactionId() {
        byte[] tid = new byte[20];
        this.random.nextBytes(tid);
        return tid;
    }

    private byte[] randomSenderNonce() {
        byte[] bytes = new byte[16];
        this.random.nextBytes(bytes);
        return bytes;
    }

    private ProtectionVerificationResult verifyProtection(String tid, GeneralPKIMessage pkiMessage) throws CMPException, InvalidKeyException, OperatorCreationException {
        ProtectedPKIMessage protectedMsg = new ProtectedPKIMessage(pkiMessage);
        PKIHeader header = protectedMsg.getHeader();
        if (this.requestor instanceof Requestor.PbmMacCmpRequestor) {
            if (!protectedMsg.hasPasswordBasedMacProtection()) {
                LOG.warn("NOT_MAC_BASED: {}", (Object)pkiMessage.getHeader().getProtectionAlg().getAlgorithm().getId());
                return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
            }
            Responder.PbmMacCmpResponder macResponder = (Responder.PbmMacCmpResponder)this.responder;
            PBMParameter parameter = PBMParameter.getInstance((Object)pkiMessage.getHeader().getProtectionAlg().getParameters());
            AlgorithmIdentifier algId = parameter.getOwf();
            if (!macResponder.isPbmOwfPermitted(algId)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.owf: {})", (Object)algId.getAlgorithm().getId());
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            algId = parameter.getMac();
            if (!macResponder.isPbmMacPermitted(algId)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.mac: {})", (Object)algId.getAlgorithm().getId());
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            PKMACBuilder pkMacBuilder = new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator());
            Requestor.PbmMacCmpRequestor macRequestor = (Requestor.PbmMacCmpRequestor)this.requestor;
            boolean macValid = protectedMsg.verify(pkMacBuilder, macRequestor.getPassword());
            return new ProtectionVerificationResult((Object)this.requestor, macValid ? ProtectionResult.MAC_VALID : ProtectionResult.MAC_INVALID);
        }
        if (protectedMsg.hasPasswordBasedMacProtection()) {
            LOG.warn("NOT_SIGNATURE_BASED: {}", (Object)pkiMessage.getHeader().getProtectionAlg().getAlgorithm().getId());
            return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        if (this.recipientName != null) {
            boolean authorizedResponder = true;
            if (header.getSender().getTagNo() != 4) {
                authorizedResponder = false;
            } else {
                X500Name msgSender = X500Name.getInstance((Object)header.getSender().getName());
                authorizedResponder = this.recipientName.equals((Object)msgSender);
            }
            if (!authorizedResponder) {
                LOG.warn("tid={}: not authorized responder '{}'", (Object)tid, (Object)header.getSender());
                return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
            }
        }
        Responder.SignaturetCmpResponder sigResponder = (Responder.SignaturetCmpResponder)this.responder;
        AlgorithmIdentifier protectionAlgo = protectedMsg.getHeader().getProtectionAlg();
        if (!sigResponder.getSigAlgoValidator().isAlgorithmPermitted(protectionAlgo)) {
            String algoName;
            try {
                algoName = AlgorithmUtil.getSignatureAlgoName((AlgorithmIdentifier)protectionAlgo);
            }
            catch (NoSuchAlgorithmException ex) {
                algoName = protectionAlgo.getAlgorithm().getId();
            }
            LOG.warn("tid={}: response protected by untrusted protection algorithm '{}'", (Object)tid, (Object)algoName);
            return new ProtectionVerificationResult(null, ProtectionResult.SIGNATURE_INVALID);
        }
        X509Certificate cert = sigResponder.getCert();
        ContentVerifierProvider verifierProvider = this.securityFactory.getContentVerifierProvider(cert);
        if (verifierProvider == null) {
            LOG.warn("tid={}: not authorized responder '{}'", (Object)tid, (Object)header.getSender());
            return new ProtectionVerificationResult((Object)cert, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        boolean signatureValid = protectedMsg.verify(verifierProvider);
        return new ProtectionVerificationResult((Object)cert, signatureValid ? ProtectionResult.SIGNATURE_VALID : ProtectionResult.SIGNATURE_INVALID);
    }

    private PKIMessage buildMessageWithXipkiAction(int action, ASN1Encodable value) {
        PKIHeader header = this.buildPkiHeader(null);
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1Integer((long)action));
        if (value != null) {
            vec.add(value);
        }
        InfoTypeAndValue itv = new InfoTypeAndValue(ObjectIdentifiers.Xipki.id_xipki_cmp_cmpGenmsg, (ASN1Encodable)new DERSequence(vec));
        GenMsgContent genMsgContent = new GenMsgContent(itv);
        PKIBody body = new PKIBody(21, (ASN1Encodable)genMsgContent);
        return new PKIMessage(header, body);
    }

    private PKIMessage buildMessageWithGeneralMsgContent(ASN1ObjectIdentifier type, ASN1Encodable value) {
        Args.notNull((Object)type, (String)"type");
        PKIHeader header = this.buildPkiHeader(null);
        InfoTypeAndValue itv = value != null ? new InfoTypeAndValue(type, value) : new InfoTypeAndValue(type);
        GenMsgContent genMsgContent = new GenMsgContent(itv);
        PKIBody body = new PKIBody(21, (ASN1Encodable)genMsgContent);
        return new PKIMessage(header, body);
    }

    private void checkProtection(VerifiedPkiMessage response) throws PkiErrorException {
        boolean valid;
        Args.notNull((Object)response, (String)"response");
        if (!response.hasProtection()) {
            return;
        }
        ProtectionVerificationResult protectionVerificationResult = response.getProtectionVerificationResult();
        if (protectionVerificationResult == null) {
            valid = false;
        } else {
            ProtectionResult protectionResult = protectionVerificationResult.getProtectionResult();
            boolean bl = valid = protectionResult == ProtectionResult.MAC_VALID || protectionResult == ProtectionResult.SIGNATURE_VALID;
        }
        if (!valid) {
            throw new PkiErrorException(-1, 64, "message check of the response failed");
        }
    }

    public boolean isSendRequestorCert() {
        return this.sendRequestorCert;
    }

    public void setSendRequestorCert(boolean sendRequestorCert) {
        this.sendRequestorCert = sendRequestorCert;
    }

    private static byte[] decrypt(EncryptedValue ev, char[] password) throws XiSecurityException {
        AlgorithmIdentifier symmAlg = ev.getSymmAlg();
        if (!PKCSObjectIdentifiers.id_PBES2.equals((ASN1Primitive)symmAlg.getAlgorithm())) {
            throw new XiSecurityException("unsupported symmAlg " + symmAlg.getAlgorithm().getId());
        }
        PBES2Parameters alg = PBES2Parameters.getInstance((Object)symmAlg.getParameters());
        PBKDF2Params func = PBKDF2Params.getInstance((Object)alg.getKeyDerivationFunc().getParameters());
        AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance((Object)alg.getEncryptionScheme());
        try {
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(alg.getKeyDerivationFunc().getAlgorithm().getId());
            int iterations = func.getIterationCount().intValue();
            SecretKey key = keyFact.generateSecret((KeySpec)new PBKDF2KeySpec(password, func.getSalt(), iterations, KEYSIZE_PROVIDER.getKeySize(encScheme), func.getPrf()));
            key = new SecretKeySpec(key.getEncoded(), "AES");
            String cipherAlgOid = alg.getEncryptionScheme().getAlgorithm().getId();
            Cipher cipher = Cipher.getInstance(cipherAlgOid);
            ASN1Encodable encParams = alg.getEncryptionScheme().getParameters();
            GCMParameters gcmParameters = GCMParameters.getInstance((Object)encParams);
            GCMParameterSpec gcmParamSpec = new GCMParameterSpec(gcmParameters.getIcvLen() * 8, gcmParameters.getNonce());
            cipher.init(2, (Key)key, gcmParamSpec);
            return cipher.doFinal(ev.getEncValue().getOctets());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new XiSecurityException("Error while decrypting the EncryptedValue", (Throwable)ex);
        }
    }

    private static byte[] decrypt(EncryptedValue ev, PrivateKey decKey) throws XiSecurityException {
        AlgorithmIdentifier keyAlg = ev.getKeyAlg();
        ASN1ObjectIdentifier keyOid = keyAlg.getAlgorithm();
        try {
            byte[] symmKey;
            if (decKey instanceof RSAPrivateKey) {
                Cipher keyCipher;
                if (keyOid.equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSAES_OAEP)) {
                    if (keyAlg.getParameters() != null) {
                        RSAESOAEPparams params = RSAESOAEPparams.getInstance((Object)keyAlg.getParameters());
                        ASN1ObjectIdentifier oid = params.getHashAlgorithm().getAlgorithm();
                        if (!oid.equals((ASN1Primitive)RSAESOAEPparams.DEFAULT_HASH_ALGORITHM.getAlgorithm())) {
                            throw new XiSecurityException("unsupported RSAESOAEPparams.HashAlgorithm " + oid.getId());
                        }
                        oid = params.getMaskGenAlgorithm().getAlgorithm();
                        if (!oid.equals((ASN1Primitive)RSAESOAEPparams.DEFAULT_MASK_GEN_FUNCTION.getAlgorithm())) {
                            throw new XiSecurityException("unsupported RSAESOAEPparams.MaskGenAlgorithm " + oid.getId());
                        }
                        oid = params.getPSourceAlgorithm().getAlgorithm();
                        if (!params.getPSourceAlgorithm().equals((Object)RSAESOAEPparams.DEFAULT_P_SOURCE_ALGORITHM)) {
                            throw new XiSecurityException("unsupported RSAESOAEPparams.PSourceAlgorithm " + oid.getId());
                        }
                    }
                    keyCipher = Cipher.getInstance("RSA/NONE/OAEPPADDING");
                } else if (keyOid.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption)) {
                    keyCipher = Cipher.getInstance("RSA/NONE/PKCS1PADDING");
                } else {
                    throw new XiSecurityException("unsupported keyAlg " + keyOid.getId());
                }
                keyCipher.init(2, decKey);
                symmKey = keyCipher.doFinal(ev.getEncSymmKey().getOctets());
            } else if (decKey instanceof ECPrivateKey) {
                ASN1Sequence params = ASN1Sequence.getInstance((Object)keyAlg.getParameters());
                int n = params.size();
                for (int i = 0; i < n; ++i) {
                    AlgorithmIdentifier hashAlgorithm;
                    AlgorithmIdentifier algId;
                    if (!keyOid.equals((ASN1Primitive)ObjectIdentifiers.Secg.id_ecies_specifiedParameters)) {
                        throw new XiSecurityException("unsupported keyAlg " + keyOid.getId());
                    }
                    ASN1TaggedObject to = (ASN1TaggedObject)params.getObjectAt(i);
                    int tag = to.getTagNo();
                    if (tag == 0) {
                        algId = AlgorithmIdentifier.getInstance((Object)to.getObject());
                        if (ObjectIdentifiers.Misc.id_iso18033_kdf2.equals((ASN1Primitive)algId.getAlgorithm())) {
                            hashAlgorithm = AlgorithmIdentifier.getInstance((Object)algId.getParameters());
                            if (hashAlgorithm.getAlgorithm().equals((ASN1Primitive)HashAlgo.SHA1.getOid())) continue;
                            throw new XiSecurityException("unsupported KeyDerivationFunction.HashAlgorithm " + hashAlgorithm.getAlgorithm().getId());
                        }
                        throw new XiSecurityException("unsupported KeyDerivationFunction " + algId.getAlgorithm().getId());
                    }
                    if (tag == 1) {
                        algId = AlgorithmIdentifier.getInstance((Object)to.getObject());
                        if (ObjectIdentifiers.Secg.id_aes128_cbc_in_ecies.equals((ASN1Primitive)algId.getAlgorithm())) continue;
                        throw new XiSecurityException("unsupported SymmetricEncryption " + algId.getAlgorithm().getId());
                    }
                    if (tag != 2) continue;
                    algId = AlgorithmIdentifier.getInstance((Object)to.getObject());
                    if (ObjectIdentifiers.Secg.id_hmac_full_ecies.equals((ASN1Primitive)algId.getAlgorithm())) {
                        hashAlgorithm = AlgorithmIdentifier.getInstance((Object)algId.getParameters());
                        if (hashAlgorithm.getAlgorithm().equals((ASN1Primitive)HashAlgo.SHA1.getOid())) continue;
                        throw new XiSecurityException("unsupported MessageAuthenticationCode.HashAlgorithm " + hashAlgorithm.getAlgorithm().getId());
                    }
                    throw new XiSecurityException("unsupported MessageAuthenticationCode " + algId.getAlgorithm().getId());
                }
                int aesKeySize = 128;
                byte[] iv = new byte[16];
                IESParameterSpec spec = new IESParameterSpec(null, null, aesKeySize, aesKeySize, iv);
                CBCBlockCipher cbcCipher = new CBCBlockCipher((BlockCipher)new AESEngine());
                IESCipher keyCipher = new IESCipher(new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()), (Mac)new HMac(DigestFactory.createSHA1()), (BufferedBlockCipher)new PaddedBufferedBlockCipher((BlockCipher)cbcCipher)), 16);
                keyCipher.engineInit(2, (Key)decKey, (AlgorithmParameterSpec)spec, null);
                byte[] encSymmKey = ev.getEncSymmKey().getOctets();
                ASN1Sequence seq = DERSequence.getInstance((Object)encSymmKey);
                byte[] ephemeralPublicKey = DEROctetString.getInstance((Object)seq.getObjectAt(0)).getOctets();
                byte[] symmetricCiphertext = DEROctetString.getInstance((Object)seq.getObjectAt(1)).getOctets();
                byte[] macTag = DEROctetString.getInstance((Object)seq.getObjectAt(2)).getOctets();
                byte[] bcInput = new byte[ephemeralPublicKey.length + symmetricCiphertext.length + macTag.length];
                System.arraycopy(ephemeralPublicKey, 0, bcInput, 0, ephemeralPublicKey.length);
                int offset = ephemeralPublicKey.length;
                System.arraycopy(symmetricCiphertext, 0, bcInput, offset, symmetricCiphertext.length);
                System.arraycopy(macTag, 0, bcInput, offset += symmetricCiphertext.length, macTag.length);
                symmKey = keyCipher.engineDoFinal(bcInput, 0, bcInput.length);
            } else {
                throw new XiSecurityException("unsupported decryption key type " + decKey.getClass().getName());
            }
            AlgorithmIdentifier symmAlg = ev.getSymmAlg();
            ASN1ObjectIdentifier symmAlgOid = symmAlg.getAlgorithm();
            if (!symmAlgOid.equals((ASN1Primitive)NISTObjectIdentifiers.id_aes128_GCM)) {
                throw new XiSecurityException("unsupported symmAlg " + symmAlgOid.getId());
            }
            GCMParameters params = GCMParameters.getInstance((Object)symmAlg.getParameters());
            Cipher dataCipher = Cipher.getInstance(symmAlgOid.getId());
            GCMParameterSpec algParams = new GCMParameterSpec(params.getIcvLen() << 3, params.getNonce());
            dataCipher.init(2, (Key)new SecretKeySpec(symmKey, "AES"), algParams);
            byte[] encValue = ev.getEncValue().getOctets();
            return dataCipher.doFinal(encValue);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new XiSecurityException("Error while decrypting the EncryptedValue", (Throwable)ex);
        }
    }

    public X509CRL generateCrl(ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        int action = 1;
        PKIMessage request = this.buildMessageWithXipkiAction(action, null);
        VerifiedPkiMessage response = this.signAndSend(request, debug);
        return this.evaluateCrlResponse(response, action);
    }

    public X509CRL downloadCurrentCrl(ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        return this.downloadCrl(null, debug);
    }

    public X509CRL downloadCrl(BigInteger crlNumber, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        PKIMessage request;
        Integer action = null;
        if (crlNumber == null) {
            ASN1ObjectIdentifier type = CMPObjectIdentifiers.it_currentCRL;
            request = this.buildMessageWithGeneralMsgContent(type, null);
        } else {
            action = 2;
            request = this.buildMessageWithXipkiAction(action, (ASN1Encodable)new ASN1Integer(crlNumber));
        }
        VerifiedPkiMessage response = this.signAndSend(request, debug);
        return this.evaluateCrlResponse(response, action);
    }

    private X509CRL evaluateCrlResponse(VerifiedPkiMessage response, Integer xipkiAction) throws CmpClientException, PkiErrorException {
        X509CRL crl;
        this.checkProtection((VerifiedPkiMessage)Args.notNull((Object)response, (String)"response"));
        PKIBody respBody = response.getPkiMessage().getBody();
        int bodyType = respBody.getType();
        if (23 == bodyType) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new PkiErrorException(content.getPKIStatusInfo());
        }
        if (22 != bodyType) {
            throw new CmpClientException(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, 22, 23));
        }
        ASN1ObjectIdentifier expectedType = xipkiAction == null ? CMPObjectIdentifiers.it_currentCRL : ObjectIdentifiers.Xipki.id_xipki_cmp_cmpGenmsg;
        GenRepContent genRep = GenRepContent.getInstance((Object)respBody.getContent());
        InfoTypeAndValue[] itvs = genRep.toInfoTypeAndValueArray();
        InfoTypeAndValue itv = null;
        if (itvs != null && itvs.length > 0) {
            for (InfoTypeAndValue m : itvs) {
                if (!expectedType.equals((ASN1Primitive)m.getInfoType())) continue;
                itv = m;
                break;
            }
        }
        if (itv == null) {
            throw new CmpClientException("the response does not contain InfoTypeAndValue " + expectedType);
        }
        ASN1Encodable certListAsn1Object = xipkiAction == null ? itv.getInfoValue() : this.extractXiActionContent(itv.getInfoValue(), xipkiAction);
        CertificateList certList = CertificateList.getInstance((Object)certListAsn1Object);
        try {
            crl = X509Util.toX509Crl((CertificateList)certList);
        }
        catch (CRLException | CertificateException ex) {
            throw new CmpClientException("returned CRL is invalid: " + ex.getMessage());
        }
        return crl;
    }

    public RevokeCertResponse revokeCertificate(RevokeCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        PKIMessage reqMessage = this.buildRevokeCertRequest((RevokeCertRequest)Args.notNull((Object)request, (String)"request"));
        VerifiedPkiMessage response = this.signAndSend(reqMessage, debug);
        return this.parse(response, request.getRequestEntries());
    }

    public RevokeCertResponse unrevokeCertificate(UnrevokeOrRemoveCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        PKIMessage reqMessage = this.buildUnrevokeOrRemoveCertRequest((UnrevokeOrRemoveCertRequest)Args.notNull((Object)request, (String)"request"), CrlReason.REMOVE_FROM_CRL.getCode());
        VerifiedPkiMessage response = this.signAndSend(reqMessage, debug);
        return this.parse(response, request.getRequestEntries());
    }

    public RevokeCertResponse removeCertificate(UnrevokeOrRemoveCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        PKIMessage reqMessage = this.buildUnrevokeOrRemoveCertRequest((UnrevokeOrRemoveCertRequest)Args.notNull((Object)request, (String)"request"), -1);
        VerifiedPkiMessage response = this.signAndSend(reqMessage, debug);
        return this.parse(response, request.getRequestEntries());
    }

    private RevokeCertResponse parse(VerifiedPkiMessage response, List<? extends UnrevokeOrRemoveCertRequest.Entry> reqEntries) throws CmpClientException, PkiErrorException {
        this.checkProtection((VerifiedPkiMessage)Args.notNull((Object)response, (String)"response"));
        PKIBody respBody = response.getPkiMessage().getBody();
        int bodyType = respBody.getType();
        if (23 == bodyType) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new PkiErrorException(content.getPKIStatusInfo());
        }
        if (12 != bodyType) {
            throw new CmpClientException(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, 12, 23));
        }
        RevRepContent content = RevRepContent.getInstance((Object)respBody.getContent());
        PKIStatusInfo[] statuses = content.getStatus();
        if (statuses == null || statuses.length != reqEntries.size()) {
            int statusesLen = 0;
            if (statuses != null) {
                statusesLen = statuses.length;
            }
            throw new CmpClientException(String.format("incorrect number of status entries in response '%s' instead the expected '%s'", statusesLen, reqEntries.size()));
        }
        CertId[] revCerts = content.getRevCerts();
        RevokeCertResponse result = new RevokeCertResponse();
        for (int i = 0; i < statuses.length; ++i) {
            PKIStatusInfo statusInfo = statuses[i];
            int status = statusInfo.getStatus().intValue();
            UnrevokeOrRemoveCertRequest.Entry re = reqEntries.get(i);
            if (status != 0 && status != 1) {
                PKIFreeText text = statusInfo.getStatusString();
                CertId[] statusString = text == null ? null : text.getStringAt(0).getString();
                ResultEntry.Error resultEntry = new ResultEntry.Error(re.getId(), status, statusInfo.getFailInfo().intValue(), (String)statusString);
                result.addResultEntry(resultEntry);
                continue;
            }
            CertId certId = null;
            if (revCerts != null) {
                for (CertId entry : revCerts) {
                    if (!re.getIssuer().equals((Object)entry.getIssuer().getName()) || !re.getSerialNumber().equals(entry.getSerialNumber().getValue())) continue;
                    certId = entry;
                    break;
                }
            }
            if (certId == null) {
                LOG.warn("certId is not present in response for (issuer='{}', serialNumber={})", (Object)X509Util.getRfc4519Name((X500Name)re.getIssuer()), (Object)LogUtil.formatCsn((BigInteger)re.getSerialNumber()));
                certId = new CertId(new GeneralName(re.getIssuer()), re.getSerialNumber());
                continue;
            }
            ResultEntry.RevokeCert resultEntry = new ResultEntry.RevokeCert(re.getId(), certId);
            result.addResultEntry(resultEntry);
        }
        return result;
    }

    public EnrollCertResponse requestCertificate(CsrEnrollCertRequest csr, Date notBefore, Date notAfter, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        PKIMessage request = this.buildPkiMessage((CsrEnrollCertRequest)Args.notNull((Object)csr, (String)"csr"), notBefore, notAfter);
        HashMap<BigInteger, String> reqIdIdMap = new HashMap<BigInteger, String>();
        reqIdIdMap.put(MINUS_ONE, csr.getId());
        return this.requestCertificate0(request, reqIdIdMap, 3, debug);
    }

    public EnrollCertResponse requestCertificate(EnrollCertRequest req, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        int exptectedBodyType;
        PKIMessage request = this.buildPkiMessage((EnrollCertRequest)Args.notNull((Object)req, (String)"req"));
        HashMap<BigInteger, String> reqIdIdMap = new HashMap<BigInteger, String>();
        List<EnrollCertRequest.Entry> reqEntries = req.getRequestEntries();
        for (EnrollCertRequest.Entry reqEntry : reqEntries) {
            reqIdIdMap.put(reqEntry.getCertReq().getCertReqId().getValue(), reqEntry.getId());
        }
        switch (req.getType()) {
            case INIT_REQ: {
                exptectedBodyType = 1;
                break;
            }
            case CERT_REQ: {
                exptectedBodyType = 3;
                break;
            }
            case KEY_UPDATE: {
                exptectedBodyType = 8;
                break;
            }
            case CROSS_CERT_REQ: {
                exptectedBodyType = 14;
                break;
            }
            default: {
                throw new IllegalStateException("unknown EnrollCertRequest.Type " + (Object)((Object)req.getType()));
            }
        }
        return this.requestCertificate0(request, reqIdIdMap, exptectedBodyType, debug);
    }

    private EnrollCertResponse requestCertificate0(PKIMessage reqMessage, Map<BigInteger, String> reqIdIdMap, int expectedBodyType, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        VerifiedPkiMessage response = this.signAndSend(reqMessage, debug);
        this.checkProtection(response);
        PKIBody respBody = response.getPkiMessage().getBody();
        int bodyType = respBody.getType();
        if (23 == bodyType) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new PkiErrorException(content.getPKIStatusInfo());
        }
        if (expectedBodyType != bodyType) {
            throw new CmpClientException(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, expectedBodyType, 23));
        }
        CertRepMessage certRep = CertRepMessage.getInstance((Object)respBody.getContent());
        CertResponse[] certResponses = certRep.getResponse();
        EnrollCertResponse result = new EnrollCertResponse();
        CMPCertificate[] caPubs = certRep.getCaPubs();
        if (caPubs != null && caPubs.length > 0) {
            for (int i = 0; i < caPubs.length; ++i) {
                if (caPubs[i] == null) continue;
                result.addCaCertificate(caPubs[i]);
            }
        }
        CertificateConfirmationContentBuilder certConfirmBuilder = null;
        if (!CmpUtil.isImplictConfirm((PKIHeader)response.getPkiMessage().getHeader())) {
            certConfirmBuilder = new CertificateConfirmationContentBuilder();
        }
        boolean requireConfirm = false;
        for (CertResponse certResp : certResponses) {
            ResultEntry resultEntry;
            PKIStatusInfo statusInfo = certResp.getStatus();
            int status = statusInfo.getStatus().intValue();
            BigInteger certReqId = certResp.getCertReqId().getValue();
            String thisId = reqIdIdMap.get(certReqId);
            if (thisId != null) {
                reqIdIdMap.remove(certReqId);
            } else if (reqIdIdMap.size() == 1) {
                thisId = reqIdIdMap.values().iterator().next();
                reqIdIdMap.clear();
            }
            if (thisId == null) continue;
            if (status == 0 || status == 1) {
                CertifiedKeyPair cvk = certResp.getCertifiedKeyPair();
                if (cvk == null) {
                    return null;
                }
                CMPCertificate cmpCert = cvk.getCertOrEncCert().getCertificate();
                if (cmpCert == null) {
                    return null;
                }
                if (this.requestor == null) {
                    resultEntry = new ResultEntry.Error(thisId, -1, 0x40000000, "could not decrypt PrivateKeyInfo/requestor is null");
                    continue;
                }
                PrivateKeyInfo privKeyInfo = null;
                if (cvk.getPrivateKey() != null) {
                    byte[] decryptedValue;
                    try {
                        if (this.requestor instanceof Requestor.SignatureCmpRequestor) {
                            ConcurrentContentSigner requestSigner = ((Requestor.SignatureCmpRequestor)this.requestor).getSigner();
                            if (!(requestSigner.getSigningKey() instanceof PrivateKey)) {
                                throw new XiSecurityException("no decryption key is configured");
                            }
                            decryptedValue = CmpAgent.decrypt(cvk.getPrivateKey(), (PrivateKey)requestSigner.getSigningKey());
                        } else {
                            decryptedValue = CmpAgent.decrypt(cvk.getPrivateKey(), ((Requestor.PbmMacCmpRequestor)this.requestor).getPassword());
                        }
                    }
                    catch (XiSecurityException ex) {
                        resultEntry = new ResultEntry.Error(thisId, -1, 0x40000000, "could not decrypt PrivateKeyInfo");
                        continue;
                    }
                    privKeyInfo = PrivateKeyInfo.getInstance((Object)decryptedValue);
                }
                resultEntry = new ResultEntry.EnrollCert(thisId, cmpCert, privKeyInfo, status);
                if (certConfirmBuilder != null) {
                    requireConfirm = true;
                    X509CertificateHolder certHolder = null;
                    try {
                        certHolder = new X509CertificateHolder(cmpCert.getEncoded());
                    }
                    catch (IOException ex) {
                        resultEntry = new ResultEntry.Error(thisId, -1, 0x40000000, "could not decode the certificate");
                    }
                    if (certHolder != null) {
                        certConfirmBuilder.addAcceptedCertificate(certHolder, certReqId);
                    }
                }
            } else {
                PKIFreeText statusString = statusInfo.getStatusString();
                String errorMessage = statusString == null ? null : statusString.getStringAt(0).getString();
                int failureInfo = statusInfo.getFailInfo().intValue();
                resultEntry = new ResultEntry.Error(thisId, status, failureInfo, errorMessage);
            }
            result.addResultEntry(resultEntry);
        }
        if (CollectionUtil.isNotEmpty(reqIdIdMap)) {
            for (BigInteger reqId : reqIdIdMap.keySet()) {
                ResultEntry.Error ere = new ResultEntry.Error(reqIdIdMap.get(reqId), -2);
                result.addResultEntry(ere);
            }
        }
        if (!requireConfirm) {
            return result;
        }
        PKIMessage confirmRequest = this.buildCertConfirmRequest(response.getPkiMessage().getHeader().getTransactionID(), certConfirmBuilder);
        response = this.signAndSend(confirmRequest, debug);
        this.checkProtection(response);
        return result;
    }

    private PKIMessage buildCertConfirmRequest(ASN1OctetString tid, CertificateConfirmationContentBuilder certConfirmBuilder) throws CmpClientException {
        CertificateConfirmationContent certConfirm;
        PKIHeader header = this.buildPkiHeader(this.implicitConfirm, tid, null, null);
        try {
            certConfirm = certConfirmBuilder.build(DIGEST_CALCULATOR_PROVIDER);
        }
        catch (CMPException ex) {
            throw new CmpClientException(ex.getMessage(), ex);
        }
        PKIBody body = new PKIBody(24, (ASN1Encodable)certConfirm.toASN1Structure());
        return new PKIMessage(header, body);
    }

    private PKIMessage buildRevokeCertRequest(RevokeCertRequest request) throws CmpClientException {
        PKIHeader header = this.buildPkiHeader(null);
        List<RevokeCertRequest.Entry> requestEntries = request.getRequestEntries();
        ArrayList<RevDetails> revDetailsArray = new ArrayList<RevDetails>(requestEntries.size());
        for (RevokeCertRequest.Entry requestEntry : requestEntries) {
            Date invalidityDate;
            CertTemplateBuilder certTempBuilder = new CertTemplateBuilder();
            certTempBuilder.setIssuer(requestEntry.getIssuer());
            certTempBuilder.setSerialNumber(new ASN1Integer(requestEntry.getSerialNumber()));
            byte[] aki = requestEntry.getAuthorityKeyIdentifier();
            if (aki != null) {
                Extensions certTempExts = CmpAgent.getCertTempExtensions(aki);
                certTempBuilder.setExtensions(certTempExts);
            }
            int idx = (invalidityDate = requestEntry.getInvalidityDate()) == null ? 1 : 2;
            Extension[] extensions = new Extension[idx];
            try {
                ASN1Enumerated reason = new ASN1Enumerated(requestEntry.getReason());
                extensions[0] = new Extension(Extension.reasonCode, true, (ASN1OctetString)new DEROctetString(reason.getEncoded()));
                if (invalidityDate != null) {
                    ASN1GeneralizedTime time = new ASN1GeneralizedTime(invalidityDate);
                    extensions[1] = new Extension(Extension.invalidityDate, true, (ASN1OctetString)new DEROctetString(time.getEncoded()));
                }
            }
            catch (IOException ex) {
                throw new CmpClientException(ex.getMessage(), ex);
            }
            Extensions exts = new Extensions(extensions);
            RevDetails revDetails = new RevDetails(certTempBuilder.build(), exts);
            revDetailsArray.add(revDetails);
        }
        RevReqContent content = new RevReqContent(revDetailsArray.toArray(new RevDetails[0]));
        PKIBody body = new PKIBody(11, (ASN1Encodable)content);
        return new PKIMessage(header, body);
    }

    private PKIMessage buildUnrevokeOrRemoveCertRequest(UnrevokeOrRemoveCertRequest request, int reasonCode) throws CmpClientException {
        PKIHeader header = this.buildPkiHeader(null);
        List<UnrevokeOrRemoveCertRequest.Entry> requestEntries = request.getRequestEntries();
        ArrayList<RevDetails> revDetailsArray = new ArrayList<RevDetails>(requestEntries.size());
        for (UnrevokeOrRemoveCertRequest.Entry requestEntry : requestEntries) {
            CertTemplateBuilder certTempBuilder = new CertTemplateBuilder();
            certTempBuilder.setIssuer(requestEntry.getIssuer());
            certTempBuilder.setSerialNumber(new ASN1Integer(requestEntry.getSerialNumber()));
            byte[] aki = requestEntry.getAuthorityKeyIdentifier();
            if (aki != null) {
                Extensions certTempExts = CmpAgent.getCertTempExtensions(aki);
                certTempBuilder.setExtensions(certTempExts);
            }
            Extension[] extensions = new Extension[1];
            try {
                ASN1Enumerated reason = new ASN1Enumerated(reasonCode);
                extensions[0] = new Extension(Extension.reasonCode, true, (ASN1OctetString)new DEROctetString(reason.getEncoded()));
            }
            catch (IOException ex) {
                throw new CmpClientException(ex.getMessage(), ex);
            }
            Extensions exts = new Extensions(extensions);
            RevDetails revDetails = new RevDetails(certTempBuilder.build(), exts);
            revDetailsArray.add(revDetails);
        }
        RevReqContent content = new RevReqContent(revDetailsArray.toArray(new RevDetails[0]));
        PKIBody body = new PKIBody(11, (ASN1Encodable)content);
        return new PKIMessage(header, body);
    }

    private PKIMessage buildPkiMessage(CsrEnrollCertRequest csr, Date notBefore, Date notAfter) {
        CmpUtf8Pairs utf8Pairs = new CmpUtf8Pairs("certprofile", csr.getCertprofile());
        if (notBefore != null) {
            utf8Pairs.putUtf8Pair("notbefore", DateUtil.toUtcTimeyyyyMMddhhmmss((Date)notBefore));
        }
        if (notAfter != null) {
            utf8Pairs.putUtf8Pair("notafter", DateUtil.toUtcTimeyyyyMMddhhmmss((Date)notAfter));
        }
        PKIHeader header = this.buildPkiHeader(this.implicitConfirm, null, utf8Pairs, new InfoTypeAndValue[0]);
        PKIBody body = new PKIBody(4, (ASN1Encodable)csr.getCsr());
        return new PKIMessage(header, body);
    }

    private PKIMessage buildPkiMessage(EnrollCertRequest req) {
        int bodyType;
        PKIHeader header = this.buildPkiHeader(this.implicitConfirm, null);
        List<EnrollCertRequest.Entry> reqEntries = req.getRequestEntries();
        CertReqMsg[] certReqMsgs = new CertReqMsg[reqEntries.size()];
        for (int i = 0; i < reqEntries.size(); ++i) {
            EnrollCertRequest.Entry reqEntry = reqEntries.get(i);
            AttributeTypeAndValue[] reginfo = null;
            CmpUtf8Pairs utf8Pairs = new CmpUtf8Pairs();
            if (reqEntry.getCertprofile() != null) {
                utf8Pairs.putUtf8Pair("certprofile", reqEntry.getCertprofile());
            }
            if (reqEntry.isCaGenerateKeypair()) {
                utf8Pairs.putUtf8Pair("ca-generate-keypair", "true");
            }
            if (!utf8Pairs.names().isEmpty()) {
                AttributeTypeAndValue atv = CmpUtil.buildAttributeTypeAndValue((CmpUtf8Pairs)utf8Pairs);
                reginfo = new AttributeTypeAndValue[]{atv};
            }
            certReqMsgs[i] = new CertReqMsg(reqEntry.getCertReq(), reqEntry.getPopo(), reginfo);
        }
        switch (req.getType()) {
            case INIT_REQ: {
                bodyType = 0;
                break;
            }
            case CERT_REQ: {
                bodyType = 2;
                break;
            }
            case KEY_UPDATE: {
                bodyType = 7;
                break;
            }
            case CROSS_CERT_REQ: {
                bodyType = 13;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown EnrollCertRequest.Type " + (Object)((Object)req.getType()));
            }
        }
        PKIBody body = new PKIBody(bodyType, (ASN1Encodable)new CertReqMessages(certReqMsgs));
        return new PKIMessage(header, body);
    }

    public CaConf.CaInfo retrieveCaInfo(String caName, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        JSONObject root;
        Args.notBlank((String)caName, (String)"caName");
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1Integer(3L));
        DERSequence acceptVersions = new DERSequence(vec);
        int action = 3;
        PKIMessage request = this.buildMessageWithXipkiAction(action, (ASN1Encodable)acceptVersions);
        VerifiedPkiMessage response = this.signAndSend(request, debug);
        ASN1Encodable itvValue = this.extractXipkiActionRepContent(response, action);
        DERUTF8String utf8Str = DERUTF8String.getInstance((Object)itvValue);
        String systemInfoStr = utf8Str.getString();
        LOG.debug("CAInfo for CA {}: {}", (Object)caName, (Object)systemInfoStr);
        try {
            root = JSON.parseObject((String)systemInfoStr);
        }
        catch (RuntimeException ex) {
            throw new CmpClientException("could not parse the returned systemInfo for CA " + caName + ": " + ex.getMessage(), ex);
        }
        int version = root.getIntValue("version");
        if (version == 3) {
            JSONArray array = root.getJSONArray("caCertchain");
            LinkedList<X509Certificate> caCertchain = new LinkedList<X509Certificate>();
            for (int i = 0; i < array.size(); ++i) {
                X509Certificate caCert;
                String base64Cert = array.getString(i);
                try {
                    caCert = X509Util.parseCert((byte[])base64Cert.getBytes());
                }
                catch (CertificateException ex) {
                    throw new CmpClientException("could no parse the CA certificate chain", ex);
                }
                caCertchain.add(caCert);
            }
            array = root.getJSONArray("dhpocs");
            LinkedList<X509Certificate> dhpocs = null;
            if (array != null) {
                dhpocs = new LinkedList<X509Certificate>();
                for (int i = 0; i < array.size(); ++i) {
                    X509Certificate caCert;
                    String base64Cert = array.getString(i);
                    try {
                        caCert = X509Util.parseCert((byte[])base64Cert.getBytes());
                    }
                    catch (CertificateException ex) {
                        throw new CmpClientException("could no parse the DHPoc (certificate)", ex);
                    }
                    dhpocs.add(caCert);
                }
            }
            CaConf.CmpControl cmpControl = null;
            JSONObject jsonCmpControl = root.getJSONObject("cmpControl");
            if (jsonCmpControl != null) {
                Boolean tmpBool = jsonCmpControl.getBoolean("rrAkiRequired");
                boolean required = tmpBool == null ? false : tmpBool;
                cmpControl = new CaConf.CmpControl(required);
            }
            HashSet<String> profileNames = new HashSet<String>();
            JSONArray jsonProfiles = root.getJSONArray("certprofiles");
            HashSet<CertprofileInfo> profiles = new HashSet<CertprofileInfo>();
            if (jsonProfiles != null) {
                int size = jsonProfiles.size();
                for (int i = 0; i < size; ++i) {
                    JSONObject jsonProfile = jsonProfiles.getJSONObject(i);
                    String name = jsonProfile.getString("name");
                    String type = jsonProfile.getString("type");
                    String conf = jsonProfile.getString("conf");
                    CertprofileInfo profile = new CertprofileInfo(name, type, conf);
                    profiles.add(profile);
                    profileNames.add(name);
                    LOG.debug("configured for CA {} certprofile (name={}, type={}, conf={})", new Object[]{caName, name, type, conf});
                }
            }
            LOG.info("CA {} supports profiles {}", (Object)caName, profileNames);
            return new CaConf.CaInfo(caCertchain, cmpControl, profiles, dhpocs);
        }
        throw new CmpClientException("unknown CAInfo version " + version);
    }

    private static Extensions getCertTempExtensions(byte[] authorityKeyIdentifier) throws CmpClientException {
        byte[] encodedAki;
        AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier(authorityKeyIdentifier);
        try {
            encodedAki = aki.getEncoded();
        }
        catch (IOException ex) {
            throw new CmpClientException("could not encoded AuthorityKeyIdentifier", ex);
        }
        Extension extAki = new Extension(Extension.authorityKeyIdentifier, false, encodedAki);
        Extensions certTempExts = new Extensions(extAki);
        return certTempExts;
    }
}

