/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import org.xipki.util.Args;

public class DataAccessException
extends Exception {
    private final Reason reason;

    public DataAccessException(String msg) {
        this(Reason.Root, msg);
    }

    public DataAccessException(Reason reason, String msg) {
        super(reason + " - " + msg);
        this.reason = (Reason)((Object)Args.notNull((Object)((Object)reason), (String)"reason"));
    }

    public DataAccessException(String msg, Throwable cause) {
        this(Reason.Root, msg, cause);
    }

    public DataAccessException(Reason reason, String msg, Throwable cause) {
        super(reason + " - " + msg, cause);
        this.reason = (Reason)((Object)Args.notNull((Object)((Object)reason), (String)"reason"));
    }

    public Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        Root(null),
        NonTransientDataAccess(Root),
        DataIntegrityViolation(NonTransientDataAccess),
        DuplicateKey(DataIntegrityViolation),
        InvalidDataAccessResourceUsage(NonTransientDataAccess),
        BadSqlGrammar(InvalidDataAccessResourceUsage),
        InvalidResultSetAccess(InvalidDataAccessResourceUsage),
        NonTransientDataAccessResource(NonTransientDataAccess),
        DataAccessResourceFailure(NonTransientDataAccessResource),
        PermissionDeniedDataAccess(NonTransientDataAccess),
        UncategorizedDataAccess(NonTransientDataAccess),
        UncategorizedSql(UncategorizedDataAccess),
        TransientDataAccess(Root),
        ConcurrencyFailure(TransientDataAccess),
        PessimisticLockingFailure(ConcurrencyFailure),
        CannotAcquireLock(PessimisticLockingFailure),
        CannotSerializeTransaction(PessimisticLockingFailure),
        DeadlockLoserDataAccess(PessimisticLockingFailure),
        QueryTimeout(TransientDataAccess),
        TransientDataAccessResource(TransientDataAccess);

        private final Reason parent;

        private Reason(Reason parent) {
            this.parent = parent;
        }

        public boolean isAncestorOf(Reason reason) {
            Reason parent;
            while ((parent = reason.parent) != null) {
                if (parent == this) {
                    return true;
                }
                reason = parent;
            }
            return false;
        }

        public boolean isAncestorOrSelfOf(Reason reason) {
            return this == reason || this.isAncestorOf(reason);
        }

        public boolean isDescendantOf(Reason reason) {
            return reason.isAncestorOf(this);
        }

        public boolean isDescendantOrSelfOf(Reason reason) {
            return this == reason || this.isDescendantOf(reason);
        }
    }
}

