/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.ConfigurableProperties;
import org.xipki.util.IoUtil;

public class ScriptRunner {
    private static final String DEFAULT_DELIMITER = ";";
    private static final Pattern SOURCE_COMMAND = Pattern.compile("^\\s*SOURCE\\s+(.*?)\\s*$", 2);
    public static final Pattern delimP = Pattern.compile("^\\s*(--)?\\s*delimiter\\s*=?\\s*([^\\s]+)+\\s*.*$", 2);
    private final Connection connection;
    private final boolean stopOnError;
    private PrintWriter logWriter = null;
    private PrintWriter errorLogWriter = null;
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;

    public static void runScript(String dbConfFile, String scriptFile) throws Exception {
        ConfigurableProperties props = new ConfigurableProperties();
        try (InputStream inStream = Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)dbConfFile), new String[0]), new OpenOption[0]);){
            props.load(inStream);
        }
        props.setProperty("minimumIdle", "1");
        try (DataSourceWrapper dataSource = new DataSourceFactory().createDataSource("default", props);){
            ScriptRunner.runScript(dataSource, scriptFile);
        }
    }

    public static void runScript(DataSourceWrapper dataSource, String scriptFile) throws Exception {
        Connection conn = dataSource.getConnection();
        try {
            ScriptRunner.runScript(conn, scriptFile);
        }
        finally {
            dataSource.returnConnection(conn);
        }
    }

    public static void runScript(Connection conn, String scriptFile) throws Exception {
        ScriptRunner runner = new ScriptRunner(conn, true);
        runner.runScript(IoUtil.expandFilepath((String)scriptFile));
    }

    public ScriptRunner(Connection connection, boolean stopOnError) {
        this.connection = connection;
        this.stopOnError = stopOnError;
        File logFile = new File("create_db.log");
        try {
            this.logWriter = new PrintWriter(new FileWriter(logFile, logFile.exists()));
        }
        catch (IOException e) {
            System.err.println("Unable to access or create the db_create log");
        }
        File errorLogFile = new File("create_db_error.log");
        try {
            this.errorLogWriter = new PrintWriter(new FileWriter(errorLogFile, errorLogFile.exists()));
        }
        catch (IOException e) {
            System.err.println("Unable to access or create the db_create error log");
        }
        String timeStamp = ZonedDateTime.now().toString();
        this.println("\n-------\n" + timeStamp + "\n-------\n");
        this.printlnError("\n-------\n" + timeStamp + "\n-------\n");
    }

    public void setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public void setErrorLogWriter(PrintWriter errorLogWriter) {
        this.errorLogWriter = errorLogWriter;
    }

    public void runScript(String filepath) throws IOException, SQLException {
        this.runScript(new BufferedReader(new FileReader(filepath)));
    }

    public void runScript(Reader reader) throws IOException, SQLException {
        try {
            boolean originalAutoCommit = this.connection.getAutoCommit();
            try {
                if (!originalAutoCommit) {
                    this.connection.setAutoCommit(true);
                }
                this.runScript(this.connection, reader);
            }
            finally {
                this.connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (IOException | SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    private void runScript(Connection conn, Reader reader) throws IOException, SQLException {
        StringBuilder command = null;
        try {
            String line;
            LineNumberReader lineReader = new LineNumberReader(reader);
            boolean ignoreSqlError = false;
            while ((line = lineReader.readLine()) != null) {
                if (command == null) {
                    command = new StringBuilder();
                }
                String trimmedLine = line.trim();
                Matcher delimMatch = delimP.matcher(trimmedLine);
                if (trimmedLine.isEmpty() || trimmedLine.startsWith("//")) continue;
                if (delimMatch.matches()) {
                    this.setDelimiter(delimMatch.group(2), false);
                    continue;
                }
                if (trimmedLine.startsWith("--")) {
                    if (trimmedLine.startsWith("-- IGNORE-ERROR")) {
                        ignoreSqlError = true;
                    }
                    this.println(trimmedLine);
                    continue;
                }
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.getDelimiter()) || this.fullLineDelimiter && trimmedLine.equals(this.getDelimiter())) {
                    command.append(line, 0, line.lastIndexOf(this.getDelimiter())).append(" ");
                    this.execCommand(conn, command, lineReader, ignoreSqlError);
                    ignoreSqlError = false;
                    command = null;
                    continue;
                }
                command.append(line);
                command.append("\n");
            }
            if (command != null) {
                this.execCommand(conn, command, lineReader, ignoreSqlError);
            }
        }
        catch (IOException e) {
            throw new IOException(String.format("Error executing '%s': %s", command, e.getMessage()), e);
        }
        finally {
            this.flush();
        }
    }

    private void execCommand(Connection conn, StringBuilder command, LineNumberReader lineReader, boolean ignoreSqlError) throws IOException, SQLException {
        if (command.length() == 0) {
            return;
        }
        Matcher sourceCommandMatcher = SOURCE_COMMAND.matcher(command);
        if (sourceCommandMatcher.matches()) {
            this.runScriptFile(conn, sourceCommandMatcher.group(1));
            return;
        }
        if (ignoreSqlError) {
            try {
                this.execSqlCommand(conn, command, lineReader, false);
            }
            catch (SQLException e) {
                System.out.println("Ignore " + e.getMessage());
            }
        } else {
            this.execSqlCommand(conn, command, lineReader, true);
        }
    }

    private void runScriptFile(Connection conn, String filepath) throws IOException, SQLException {
        File file = new File(filepath);
        this.runScript(conn, new BufferedReader(new FileReader(file)));
    }

    private void execSqlCommand(Connection conn, StringBuilder command, LineNumberReader lineReader, boolean outputErr) throws SQLException {
        boolean hasResults;
        Statement statement;
        block9: {
            statement = conn.createStatement();
            this.println(command);
            hasResults = false;
            try {
                hasResults = statement.execute(command.toString());
            }
            catch (SQLException e) {
                if (!outputErr) break block9;
                String errText = String.format("Error executing '%s' (line %d): %s", command, lineReader.getLineNumber(), e.getMessage());
                this.printlnError(errText);
                System.err.println(errText);
                if (!this.stopOnError) break block9;
                throw new SQLException(errText, e);
            }
        }
        if (!conn.getAutoCommit()) {
            conn.commit();
        }
        ResultSet rs = statement.getResultSet();
        if (hasResults && rs != null) {
            int i;
            ResultSetMetaData md = rs.getMetaData();
            int cols = md.getColumnCount();
            for (i = 1; i <= cols; ++i) {
                String name = md.getColumnLabel(i);
                this.print(name + "\t");
            }
            this.println("");
            while (rs.next()) {
                for (i = 1; i <= cols; ++i) {
                    String value = rs.getString(i);
                    this.print(value + "\t");
                }
                this.println("");
            }
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getDelimiter() {
        return this.delimiter;
    }

    private void print(Object o) {
        if (this.logWriter != null) {
            this.logWriter.print(o);
        }
    }

    private void println(Object o) {
        if (this.logWriter != null) {
            this.logWriter.println(o);
        }
    }

    private void printlnError(Object o) {
        if (this.errorLogWriter != null) {
            this.errorLogWriter.println(o);
        }
    }

    private void flush() {
        if (this.logWriter != null) {
            this.logWriter.flush();
        }
        if (this.errorLogWriter != null) {
            this.errorLogWriter.flush();
        }
    }
}

