/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolverException;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Key;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.shell.Actions;
import org.xipki.security.shell.SecurityCompleters;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class P11Actions {

    @Command(scope="xi", name="token-info-p11", description="list objects in PKCS#11 device")
    @Service
    public static class TokenInfoP11
    extends Actions.SecurityAction {
        @Option(name="--verbose", aliases={"-v"}, description="show object information verbosely")
        private Boolean verbose = Boolean.FALSE;
        @Option(name="--module", description="name of the PKCS#11 module.")
        @Completion(value=SecurityCompleters.P11ModuleNameCompleter.class)
        private String moduleName = "default";
        @Option(name="--slot", description="slot index")
        private Integer slotIndex;
        @Option(name="--object", description="object handle")
        private Long objectHandle;
        @Reference(optional=true)
        protected P11CryptServiceFactory p11CryptServiceFactory;

        protected Object execute0() throws Exception {
            P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(this.moduleName);
            if (p11Service == null) {
                throw new IllegalCmdParamException("undefined module " + this.moduleName);
            }
            P11Module module = p11Service.getModule();
            this.println("module: " + this.moduleName);
            this.println(module.getDescription());
            List slots = module.getSlotIds();
            if (this.slotIndex == null) {
                this.output(slots);
                return null;
            }
            P11SlotId slotId = module.getSlotIdForIndex(this.slotIndex.intValue());
            P11Slot slot = module.getSlot(slotId);
            this.println("Details of slot " + slotId + ":");
            slot.showDetails((OutputStream)System.out, this.objectHandle, this.verbose.booleanValue());
            System.out.flush();
            System.out.println();
            return null;
        }

        private void output(List<P11SlotId> slots) {
            int n = slots.size();
            if (n == 0 || n == 1) {
                String numText = n == 0 ? "no" : "1";
                this.println(numText + " slot is configured");
            } else {
                this.println(n + " slots are configured");
            }
            for (P11SlotId slotId : slots) {
                this.println("\tslot[" + slotId.getIndex() + "]: " + slotId.getId());
            }
        }
    }

    @Command(scope="xi", name="sm2-p11", description="generate SM2 (curve sm2p256v1) keypair in PKCS#11 device")
    @Service
    public static class Sm2P11
    extends P11KeyGenAction {
        protected Object execute0() throws Exception {
            P11Slot slot = this.getSlot();
            this.finalize("SM2", slot.generateSM2Keypair(this.getControl()));
            return null;
        }
    }

    public static abstract class P11SecurityAction
    extends Actions.SecurityAction {
        protected static final String DEFAULT_P11MODULE_NAME = "default";
        @Option(name="--slot", description="slot index")
        protected String slotIndex = "0";
        @Option(name="--module", description="name of the PKCS#11 module")
        @Completion(value=SecurityCompleters.P11ModuleNameCompleter.class)
        protected String moduleName = "default";
        @Reference(optional=true)
        protected P11CryptServiceFactory p11CryptServiceFactory;

        protected P11Slot getSlot() throws XiSecurityException, TokenException, IllegalCmdParamException {
            P11Module module = this.getP11Module(this.moduleName);
            P11SlotId slotId = module.getSlotIdForIndex(Integer.parseInt(this.slotIndex));
            return module.getSlot(slotId);
        }

        protected P11Module getP11Module(String moduleName) throws XiSecurityException, TokenException, IllegalCmdParamException {
            P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(moduleName);
            if (p11Service == null) {
                throw new IllegalCmdParamException("undefined module " + moduleName);
            }
            return p11Service.getModule();
        }

        public P11Key getIdentity(String hexId, String label) throws IllegalCmdParamException, XiSecurityException, TokenException {
            P11Slot slot = this.getSlot();
            byte[] id = hexId == null ? null : Hex.decode((String)hexId);
            return slot.getKey(id, label);
        }
    }

    @Command(scope="xi", name="import-secretkey-p11", description="import secret key with given value in PKCS#11 device")
    @Service
    public static class ImportSecretkeyP11
    extends P11KeyGenAction {
        @Option(name="--key-type", required=true, description="keytype, current only AES, DES3 and GENERIC are supported")
        @Completion(value=SecurityCompleters.SecretKeyTypeCompleter.class)
        private String keyType;
        @Option(name="--keystore", required=true, description="JCEKS keystore from which the key is imported")
        @Completion(value=FileCompleter.class)
        private String keyOutFile;
        @Option(name="--password", description="password of the keystore file, as plaintext or PBE-encrypted.")
        private String passwordHint;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            long p11KeyType;
            if ("AES".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 31L;
            } else if ("DES3".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 21L;
            } else if ("GENERIC".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 16L;
            } else {
                throw new IllegalCmdParamException("invalid keyType " + this.keyType);
            }
            KeyStore ks = KeyUtil.getInKeyStore((String)"JCEKS");
            char[] pwd = this.getPassword();
            try (InputStream ksStream = Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)this.keyOutFile), new String[0]), new OpenOption[0]);){
                ks.load(ksStream, pwd);
            }
            byte[] keyValue = null;
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                Key key;
                String alias = aliases.nextElement();
                if (!ks.isKeyEntry(alias) || !((key = ks.getKey(alias, pwd)) instanceof SecretKey)) continue;
                keyValue = key.getEncoded();
                break;
            }
            if (keyValue == null) {
                throw new IllegalCmdParamException("keystore does not contain secret key");
            }
            P11Slot slot = this.getSlot();
            PKCS11KeyId objId = slot.importSecretKey(p11KeyType, keyValue, this.getControl());
            this.println("imported " + this.keyType + " key " + objId);
            return null;
        }

        protected char[] getPassword() throws IOException, PasswordResolverException {
            char[] pwdInChar = this.readPasswordIfNotSet("Enter the keystore password", this.passwordHint);
            if (pwdInChar != null) {
                this.passwordHint = new String(pwdInChar);
            }
            return pwdInChar;
        }
    }

    @Command(scope="xi", name="secretkey-p11", description="generate secret key in PKCS#11 device")
    @Service
    public static class SecretkeyP11
    extends P11KeyGenAction {
        private static final Logger LOG = LoggerFactory.getLogger(SecretkeyP11.class);
        @Option(name="--key-type", required=true, description="keytype, current only AES, DES3 and GENERIC are supported")
        @Completion(value=SecurityCompleters.SecretKeyTypeCompleter.class)
        private String keyType;
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize;
        @Option(name="--extern-if-gen-unsupported", description="If set, if the generation mechanism is not supported by the PKCS#11 device, create in memory and then import it to the device")
        private Boolean createExternIfGenUnsupported = Boolean.FALSE;

        protected Object execute0() throws Exception {
            long p11KeyType;
            if (this.keysize != null && this.keysize % 8 != 0) {
                throw new IllegalCmdParamException("keysize is not multiple of 8: " + this.keysize);
            }
            if ("AES".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 31L;
            } else if ("DES3".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 21L;
                this.keysize = 192;
            } else if ("GENERIC".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 16L;
            } else {
                throw new IllegalCmdParamException("invalid keyType " + this.keyType);
            }
            if (this.keysize == null) {
                throw new IllegalCmdParamException("key-size is not specified");
            }
            P11Slot slot = this.getSlot();
            P11Slot.P11NewKeyControl control = this.getControl();
            try {
                this.finalize(this.keyType, slot.generateSecretKey(p11KeyType, this.keysize, control));
            }
            catch (TokenException ex) {
                if (!this.createExternIfGenUnsupported.booleanValue()) {
                    throw ex;
                }
                Object msgPrefix = "could not generate secret key ";
                if (control.getId() != null) {
                    msgPrefix = (String)msgPrefix + "id=" + Hex.encode((byte[])control.getId());
                    if (control.getLabel() != null) {
                        msgPrefix = (String)msgPrefix + " and ";
                    }
                }
                if (control.getLabel() != null) {
                    msgPrefix = (String)msgPrefix + "label=" + control.getLabel();
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((String)msgPrefix + ex.getMessage());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((String)msgPrefix, (Throwable)ex);
                }
                byte[] keyValue = new byte[this.keysize / 8];
                this.securityFactory.getRandom4Key().nextBytes(keyValue);
                PKCS11KeyId objId = slot.importSecretKey(p11KeyType, keyValue, control);
                Arrays.fill(keyValue, (byte)0);
                String msg = "generated in memory and imported " + this.keyType + " key " + objId;
                if (LOG.isInfoEnabled()) {
                    LOG.info(msg);
                }
                this.println(msg);
            }
            return null;
        }
    }

    @Command(scope="xi", name="rsa-p11", description="generate RSA keypair in PKCS#11 device")
    @Service
    public static class RsaP11
    extends P11KeyGenAction {
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize = 2048;
        @Option(name="-e", description="public exponent")
        private String publicExponent = "0x10001";

        protected Object execute0() throws Exception {
            if (this.keysize % 1024 != 0) {
                throw new IllegalCmdParamException("keysize is not multiple of 1024: " + this.keysize);
            }
            P11Slot slot = this.getSlot();
            this.finalize("RSA", slot.generateRSAKeypair(this.keysize.intValue(), RsaP11.toBigInt((String)this.publicExponent), this.getControl()));
            return null;
        }
    }

    @Command(scope="xi", name="delete-all-objects-p11", description="delete all objects in PKCS#11 device")
    @Service
    public static class DeleteAllObjectsP11
    extends P11SecurityAction {
        protected Object execute0() throws Exception {
            String prompt = "!!!DANGEROUS OPERATION!!!, do you want to remove ALL PKCS#11 objects";
            if (this.confirm(prompt, 1) && this.confirm(prompt, 1) && this.confirm(prompt, 1)) {
                P11Slot slot = this.getSlot();
                int num = slot.destroyAllObjects();
                System.out.println("Destroyed " + num + " objects!");
            }
            return null;
        }
    }

    @Command(scope="xi", name="delete-objects-p11", description="delete objects in PKCS#11 device")
    @Service
    public static class DeleteObjectsP11
    extends P11SecurityAction {
        @Option(name="--handle", aliases={"-h"}, multiValued=true, description="Object handle, if specified, id and label must not be set")
        private long[] handles;
        @Option(name="--id", description="id (hex) of the objects in the PKCS#11 device\nat least one of id and label must be specified (if handle is not set).")
        private String id;
        @Option(name="--label", description="label of the objects in the PKCS#11 device\nat least one of id and label must be specified (if handle is not set).")
        private String label;
        @Option(name="--force", aliases={"-f"}, description="remove identifies without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            if (this.handles != null && this.handles.length > 0) {
                if (this.id != null || this.label != null) {
                    throw new IllegalCmdParamException("If handle is set, id an label must not be set.");
                }
                if (this.force.booleanValue() || this.confirm("Do you want to remove the PKCS#11 objects " + Arrays.toString(this.handles), 3)) {
                    P11Slot slot = this.getSlot();
                    long[] failedHandles = slot.destroyObjectsByHandle(this.handles);
                    if (failedHandles.length == 0) {
                        this.println("deleted all " + this.handles.length + " objects");
                    } else {
                        this.println("deleted " + (this.handles.length - failedHandles.length) + " objects except " + failedHandles.length + " objects: " + Arrays.toString(failedHandles));
                    }
                }
            } else {
                if (this.id == null && this.label == null) {
                    throw new IllegalCmdParamException("If handle is not set, at least one of id and label must be set.");
                }
                if (this.force.booleanValue() || this.confirm("Do you want to remove the PKCS#11 objects (id = " + this.id + ", label = " + this.label + ")", 3)) {
                    int num;
                    P11Slot slot = this.getSlot();
                    byte[] idBytes = null;
                    if (this.id != null) {
                        idBytes = Hex.decode((String)this.id);
                        num = this.label == null ? slot.destroyObjectsById(idBytes) : slot.destroyObjectsByIdLabel(idBytes, this.label);
                    } else {
                        num = slot.destroyObjectsByLabel(this.label);
                    }
                    this.println("deleted " + num + " objects");
                }
            }
            return null;
        }
    }

    public static abstract class P11KeyGenAction
    extends P11SecurityAction {
        @Option(name="--id", description="id (hex) of the PKCS#11 objects")
        private String id;
        @Option(name="--label", required=true, description="label of the PKCS#11 objects")
        protected String label;
        @Option(name="--extractable", aliases={"-x"}, description="whether the key is extractable, valid values are yes|no|true|false")
        private String extractable;
        @Option(name="--sensitive", description="whether the key is sensitive, valid values are yes|no|true|false")
        private String sensitive;
        @Option(name="--key-usage", multiValued=true, description="key usage of the private key")
        @Completion(value=SecurityCompleters.P11KeyUsageCompleter.class)
        private List<String> keyusages;

        protected void finalize(String keyType, PKCS11KeyId keyId) {
            Args.notNull((Object)keyId, (String)"keyId");
            this.println("generated " + keyType + " key " + keyId + " on slot " + this.slotIndex);
        }

        protected P11Slot.P11NewKeyControl getControl() {
            byte[] id0 = this.id == null ? null : Hex.decode((String)this.id);
            P11Slot.P11NewKeyControl control = new P11Slot.P11NewKeyControl(id0, this.label);
            if (StringUtil.isNotBlank((String)this.extractable)) {
                control.setExtractable(Boolean.valueOf(P11KeyGenAction.isEnabled((String)this.extractable, (boolean)false, (String)"extractable")));
            }
            if (StringUtil.isNotBlank((String)this.sensitive)) {
                control.setSensitive(Boolean.valueOf(P11KeyGenAction.isEnabled((String)this.sensitive, (boolean)false, (String)"sensitive")));
            }
            if (CollectionUtil.isNotEmpty(this.keyusages)) {
                control.setUsages(SecurityCompleters.P11KeyUsageCompleter.parseUsages(this.keyusages));
            }
            return control;
        }
    }

    @Command(scope="xi", name="key-exists-p11", description="return whether keys exist in PKCS#11 device")
    @Service
    public static class KeyExistsP11
    extends P11SecurityAction {
        @Option(name="--id", description="id (hex) of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String id;
        @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String label;

        protected Object execute0() throws Exception {
            return null != this.getIdentity(this.id, this.label);
        }
    }

    @Command(scope="xi", name="delete-key-p11", description="delete key in PKCS#11 device")
    @Service
    public static class DeleteKeyP11
    extends P11SecurityAction {
        @Option(name="--id", description="id (hex) of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String id;
        @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String label;
        @Option(name="--force", aliases={"-f"}, description="remove identifies without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            P11Slot slot = this.getSlot();
            P11Key identity = this.getIdentity(this.id, this.label);
            if (identity == null) {
                this.println("unknown identity");
                return null;
            }
            if (this.force.booleanValue() || this.confirm("Do you want to remove the identity " + identity.getKeyId(), 3)) {
                identity.destroy();
                this.println("deleted identity " + identity.getKeyId());
            }
            return null;
        }
    }

    @Command(scope="xi", name="ec-p11", description="generate EC keypair in PKCS#11 device")
    @Service
    public static class EcP11
    extends P11KeyGenAction {
        @Option(name="--curve", description="EC curve name")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName = "secp256r1";

        protected Object execute0() throws Exception {
            P11Slot slot = this.getSlot();
            P11Slot.P11NewKeyControl control = this.getControl();
            ASN1ObjectIdentifier curveOid = EdECConstants.getCurveOid((String)this.curveName);
            if (curveOid == null) {
                curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)this.curveName);
            }
            if (curveOid == null) {
                throw new Exception("unknown curve " + this.curveName);
            }
            this.finalize("EC", slot.generateECKeypair(curveOid, control));
            return null;
        }
    }

    @Command(scope="xi", name="dsa-p11", description="generate DSA keypair in PKCS#11 device")
    @Service
    public static class Dsa11
    extends P11KeyGenAction {
        @Option(name="--plen", description="bit length of the prime")
        private Integer plen = 2048;
        @Option(name="--qlen", description="bit length of the sub-prime")
        private Integer qlen;

        protected Object execute0() throws Exception {
            if (this.plen % 1024 != 0) {
                throw new IllegalCmdParamException("plen is not multiple of 1024: " + this.plen);
            }
            if (this.qlen == null) {
                this.qlen = this.plen <= 1024 ? 160 : (this.plen <= 2048 ? 224 : 256);
            }
            P11Slot slot = this.getSlot();
            this.finalize("DSA", slot.generateDSAKeypair(this.plen.intValue(), this.qlen.intValue(), this.getControl()));
            return null;
        }
    }

    @Command(scope="xi", name="csr-p11", description="generate CSR request with PKCS#11 device")
    @Service
    public static class CsrP11
    extends Actions.CsrGenAction {
        @Option(name="--slot", description="slot index")
        private String slotIndex = "0";
        @Option(name="--id", description="id (hex) of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        private String id;
        @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        private String label;
        @Option(name="--module", description="name of the PKCS#11 module")
        @Completion(value=SecurityCompleters.P11ModuleNameCompleter.class)
        private String moduleName = "default";

        @Override
        protected ConcurrentContentSigner getSigner() throws Exception {
            SignatureAlgoControl signatureAlgoControl = this.getSignatureAlgoControl();
            byte[] idBytes = null;
            if (this.id != null) {
                idBytes = Hex.decode((String)this.id);
            }
            SignerConf conf = CsrP11.getPkcs11SignerConf(this.moduleName, Integer.parseInt(this.slotIndex), this.label, idBytes, 1, HashAlgo.getInstance((String)this.hashAlgo), signatureAlgoControl);
            return this.securityFactory.createSigner("PKCS11", conf, (X509Cert[])null);
        }

        public static SignerConf getPkcs11SignerConf(String pkcs11ModuleName, int slotIndex, String keyLabel, byte[] keyId, int parallelism, HashAlgo hashAlgo, SignatureAlgoControl signatureAlgoControl) {
            Args.positive((int)parallelism, (String)"parallelism");
            Args.notNull((Object)hashAlgo, (String)"hashAlgo");
            if (keyId == null && keyLabel == null) {
                throw new IllegalArgumentException("at least one of keyId and keyLabel may not be null");
            }
            ConfPairs conf = new ConfPairs();
            conf.putPair("parallelism", Integer.toString(parallelism));
            if (pkcs11ModuleName != null && pkcs11ModuleName.length() > 0) {
                conf.putPair("module", pkcs11ModuleName);
            }
            conf.putPair("slot", Integer.toString(slotIndex));
            if (keyId != null) {
                conf.putPair("key-id", Hex.encode((byte[])keyId));
            }
            if (keyLabel != null) {
                conf.putPair("key-label", keyLabel);
            }
            return new SignerConf(conf.getEncoded(), hashAlgo, signatureAlgoControl);
        }
    }
}

