/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.lang.invoke.CallSite;
import java.util.LinkedList;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.shell.EnumCompleter;

public class QaCompleters {

    @Service
    public static class RSASigAlgCompleter
    extends EnumCompleter {
        public RSASigAlgCompleter() {
            String[] hashAlgs = new String[]{"SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3-224", "SHA3-256", "SHA3-384", "SHA3-512"};
            LinkedList<CallSite> enums = new LinkedList<CallSite>();
            for (String hashAlg : hashAlgs) {
                enums.add((CallSite)((Object)(hashAlg + "withRSA")));
                enums.add((CallSite)((Object)(hashAlg + "withRSAandMGF1")));
            }
            this.setTokens(enums);
        }
    }

    @Service
    public static class HMACSigAlgCompleter
    extends EnumCompleter {
        public HMACSigAlgCompleter() {
            this.setTokens(new String[]{"HMACSHA1", "HMACSHA224", "HMACSHA256", "HMACSHA384", "HMACSHA512", "HMACSHA3-224", "HMACSHA3-256", "HMACSHA3-384", "HMACSHA3-512"});
        }
    }

    @Service
    public static class GMACSigAlgCompleter
    extends EnumCompleter {
        public GMACSigAlgCompleter() {
            this.setTokens(new String[]{"AES128-GMAC", "AES192-GMAC", "AES256-GMAC"});
        }
    }

    @Service
    public static class EDDSASigAlgCompleter
    extends EnumCompleter {
        public EDDSASigAlgCompleter() {
            this.setTokens(new String[]{"ED25519", "ED448"});
        }
    }

    @Service
    public static class ECDSASigAlgCompleter
    extends EnumCompleter {
        public ECDSASigAlgCompleter() {
            String[] hashAlgs = new String[]{"SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3-224", "SHA3-256", "SHA3-384", "SHA3-512"};
            LinkedList<CallSite> enums = new LinkedList<CallSite>();
            for (String hashAlg : hashAlgs) {
                enums.add((CallSite)((Object)(hashAlg + "withECDSA")));
            }
            for (String hashAlg : hashAlgs = new String[]{"SHA1", "SHA224", "SHA256", "SHA384", "SHA512"}) {
                enums.add((CallSite)((Object)(hashAlg + "withPlainECDSA")));
            }
            this.setTokens(enums);
        }
    }

    @Service
    public static class DSASigAlgCompleter
    extends EnumCompleter {
        public DSASigAlgCompleter() {
            String[] hashAlgs = new String[]{"SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3-224", "SHA3-256", "SHA3-384", "SHA3-512"};
            LinkedList<CallSite> enums = new LinkedList<CallSite>();
            for (String hashAlg : hashAlgs) {
                enums.add((CallSite)((Object)(hashAlg + "withDSA")));
            }
            this.setTokens(enums);
        }
    }
}

