/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import java.util.Objects;

public class DataAccessException
extends Exception {
    private Reason reason;

    public DataAccessException(String msg) {
        this(Reason.Root, msg);
    }

    public DataAccessException(Reason reason, String msg) {
        super((Object)((Object)reason) + " - " + msg);
        this.reason = Objects.requireNonNull(reason, "reason must not be null");
    }

    public DataAccessException(String msg, Throwable cause) {
        this(Reason.Root, msg, cause);
    }

    public DataAccessException(Reason reason, String msg, Throwable cause) {
        super((Object)((Object)reason) + " - " + msg, cause);
        this.reason = Objects.requireNonNull(reason, "reason must not be null");
    }

    public Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        Root(null),
        NonTransientDataAccess(Root),
        DataIntegrityViolation(NonTransientDataAccess),
        DuplicateKey(DataIntegrityViolation),
        InvalidDataAccessResourceUsage(NonTransientDataAccess),
        BadSqlGrammar(InvalidDataAccessResourceUsage),
        InvalidResultSetAccess(InvalidDataAccessResourceUsage),
        NonTransientDataAccessResource(NonTransientDataAccess),
        DataAccessResourceFailure(NonTransientDataAccessResource),
        PermissionDeniedDataAccess(NonTransientDataAccess),
        UncategorizedDataAccess(NonTransientDataAccess),
        UncategorizedSql(UncategorizedDataAccess),
        TransientDataAcces(Root),
        ConcurrencyFailure(TransientDataAcces),
        PessimisticLockingFailure(ConcurrencyFailure),
        CannotAcquireLock(PessimisticLockingFailure),
        CannotSerializeTransaction(PessimisticLockingFailure),
        DeadlockLoserDataAccess(PessimisticLockingFailure),
        QueryTimeout(TransientDataAcces),
        TransientDataAccessResource(TransientDataAcces);

        private final Reason parent;

        private Reason(Reason parent) {
            this.parent = parent;
        }

        public boolean isAncestorOf(Reason reason) {
            Reason parent;
            while ((parent = reason.parent) != null) {
                if (parent == this) {
                    return true;
                }
                reason = parent;
            }
            return false;
        }

        public boolean isAncestorOrSelfOf(Reason reason) {
            return this == reason ? true : this.isAncestorOf(reason);
        }

        public boolean isDescendantOf(Reason reason) {
            return reason.isAncestorOf(this);
        }

        public boolean isDescendantOrSelfOf(Reason reason) {
            return this == reason ? true : this.isDescendantOf(reason);
        }
    }
}

