/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.datasource.DatabaseType;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.IoUtil;
import org.xipki.util.ParamUtil;

public class DataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceFactory.class);

    public DataSourceWrapper createDataSourceForFile(String name, String confFile, PasswordResolver passwordResolver) throws PasswordResolverException, IOException {
        ParamUtil.requireNonNull((String)"confFile", (Object)confFile);
        FileInputStream fileIn = new FileInputStream(IoUtil.expandFilepath((String)confFile));
        return this.createDataSource(name, fileIn, passwordResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceWrapper createDataSource(String name, InputStream conf, PasswordResolver passwordResolver) throws PasswordResolverException, IOException {
        ParamUtil.requireNonNull((String)"conf", (Object)conf);
        Properties config = new Properties();
        try {
            config.load(conf);
        }
        finally {
            try {
                conf.close();
            }
            catch (Exception ex) {
                LOG.error("could not close stream: {}", (Object)ex.getMessage());
            }
        }
        return this.createDataSource(name, config, passwordResolver);
    }

    public DataSourceWrapper createDataSource(String name, Properties conf, PasswordResolver passwordResolver) throws PasswordResolverException {
        DatabaseType databaseType;
        ParamUtil.requireNonNull((String)"conf", (Object)conf);
        String className = conf.getProperty("dataSourceClassName");
        if (className != null) {
            databaseType = DatabaseType.forDataSourceClass(className);
        } else {
            className = conf.getProperty("driverClassName");
            if (className != null) {
                databaseType = DatabaseType.forDriver(className);
            } else {
                String jdbcUrl = conf.getProperty("jdbcUrl");
                if (jdbcUrl == null) {
                    throw new IllegalArgumentException("none of the properties dataSourceClassName, driverClassName and jdbcUrl is configured");
                }
                databaseType = DatabaseType.forJdbcUrl(jdbcUrl);
            }
        }
        String password = conf.getProperty("password");
        if (password != null) {
            if (passwordResolver != null) {
                password = new String(passwordResolver.resolvePassword(password));
            }
            conf.setProperty("password", password);
        }
        if ((password = conf.getProperty("dataSource.password")) != null) {
            if (passwordResolver != null) {
                password = new String(passwordResolver.resolvePassword(password));
            }
            conf.setProperty("dataSource.password", password);
        }
        HashSet<Object> keySet = new HashSet<Object>(conf.keySet());
        for (Object e : keySet) {
            if (!((String)e).startsWith("liquibase")) continue;
            conf.remove(e);
        }
        return DataSourceWrapper.createDataSource(name, conf, databaseType);
    }
}

