/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import org.xipki.util.ParamUtil;

public enum DatabaseType {
    H2,
    DB2,
    HSQL,
    MYSQL,
    MARIADB,
    ORACLE,
    POSTGRES,
    UNKNOWN;


    public static DatabaseType forDriver(String driverClass) {
        ParamUtil.requireNonNull((String)"driverClass", (Object)driverClass);
        return DatabaseType.getDatabaseType(driverClass);
    }

    public static DatabaseType forDataSourceClass(String datasourceClass) {
        ParamUtil.requireNonNull((String)"datasourceClass", (Object)datasourceClass);
        return DatabaseType.getDatabaseType(datasourceClass);
    }

    public static DatabaseType forJdbcUrl(String url) {
        ParamUtil.requireNonNull((String)"url", (Object)url);
        url = url.toLowerCase();
        if (url.startsWith("jdbc:db2")) {
            return DB2;
        }
        if (url.startsWith("jdbc:h2")) {
            return H2;
        }
        if (url.startsWith("jdbc:hsqldb")) {
            return HSQL;
        }
        if (url.startsWith("jdbc:mysql")) {
            return MYSQL;
        }
        if (url.startsWith("jdbc:mariadb")) {
            return MARIADB;
        }
        if (url.startsWith("jdbc:oracle")) {
            return ORACLE;
        }
        if (url.startsWith("jdbc:pgsql") || url.startsWith("jdbc:postgres") || url.startsWith("jdbc:postgresql")) {
            return POSTGRES;
        }
        return UNKNOWN;
    }

    private static DatabaseType getDatabaseType(String className) {
        if (className.contains("db2.")) {
            return DB2;
        }
        if (className.contains("h2.")) {
            return H2;
        }
        if (className.contains("hsqldb.")) {
            return HSQL;
        }
        if (className.contains("mysql.")) {
            return MYSQL;
        }
        if (className.contains("mariadb.")) {
            return MARIADB;
        }
        if (className.contains("oracle.")) {
            return ORACLE;
        }
        if (className.contains("postgres.") || className.contains("postgresql.")) {
            return POSTGRES;
        }
        return UNKNOWN;
    }
}

