/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import org.xipki.util.Args;

public enum DatabaseType {
    H2,
    DB2,
    HSQL,
    MYSQL,
    MARIADB,
    ORACLE,
    POSTGRES,
    UNKNOWN;


    public static DatabaseType forDriver(String driverClass) {
        Args.notNull((Object)driverClass, (String)"driverClass");
        return DatabaseType.getDatabaseType(driverClass);
    }

    public static DatabaseType forDataSourceClass(String datasourceClass) {
        Args.notNull((Object)datasourceClass, (String)"datasourceClass");
        return DatabaseType.getDatabaseType(datasourceClass);
    }

    public static DatabaseType forJdbcUrl(String url) {
        if ((url = ((String)Args.notNull((Object)url, (String)"url")).toLowerCase()).startsWith("jdbc:db2")) {
            return DB2;
        }
        if (url.startsWith("jdbc:h2")) {
            return H2;
        }
        if (url.startsWith("jdbc:hsqldb")) {
            return HSQL;
        }
        if (url.startsWith("jdbc:mysql")) {
            return MYSQL;
        }
        if (url.startsWith("jdbc:mariadb")) {
            return MARIADB;
        }
        if (url.startsWith("jdbc:oracle")) {
            return ORACLE;
        }
        if (url.startsWith("jdbc:pgsql") || url.startsWith("jdbc:postgres") || url.startsWith("jdbc:postgresql")) {
            return POSTGRES;
        }
        return UNKNOWN;
    }

    private static DatabaseType getDatabaseType(String className) {
        if (className.contains("db2.")) {
            return DB2;
        }
        if (className.contains("h2.")) {
            return H2;
        }
        if (className.contains("hsqldb.")) {
            return HSQL;
        }
        if (className.contains("mysql.")) {
            return MYSQL;
        }
        if (className.contains("mariadb.")) {
            return MARIADB;
        }
        if (className.contains("oracle.")) {
            return ORACLE;
        }
        if (className.contains("postgres.") || className.contains("postgresql.")) {
            return POSTGRES;
        }
        return UNKNOWN;
    }
}

