/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.datasource.DatabaseType;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.Args;
import org.xipki.util.FileOrValue;
import org.xipki.util.IoUtil;

public class DataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceFactory.class);

    public DataSourceWrapper createDataSource(String name, FileOrValue conf, PasswordResolver passwordResolver) throws PasswordResolverException, IOException {
        Args.notNull((Object)conf, (String)"conf");
        Properties props = new Properties();
        try (StringReader reader = new StringReader(conf.readContent());){
            props.load(reader);
        }
        return this.createDataSource(name, props, passwordResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceWrapper createDataSource(String name, InputStream conf, PasswordResolver passwordResolver) throws PasswordResolverException, IOException {
        Args.notNull((Object)conf, (String)"conf");
        Properties config = new Properties();
        try {
            config.load(conf);
        }
        finally {
            try {
                conf.close();
            }
            catch (Exception ex) {
                LOG.error("could not close stream: {}", (Object)ex.getMessage());
            }
        }
        return this.createDataSource(name, config, passwordResolver);
    }

    public DataSourceWrapper createDataSource(String name, Properties conf, PasswordResolver passwordResolver) throws PasswordResolverException {
        String dataSourceUrl;
        DatabaseType databaseType;
        Args.notNull((Object)conf, (String)"conf");
        String className = conf.getProperty("dataSourceClassName");
        if (className != null) {
            databaseType = DatabaseType.forDataSourceClass(className);
        } else {
            className = conf.getProperty("driverClassName");
            if (className != null) {
                databaseType = DatabaseType.forDriver(className);
            } else {
                String jdbcUrl = conf.getProperty("jdbcUrl");
                if (jdbcUrl == null) {
                    throw new IllegalArgumentException("none of the properties dataSourceClassName, driverClassName and jdbcUrl is configured");
                }
                databaseType = DatabaseType.forJdbcUrl(jdbcUrl);
            }
        }
        String password = conf.getProperty("password");
        if (password != null) {
            if (passwordResolver != null) {
                password = new String(passwordResolver.resolvePassword(password));
            }
            conf.setProperty("password", password);
        }
        if ((password = conf.getProperty("dataSource.password")) != null) {
            if (passwordResolver != null) {
                password = new String(passwordResolver.resolvePassword(password));
            }
            conf.setProperty("dataSource.password", password);
        }
        if ((dataSourceUrl = conf.getProperty("dataSource.url")) != null) {
            String newUrl = null;
            if (dataSourceUrl.startsWith("jdbc:h2:~")) {
                newUrl = "jdbc:h2:" + IoUtil.expandFilepath((String)dataSourceUrl.substring("jdbc:h2:".length()));
            } else if (dataSourceUrl.startsWith("jdbc:hsqldb:file:~")) {
                newUrl = "jdbc:h2:" + IoUtil.expandFilepath((String)dataSourceUrl.substring("jdbc:hsqldb:file:".length()));
            }
            if (newUrl != null) {
                conf.setProperty("dataSource.url", newUrl);
            }
        }
        HashSet<Object> keySet = new HashSet<Object>(conf.keySet());
        for (Object e : keySet) {
            if (!((String)e).startsWith("liquibase")) continue;
            conf.remove(e);
        }
        return DataSourceWrapper.createDataSource(name, conf, databaseType);
    }

    public DataSourceWrapper createDataSourceForFile(String name, String confFile, PasswordResolver passwordResolver) throws PasswordResolverException, IOException {
        Args.notBlank((String)confFile, (String)"confFile");
        InputStream fileIn = Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)confFile), new String[0]), new OpenOption[0]);
        return this.createDataSource(name, fileIn, passwordResolver);
    }
}

