/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource.tool;

import java.util.Properties;
import org.xipki.password.PBEPasswordService;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.SinglePasswordResolver;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class DatabaseConf {
    private final String type;
    private final String driver;
    private final String username;
    private final String password;
    private final String url;
    private final String schema;

    public DatabaseConf(String driver, String username, String password, String url, String schema) {
        this.driver = driver;
        this.username = (String)Args.notNull((Object)username, (String)"username");
        this.password = password;
        this.url = (String)Args.notNull((Object)url, (String)"url");
        this.schema = schema;
        this.type = driver.contains("org.h2.") ? "h2" : (driver.contains("mysql.") || driver.contains("mariadb.") ? "mysql" : (driver.contains("oracle.") ? "oracle" : (driver.contains("db2.") ? "db2" : (driver.contains("postgresql.") || driver.contains("postgres.") ? "postgresql" : (driver.contains("hsqldb.") ? "hsqldb" : "unknown")))));
    }

    public String getType() {
        return this.type;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSchema() {
        return this.schema;
    }

    public static DatabaseConf getInstance(Properties dbProps, PasswordResolver passwordResolver) throws PasswordResolverException {
        String str;
        String prefix;
        String dataSourceUrl;
        String driverClassName;
        String url;
        String password;
        String user;
        Args.notNull((Object)dbProps, (String)"dbProps");
        String schema = dbProps.getProperty("sqlscript.schema");
        if (schema == null) {
            schema = dbProps.getProperty("liquibase.schema");
        }
        if (schema != null && (schema = schema.trim()).isEmpty()) {
            schema = null;
        }
        if ((user = dbProps.getProperty("dataSource.user")) == null) {
            user = dbProps.getProperty("username");
        }
        if ((password = dbProps.getProperty("dataSource.password")) == null) {
            password = dbProps.getProperty("password");
        }
        if (passwordResolver != null && password != null && !password.isEmpty()) {
            password = new String(passwordResolver.resolvePassword(password));
        }
        if ((url = dbProps.getProperty("jdbcUrl")) != null) {
            String driverClassName2 = dbProps.getProperty("driverClassName");
            if (driverClassName2 == null) {
                if (url.startsWith("jdbc:h2:")) {
                    driverClassName2 = "org.h2.Driver";
                } else if (url.startsWith("jdbc:mysql:")) {
                    driverClassName2 = "com.mysql.jdbc.Driver";
                } else if (url.startsWith("jdbc:mariadb:")) {
                    driverClassName2 = "org.mariadb.jdbc.Driver";
                } else if (url.startsWith("jdbc:oracle:")) {
                    driverClassName2 = "oracle.jdbc.driver.OracleDriver";
                } else if (url.startsWith("jdbc:db2:")) {
                    driverClassName2 = "com.ibm.db2.jcc.DB2Driver";
                } else if (url.startsWith("jdbc:postgresql:") || url.startsWith("jdbc:pgsql:")) {
                    driverClassName2 = "org.postgresql.Driver";
                } else if (url.startsWith("jdbc:hsqldb:")) {
                    driverClassName2 = "org.hsqldb.jdbc.JDBCDriver";
                } else {
                    throw new IllegalArgumentException("unknown jdbc database URL " + url + ", please specify driverClassName");
                }
            }
            return new DatabaseConf(driverClassName2, user, password, url, schema);
        }
        String datasourceClassName = dbProps.getProperty("dataSourceClassName");
        if (datasourceClassName == null) {
            throw new IllegalArgumentException("unsupported configuration");
        }
        StringBuilder urlBuilder = new StringBuilder();
        if ((datasourceClassName = datasourceClassName.toLowerCase()).contains("org.h2.")) {
            driverClassName = "org.h2.Driver";
            dataSourceUrl = dbProps.getProperty("dataSource.url");
            if (dataSourceUrl.startsWith((prefix = "jdbc:h2:") + "~")) {
                urlBuilder.append(prefix).append(IoUtil.expandFilepath((String)dataSourceUrl.substring(prefix.length())));
            } else {
                urlBuilder.append(dataSourceUrl);
            }
            if (schema != null) {
                urlBuilder.append(";INIT=CREATE SCHEMA IF NOT EXISTS ").append(schema);
            }
        } else if (datasourceClassName.contains("mysql.")) {
            driverClassName = "com.mysql.jdbc.Driver";
            urlBuilder.append("jdbc:mysql://").append(dbProps.getProperty("dataSource.serverName")).append(":").append(dbProps.getProperty("dataSource.port")).append("/").append(dbProps.getProperty("dataSource.databaseName"));
        } else if (datasourceClassName.contains("mariadb.")) {
            driverClassName = "org.mariadb.jdbc.Driver";
            str = dbProps.getProperty("dataSource.url");
            if (StringUtil.isNotBlank((String)str)) {
                urlBuilder.append(str);
            } else {
                urlBuilder.append("jdbc:mariadb://").append(dbProps.getProperty("dataSource.serverName")).append(":").append(dbProps.getProperty("dataSource.port")).append("/").append(dbProps.getProperty("dataSource.databaseName"));
            }
        } else if (datasourceClassName.contains("oracle.")) {
            driverClassName = "oracle.jdbc.driver.OracleDriver";
            str = dbProps.getProperty("dataSource.URL");
            if (StringUtil.isNotBlank((String)str)) {
                urlBuilder.append(str);
            } else {
                urlBuilder.append("jdbc:oracle:thin:@").append(dbProps.getProperty("dataSource.serverName")).append(":").append(dbProps.getProperty("dataSource.portNumber")).append(":").append(dbProps.getProperty("dataSource.databaseName"));
            }
        } else if (datasourceClassName.contains("com.ibm.db2.")) {
            driverClassName = "com.ibm.db2.jcc.DB2Driver";
            schema = dbProps.getProperty("dataSource.currentSchema");
            urlBuilder.append("jdbc:db2://").append(dbProps.getProperty("dataSource.serverName")).append(":").append(dbProps.getProperty("dataSource.portNumber")).append("/").append(dbProps.getProperty("dataSource.databaseName"));
        } else if (datasourceClassName.contains("postgresql.") || datasourceClassName.contains("impossibl.postgres.")) {
            String databaseName;
            String portNumber;
            String serverName;
            if (datasourceClassName.contains("postgresql.")) {
                serverName = dbProps.getProperty("dataSource.serverName");
                portNumber = dbProps.getProperty("dataSource.portNumber");
                databaseName = dbProps.getProperty("dataSource.databaseName");
            } else {
                serverName = dbProps.getProperty("dataSource.host");
                portNumber = dbProps.getProperty("dataSource.port");
                databaseName = dbProps.getProperty("dataSource.database");
            }
            driverClassName = "org.postgresql.Driver";
            urlBuilder.append("jdbc:postgresql://").append(serverName).append(":").append(portNumber).append("/").append(databaseName);
        } else if (datasourceClassName.contains("hsqldb.")) {
            driverClassName = "org.hsqldb.jdbc.JDBCDriver";
            dataSourceUrl = dbProps.getProperty("dataSource.url");
            if (dataSourceUrl.startsWith((prefix = "jdbc:hsqldb:file:") + "~")) {
                urlBuilder.append(prefix).append(IoUtil.expandFilepath((String)dataSourceUrl.substring(prefix.length())));
            } else {
                urlBuilder.append(dataSourceUrl);
            }
        } else {
            throw new IllegalArgumentException("unsupported database type " + datasourceClassName);
        }
        url = urlBuilder.toString();
        if (password != null) {
            char[] newPassword = null;
            if (StringUtil.startsWithIgnoreCase((String)password, (String)"OBF:")) {
                SinglePasswordResolver.OBF resolver = new SinglePasswordResolver.OBF();
                newPassword = resolver.resolvePassword(password);
            } else if (StringUtil.startsWithIgnoreCase((String)password, (String)"PBE:")) {
                char[] masterPassword = IoUtil.readPasswordFromConsole((String)"Enter the master password");
                newPassword = PBEPasswordService.decryptPassword((char[])masterPassword, (String)password);
            }
            if (newPassword != null) {
                password = new String(newPassword);
            }
        }
        return new DatabaseConf(driverClassName, user, password, url, schema);
    }
}

