/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.dbtool;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.dbtool.LiquibaseMain;
import org.xipki.password.PBEPasswordService;
import org.xipki.password.SinglePasswordResolver;
import org.xipki.util.CollectionUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class InitDbMain {
    private static final Logger LOG = LoggerFactory.getLogger(InitDbMain.class);

    public static void main(String[] args) {
        if (args == null || args.length < 4 || "--help".equals(args[0])) {
            InitDbMain.printUsage(null);
            return;
        }
        boolean force = false;
        String dbConfFile = null;
        String dbSchemaFile = null;
        int argSize = args.length;
        block13: for (int i = 0; i < argSize; ++i) {
            String name;
            switch (name = args[i]) {
                case "--db-conf": {
                    if (i >= argSize - 1) continue block13;
                    dbConfFile = args[++i];
                    continue block13;
                }
                case "--db-schema": {
                    if (i >= argSize - 1) continue block13;
                    dbSchemaFile = args[++i];
                    continue block13;
                }
                case "--force": 
                case "-f": {
                    force = true;
                    continue block13;
                }
            }
        }
        if (dbConfFile == null) {
            InitDbMain.printUsage("dbConfFile is not specified");
            return;
        }
        if (dbSchemaFile == null) {
            InitDbMain.printUsage("dbSchemaFile is not specified");
            return;
        }
        try {
            InitDbMain.exec(dbConfFile, dbSchemaFile, force);
        }
        catch (Exception ex) {
            System.err.println("Error while initializing database: " + ex.getMessage());
            LOG.error("Error while initializing database", (Throwable)ex);
        }
    }

    private static void exec(String dbConfFile, String dbSchemaFile, boolean force) throws Exception {
        Properties props = new Properties();
        props.load(Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)dbConfFile), new String[0]), new OpenOption[0]));
        LiquibaseMain.DatabaseConf dbConf = LiquibaseMain.DatabaseConf.getInstance(props, null);
        String password = dbConf.getPassword();
        if (password != null) {
            char[] newPassword = null;
            if (StringUtil.startsWithIgnoreCase((String)password, (String)"OBF:")) {
                SinglePasswordResolver.OBF resolver = new SinglePasswordResolver.OBF();
                newPassword = resolver.resolvePassword(password);
            } else if (StringUtil.startsWithIgnoreCase((String)password, (String)"PBE:")) {
                char[] masterPassword = IoUtil.readPasswordFromConsole((String)"Enter the master password");
                newPassword = PBEPasswordService.decryptPassword((char[])masterPassword, (String)password);
            }
            if (newPassword != null) {
                dbConf = new LiquibaseMain.DatabaseConf(dbConf.getDriver(), dbConf.getUsername(), new String(newPassword), dbConf.getUrl(), dbConf.getSchema());
            }
        }
        InitDbMain.printDatabaseInfo(dbConf, dbSchemaFile);
        if (!force && !InitDbMain.confirm("reset and initialize")) {
            System.out.println("cancelled");
            return;
        }
        InitDbMain.initDb(dbConf, dbSchemaFile);
    }

    public static void initDb(LiquibaseMain.DatabaseConf dbConf, String dbSchemaFile) throws Exception {
        try (LiquibaseMain liquibase = new LiquibaseMain(dbConf, dbSchemaFile);){
            liquibase.init();
            liquibase.releaseLocks();
            liquibase.dropAll();
            liquibase.update();
        }
        InitDbMain.dropLiquibaseTables(dbConf);
    }

    private static void printDatabaseInfo(LiquibaseMain.DatabaseConf dbParams, String schemaFile) {
        String msg = StringUtil.concat((String)"\n--------------------------------------------", (String[])new String[]{"\n     driver: ", dbParams.getDriver(), "\n       user: ", dbParams.getUsername(), "\n        URL: ", dbParams.getUrl(), dbParams.getSchema() != null ? "     schema: " + dbParams.getSchema() : "", "\nschema file: ", schemaFile, "\n"});
        System.out.println(msg);
    }

    private static boolean confirm(String command) throws IOException {
        String text = InitDbMain.read("\nDo you wish to " + command + " the database", Arrays.asList("yes", "no"));
        return "yes".equalsIgnoreCase(text);
    }

    private static String read(String prompt, List<String> validValues) throws IOException {
        List<String> tmpValidValues = validValues;
        if (tmpValidValues == null) {
            tmpValidValues = Collections.emptyList();
        }
        if (prompt == null) {
            prompt = "Please enter";
        }
        if (CollectionUtil.isNonEmpty(tmpValidValues)) {
            StringBuilder promptBuilder = new StringBuilder(prompt);
            promptBuilder.append(" [");
            for (String validValue : tmpValidValues) {
                promptBuilder.append(validValue).append("/");
            }
            promptBuilder.deleteCharAt(promptBuilder.length() - 1);
            promptBuilder.append("] ?");
            prompt = promptBuilder.toString();
        }
        while (true) {
            String answer = IoUtil.readLineFromConsole((String)prompt);
            if (CollectionUtil.isEmpty(tmpValidValues) || tmpValidValues.contains(answer)) {
                return answer;
            }
            StringBuilder retryPromptBuilder = new StringBuilder("Please answer with ");
            for (String validValue : tmpValidValues) {
                retryPromptBuilder.append(validValue).append("/");
            }
            retryPromptBuilder.deleteCharAt(retryPromptBuilder.length() - 1);
            prompt = retryPromptBuilder.toString();
        }
    }

    private static void printUsage(String prefix) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix).append("\n");
        }
        sb.append("DESCRIPTION\n");
        sb.append("\tinitdb [options]\n");
        sb.append("\tReset and initialize the database\n");
        sb.append("OPTIONS\n");
        sb.append("\t--db-schema\n");
        sb.append("\t\tDB schema file\n");
        sb.append("\t\t(required)\n");
        sb.append("\t--db-conf\n");
        sb.append("\t\tDB configuration file\n");
        sb.append("\t\t(required)\n");
        sb.append("\t--help\n");
        sb.append("\t\tDisplay this help message\n");
        sb.append("\t--force, -f\n");
        sb.append("\t\tNever prompt for confirmation");
        System.out.println(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropLiquibaseTables(LiquibaseMain.DatabaseConf dbConf) {
        List<String> tables = Arrays.asList("DATABASECHANGELOG", "DATABASECHANGELOGLOCK");
        Connection conn = null;
        try {
            Statement stmt;
            try {
                conn = DriverManager.getConnection(dbConf.getUrl(), dbConf.getUsername(), dbConf.getPassword());
                if (dbConf.getSchema() != null) {
                    conn.setSchema(dbConf.getSchema());
                }
                stmt = conn.createStatement();
            }
            catch (SQLException ex) {
                LOG.info("Could not create statement, message: {}, this is OK", (Object)ex.getMessage());
                LOG.info("Could not create statement, this is OK", (Throwable)ex);
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex2) {
                        LOG.info("Could not close database connection, this is OK");
                        LOG.debug("Could not close database connection", (Throwable)ex2);
                    }
                }
                return;
            }
            for (String table : tables) {
                try {
                    stmt.execute("DROP TABLE " + table);
                }
                catch (SQLException ex) {
                    LOG.info("Could not drop table {}, this is OK", (Object)table);
                    LOG.debug("Could not drop table" + table, (Throwable)ex);
                }
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    LOG.info("Could not close database connection, this is OK");
                    LOG.debug("Could not close database connection", (Throwable)ex);
                }
            }
        }
    }
}

