/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.dbtool;

import java.io.Closeable;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.exception.DatabaseException;
import liquibase.integration.commandline.CommandLineResourceAccessor;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class LiquibaseMain
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LiquibaseMain.class);
    private final DatabaseConf dbConf;
    private final String changeLogFile;
    private Database database;
    private Liquibase liquibase;

    public LiquibaseMain(DatabaseConf dbConf, String changeLogFile) {
        this.dbConf = (DatabaseConf)Args.notNull((Object)dbConf, (String)"dbConf");
        this.changeLogFile = IoUtil.expandFilepath((String)Args.notBlank((String)changeLogFile, (String)"changeLogFile"));
    }

    public void init() throws Exception {
        FileSystemResourceAccessor fsOpener = new FileSystemResourceAccessor(){

            protected void addRootPath(URL path) {
                try {
                    new File(path.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                super.addRootPath(path);
            }
        };
        ClassLoader classLoader = this.getClass().getClassLoader();
        CommandLineResourceAccessor clOpener = new CommandLineResourceAccessor(classLoader);
        String defaultSchemaName = this.dbConf.getSchema();
        this.database = CommandLineUtils.createDatabaseObject((ResourceAccessor)clOpener, (String)this.dbConf.getUrl(), (String)this.dbConf.getUsername(), (String)this.dbConf.getPassword(), (String)this.dbConf.getDriver(), null, (String)defaultSchemaName, (boolean)false, (boolean)false, null, null, null, null, null, null, null);
        try {
            CompareControl.SchemaComparison[] finalSchemaComparisons;
            CompositeResourceAccessor fileOpener = new CompositeResourceAccessor(new ResourceAccessor[]{fsOpener, clOpener});
            DiffOutputControl diffOutputControl = new DiffOutputControl(false, false, false, null);
            for (CompareControl.SchemaComparison schema : finalSchemaComparisons = new CompareControl.SchemaComparison[]{new CompareControl.SchemaComparison(new CatalogAndSchema(null, defaultSchemaName), new CatalogAndSchema(null, defaultSchemaName))}) {
                diffOutputControl.addIncludedSchema(schema.getReferenceSchema());
                diffOutputControl.addIncludedSchema(schema.getComparisonSchema());
            }
            this.liquibase = new Liquibase(this.changeLogFile, (ResourceAccessor)fileOpener, this.database);
        }
        catch (Exception ex) {
            try {
                this.database.rollback();
                this.database.close();
            }
            catch (Exception ex2) {
                LOG.warn("problem closing connection", (Throwable)ex2);
            }
            throw ex;
        }
    }

    public void releaseLocks() throws Exception {
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.forceReleaseLock();
        System.out.println("successfully released the database");
    }

    public void dropAll() throws Exception {
        this.liquibase.dropAll();
        System.out.println("successfully  dropped the database");
    }

    public void update() throws Exception {
        this.liquibase.update((String)null);
        System.out.println("successfully  updated the database");
    }

    @Override
    public void close() {
        try {
            if (this.database != null) {
                this.database.rollback();
                this.database.close();
            }
        }
        catch (DatabaseException ex) {
            LOG.warn("problem closing connection", (Throwable)ex);
        }
        finally {
            this.database = null;
            this.liquibase = null;
        }
    }

    public static boolean loglevelIsSevereOrOff(String logLevel) {
        return "off".equalsIgnoreCase(logLevel) || "severe".equalsIgnoreCase(logLevel);
    }

    public static class DatabaseConf {
        private final String driver;
        private final String username;
        private final String password;
        private final String url;
        private final String schema;

        public DatabaseConf(String driver, String username, String password, String url, String schema) {
            this.driver = driver;
            this.username = (String)Args.notNull((Object)username, (String)"username");
            this.password = password;
            this.url = (String)Args.notNull((Object)url, (String)"url");
            this.schema = schema;
        }

        public String getDriver() {
            return this.driver;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUrl() {
            return this.url;
        }

        public String getSchema() {
            return this.schema;
        }

        public static DatabaseConf getInstance(Properties dbProps, PasswordResolver passwordResolver) throws PasswordResolverException {
            String driverClassName;
            String url;
            String password;
            String user;
            Args.notNull((Object)dbProps, (String)"dbProps");
            String schema = dbProps.getProperty("liquibase.schema");
            if (schema != null && (schema = schema.trim()).isEmpty()) {
                schema = null;
            }
            if ((user = dbProps.getProperty("dataSource.user")) == null) {
                user = dbProps.getProperty("username");
            }
            if ((password = dbProps.getProperty("dataSource.password")) == null) {
                password = dbProps.getProperty("password");
            }
            if (passwordResolver != null && password != null && !password.isEmpty()) {
                password = new String(passwordResolver.resolvePassword(password));
            }
            if ((url = dbProps.getProperty("jdbcUrl")) != null) {
                String driverClassName2 = dbProps.getProperty("driverClassName");
                return new DatabaseConf(driverClassName2, user, password, url, schema);
            }
            String datasourceClassName = dbProps.getProperty("dataSourceClassName");
            if (datasourceClassName == null) {
                throw new IllegalArgumentException("unsupported configuration");
            }
            StringBuilder urlBuilder = new StringBuilder();
            if ((datasourceClassName = datasourceClassName.toLowerCase()).contains("org.h2.")) {
                String prefix;
                driverClassName = "org.h2.Driver";
                String dataSourceUrl = dbProps.getProperty("dataSource.url");
                if (dataSourceUrl.startsWith((prefix = "jdbc:h2:") + "~")) {
                    urlBuilder.append(prefix).append(IoUtil.expandFilepath((String)dataSourceUrl.substring(prefix.length())));
                } else {
                    urlBuilder.append(dataSourceUrl);
                }
                if (schema != null) {
                    urlBuilder.append(";INIT=CREATE SCHEMA IF NOT EXISTS ").append(schema);
                }
            } else if (datasourceClassName.contains("mysql.")) {
                driverClassName = "com.mysql.jdbc.Driver";
                urlBuilder.append("jdbc:mysql://").append(dbProps.getProperty("dataSource.serverName")).append(":").append(dbProps.getProperty("dataSource.port")).append("/").append(dbProps.getProperty("dataSource.databaseName"));
            } else if (datasourceClassName.contains("mariadb.")) {
                driverClassName = "org.mariadb.jdbc.Driver";
                String str = dbProps.getProperty("dataSource.url");
                if (StringUtil.isNotBlank((String)str)) {
                    urlBuilder.append(str);
                } else {
                    urlBuilder.append("jdbc:mariadb://").append(dbProps.getProperty("dataSource.serverName")).append(":").append(dbProps.getProperty("dataSource.port")).append("/").append(dbProps.getProperty("dataSource.databaseName"));
                }
            } else if (datasourceClassName.contains("oracle.")) {
                driverClassName = "oracle.jdbc.driver.OracleDriver";
                String str = dbProps.getProperty("dataSource.URL");
                if (StringUtil.isNotBlank((String)str)) {
                    urlBuilder.append(str);
                } else {
                    urlBuilder.append("jdbc:oracle:thin:@").append(dbProps.getProperty("dataSource.serverName")).append(":").append(dbProps.getProperty("dataSource.portNumber")).append(":").append(dbProps.getProperty("dataSource.databaseName"));
                }
            } else if (datasourceClassName.contains("com.ibm.db2.")) {
                driverClassName = "com.ibm.db2.jcc.DB2Driver";
                schema = dbProps.getProperty("dataSource.currentSchema");
                urlBuilder.append("jdbc:db2://").append(dbProps.getProperty("dataSource.serverName")).append(":").append(dbProps.getProperty("dataSource.portNumber")).append("/").append(dbProps.getProperty("dataSource.databaseName"));
            } else if (datasourceClassName.contains("postgresql.") || datasourceClassName.contains("impossibl.postgres.")) {
                String databaseName;
                String portNumber;
                String serverName;
                if (datasourceClassName.contains("postgresql.")) {
                    serverName = dbProps.getProperty("dataSource.serverName");
                    portNumber = dbProps.getProperty("dataSource.portNumber");
                    databaseName = dbProps.getProperty("dataSource.databaseName");
                } else {
                    serverName = dbProps.getProperty("dataSource.host");
                    portNumber = dbProps.getProperty("dataSource.port");
                    databaseName = dbProps.getProperty("dataSource.database");
                }
                driverClassName = "org.postgresql.Driver";
                urlBuilder.append("jdbc:postgresql://").append(serverName).append(":").append(portNumber).append("/").append(databaseName);
            } else if (datasourceClassName.contains("hsqldb.")) {
                String prefix;
                driverClassName = "org.hsqldb.jdbc.JDBCDriver";
                String dataSourceUrl = dbProps.getProperty("dataSource.url");
                if (dataSourceUrl.startsWith((prefix = "jdbc:hsqldb:file:") + "~")) {
                    urlBuilder.append(prefix).append(IoUtil.expandFilepath((String)dataSourceUrl.substring(prefix.length())));
                } else {
                    urlBuilder.append(dataSourceUrl);
                }
            } else {
                throw new IllegalArgumentException("unsupported database type " + datasourceClassName);
            }
            url = urlBuilder.toString();
            return new DatabaseConf(driverClassName, user, password, url, schema);
        }
    }
}

