/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.dbtool;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.dbtool.LiquibaseMain;
import org.xipki.dbtool.ScriptRunner;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class RunScriptMain {
    private static final Logger LOG = LoggerFactory.getLogger(RunScriptMain.class);

    public static void main(String[] args) {
        if (args == null || args.length < 4 || "--help".equals(args[0])) {
            RunScriptMain.printUsage(null);
            return;
        }
        boolean force = false;
        String dbConfFile = null;
        String scriptFile = null;
        int argSize = args.length;
        block13: for (int i = 0; i < argSize; ++i) {
            String name;
            switch (name = args[i]) {
                case "--db-conf": {
                    if (i >= argSize - 1) continue block13;
                    dbConfFile = args[++i];
                    continue block13;
                }
                case "--script": {
                    if (i >= argSize - 1) continue block13;
                    scriptFile = args[++i];
                    continue block13;
                }
                case "--force": 
                case "-f": {
                    force = true;
                    continue block13;
                }
            }
        }
        if (dbConfFile == null) {
            RunScriptMain.printUsage("dbConfFile is not specified");
            return;
        }
        if (scriptFile == null) {
            RunScriptMain.printUsage("scriptFile is not specified");
            return;
        }
        try {
            RunScriptMain.exec(dbConfFile, scriptFile, force);
        }
        catch (Exception ex) {
            System.err.println("Error while running script on the database: " + ex.getMessage());
            LOG.error("Error while running script on the database", (Throwable)ex);
        }
    }

    private static void exec(String dbConfFile, String scriptFile, boolean force) throws Exception {
        Properties props = new Properties();
        try (InputStream is = Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)dbConfFile), new String[0]), new OpenOption[0]);){
            props.load(is);
        }
        LiquibaseMain.DatabaseConf dbConf = LiquibaseMain.DatabaseConf.getInstance(props, null);
        RunScriptMain.printDatabaseInfo(dbConf, scriptFile);
        if (!force && !RunScriptMain.confirm("run the script on the database")) {
            System.out.println("cancelled");
            return;
        }
        RunScriptMain.runScript(dbConf, scriptFile);
    }

    public static void runScript(LiquibaseMain.DatabaseConf dbConf, String scriptFile) throws Exception {
        try (Connection conn = DriverManager.getConnection(dbConf.getUrl(), dbConf.getUsername(), dbConf.getPassword());){
            if (dbConf.getSchema() != null) {
                conn.setSchema(dbConf.getSchema());
            }
            ScriptRunner runner = new ScriptRunner(conn, false, true);
            runner.runScript(IoUtil.expandFilepath((String)scriptFile));
            conn.commit();
        }
    }

    private static void printDatabaseInfo(LiquibaseMain.DatabaseConf dbParams, String schemaFile) {
        String msg = StringUtil.concat((String)"\n--------------------------------------------", (String[])new String[]{"\n     driver: ", dbParams.getDriver(), "\n       user: ", dbParams.getUsername(), "\n        URL: ", dbParams.getUrl(), dbParams.getSchema() != null ? "     schema: " + dbParams.getSchema() : "", "\nscript file: ", schemaFile, "\n"});
        System.out.println(msg);
    }

    private static boolean confirm(String command) {
        String prompt = "Do you wish to " + command + " the database (Yes/No)? ";
        String answer = IoUtil.readLineFromConsole((String)prompt);
        return StringUtil.orEqualsIgnoreCase((String)answer, (String[])new String[]{"yes", "y"});
    }

    private static void printUsage(String prefix) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix).append("\n");
        }
        sb.append("DESCRIPTION\n");
        sb.append("\trunscript [options]\n");
        sb.append("\tRun script on the database\n");
        sb.append("OPTIONS\n");
        sb.append("\t--script\n");
        sb.append("\t\tSQL script file\n");
        sb.append("\t\t(required)\n");
        sb.append("\t--db-conf\n");
        sb.append("\t\tDB configuration file\n");
        sb.append("\t\t(required)\n");
        sb.append("\t--help\n");
        sb.append("\t\tDisplay this help message\n");
        sb.append("\t--force, -f\n");
        sb.append("\t\tNever prompt for confirmation");
        System.out.println(sb);
    }
}

