/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.litecaclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.Extension;

public class SdkUtil {
    private static CertificateFactory certFact;
    private static Object certFactLock;

    private SdkUtil() {
    }

    public static X509Certificate parseCert(File file) throws IOException, CertificateException {
        SdkUtil.requireNonNull("file", file);
        try (FileInputStream in = new FileInputStream(file);){
            X509Certificate x509Certificate = SdkUtil.parseCert(in);
            return x509Certificate;
        }
    }

    public static X509Certificate parseCert(byte[] certBytes) throws CertificateException {
        SdkUtil.requireNonNull("certBytes", certBytes);
        return SdkUtil.parseCert(new ByteArrayInputStream(certBytes));
    }

    public static X509Certificate parseCert(InputStream certStream) throws CertificateException {
        SdkUtil.requireNonNull("certStream", certStream);
        X509Certificate cert = (X509Certificate)SdkUtil.getCertFactory().generateCertificate(certStream);
        if (cert == null) {
            throw new CertificateEncodingException("the given one is not a valid X.509 certificate");
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CertificateFactory getCertFactory() throws CertificateException {
        Object object = certFactLock;
        synchronized (object) {
            if (certFact == null) {
                certFact = CertificateFactory.getInstance("X.509");
            }
            return certFact;
        }
    }

    public static byte[] extractSki(X509Certificate cert) throws CertificateEncodingException {
        byte[] fullExtValue = cert.getExtensionValue(Extension.subjectKeyIdentifier.getId());
        if (fullExtValue == null) {
            return null;
        }
        byte[] extValue = ASN1OctetString.getInstance((Object)fullExtValue).getOctets();
        return ASN1OctetString.getInstance((Object)extValue).getOctets();
    }

    public static byte[] read(File file) throws IOException {
        return SdkUtil.read(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int readed = 0;
            byte[] buffer = new byte[2048];
            while ((readed = in.read(buffer)) != -1) {
                bout.write(buffer, 0, readed);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, byte[] content) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(content);
        }
    }

    public static HttpURLConnection openHttpConn(URL url) throws IOException {
        SdkUtil.requireNonNull("url", url);
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection) {
            return (HttpURLConnection)conn;
        }
        throw new IOException(url.toString() + " is not of protocol HTTP: " + url.getProtocol());
    }

    public static <T> T requireNonNull(String objName, T obj) {
        return Objects.requireNonNull(obj, objName + " must not be null");
    }

    public static String requireNonBlank(String objName, String obj) {
        Objects.requireNonNull(obj, objName + " must not be null");
        if (obj.isEmpty()) {
            throw new IllegalArgumentException(objName + " must not be blank");
        }
        return obj;
    }

    public static byte[] send(URL url, String httpMethod, byte[] request, String requestContentType, String expectedResponseContentType) throws IOException {
        HttpURLConnection httpUrlConnection = SdkUtil.openHttpConn(url);
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setUseCaches(false);
        httpUrlConnection.setRequestMethod(httpMethod);
        if (requestContentType != null) {
            httpUrlConnection.setRequestProperty("Content-Type", requestContentType);
        }
        if (request != null) {
            httpUrlConnection.setRequestProperty("Content-Length", Integer.toString(request.length));
            OutputStream outputstream = httpUrlConnection.getOutputStream();
            outputstream.write(request);
            outputstream.flush();
        }
        InputStream inputStream = httpUrlConnection.getInputStream();
        if (httpUrlConnection.getResponseCode() != 200) {
            inputStream.close();
            throw new IOException("bad response: " + httpUrlConnection.getResponseCode() + "    " + httpUrlConnection.getResponseMessage());
        }
        String responseContentType = httpUrlConnection.getContentType();
        boolean isValidContentType = false;
        if (responseContentType != null && responseContentType.equalsIgnoreCase(expectedResponseContentType)) {
            isValidContentType = true;
        }
        if (!isValidContentType) {
            inputStream.close();
            throw new IOException("bad response: mime type " + responseContentType + " not supported!");
        }
        return SdkUtil.read(inputStream);
    }

    static {
        certFactLock = new Object();
    }
}

