/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.litecaclient;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsInit {
    private static final Logger LOG = LoggerFactory.getLogger(SdkHostnameVerifier.class);
    private static HostnameVerifier oldHostnameVerifier;

    public static void init() throws GeneralSecurityException {
        System.err.println("***** ONLY FOR TEST, DO NOT USE IT IN PRODUCTION ENVIRONMENT ******");
        TrustManager[] trustManagers = new TrustManager[]{new InternX509TrustManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustManagers, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        oldHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        LOG.info("Register me as DefaultHostnameVerifier, and backup the old one {}", (Object)oldHostnameVerifier);
        HttpsURLConnection.setDefaultHostnameVerifier(SdkHostnameVerifier.INSTANCE);
    }

    public static void shutdown() {
        if (HttpsURLConnection.getDefaultHostnameVerifier() == SdkHostnameVerifier.INSTANCE) {
            LOG.info("Unregister me as DefaultHostnameVerifier, and reuse the old one {}", (Object)oldHostnameVerifier);
            HttpsURLConnection.setDefaultHostnameVerifier(oldHostnameVerifier);
        }
    }

    private static class SdkHostnameVerifier
    implements HostnameVerifier {
        private static SdkHostnameVerifier INSTANCE = new SdkHostnameVerifier();

        private SdkHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static final class InternX509TrustManager
    implements X509TrustManager {
        private InternX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

