/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.litecaclient.example;

import java.io.File;
import java.math.BigInteger;
import java.net.URL;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.litecaclient.KeyAndCert;
import org.xipki.litecaclient.PbmMacCmpCaClient;
import org.xipki.litecaclient.SdkUtil;
import org.xipki.litecaclient.TlsInit;
import org.xipki.litecaclient.example.CaClientExample;

public class PbmMacCmpCaClientExample
extends CaClientExample {
    private static final String URL_PREFIX = "https://localhost:8443";
    private static final String CMP_URL = "https://localhost:8443/cmp/myca";
    private static final String CACERT_URL = "https://localhost:8443/cacert/myca";
    private static final String KEYCERT_DIR = "target/tlskeys";
    private static final String RESPONDER_CERT_FILE = "target/tlskeys/tls-server.der";
    private static final String HASH_ALGO = "SHA256";
    private static final String CERT_PROFILE = "tls";
    private static final AtomicLong index = new AtomicLong(System.currentTimeMillis());
    private static final boolean profileAndKeyTypeInUri = true;

    public static void main(String[] args) {
        if (!new File(KEYCERT_DIR).exists()) {
            System.err.println("Please call \"mvn generate-resources\" first.");
            return;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            int i;
            TlsInit.init();
            byte[] encodedCaCert = SdkUtil.send(new URL(CACERT_URL), "GET", null, null, "application/pkix-cert");
            TlsInit.shutdown();
            X509Certificate caCert = SdkUtil.parseCert(encodedCaCert);
            X500Name issuer = X500Name.getInstance((Object)caCert.getSubjectX500Principal().getEncoded());
            X509Certificate responderCert = SdkUtil.parseCert(new File(PbmMacCmpCaClientExample.expandPath(RESPONDER_CERT_FILE)));
            X500Name requestorSubject = new X500Name("CN=PBMMAC");
            X500Name responderSubject = X500Name.getInstance((Object)responderCert.getSubjectX500Principal().getEncoded());
            PbmMacCmpCaClient client = new PbmMacCmpCaClient(CMP_URL, caCert, requestorSubject, responderSubject, HASH_ALGO);
            client.setKid(Hex.decode((String)"466827c7757a70af71ca0338c01361aab2019dcf"));
            client.setPassword("123456".toCharArray());
            client.setRequestInterationCount(10240);
            client.setRequestMac(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA256, (ASN1Encodable)DERNull.INSTANCE));
            client.setRequestOwf(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE));
            HashSet<ASN1ObjectIdentifier> owfOids = new HashSet<ASN1ObjectIdentifier>();
            owfOids.add(NISTObjectIdentifiers.id_sha256);
            client.setTrustedOwfOids(owfOids);
            HashSet<ASN1ObjectIdentifier> macOids = new HashSet<ASN1ObjectIdentifier>();
            macOids.add(PKCSObjectIdentifiers.id_hmacWithSHA256);
            client.setTrustedMacOids(macOids);
            client.init();
            PbmMacCmpCaClientExample.printCert("===== CA Certificate =====", client.getCaCert());
            KeyAndCert[] keyAndCerts = client.enrollCertsViaCrmfCaGenKeypair(new String[]{CERT_PROFILE, CERT_PROFILE}, new String[]{PbmMacCmpCaClientExample.getSubject(), PbmMacCmpCaClientExample.getSubject()}, true);
            for (int i2 = 0; i2 < keyAndCerts.length; ++i2) {
                PbmMacCmpCaClientExample.printKeyAndCert("===== Enroll via CRMF (CMP, CA generate keypair) =====", keyAndCerts[i2]);
            }
            X509Certificate cert = client.enrollCertViaCsr(CERT_PROFILE, PbmMacCmpCaClientExample.genCsr(PbmMacCmpCaClientExample.generateRsaKeypair(), PbmMacCmpCaClientExample.getSubject()), true);
            PbmMacCmpCaClientExample.printCert("===== Enroll RSA via CSR (CMP) =====", cert);
            cert = client.enrollCertViaCsr(CERT_PROFILE, PbmMacCmpCaClientExample.genCsr(PbmMacCmpCaClientExample.generateEcKeypair(), PbmMacCmpCaClientExample.getSubject()), true);
            PbmMacCmpCaClientExample.printCert("===== Enroll EC via CSR (CMP) =====", cert);
            cert = client.enrollCertViaCsr(CERT_PROFILE, PbmMacCmpCaClientExample.genCsr(PbmMacCmpCaClientExample.generateDsaKeypair(), PbmMacCmpCaClientExample.getSubject()), true);
            PbmMacCmpCaClientExample.printCert("===== Enroll DSA via CSR (CMP) =====", cert);
            CaClientExample.MyKeypair kp = PbmMacCmpCaClientExample.generateRsaKeypair();
            cert = client.enrollCertViaCrmf(CERT_PROFILE, kp.getPrivate(), kp.getPublic(), PbmMacCmpCaClientExample.getSubject(), true);
            PbmMacCmpCaClientExample.printCert("===== Enroll RSA via CRMF (CMP) =====", cert);
            cert = client.updateCertViaCrmf(kp.getPrivate(), issuer, cert.getSerialNumber());
            PbmMacCmpCaClientExample.printCert("===== Update RSA via CRMF (CMP) =====", cert);
            KeyAndCert keyAndCert = client.updateCertViaCrmfCaGenKeypair(issuer, cert.getSerialNumber(), true);
            PbmMacCmpCaClientExample.printKeyAndCert("===== Update via CRMF (CMP, CA generate keypair) =====", keyAndCert);
            kp = PbmMacCmpCaClientExample.generateEcKeypair();
            CaClientExample.MyKeypair kp2 = PbmMacCmpCaClientExample.generateEcKeypair();
            X509Certificate[] certs = client.enrollCertsViaCrmf(new String[]{CERT_PROFILE, CERT_PROFILE}, new PrivateKey[]{kp.getPrivate(), kp2.getPrivate()}, new SubjectPublicKeyInfo[]{kp.getPublic(), kp2.getPublic()}, new String[]{PbmMacCmpCaClientExample.getSubject(), PbmMacCmpCaClientExample.getSubject()}, true);
            for (i = 0; i < certs.length; ++i) {
                PbmMacCmpCaClientExample.printCert("===== Enroll EC via CRMF (CMP) =====", certs[i]);
            }
            certs = client.updateCertsViaCrmf(new PrivateKey[]{kp.getPrivate(), kp2.getPrivate()}, issuer, new BigInteger[]{certs[0].getSerialNumber(), certs[1].getSerialNumber()});
            for (i = 0; i < certs.length; ++i) {
                PbmMacCmpCaClientExample.printCert("===== Update EC via CRMF (CMP) =====", certs[i]);
            }
            kp = PbmMacCmpCaClientExample.generateDsaKeypair();
            cert = client.enrollCertViaCrmf(CERT_PROFILE, kp.getPrivate(), kp.getPublic(), PbmMacCmpCaClientExample.getSubject(), true);
            PbmMacCmpCaClientExample.printCert("===== Enroll DSA via CRMF (CMP) =====", cert);
            cert = client.updateCertViaCrmf(kp.getPrivate(), issuer, cert.getSerialNumber());
            PbmMacCmpCaClientExample.printCert("===== Update DSA via CRMF (CMP) =====", cert);
            BigInteger serialNumber = cert.getSerialNumber();
            boolean flag = client.revokeCert(serialNumber, CRLReason.lookup((int)6));
            if (flag) {
                System.out.println("(CMP) suspended certificate");
            } else {
                System.err.println("(CMP) suspending certificate failed");
            }
            flag = client.revokeCert(serialNumber, CRLReason.lookup((int)8));
            if (flag) {
                System.out.println("(CMP) unsuspended certificate");
            } else {
                System.err.println("(CMP) unsuspending certificate failed");
            }
            flag = client.revokeCert(serialNumber, CRLReason.lookup((int)1));
            if (flag) {
                System.out.println("(CMP) revoked certificate");
            } else {
                System.err.println("(CMP) revoking certificate failed");
            }
            client.shutdown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static String getSubject() {
        return "CN=CMP-" + index.incrementAndGet() + ".xipki.org,O=xipki,C=DE";
    }
}

