/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.litecaclient.example;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x509.CRLReason;
import org.xipki.litecaclient.RestCaClient;
import org.xipki.litecaclient.example.CaClientExample;

public class RestCaClientExample
extends CaClientExample {
    private static final String CA_URL = "https://localhost:8443/rest/myca";
    private static final String USER = "user1";
    private static final String PASSWORD = "password1";
    private static final String CERT_PROFILE = "tls";
    private static final AtomicLong index = new AtomicLong(System.currentTimeMillis());

    public static void main(String[] args) {
        try {
            RestCaClient client = new RestCaClient(CA_URL, USER, PASSWORD);
            client.init();
            RestCaClientExample.printCert("===== CA Certificate (REST) =====", client.getCaCert());
            CaClientExample.MyKeypair kp = RestCaClientExample.generateRsaKeypair();
            CertificationRequest csr = RestCaClientExample.genCsr(kp, RestCaClientExample.getSubject());
            X509Certificate cert = client.requestCert(CERT_PROFILE, csr);
            RestCaClientExample.printCert("===== RSA (REST) =====", cert);
            kp = RestCaClientExample.generateEcKeypair();
            csr = RestCaClientExample.genCsr(kp, RestCaClientExample.getSubject());
            cert = client.requestCert(CERT_PROFILE, csr);
            RestCaClientExample.printCert("===== EC (REST) =====", cert);
            kp = RestCaClientExample.generateDsaKeypair();
            csr = RestCaClientExample.genCsr(kp, RestCaClientExample.getSubject());
            cert = client.requestCert(CERT_PROFILE, csr);
            RestCaClientExample.printCert("===== DSA =====", cert);
            BigInteger serialNumber = cert.getSerialNumber();
            boolean flag = client.revokeCert(serialNumber, CRLReason.lookup((int)6));
            if (flag) {
                System.out.println("(REST) suspended certificate");
            } else {
                System.err.println("(REST) suspending certificate failed");
            }
            flag = client.revokeCert(serialNumber, CRLReason.lookup((int)8));
            if (flag) {
                System.out.println("(REST) unsuspended certificate");
            } else {
                System.err.println("(REST) unsuspending certificate failed");
            }
            flag = client.revokeCert(serialNumber, CRLReason.lookup((int)1));
            if (flag) {
                System.out.println("(REST) revoked certificate");
            } else {
                System.err.println("(REST) revoking certificate failed");
            }
            client.shutdown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static String getSubject() {
        return "CN=REST-" + index.incrementAndGet() + ".xipki.org,O=xipki,C=DE";
    }
}

