/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.litecaclient.example;

import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.xipki.litecaclient.KeyAndCert;
import org.xipki.litecaclient.SdkUtil;
import org.xipki.litecaclient.SignatureCmpCaClient;
import org.xipki.litecaclient.TlsInit;
import org.xipki.litecaclient.example.CaClientExample;

public class SignatureCmpCaClientExample
extends CaClientExample {
    private static final String URL_PREFIX = "https://localhost:8443";
    private static final String CMP_URL = "https://localhost:8443/cmp/myca";
    private static final String CACERT_URL = "https://localhost:8443/cacert/myca";
    private static final String KEYCERT_DIR = "target/tlskeys";
    private static final String REQUESTOR_KEYSTORE_FILE = "target/tlskeys/tls-client.p12";
    private static final String REQUESTOR_KEYSTORE_PASSWORD = "1234";
    private static final String RESPONDER_CERT_FILE = "target/tlskeys/tls-server.der";
    private static final String HASH_ALGO = "SHA256";
    private static final String CERT_PROFILE = "tls";
    private static final AtomicLong index = new AtomicLong(System.currentTimeMillis());
    private static final boolean profileAndKeyTypeInUri = true;

    public static void main(String[] args) {
        if (!new File(KEYCERT_DIR).exists()) {
            System.err.println("Please call \"mvn generate-resources\" first.");
            return;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            int i;
            KeyStore ks = KeyStore.getInstance("PKCS12");
            char[] password = REQUESTOR_KEYSTORE_PASSWORD.toCharArray();
            FileInputStream ksStream = new FileInputStream(SignatureCmpCaClientExample.expandPath(REQUESTOR_KEYSTORE_FILE));
            ks.load(ksStream, password);
            ksStream.close();
            Enumeration<String> aliases = ks.aliases();
            String alias = null;
            while (aliases.hasMoreElements()) {
                String tmp = aliases.nextElement();
                if (!ks.isKeyEntry(tmp)) continue;
                alias = tmp;
                break;
            }
            PrivateKey requestorKey = (PrivateKey)ks.getKey(alias, password);
            X509Certificate requestorCert = (X509Certificate)ks.getCertificate(alias);
            TlsInit.init();
            byte[] encodedCaCert = SdkUtil.send(new URL(CACERT_URL), "GET", null, null, "application/pkix-cert");
            TlsInit.shutdown();
            X509Certificate caCert = SdkUtil.parseCert(encodedCaCert);
            X500Name issuer = X500Name.getInstance((Object)caCert.getSubjectX500Principal().getEncoded());
            X509Certificate responderCert = SdkUtil.parseCert(new File(SignatureCmpCaClientExample.expandPath(RESPONDER_CERT_FILE)));
            SignatureCmpCaClient client = new SignatureCmpCaClient(CMP_URL, caCert, requestorKey, requestorCert, responderCert, HASH_ALGO);
            client.init();
            SignatureCmpCaClientExample.printCert("===== CA Certificate =====", client.getCaCert());
            KeyAndCert[] keyAndCerts = client.enrollCertsViaCrmfCaGenKeypair(new String[]{CERT_PROFILE, CERT_PROFILE}, new String[]{SignatureCmpCaClientExample.getSubject(), SignatureCmpCaClientExample.getSubject()}, true);
            for (int i2 = 0; i2 < keyAndCerts.length; ++i2) {
                SignatureCmpCaClientExample.printKeyAndCert("===== Enroll via CRMF (CMP, CA generate keypair) =====", keyAndCerts[i2]);
            }
            CaClientExample.MyKeypair kp = SignatureCmpCaClientExample.generateRsaKeypair();
            CertificationRequest csr = SignatureCmpCaClientExample.genCsr(kp, SignatureCmpCaClientExample.getSubject());
            X509Certificate cert = client.enrollCertViaCsr(CERT_PROFILE, csr, true);
            SignatureCmpCaClientExample.printCert("===== Enroll RSA via CSR (CMP) =====", cert);
            kp = SignatureCmpCaClientExample.generateEcKeypair();
            csr = SignatureCmpCaClientExample.genCsr(kp, SignatureCmpCaClientExample.getSubject());
            cert = client.enrollCertViaCsr(CERT_PROFILE, csr, true);
            SignatureCmpCaClientExample.printCert("===== Enroll Enroll EC via CSR (CMP) =====", cert);
            kp = SignatureCmpCaClientExample.generateDsaKeypair();
            csr = SignatureCmpCaClientExample.genCsr(kp, SignatureCmpCaClientExample.getSubject());
            cert = client.enrollCertViaCsr(CERT_PROFILE, csr, true);
            SignatureCmpCaClientExample.printCert("===== Enroll DSA via CSR (CMP) =====", cert);
            kp = SignatureCmpCaClientExample.generateRsaKeypair();
            cert = client.enrollCertViaCrmf(CERT_PROFILE, kp.getPrivate(), kp.getPublic(), SignatureCmpCaClientExample.getSubject(), true);
            SignatureCmpCaClientExample.printCert("===== Enroll Enroll RSA via CRMF (CMP) =====", cert);
            cert = client.updateCertViaCrmf(kp.getPrivate(), issuer, cert.getSerialNumber());
            SignatureCmpCaClientExample.printCert("===== Update RSA via CRMF (CMP) =====", cert);
            KeyAndCert keyAndCert = client.updateCertViaCrmfCaGenKeypair(issuer, cert.getSerialNumber(), true);
            SignatureCmpCaClientExample.printKeyAndCert("===== Update via CRMF (CMP, CA generate keypair) =====", keyAndCert);
            kp = SignatureCmpCaClientExample.generateEcKeypair();
            CaClientExample.MyKeypair kp2 = SignatureCmpCaClientExample.generateEcKeypair();
            X509Certificate[] certs = client.enrollCertsViaCrmf(new String[]{CERT_PROFILE, CERT_PROFILE}, new PrivateKey[]{kp.getPrivate(), kp2.getPrivate()}, new SubjectPublicKeyInfo[]{kp.getPublic(), kp2.getPublic()}, new String[]{SignatureCmpCaClientExample.getSubject(), SignatureCmpCaClientExample.getSubject()}, true);
            for (i = 0; i < certs.length; ++i) {
                SignatureCmpCaClientExample.printCert("===== Enroll EC via CRMF (CMP) =====", certs[i]);
            }
            certs = client.updateCertsViaCrmf(new PrivateKey[]{kp.getPrivate(), kp2.getPrivate()}, issuer, new BigInteger[]{certs[0].getSerialNumber(), certs[1].getSerialNumber()});
            for (i = 0; i < certs.length; ++i) {
                SignatureCmpCaClientExample.printCert("===== Update EC via CRMF (CMP) =====", certs[i]);
            }
            kp = SignatureCmpCaClientExample.generateDsaKeypair();
            cert = client.enrollCertViaCrmf(CERT_PROFILE, kp.getPrivate(), kp.getPublic(), SignatureCmpCaClientExample.getSubject(), true);
            SignatureCmpCaClientExample.printCert("===== Enroll DSA via CRMF (CMP) =====", cert);
            cert = client.updateCertViaCrmf(kp.getPrivate(), issuer, cert.getSerialNumber());
            SignatureCmpCaClientExample.printCert("===== Update DSA via CRMF (CMP) =====", cert);
            BigInteger serialNumber = cert.getSerialNumber();
            boolean flag = client.revokeCert(serialNumber, CRLReason.lookup((int)6));
            if (flag) {
                System.out.println("(CMP) suspended certificate");
            } else {
                System.err.println("(CMP) suspending certificate failed");
            }
            flag = client.revokeCert(serialNumber, CRLReason.lookup((int)8));
            if (flag) {
                System.out.println("(CMP) unsuspended certificate");
            } else {
                System.err.println("(CMP) unsuspending certificate failed");
            }
            flag = client.revokeCert(serialNumber, CRLReason.lookup((int)1));
            if (flag) {
                System.out.println("(CMP) revoked certificate");
            } else {
                System.err.println("(CMP) revoking certificate failed");
            }
            client.shutdown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static String getSubject() {
        return "CN=CMP-" + index.incrementAndGet() + ".xipki.org,O=xipki,C=DE";
    }
}

