/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.util.Pack;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.InvalidAlgorithmException;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.PopControl;
import org.xipki.ca.gateway.acme.AcmeAccount;
import org.xipki.ca.gateway.acme.AcmeAuthz;
import org.xipki.ca.gateway.acme.AcmeChallenge;
import org.xipki.ca.gateway.acme.AcmeChallenge2;
import org.xipki.ca.gateway.acme.AcmeDataSource;
import org.xipki.ca.gateway.acme.AcmeOrder;
import org.xipki.ca.gateway.acme.AcmeProtocolException;
import org.xipki.ca.gateway.acme.AcmeProxyConf;
import org.xipki.ca.gateway.acme.AcmeRepo;
import org.xipki.ca.gateway.acme.AcmeSystemException;
import org.xipki.ca.gateway.acme.AuthzId;
import org.xipki.ca.gateway.acme.CertEnroller;
import org.xipki.ca.gateway.acme.ChallId;
import org.xipki.ca.gateway.acme.ChallengeValidator;
import org.xipki.ca.gateway.acme.ContactVerifier;
import org.xipki.ca.gateway.acme.NonceManager;
import org.xipki.ca.gateway.acme.msg.AccountResponse;
import org.xipki.ca.gateway.acme.msg.ChallengeResponse;
import org.xipki.ca.gateway.acme.msg.FinalizeOrderPayload;
import org.xipki.ca.gateway.acme.msg.JoseMessage;
import org.xipki.ca.gateway.acme.msg.NewAccountPayload;
import org.xipki.ca.gateway.acme.msg.NewOrderPayload;
import org.xipki.ca.gateway.acme.msg.OrderResponse;
import org.xipki.ca.gateway.acme.msg.OrdersResponse;
import org.xipki.ca.gateway.acme.msg.RevokeCertPayload;
import org.xipki.ca.gateway.acme.type.AccountStatus;
import org.xipki.ca.gateway.acme.type.AcmeError;
import org.xipki.ca.gateway.acme.type.AuthzStatus;
import org.xipki.ca.gateway.acme.type.CertReqMeta;
import org.xipki.ca.gateway.acme.type.ChallengeStatus;
import org.xipki.ca.gateway.acme.type.Identifier;
import org.xipki.ca.gateway.acme.type.OrderStatus;
import org.xipki.ca.gateway.acme.type.Problem;
import org.xipki.ca.gateway.acme.util.AcmeJson;
import org.xipki.ca.gateway.acme.util.AcmeUtils;
import org.xipki.ca.sdk.ErrorEntry;
import org.xipki.ca.sdk.RevokeCertRequestEntry;
import org.xipki.ca.sdk.RevokeCertsRequest;
import org.xipki.ca.sdk.RevokeCertsResponse;
import org.xipki.ca.sdk.SdkClient;
import org.xipki.ca.sdk.SdkErrorResponseException;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.SecurityFactory;
import org.xipki.security.util.JSON;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64Url;
import org.xipki.util.CollectionUtil;
import org.xipki.util.FileOrValue;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ErrorCode;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.http.HttpRespContent;
import org.xipki.util.http.HttpResponse;
import org.xipki.util.http.XiHttpRequest;

public class AcmeResponder {
    private static final Logger LOG = LoggerFactory.getLogger(AcmeResponder.class);
    private final SdkClient sdk;
    private final PopControl popControl;
    private final SecurityFactory securityFactory;
    private final ContactVerifier contactVerifier;
    private final NonceManager nonceManager;
    private static final Set<String> knownCommands = CollectionUtil.asUnmodifiableSet((Object[])new String[]{"directory", "new-nonce", "new-account", "new-order", "revoke-cert", "key-change", "acct", "order", "orders", "authz", "chall", "finalize", "cert"});
    private final boolean termsOfServicePresent;
    private final byte[] directoryBytes;
    private final String directoryHeader;
    private final String host;
    private final String host2;
    private final String baseUrl;
    private final String accountPrefix;
    private final List<AcmeProxyConf.CaProfile> caProfiles;
    private final Set<String> challengeTypes;
    private final SecureRandom rnd;
    private final AcmeRepo repo;
    private final Map<String, byte[][]> cacertsMap = new ConcurrentHashMap<String, byte[][]>();
    private final int tokenNumBytes;
    private final AcmeProxyConf.CleanupOrderConf cleanOrderConf;
    private final ChallengeValidator challengeValidator;
    private final CertEnroller certEnroller;
    private final AtomicLong lastOrdersCleaned = new AtomicLong(0L);

    public AcmeResponder(SdkClient sdk, SecurityFactory securityFactory, PopControl popControl, AcmeProxyConf.Acme conf) throws InvalidConfException {
        LOG.info("XiPKI ACME-Gateway version {}", this.getClass());
        this.sdk = (SdkClient)Args.notNull((Object)sdk, (String)"sdk");
        this.popControl = (PopControl)Args.notNull((Object)popControl, (String)"popControl");
        this.securityFactory = (SecurityFactory)Args.notNull((Object)securityFactory, (String)"securityFactory");
        this.baseUrl = Args.notBlank((String)conf.getBaseUrl(), (String)"baseUrl");
        this.accountPrefix = this.baseUrl + "acct/";
        this.cleanOrderConf = new AcmeProxyConf.CleanupOrderConf();
        AcmeProxyConf.CleanupOrderConf cleanOrder = conf.getCleanupOrder();
        if (cleanOrder == null) {
            this.cleanOrderConf.setExpiredOrderDays(365);
            this.cleanOrderConf.setExpiredCertDays(365);
        } else {
            this.cleanOrderConf.setExpiredCertDays(Math.max(10, cleanOrder.getExpiredCertDays()));
            this.cleanOrderConf.setExpiredOrderDays(Math.max(10, cleanOrder.getExpiredOrderDays()));
        }
        try {
            URL url = new URL(this.baseUrl);
            String host0 = url.getHost();
            int port = url.getPort();
            int dfltPort = url.getDefaultPort();
            if (port == -1) {
                this.host = host0;
                this.host2 = (String)host0 + ":" + dfltPort;
            } else {
                this.host = (String)host0 + ":" + port;
                this.host2 = port == dfltPort ? host0 : this.host;
            }
        }
        catch (MalformedURLException e) {
            throw new InvalidConfException("invalid baseUrl '" + this.baseUrl + "'");
        }
        this.nonceManager = new NonceManager(conf.getNonceNumBytes());
        this.tokenNumBytes = conf.getTokenNumBytes();
        this.directoryHeader = "<" + this.baseUrl + "directory>;rel=\"index\"";
        this.caProfiles = conf.getCaProfiles();
        if (conf.getChallengeTypes() != null) {
            List<String> types = conf.getChallengeTypes();
            if (!(types.contains("dns-01") || types.contains("http-01") || types.contains("tls-alpn-01"))) {
                throw new InvalidConfException("invalid challengeTypes '" + types + "'");
            }
            this.challengeTypes = new HashSet<String>(types);
        } else {
            this.challengeTypes = new HashSet<String>(4);
            this.challengeTypes.add("dns-01");
            this.challengeTypes.add("http-01");
            this.challengeTypes.add("tls-alpn-01");
        }
        LOG.info("challenge types: {}", this.challengeTypes);
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        AcmeResponder.addJsonField(sb, "newNonce", this.baseUrl + "new-nonce");
        AcmeResponder.addJsonField(sb, "newAccount", this.baseUrl + "new-account");
        AcmeResponder.addJsonField(sb, "newOrder", this.baseUrl + "new-order");
        AcmeResponder.addJsonField(sb, "revokeCert", this.baseUrl + "revoke-cert");
        AcmeResponder.addJsonField(sb, "keyChange", this.baseUrl + "key-change");
        sb.append(AcmeResponder.addQuoteSign("meta")).append(":{");
        if (StringUtil.isNotBlank((String)conf.getWebsite())) {
            AcmeResponder.addJsonField(sb, "website", conf.getWebsite());
        }
        this.termsOfServicePresent = StringUtil.isNotBlank((String)conf.getTermsOfService());
        if (this.termsOfServicePresent) {
            AcmeResponder.addJsonField(sb, "termsOfService", conf.getTermsOfService());
        }
        if (CollectionUtil.isNotEmpty(conf.getCaaIdentities())) {
            sb.append(AcmeResponder.addQuoteSign("caaIdentities")).append(":[");
            for (String caIdentity : conf.getCaaIdentities()) {
                sb.append(AcmeResponder.addQuoteSign(caIdentity)).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("],");
        }
        sb.append(AcmeResponder.addQuoteSign("externalAccountRequired")).append(":false");
        sb.append("}}");
        this.directoryBytes = sb.toString().getBytes(StandardCharsets.UTF_8);
        String str = conf.getContactVerifier();
        if (str != null) {
            str = str.trim();
        }
        if (str == null || str.isEmpty()) {
            this.contactVerifier = new ContactVerifier.DfltContactVerifier();
        } else {
            try {
                this.contactVerifier = (ContactVerifier)Class.forName(str).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("invalid contactVerifier '" + str + "'");
            }
        }
        this.rnd = new SecureRandom();
        if (conf.getDbConf() == null) {
            throw new InvalidConfException("dbConf is not specified");
        }
        try {
            FileOrValue fileOrValue = new FileOrValue();
            fileOrValue.setFile(conf.getDbConf());
            DataSourceWrapper dataSource0 = new DataSourceFactory().createDataSource("acme-db", fileOrValue, securityFactory.getPasswordResolver());
            this.repo = new AcmeRepo(new AcmeDataSource(dataSource0), conf.getCacheSize(), conf.getSyncDbSeconds());
        }
        catch (Exception ex) {
            throw new InvalidConfException("could not initialize database", (Throwable)ex);
        }
        this.challengeValidator = new ChallengeValidator(this.repo);
        this.certEnroller = new CertEnroller(this.repo, sdk);
    }

    private static String addQuoteSign(String text) {
        return "\"" + text + "\"";
    }

    private static void addJsonField(StringBuilder sb, String name, String value) {
        sb.append(AcmeResponder.addQuoteSign(name)).append(":").append(AcmeResponder.addQuoteSign(value)).append(",");
    }

    public void start() {
        Thread t = new Thread(this.challengeValidator);
        t.setName("challengeValidator");
        t.setDaemon(true);
        t.start();
        t = new Thread(this.certEnroller);
        t.setName("certEnroller");
        t.setDaemon(true);
        t.start();
        this.repo.start();
    }

    public void close() {
        this.challengeValidator.close();
        this.certEnroller.close();
        this.nonceManager.close();
        this.repo.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse service(XiHttpRequest servletReq, byte[] request, AuditEvent event) {
        HttpResponse resp;
        StringContainer command = new StringContainer();
        AuditStatus auditStatus = AuditStatus.SUCCESSFUL;
        AuditLevel auditLevel = AuditLevel.INFO;
        String auditMessage = null;
        try {
            resp = this.doService(servletReq, request, event, command);
            int sc = resp.getStatusCode();
            if (sc >= 300 || sc < 200) {
                auditStatus = AuditStatus.FAILED;
                auditLevel = AuditLevel.ERROR;
            }
        }
        catch (HttpRespAuditException ex) {
            auditStatus = ex.getAuditStatus();
            auditLevel = ex.getAuditLevel();
            auditMessage = ex.getAuditMessage();
            HttpResponse httpResponse = new HttpResponse(ex.getHttpStatus(), null, null, null);
            return httpResponse;
        }
        catch (AcmeProtocolException ex) {
            auditLevel = AuditLevel.WARN;
            auditStatus = AuditStatus.FAILED;
            auditMessage = ex.getMessage();
            Problem problem = new Problem();
            problem.setType(ex.getAcmeError().getQualifiedCode());
            problem.setDetail(ex.getAcmeDetail());
            HttpResponse httpResponse = this.buildProblemResp(ex.getHttpError(), problem);
            return httpResponse;
        }
        catch (AcmeSystemException | DataAccessException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, null);
            auditLevel = AuditLevel.ERROR;
            auditStatus = AuditStatus.FAILED;
            auditMessage = ex instanceof DataAccessException ? "database error" : "ACME system exception";
            HttpResponse httpResponse = new HttpResponse(500, null, null, null);
            return httpResponse;
        }
        catch (Throwable th) {
            LOG.error("Throwable thrown, this should not happen!", th);
            auditLevel = AuditLevel.ERROR;
            auditStatus = AuditStatus.FAILED;
            auditMessage = "internal error";
            HttpResponse httpResponse = new HttpResponse(500, null, null, null);
            return httpResponse;
        }
        finally {
            event.setStatus(auditStatus);
            event.setLevel(auditLevel);
            if (auditMessage != null) {
                event.addEventData("message", (Object)auditMessage);
            }
        }
        if (command.text != null && !"directory".equals(command.text)) {
            String nonce = this.nonceManager.newNonce();
            resp.putHeader("Replay-Nonce", nonce).putHeader("Link", this.directoryHeader);
        }
        return resp;
    }

    private HttpResponse doService(XiHttpRequest servletReq, byte[] request, AuditEvent event, StringContainer commandContainer) throws HttpRespAuditException, AcmeProtocolException, AcmeSystemException, DataAccessException {
        PublicKey pubKey;
        String command;
        String coreUri;
        String[] tokens;
        String method = servletReq.getMethod();
        String path = servletReq.getServletPath();
        String hdrHost = servletReq.getHeader("host");
        if (!this.host.equals(hdrHost) && !this.host2.equals(hdrHost)) {
            String message = "invalid header host '" + hdrHost + "'";
            LOG.error(message);
            throw new HttpRespAuditException(400, message, AuditLevel.ERROR, AuditStatus.FAILED);
        }
        if (path.isEmpty()) {
            path = "/";
        }
        if ((tokens = (coreUri = path.substring("/".length())).split("/")).length < 1) {
            String message = "invalid path " + path;
            LOG.error(message);
            throw new HttpRespAuditException(404, message, AuditLevel.ERROR, AuditStatus.FAILED);
        }
        commandContainer.text = command = tokens[0].toLowerCase(Locale.ROOT);
        if (StringUtil.isBlank((String)command)) {
            command = "directory";
        }
        event.addEventType(command);
        if (!knownCommands.contains(command)) {
            String message = "invalid command '" + command + "'";
            LOG.error(message);
            throw new HttpRespAuditException(404, message, AuditLevel.INFO, AuditStatus.FAILED);
        }
        if ("new-nonce".equalsIgnoreCase(command)) {
            int sc;
            int n = "HEAD".equals(method) ? 200 : (sc = "GET".equals(method) ? 204 : 0);
            if (sc == 0) {
                throw new HttpRespAuditException(405, "HTTP method not allowed: " + method, AuditLevel.INFO, AuditStatus.FAILED);
            }
            return new HttpResponse(sc, null, null, null).putHeader("Cache-Control", "no-store");
        }
        if ("directory".equalsIgnoreCase(command)) {
            if (!"GET".equals(method)) {
                throw new HttpRespAuditException(405, "HTTP method not allowed: " + method, AuditLevel.INFO, AuditStatus.FAILED);
            }
            HttpRespContent respContent = HttpRespContent.ofOk((String)"application/json", (boolean)false, (byte[])this.directoryBytes);
            return new HttpResponse(200, respContent.getContentType(), null, respContent.isBase64(), respContent.getContent());
        }
        if (!"POST".equals(method)) {
            throw new HttpRespAuditException(405, "HTTP method not allowed: " + method, AuditLevel.INFO, AuditStatus.FAILED);
        }
        String contentType = servletReq.getContentType();
        if (!"application/jose+json".equals(contentType)) {
            throw new AcmeProtocolException(400, AcmeError.malformed, "invalid Content-Type '" + contentType + "'");
        }
        JoseMessage body = (JoseMessage)JSON.parseObject((byte[])request, JoseMessage.class);
        AcmeJson protected_ = AcmeJson.parse(Base64Url.decodeFast((String)body.getProtected()));
        if (!protected_.contains("url")) {
            throw new AcmeProtocolException(400, AcmeError.malformed, "url is not present");
        }
        String protectedUrl = protected_.get("url").asString();
        if (!protectedUrl.equals(this.baseUrl + path.substring(1))) {
            throw new AcmeProtocolException(400, AcmeError.malformed, "url is not valid: '" + protectedUrl + "'");
        }
        if (!protected_.contains("nonce")) {
            throw new AcmeProtocolException(400, AcmeError.badNonce, "nonce is not present");
        }
        String nonce = protected_.get("nonce").asString();
        if (!this.nonceManager.removeNonce(nonce)) {
            throw new AcmeProtocolException(400, AcmeError.badNonce, null);
        }
        boolean MASK_JWK = true;
        int MASK_KID = 2;
        int verificationKeyRequirement = "new-account".equals(command) ? 1 : ("revoke-cert".equals(command) ? 3 : 2);
        boolean withJwk = protected_.contains("jwk");
        boolean withKid = protected_.contains("kid");
        AcmeAccount account = null;
        String kid = null;
        Map<String, String> jwk = null;
        if (withKid && withJwk) {
            throw new AcmeProtocolException(400, AcmeError.malformed, "Both jwk and kid are specified, but exactly one of them is allowed");
        }
        if (withJwk) {
            if ((verificationKeyRequirement & 1) == 0) {
                throw new AcmeProtocolException(400, AcmeError.malformed, "kid is specified, but jwk is allowed");
            }
            jwk = AcmeUtils.jsonToMap(protected_.get("jwk").asObject());
            try {
                pubKey = AcmeUtils.jwkPublicKey(jwk);
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"jwkPublicKey");
                throw new AcmeProtocolException(400, AcmeError.badPublicKey, null);
            }
        } else if (protected_.contains("kid")) {
            Long id;
            if ((verificationKeyRequirement & 2) == 0) {
                throw new AcmeProtocolException(400, AcmeError.malformed, "jwk is specified, but only kid is allowed");
            }
            kid = protected_.get("kid").asString();
            if (kid.startsWith(this.accountPrefix) && (id = AcmeResponder.toLongId(kid.substring(this.accountPrefix.length()))) != null) {
                account = this.repo.getAccount(id);
            }
            if (account == null) {
                throw new AcmeProtocolException(400, AcmeError.accountDoesNotExist, null);
            }
            try {
                pubKey = account.getPublicKey();
            }
            catch (InvalidKeySpecException e) {
                throw new AcmeProtocolException(500, AcmeError.badPublicKey, null);
            }
        } else {
            throw new AcmeProtocolException(400, AcmeError.malformed, "None of jwk and kid is specified, but one of them is required");
        }
        if ("acct".equals(command) && !protected_.get("url").asString().equals(kid)) {
            throw new AcmeProtocolException(400, AcmeError.malformed, "kid and url do not match");
        }
        if (account != null && account.getStatus() != AccountStatus.valid) {
            throw new AcmeProtocolException(401, AcmeError.unauthorized, "account is not valid");
        }
        HttpResponse verifyRes = this.verifySignature(pubKey, body);
        if (verifyRes != null) {
            return verifyRes;
        }
        switch (command) {
            case "new-account": {
                boolean tosAgreed;
                NewAccountPayload reqPayload = (NewAccountPayload)JSON.parseObject((byte[])Base64Url.decodeFast((String)body.getPayload()), NewAccountPayload.class);
                AcmeAccount existingAccount = this.repo.getAccountForJwk(jwk);
                if (existingAccount != null) {
                    return this.buildSuccJsonResp(200, existingAccount.toResponse(this.baseUrl)).putHeader("Location", existingAccount.getLocation(this.baseUrl));
                }
                Boolean onlyReturnExisting = reqPayload.getOnlyReturnExisting();
                if (onlyReturnExisting != null && onlyReturnExisting.booleanValue()) {
                    throw new AcmeProtocolException(400, AcmeError.accountDoesNotExist, null);
                }
                Boolean b = reqPayload.getTermsOfServiceAgreed();
                boolean bl = b != null ? b : (tosAgreed = !this.termsOfServicePresent);
                if (!tosAgreed) {
                    throw new AcmeProtocolException(401, AcmeError.userActionRequired, "terms of service has not been agreed");
                }
                AcmeAccount newAccount = this.repo.newAcmeAccount();
                List<String> contacts = reqPayload.getContact();
                if (contacts != null && !contacts.isEmpty()) {
                    HttpResponse verifyErrorResp = this.verifyContacts(contacts);
                    if (verifyErrorResp != null) {
                        return verifyErrorResp;
                    }
                    newAccount.setContact(contacts);
                }
                newAccount.setExternalAccountBinding(reqPayload.getExternalAccountBinding());
                if (b != null) {
                    newAccount.setTermsOfServiceAgreed(true);
                }
                newAccount.setJwk(jwk);
                newAccount.setStatus(AccountStatus.valid);
                this.repo.addAccount(newAccount);
                AccountResponse resp = newAccount.toResponse(this.baseUrl);
                LOG.info("created new account {}", (Object)newAccount.idText());
                return this.buildSuccJsonResp(201, resp).putHeader("Location", newAccount.getLocation(this.baseUrl));
            }
            case "key-change": {
                PublicKey newPubKey;
                JoseMessage reqPayload = (JoseMessage)JSON.parseObject((byte[])Base64Url.decodeFast((String)body.getPayload()), JoseMessage.class);
                AcmeJson innerProtected = AcmeJson.parse(Base64Url.decodeFast((String)reqPayload.getProtected()));
                Map<String, String> newJwk = AcmeUtils.jsonToMap(innerProtected.get("jwk").asObject());
                AcmeAccount accountForNewJwk = this.repo.getAccountForJwk(newJwk);
                if (accountForNewJwk != null) {
                    return this.toHttpResponse(HttpRespContent.of((int)409, null, null)).putHeader("Location", accountForNewJwk.getLocation(this.baseUrl));
                }
                AcmeJson innerPayload = AcmeJson.parse(Base64Url.decodeFast((String)reqPayload.getPayload()));
                String innerAccount = innerPayload.get("account").asString();
                if (!innerAccount.equals(kid)) {
                    throw new AcmeProtocolException(400, AcmeError.malformed, "invalid payload.account");
                }
                Map<String, String> oldKey = AcmeUtils.jsonToMap(innerPayload.get("oldKey").asObject());
                if (!account.hasJwk(oldKey)) {
                    throw new AcmeProtocolException(400, AcmeError.malformed, "oldKey does not match the account");
                }
                try {
                    newPubKey = AcmeUtils.jwkPublicKey(newJwk);
                }
                catch (InvalidKeySpecException e) {
                    LogUtil.error((Logger)LOG, (Throwable)e, (String)"jwkPublicKey");
                    throw new AcmeProtocolException(400, AcmeError.badPublicKey, null);
                }
                verifyRes = this.verifySignature(newPubKey, reqPayload);
                if (verifyRes != null) {
                    return verifyRes;
                }
                account.setJwk(newJwk);
                LOG.info("changed key of account {}", (Object)account.idText());
                return this.buildSuccJsonResp(200, account.toResponse(this.baseUrl)).putHeader("Location", account.getLocation(this.baseUrl));
            }
            case "acct": {
                List<String> contacts;
                AccountResponse reqPayload = (AccountResponse)JSON.parseObject((byte[])Base64Url.decodeFast((String)body.getPayload()), AccountResponse.class);
                AccountStatus status = reqPayload.getStatus();
                if (status == AccountStatus.revoked) {
                    throw new AcmeProtocolException(401, AcmeError.unauthorized, "status revoked is not allowed");
                }
                if (status == AccountStatus.deactivated) {
                    account.setStatus(AccountStatus.deactivated);
                }
                if ((contacts = reqPayload.getContact()) != null && !contacts.isEmpty()) {
                    HttpResponse errResp = this.verifyContacts(contacts);
                    if (errResp != null) {
                        return errResp;
                    }
                    account.setContact(contacts);
                }
                LOG.info("updated account {}", (Object)account.idText());
                return this.buildSuccJsonResp(200, account.toResponse(this.baseUrl));
            }
            case "revoke-cert": {
                RevokeCertsResponse sdkResp;
                AcmeOrder order;
                byte[] encodedIssuer;
                Certificate cert;
                CrlReason reason;
                RevokeCertPayload reqPayload = (RevokeCertPayload)JSON.parseObject((byte[])Base64Url.decodeFast((String)body.getPayload()), RevokeCertPayload.class);
                Integer reasonCode = reqPayload.getReason();
                try {
                    reason = reasonCode == null ? CrlReason.UNSPECIFIED : CrlReason.forReasonCode((int)reasonCode);
                }
                catch (Exception e) {
                    reason = null;
                }
                if (reason == null || !CrlReason.PERMITTED_CLIENT_CRLREASONS.contains(reason)) {
                    throw new AcmeProtocolException(400, AcmeError.badRevocationReason, "bad revocation reason " + reasonCode);
                }
                byte[] certBytes = Base64Url.decodeFast((String)reqPayload.getCertificate());
                try {
                    cert = Certificate.getInstance((Object)certBytes);
                    encodedIssuer = cert.getIssuer().getEncoded();
                }
                catch (Exception e) {
                    throw new AcmeProtocolException(400, AcmeError.malformed, "malformed certificate");
                }
                LOG.info("try to revoke certificate with (subject={}, issuer={}, serialNumber={})", new Object[]{cert.getSubject(), cert.getIssuer(), cert.getSerialNumber()});
                if (jwk != null) {
                    boolean jwkAndCertMatch;
                    try {
                        jwkAndCertMatch = AcmeUtils.matchKey(jwk, cert.getSubjectPublicKeyInfo());
                    }
                    catch (InvalidKeySpecException e) {
                        LogUtil.error((Logger)LOG, (Throwable)e, (String)"matchKey");
                        throw new AcmeProtocolException(400, AcmeError.badPublicKey, "bad jwk");
                    }
                    if (!jwkAndCertMatch) {
                        throw new AcmeProtocolException(400, AcmeError.unauthorized, "jwk and certificate do not match");
                    }
                }
                if ((order = this.repo.getOrderForCert(certBytes)) == null) {
                    throw new AcmeProtocolException(400, AcmeError.unauthorized, "certificate not enrolled through this ACME server");
                }
                if (jwk == null && order.getAccountId() != account.getId()) {
                    throw new AcmeProtocolException(400, AcmeError.unauthorized, "account and certificate do not match");
                }
                RevokeCertRequestEntry sdkEntry = new RevokeCertRequestEntry(cert.getSerialNumber().getPositiveValue(), reason, null);
                RevokeCertsRequest sdkReq = new RevokeCertsRequest();
                sdkReq.setIssuer(new X500NameType(encodedIssuer));
                sdkReq.setEntries(new RevokeCertRequestEntry[]{sdkEntry});
                try {
                    sdkResp = this.sdk.revokeCerts(sdkReq);
                    LOG.info("revoked certificate");
                }
                catch (IOException | SdkErrorResponseException e) {
                    LogUtil.error((Logger)LOG, (Throwable)e, (String)"sdk.revokeCerts");
                    throw new AcmeProtocolException(500, AcmeError.serverInternal, "error revoking the certificate");
                }
                ErrorEntry errorEntry = sdkResp.getEntries()[0].getError();
                if (errorEntry == null) {
                    return this.toHttpResponse(HttpRespContent.of((int)200, null, null));
                }
                int errCode = errorEntry.getCode();
                if (errCode == ErrorCode.CERT_REVOKED.getCode()) {
                    throw new AcmeProtocolException(400, AcmeError.alreadyRevoked, null);
                }
                if (errCode == ErrorCode.UNKNOWN_CERT.getCode()) {
                    throw new AcmeProtocolException(400, AcmeError.malformed, "certificate is unknown");
                }
                throw new AcmeProtocolException(403, AcmeError.unauthorized, null);
            }
            case "orders": {
                this.cleanOrders();
                Long id = AcmeResponder.toLongId(tokens[1]);
                if (id == null || id.longValue() != account.getId()) {
                    throw new AcmeProtocolException(404, AcmeError.accountDoesNotExist, null);
                }
                List<Long> orderIds = this.repo.getOrderIds(id);
                int size = orderIds == null ? 0 : orderIds.size();
                ArrayList<String> urls = new ArrayList<String>(size);
                if (orderIds != null) {
                    for (Long orderId : orderIds) {
                        urls.add(this.baseUrl + "order/" + AcmeUtils.toBase64(orderId));
                    }
                }
                OrdersResponse resp = new OrdersResponse();
                resp.setOrders(urls);
                return this.buildSuccJsonResp(200, resp);
            }
            case "new-order": {
                int size;
                NewOrderPayload newOrderReq = (NewOrderPayload)JSON.parseObject((byte[])Base64Url.decodeFast((String)body.getPayload()), NewOrderPayload.class);
                List<Identifier> identifiers = newOrderReq.getIdentifiers();
                int n = size = identifiers == null ? 0 : identifiers.size();
                if (size == 0) {
                    throw new AcmeProtocolException(400, AcmeError.malformed, "no identifier is specified");
                }
                int numChalls = 0;
                for (Identifier identifier : identifiers) {
                    String type = identifier.getType();
                    String value = identifier.getValue();
                    if ("dns".equals(type)) {
                        if (!value.startsWith("*.")) {
                            if (this.challengeTypes.contains("http-01")) {
                                ++numChalls;
                            }
                            if (this.challengeTypes.contains("tls-alpn-01")) {
                                ++numChalls;
                            }
                        }
                        if (this.challengeTypes.contains("dns-01")) {
                            ++numChalls;
                        }
                        if (numChalls != 0) continue;
                        throw new AcmeProtocolException(400, AcmeError.unsupportedIdentifier, "unsupported identifier '" + type + "/" + value + "'");
                    }
                    throw new AcmeProtocolException(400, AcmeError.unsupportedIdentifier, "unsupported identifier type '" + type + "'");
                }
                Instant expires = Instant.now().truncatedTo(ChronoUnit.SECONDS).plus(7L, ChronoUnit.DAYS);
                ArrayList<AcmeAuthz> authzs = new ArrayList<AcmeAuthz>(size);
                AcmeRepo.IdsForOrder ids = this.repo.newIdsForOrder(size, numChalls);
                int[] authzIds = ids.getAuthzSubIds();
                int[] challIds = ids.getChallSubIds();
                int authzIdOffset = 0;
                int challIdOffset = 0;
                for (Identifier identifier : identifiers) {
                    AcmeAuthz authz = new AcmeAuthz(authzIds[authzIdOffset++], identifier.toAcmeIdentifier());
                    authzs.add(authz);
                    authz.status(AuthzStatus.pending);
                    authz.expires(expires);
                    String type = identifier.getType();
                    String value = identifier.getValue();
                    String token = this.rndToken();
                    if ("dns".equals(type)) {
                        String v = value;
                        if (v.startsWith("*.")) {
                            v = v.substring(2);
                        }
                        if (v.indexOf(42) != -1) {
                            throw new AcmeProtocolException(400, AcmeError.unsupportedIdentifier, "unsupported identifier '" + value + "'");
                        }
                        String jwkSha256 = account.getJwkSha256();
                        String authorization = token + "." + jwkSha256;
                        String authorizationSha256 = Base64Url.encodeToStringNoPadding((byte[])HashAlgo.SHA256.hash((byte[][])new byte[][]{authorization.getBytes(StandardCharsets.UTF_8)}));
                        ArrayList<AcmeChallenge> challenges = new ArrayList<AcmeChallenge>(3);
                        if (!value.startsWith("*.")) {
                            if (this.challengeTypes.contains("http-01")) {
                                challenges.add(this.newChall(challIds[challIdOffset++], "http-01", token, authorization));
                            }
                            if (this.challengeTypes.contains("tls-alpn-01")) {
                                challenges.add(this.newChall(challIds[challIdOffset++], "tls-alpn-01", token, authorizationSha256));
                            }
                        }
                        if (this.challengeTypes.contains("dns-01")) {
                            challenges.add(this.newChall(challIds[challIdOffset++], "dns-01", token, authorizationSha256));
                        }
                        authz.challenges(challenges);
                        continue;
                    }
                    throw new AcmeProtocolException(400, AcmeError.unsupportedIdentifier, "unsupported identifier type '" + type + "'");
                }
                AcmeOrder order = this.repo.newAcmeOrder(account.getId(), ids.getOrderId());
                order.setAuthzs(authzs);
                Instant notBefore = null;
                Instant notAfter = null;
                if (newOrderReq.getNotBefore() != null) {
                    notBefore = AcmeUtils.parseTimestamp(newOrderReq.getNotBefore());
                }
                if (newOrderReq.getNotAfter() != null) {
                    notAfter = AcmeUtils.parseTimestamp(newOrderReq.getNotAfter());
                }
                order.setExpires(expires);
                if (notBefore != null || notAfter != null) {
                    CertReqMeta certReqMeta = new CertReqMeta();
                    certReqMeta.setNotBefore(notBefore);
                    certReqMeta.setNotAfter(notAfter);
                    order.setCertReqMeta(certReqMeta);
                }
                this.repo.addOrder(order);
                OrderResponse orderResp = order.toResponse(this.baseUrl);
                if (LOG.isInfoEnabled()) {
                    LOG.info("added new order {} for identifiers {}: {}", new Object[]{order.idText(), identifiers, JSON.toJson((Object)orderResp)});
                }
                return this.buildSuccJsonResp(201, orderResp).putHeader("Location", order.getLocation(this.baseUrl));
            }
            case "order": {
                String id = tokens[1];
                AcmeOrder order = this.getOrder(id);
                return this.buildSuccJsonResp(200, order.toResponse(this.baseUrl)).putHeader("Location", order.getLocation(this.baseUrl));
            }
            case "finalize": {
                Extensions csrExtensions;
                byte[] sanExtnValue;
                CertificationRequest csr;
                byte[] csrBytes;
                String id = tokens[1];
                AcmeOrder order = this.getOrder(id);
                order.updateStatus();
                switch (order.getStatus()) {
                    case ready: {
                        break;
                    }
                    case pending: {
                        throw new AcmeProtocolException(403, AcmeError.orderNotReady, "Order is not ready");
                    }
                    case invalid: {
                        throw new AcmeProtocolException(403, AcmeError.unauthorized, "Order is invalid");
                    }
                    case processing: {
                        throw new AcmeProtocolException(403, AcmeError.orderNotReady, "Enrolling certificate is processing");
                    }
                    case valid: {
                        throw new AcmeProtocolException(403, AcmeError.orderNotReady, "Certificate has been issued");
                    }
                    default: {
                        throw new RuntimeException("should not reach here, invalid order status " + order.getStatus());
                    }
                }
                FinalizeOrderPayload finalizeOrderReq = (FinalizeOrderPayload)JSON.parseObject((byte[])Base64Url.decodeFast((String)body.getPayload()), FinalizeOrderPayload.class);
                try {
                    csrBytes = Base64Url.decodeFast((String)finalizeOrderReq.getCsr());
                    csr = X509Util.parseCsrInRequest((byte[])csrBytes);
                }
                catch (Exception e) {
                    throw new AcmeProtocolException(400, AcmeError.badCSR, "could not parse CSR");
                }
                String keyAlgOid = csr.getCertificationRequestInfo().getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId();
                AcmeProxyConf.CaProfile caProfile = this.getCaProfile(keyAlgOid);
                if (caProfile == null) {
                    throw new AcmeProtocolException(400, AcmeError.badCSR, "unsupported key type " + keyAlgOid);
                }
                HashSet<Identifier> identifiers = new HashSet<Identifier>();
                for (AcmeAuthz authz : order.getAuthzs()) {
                    identifiers.add(authz.getIdentifier().toIdentifier());
                }
                X500Name csrSubject = csr.getCertificationRequestInfo().getSubject();
                String cn = X509Util.getCommonName((X500Name)csrSubject);
                if (cn != null && !cn.isEmpty()) {
                    boolean match = false;
                    for (Identifier identifier : identifiers) {
                        if (!identifier.getValue().equals(cn)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        throw new AcmeProtocolException(400, AcmeError.badCSR, "invalid commonName in CSR");
                    }
                }
                byte[] byArray = sanExtnValue = (csrExtensions = X509Util.getExtensions((CertificationRequestInfo)csr.getCertificationRequestInfo())) == null ? null : X509Util.getCoreExtValue((Extensions)csrExtensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
                if (sanExtnValue == null) {
                    throw new AcmeProtocolException(400, AcmeError.badCSR, "no extension subjectAlternativeName in CSR");
                }
                GeneralNames generalNames = GeneralNames.getInstance((Object)sanExtnValue);
                String firstSanValue = null;
                for (GeneralName gn : generalNames.getNames()) {
                    Identifier matchedId;
                    int tagNo = gn.getTagNo();
                    if (tagNo == 2) {
                        String value = ASN1IA5String.getInstance((Object)gn.getName()).getString();
                        if (firstSanValue == null) {
                            firstSanValue = value;
                        }
                        matchedId = null;
                        for (Identifier identifier : identifiers) {
                            if (!"dns".equalsIgnoreCase(identifier.getType()) || !value.equals(identifier.getValue())) continue;
                            matchedId = identifier;
                            break;
                        }
                        if (matchedId == null) {
                            throw new AcmeProtocolException(400, AcmeError.badCSR, "invalid DNS identifier in the extension subjectAlternativeName in CSR: " + value);
                        }
                    } else {
                        throw new AcmeProtocolException(400, AcmeError.badCSR, "unsupported name in the extension subjectAlternativeName in CSR.");
                    }
                    identifiers.remove(matchedId);
                }
                if (!identifiers.isEmpty()) {
                    throw new AcmeProtocolException(400, AcmeError.badCSR, "missing identifier in the extension subjectAlternativeName in CSR: " + identifiers);
                }
                try {
                    if (!GatewayUtil.verifyCsr((CertificationRequest)csr, (SecurityFactory)this.securityFactory, (PopControl)this.popControl)) {
                        throw new AcmeProtocolException(400, AcmeError.badCSR, "could not verify signature of CSR");
                    }
                }
                catch (Exception ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error verifying CSR");
                    throw new AcmeProtocolException(400, AcmeError.badCSR, null);
                }
                CertReqMeta certReqMeta = order.getCertReqMeta();
                if (certReqMeta == null) {
                    certReqMeta = new CertReqMeta();
                    order.setCertReqMeta(certReqMeta);
                }
                if (cn == null || cn.isEmpty()) {
                    certReqMeta.setSubject("CN=" + firstSanValue);
                }
                certReqMeta.setCa(caProfile.getCa());
                certReqMeta.setCertProfile(caProfile.getTlsProfile());
                order.setCsr(csrBytes);
                order.setStatus(OrderStatus.processing);
                LOG.info("finalized order {}", (Object)order.idText());
                return this.buildSuccJsonResp(200, order.toResponse(this.baseUrl)).putHeader("Location", order.getLocation(this.baseUrl));
            }
            case "cert": {
                String id = tokens[1];
                AcmeOrder order = this.getOrder(id);
                byte[] certBytes = order.getCert();
                if (certBytes == null) {
                    throw new AcmeProtocolException(404, AcmeError.orderNotReady, "found no certificate");
                }
                byte[] encodedIssuer = X509Util.extractCertIssuer((byte[])certBytes);
                String hexIssuer = Hex.encode((byte[])encodedIssuer);
                byte[][] cacerts = this.cacertsMap.get(hexIssuer);
                if (cacerts == null) {
                    try {
                        cacerts = this.sdk.cacertsBySubject(encodedIssuer);
                    }
                    catch (IOException | SdkErrorResponseException e) {
                        throw new AcmeProtocolException(500, AcmeError.serverInternal, "could not retrieve CA certificate chain");
                    }
                    String hexCaSubject = Hex.encode((byte[])X509Util.extractCertSubject((byte[])cacerts[0]));
                    if (!hexIssuer.equals(hexCaSubject)) {
                        throw new AcmeProtocolException(500, AcmeError.serverInternal, "could not retrieve CA certificate chain");
                    }
                    this.cacertsMap.put(hexCaSubject, cacerts);
                }
                byte[][] certchain = new byte[1 + cacerts.length][];
                certchain[0] = certBytes;
                System.arraycopy(cacerts, 0, certchain, 1, cacerts.length);
                byte[] respBytes = StringUtil.toUtf8Bytes((String)X509Util.encodeCertificates((byte[][])certchain));
                LOG.info("downloaded certificate of order {}", (Object)order.idText());
                return this.toHttpResponse(HttpRespContent.ofOk((String)"application/pem-certificate-chain", (byte[])respBytes));
            }
            case "authz": {
                if (tokens.length != 2) {
                    throw new HttpRespAuditException(404, "unknown authz", AuditLevel.ERROR, AuditStatus.FAILED);
                }
                AuthzId id = new AuthzId(Base64Url.decodeFast((String)tokens[1]));
                AcmeAuthz authz = this.repo.getAuthz(id);
                if (authz == null) {
                    throw new HttpRespAuditException(404, "unknown authz", AuditLevel.ERROR, AuditStatus.FAILED);
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("downloaded authz {}: {}", (Object)id, (Object)JSON.toJson((Object)authz.toResponse(this.baseUrl, id.getOrderId())));
                }
                return this.buildSuccJsonResp(200, authz.toResponse(this.baseUrl, id.getOrderId()));
            }
            case "chall": {
                if (tokens.length != 2) {
                    throw new HttpRespAuditException(404, "unknown challenge", AuditLevel.ERROR, AuditStatus.FAILED);
                }
                ChallId challId = new ChallId(Base64Url.decodeFast((String)tokens[1]));
                AcmeChallenge2 chall2 = this.repo.getChallenge(challId);
                if (chall2 == null) {
                    throw new HttpRespAuditException(404, "unknown challenge", AuditLevel.ERROR, AuditStatus.FAILED);
                }
                AcmeChallenge chall = chall2.getChallenge();
                ChallengeStatus status = chall.getStatus();
                if (status == ChallengeStatus.pending) {
                    chall.status(ChallengeStatus.processing);
                }
                ChallengeResponse resp = chall.toChallengeResponse(this.baseUrl, challId.getOrderId(), challId.getAuthzId());
                LOG.info("Received ready for challenge {} of order {}", (Object)challId, (Object)challId.getOrderId());
                HttpResponse ret = this.buildSuccJsonResp(200, resp);
                String authzUrl = chall2.getChallenge().authz().getUrl(this.baseUrl);
                ret.putHeader("Link", "<" + authzUrl + ">;rel=\"up\"");
                return ret;
            }
        }
        throw new HttpRespAuditException(404, "unknown command " + command, AuditLevel.ERROR, AuditStatus.FAILED);
    }

    private HttpResponse toHttpResponse(HttpRespContent respContent) {
        if (respContent == null) {
            return new HttpResponse(200);
        }
        return new HttpResponse(respContent.getStatusCode(), respContent.getContentType(), null, respContent.isBase64(), respContent.getContent());
    }

    private AcmeOrder getOrder(String id) throws HttpRespAuditException, AcmeSystemException {
        AcmeOrder order;
        Long lLabel = AcmeResponder.toLongId(id);
        AcmeOrder acmeOrder = order = lLabel == null ? null : this.repo.getOrder(lLabel);
        if (order == null) {
            throw new HttpRespAuditException(404, "unknown order", AuditLevel.ERROR, AuditStatus.FAILED);
        }
        return order;
    }

    private HttpResponse buildSuccJsonResp(int statusCode, Object body) {
        return this.toHttpResponse(HttpRespContent.of((int)statusCode, (String)"application/json", (byte[])JSON.toJSONBytes((Object)body)));
    }

    private HttpResponse buildProblemResp(int statusCode, Problem problem) {
        byte[] bytes = JSON.toJSONBytes((Object)problem);
        return this.toHttpResponse(HttpRespContent.of((int)statusCode, (String)"application/problem+json", (byte[])bytes));
    }

    private HttpResponse verifySignature(PublicKey pubKey, JoseMessage joseMessage) throws AcmeProtocolException {
        try {
            JsonWebSignature jws = new JsonWebSignature();
            jws.setCompactSerialization(joseMessage.getProtected() + "." + joseMessage.getPayload() + "." + joseMessage.getSignature());
            jws.setKey((Key)pubKey);
            boolean sigValid = jws.verifySignature();
            if (!sigValid) {
                throw new AcmeProtocolException(400, AcmeError.malformed, "signature is not valid");
            }
            return null;
        }
        catch (InvalidAlgorithmException e) {
            throw new AcmeProtocolException(400, AcmeError.badSignatureAlgorithm, e.getMessage());
        }
        catch (JoseException e) {
            throw new AcmeProtocolException(400, AcmeError.malformed, "signature is not valid");
        }
    }

    private HttpResponse verifyContacts(List<String> contacts) throws AcmeProtocolException {
        if (contacts == null || contacts.isEmpty()) {
            throw new AcmeProtocolException(400, AcmeError.invalidContact, "no contact is specified");
        }
        for (String contact : contacts) {
            int rc = this.contactVerifier.verfifyContact(contact);
            if (rc == 2) {
                throw new AcmeProtocolException(400, AcmeError.unsupportedContact, "unsupported contact '" + contact + "'");
            }
            if (rc != 1) continue;
            throw new AcmeProtocolException(400, AcmeError.invalidContact, "invalid contact '" + contact + "'");
        }
        return null;
    }

    private String rndToken() {
        byte[] token = new byte[this.tokenNumBytes];
        this.rnd.nextBytes(token);
        return Base64Url.encodeToStringNoPadding((byte[])token);
    }

    private AcmeChallenge newChall(int subId, String type, String token, String expectedAuthorization) {
        AcmeChallenge chall = new AcmeChallenge(subId, expectedAuthorization);
        chall.status(ChallengeStatus.pending);
        chall.type(type);
        chall.token(token);
        return chall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOrders() {
        AtomicLong atomicLong = this.lastOrdersCleaned;
        synchronized (atomicLong) {
            Instant now = Instant.now().truncatedTo(ChronoUnit.SECONDS);
            Instant last = Instant.ofEpochSecond(this.lastOrdersCleaned.get());
            if (Duration.between(last, now).compareTo(Duration.ofDays(1L)) < 0) {
                return;
            }
            this.lastOrdersCleaned.set(now.getEpochSecond());
            Instant certExpired = now.minus(this.cleanOrderConf.getExpiredCertDays(), ChronoUnit.DAYS);
            Instant notFinishedOrderExpires = now.minus(this.cleanOrderConf.getExpiredOrderDays(), ChronoUnit.DAYS);
            Thread thread = new Thread(() -> {
                try {
                    int num = this.repo.cleanOrders(certExpired, notFinishedOrderExpires);
                    LOG.info("removed {} orders with cert.notAfter<{} or not-finished-order.expires<{}", new Object[]{num, certExpired, notFinishedOrderExpires});
                }
                catch (Exception e) {
                    LogUtil.error((Logger)LOG, (Throwable)e, (String)"error cleaning orders");
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static Long toLongId(String id) {
        if (id.length() != 11) {
            return null;
        }
        return Pack.littleEndianToLong((byte[])Base64Url.decodeFast((String)id), (int)0);
    }

    private AcmeProxyConf.CaProfile getCaProfile(String keyAlgId) {
        for (AcmeProxyConf.CaProfile caProfile : this.caProfiles) {
            if (!caProfile.getKeyTypes().contains(keyAlgId)) continue;
            return caProfile;
        }
        return null;
    }

    private static class StringContainer {
        String text;

        private StringContainer() {
        }
    }

    private static class HttpRespAuditException
    extends Exception {
        private final int httpStatus;
        private final String auditMessage;
        private final AuditLevel auditLevel;
        private final AuditStatus auditStatus;

        public HttpRespAuditException(int httpStatus, String auditMessage, AuditLevel auditLevel, AuditStatus auditStatus) {
            this.httpStatus = httpStatus;
            this.auditMessage = Args.notBlank((String)auditMessage, (String)"auditMessage");
            this.auditLevel = (AuditLevel)Args.notNull((Object)auditLevel, (String)"auditLevel");
            this.auditStatus = (AuditStatus)Args.notNull((Object)auditStatus, (String)"auditStatus");
        }

        public int getHttpStatus() {
            return this.httpStatus;
        }

        public String getAuditMessage() {
            return this.auditMessage;
        }

        public AuditLevel getAuditLevel() {
            return this.auditLevel;
        }

        public AuditStatus getAuditStatus() {
            return this.auditStatus;
        }
    }
}

